/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.AbstractByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.UnpooledUnsafeNoCleanerDirectByteBuf;
import io.grpc.netty.shaded.io.netty.util.internal.MathUtil;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

final class UnsafeByteBufUtil {
    private static final boolean UNALIGNED = PlatformDependent.isUnaligned();
    private static final byte ZERO = 0;

    static byte getByte(long l2) {
        return PlatformDependent.getByte(l2);
    }

    static short getShort(long l2) {
        if (UNALIGNED) {
            short s11 = PlatformDependent.getShort(l2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? s11 : Short.reverseBytes(s11);
        }
        return (short)(PlatformDependent.getByte(l2) << 8 | PlatformDependent.getByte(l2 + 1L) & 0xFF);
    }

    static short getShortLE(long l2) {
        if (UNALIGNED) {
            short s11 = PlatformDependent.getShort(l2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes(s11) : s11;
        }
        return (short)(PlatformDependent.getByte(l2) & 0xFF | PlatformDependent.getByte(l2 + 1L) << 8);
    }

    static int getUnsignedMedium(long l2) {
        if (UNALIGNED) {
            return (PlatformDependent.getByte(l2) & 0xFF) << 16 | (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? PlatformDependent.getShort(l2 + 1L) : Short.reverseBytes(PlatformDependent.getShort(l2 + 1L))) & 0xFFFF;
        }
        return (PlatformDependent.getByte(l2) & 0xFF) << 16 | (PlatformDependent.getByte(l2 + 1L) & 0xFF) << 8 | PlatformDependent.getByte(l2 + 2L) & 0xFF;
    }

    static int getUnsignedMediumLE(long l2) {
        if (UNALIGNED) {
            return PlatformDependent.getByte(l2) & 0xFF | ((PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes(PlatformDependent.getShort(l2 + 1L)) : PlatformDependent.getShort(l2 + 1L)) & 0xFFFF) << 8;
        }
        return PlatformDependent.getByte(l2) & 0xFF | (PlatformDependent.getByte(l2 + 1L) & 0xFF) << 8 | (PlatformDependent.getByte(l2 + 2L) & 0xFF) << 16;
    }

    static int getInt(long l2) {
        if (UNALIGNED) {
            int n4 = PlatformDependent.getInt(l2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? n4 : Integer.reverseBytes(n4);
        }
        return PlatformDependent.getByte(l2) << 24 | (PlatformDependent.getByte(l2 + 1L) & 0xFF) << 16 | (PlatformDependent.getByte(l2 + 2L) & 0xFF) << 8 | PlatformDependent.getByte(l2 + 3L) & 0xFF;
    }

    static int getIntLE(long l2) {
        if (UNALIGNED) {
            int n4 = PlatformDependent.getInt(l2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Integer.reverseBytes(n4) : n4;
        }
        return PlatformDependent.getByte(l2) & 0xFF | (PlatformDependent.getByte(l2 + 1L) & 0xFF) << 8 | (PlatformDependent.getByte(l2 + 2L) & 0xFF) << 16 | PlatformDependent.getByte(l2 + 3L) << 24;
    }

    static long getLong(long l2) {
        if (UNALIGNED) {
            long l10 = PlatformDependent.getLong(l2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? l10 : Long.reverseBytes(l10);
        }
        return (long)PlatformDependent.getByte(l2) << 56 | ((long)PlatformDependent.getByte(l2 + 1L) & 0xFFL) << 48 | ((long)PlatformDependent.getByte(l2 + 2L) & 0xFFL) << 40 | ((long)PlatformDependent.getByte(l2 + 3L) & 0xFFL) << 32 | ((long)PlatformDependent.getByte(l2 + 4L) & 0xFFL) << 24 | ((long)PlatformDependent.getByte(l2 + 5L) & 0xFFL) << 16 | ((long)PlatformDependent.getByte(l2 + 6L) & 0xFFL) << 8 | (long)PlatformDependent.getByte(l2 + 7L) & 0xFFL;
    }

    static long getLongLE(long l2) {
        if (UNALIGNED) {
            long l10 = PlatformDependent.getLong(l2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Long.reverseBytes(l10) : l10;
        }
        return (long)PlatformDependent.getByte(l2) & 0xFFL | ((long)PlatformDependent.getByte(l2 + 1L) & 0xFFL) << 8 | ((long)PlatformDependent.getByte(l2 + 2L) & 0xFFL) << 16 | ((long)PlatformDependent.getByte(l2 + 3L) & 0xFFL) << 24 | ((long)PlatformDependent.getByte(l2 + 4L) & 0xFFL) << 32 | ((long)PlatformDependent.getByte(l2 + 5L) & 0xFFL) << 40 | ((long)PlatformDependent.getByte(l2 + 6L) & 0xFFL) << 48 | (long)PlatformDependent.getByte(l2 + 7L) << 56;
    }

    static void setByte(long l2, int n4) {
        PlatformDependent.putByte(l2, (byte)n4);
    }

    static void setShort(long l2, int n4) {
        if (UNALIGNED) {
            PlatformDependent.putShort(l2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)n4 : Short.reverseBytes((short)n4));
        } else {
            PlatformDependent.putByte(l2, (byte)(n4 >>> 8));
            PlatformDependent.putByte(l2 + 1L, (byte)n4);
        }
    }

    static void setShortLE(long l2, int n4) {
        if (UNALIGNED) {
            PlatformDependent.putShort(l2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)n4) : (short)n4);
        } else {
            PlatformDependent.putByte(l2, (byte)n4);
            PlatformDependent.putByte(l2 + 1L, (byte)(n4 >>> 8));
        }
    }

    static void setMedium(long l2, int n4) {
        PlatformDependent.putByte(l2, (byte)(n4 >>> 16));
        if (UNALIGNED) {
            PlatformDependent.putShort(l2 + 1L, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)n4 : Short.reverseBytes((short)n4));
        } else {
            PlatformDependent.putByte(l2 + 1L, (byte)(n4 >>> 8));
            PlatformDependent.putByte(l2 + 2L, (byte)n4);
        }
    }

    static void setMediumLE(long l2, int n4) {
        PlatformDependent.putByte(l2, (byte)n4);
        if (UNALIGNED) {
            PlatformDependent.putShort(l2 + 1L, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)(n4 >>> 8)) : (short)(n4 >>> 8));
        } else {
            PlatformDependent.putByte(l2 + 1L, (byte)(n4 >>> 8));
            PlatformDependent.putByte(l2 + 2L, (byte)(n4 >>> 16));
        }
    }

    static void setInt(long l2, int n4) {
        if (UNALIGNED) {
            PlatformDependent.putInt(l2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? n4 : Integer.reverseBytes(n4));
        } else {
            PlatformDependent.putByte(l2, (byte)(n4 >>> 24));
            PlatformDependent.putByte(l2 + 1L, (byte)(n4 >>> 16));
            PlatformDependent.putByte(l2 + 2L, (byte)(n4 >>> 8));
            PlatformDependent.putByte(l2 + 3L, (byte)n4);
        }
    }

    static void setIntLE(long l2, int n4) {
        if (UNALIGNED) {
            PlatformDependent.putInt(l2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Integer.reverseBytes(n4) : n4);
        } else {
            PlatformDependent.putByte(l2, (byte)n4);
            PlatformDependent.putByte(l2 + 1L, (byte)(n4 >>> 8));
            PlatformDependent.putByte(l2 + 2L, (byte)(n4 >>> 16));
            PlatformDependent.putByte(l2 + 3L, (byte)(n4 >>> 24));
        }
    }

    static void setLong(long l2, long l10) {
        if (UNALIGNED) {
            PlatformDependent.putLong(l2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? l10 : Long.reverseBytes(l10));
        } else {
            PlatformDependent.putByte(l2, (byte)(l10 >>> 56));
            PlatformDependent.putByte(l2 + 1L, (byte)(l10 >>> 48));
            PlatformDependent.putByte(l2 + 2L, (byte)(l10 >>> 40));
            PlatformDependent.putByte(l2 + 3L, (byte)(l10 >>> 32));
            PlatformDependent.putByte(l2 + 4L, (byte)(l10 >>> 24));
            PlatformDependent.putByte(l2 + 5L, (byte)(l10 >>> 16));
            PlatformDependent.putByte(l2 + 6L, (byte)(l10 >>> 8));
            PlatformDependent.putByte(l2 + 7L, (byte)l10);
        }
    }

    static void setLongLE(long l2, long l10) {
        if (UNALIGNED) {
            PlatformDependent.putLong(l2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Long.reverseBytes(l10) : l10);
        } else {
            PlatformDependent.putByte(l2, (byte)l10);
            PlatformDependent.putByte(l2 + 1L, (byte)(l10 >>> 8));
            PlatformDependent.putByte(l2 + 2L, (byte)(l10 >>> 16));
            PlatformDependent.putByte(l2 + 3L, (byte)(l10 >>> 24));
            PlatformDependent.putByte(l2 + 4L, (byte)(l10 >>> 32));
            PlatformDependent.putByte(l2 + 5L, (byte)(l10 >>> 40));
            PlatformDependent.putByte(l2 + 6L, (byte)(l10 >>> 48));
            PlatformDependent.putByte(l2 + 7L, (byte)(l10 >>> 56));
        }
    }

    static byte getByte(byte[] byArray, int n4) {
        return PlatformDependent.getByte(byArray, n4);
    }

    static short getShort(byte[] byArray, int n4) {
        if (UNALIGNED) {
            short s11 = PlatformDependent.getShort(byArray, n4);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? s11 : Short.reverseBytes(s11);
        }
        return (short)(PlatformDependent.getByte(byArray, n4) << 8 | PlatformDependent.getByte(byArray, n4 + 1) & 0xFF);
    }

    static short getShortLE(byte[] byArray, int n4) {
        if (UNALIGNED) {
            short s11 = PlatformDependent.getShort(byArray, n4);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes(s11) : s11;
        }
        return (short)(PlatformDependent.getByte(byArray, n4) & 0xFF | PlatformDependent.getByte(byArray, n4 + 1) << 8);
    }

    static int getUnsignedMedium(byte[] byArray, int n4) {
        if (UNALIGNED) {
            return (PlatformDependent.getByte(byArray, n4) & 0xFF) << 16 | (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? PlatformDependent.getShort(byArray, n4 + 1) : Short.reverseBytes(PlatformDependent.getShort(byArray, n4 + 1))) & 0xFFFF;
        }
        return (PlatformDependent.getByte(byArray, n4) & 0xFF) << 16 | (PlatformDependent.getByte(byArray, n4 + 1) & 0xFF) << 8 | PlatformDependent.getByte(byArray, n4 + 2) & 0xFF;
    }

    static int getUnsignedMediumLE(byte[] byArray, int n4) {
        if (UNALIGNED) {
            return PlatformDependent.getByte(byArray, n4) & 0xFF | ((PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes(PlatformDependent.getShort(byArray, n4 + 1)) : PlatformDependent.getShort(byArray, n4 + 1)) & 0xFFFF) << 8;
        }
        return PlatformDependent.getByte(byArray, n4) & 0xFF | (PlatformDependent.getByte(byArray, n4 + 1) & 0xFF) << 8 | (PlatformDependent.getByte(byArray, n4 + 2) & 0xFF) << 16;
    }

    static int getInt(byte[] byArray, int n4) {
        if (UNALIGNED) {
            int n7 = PlatformDependent.getInt(byArray, n4);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? n7 : Integer.reverseBytes(n7);
        }
        return PlatformDependent.getByte(byArray, n4) << 24 | (PlatformDependent.getByte(byArray, n4 + 1) & 0xFF) << 16 | (PlatformDependent.getByte(byArray, n4 + 2) & 0xFF) << 8 | PlatformDependent.getByte(byArray, n4 + 3) & 0xFF;
    }

    static int getIntLE(byte[] byArray, int n4) {
        if (UNALIGNED) {
            int n7 = PlatformDependent.getInt(byArray, n4);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Integer.reverseBytes(n7) : n7;
        }
        return PlatformDependent.getByte(byArray, n4) & 0xFF | (PlatformDependent.getByte(byArray, n4 + 1) & 0xFF) << 8 | (PlatformDependent.getByte(byArray, n4 + 2) & 0xFF) << 16 | PlatformDependent.getByte(byArray, n4 + 3) << 24;
    }

    static long getLong(byte[] byArray, int n4) {
        if (UNALIGNED) {
            long l2 = PlatformDependent.getLong(byArray, n4);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? l2 : Long.reverseBytes(l2);
        }
        return (long)PlatformDependent.getByte(byArray, n4) << 56 | ((long)PlatformDependent.getByte(byArray, n4 + 1) & 0xFFL) << 48 | ((long)PlatformDependent.getByte(byArray, n4 + 2) & 0xFFL) << 40 | ((long)PlatformDependent.getByte(byArray, n4 + 3) & 0xFFL) << 32 | ((long)PlatformDependent.getByte(byArray, n4 + 4) & 0xFFL) << 24 | ((long)PlatformDependent.getByte(byArray, n4 + 5) & 0xFFL) << 16 | ((long)PlatformDependent.getByte(byArray, n4 + 6) & 0xFFL) << 8 | (long)PlatformDependent.getByte(byArray, n4 + 7) & 0xFFL;
    }

    static long getLongLE(byte[] byArray, int n4) {
        if (UNALIGNED) {
            long l2 = PlatformDependent.getLong(byArray, n4);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Long.reverseBytes(l2) : l2;
        }
        return (long)PlatformDependent.getByte(byArray, n4) & 0xFFL | ((long)PlatformDependent.getByte(byArray, n4 + 1) & 0xFFL) << 8 | ((long)PlatformDependent.getByte(byArray, n4 + 2) & 0xFFL) << 16 | ((long)PlatformDependent.getByte(byArray, n4 + 3) & 0xFFL) << 24 | ((long)PlatformDependent.getByte(byArray, n4 + 4) & 0xFFL) << 32 | ((long)PlatformDependent.getByte(byArray, n4 + 5) & 0xFFL) << 40 | ((long)PlatformDependent.getByte(byArray, n4 + 6) & 0xFFL) << 48 | (long)PlatformDependent.getByte(byArray, n4 + 7) << 56;
    }

    static void setByte(byte[] byArray, int n4, int n7) {
        PlatformDependent.putByte(byArray, n4, (byte)n7);
    }

    static void setShort(byte[] byArray, int n4, int n7) {
        if (UNALIGNED) {
            PlatformDependent.putShort(byArray, n4, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)n7 : Short.reverseBytes((short)n7));
        } else {
            PlatformDependent.putByte(byArray, n4, (byte)(n7 >>> 8));
            PlatformDependent.putByte(byArray, n4 + 1, (byte)n7);
        }
    }

    static void setShortLE(byte[] byArray, int n4, int n7) {
        if (UNALIGNED) {
            PlatformDependent.putShort(byArray, n4, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)n7) : (short)n7);
        } else {
            PlatformDependent.putByte(byArray, n4, (byte)n7);
            PlatformDependent.putByte(byArray, n4 + 1, (byte)(n7 >>> 8));
        }
    }

    static void setMedium(byte[] byArray, int n4, int n7) {
        PlatformDependent.putByte(byArray, n4, (byte)(n7 >>> 16));
        if (UNALIGNED) {
            PlatformDependent.putShort(byArray, n4 + 1, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)n7 : Short.reverseBytes((short)n7));
        } else {
            PlatformDependent.putByte(byArray, n4 + 1, (byte)(n7 >>> 8));
            PlatformDependent.putByte(byArray, n4 + 2, (byte)n7);
        }
    }

    static void setMediumLE(byte[] byArray, int n4, int n7) {
        PlatformDependent.putByte(byArray, n4, (byte)n7);
        if (UNALIGNED) {
            PlatformDependent.putShort(byArray, n4 + 1, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)(n7 >>> 8)) : (short)(n7 >>> 8));
        } else {
            PlatformDependent.putByte(byArray, n4 + 1, (byte)(n7 >>> 8));
            PlatformDependent.putByte(byArray, n4 + 2, (byte)(n7 >>> 16));
        }
    }

    static void setInt(byte[] byArray, int n4, int n7) {
        if (UNALIGNED) {
            PlatformDependent.putInt(byArray, n4, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? n7 : Integer.reverseBytes(n7));
        } else {
            PlatformDependent.putByte(byArray, n4, (byte)(n7 >>> 24));
            PlatformDependent.putByte(byArray, n4 + 1, (byte)(n7 >>> 16));
            PlatformDependent.putByte(byArray, n4 + 2, (byte)(n7 >>> 8));
            PlatformDependent.putByte(byArray, n4 + 3, (byte)n7);
        }
    }

    static void setIntLE(byte[] byArray, int n4, int n7) {
        if (UNALIGNED) {
            PlatformDependent.putInt(byArray, n4, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Integer.reverseBytes(n7) : n7);
        } else {
            PlatformDependent.putByte(byArray, n4, (byte)n7);
            PlatformDependent.putByte(byArray, n4 + 1, (byte)(n7 >>> 8));
            PlatformDependent.putByte(byArray, n4 + 2, (byte)(n7 >>> 16));
            PlatformDependent.putByte(byArray, n4 + 3, (byte)(n7 >>> 24));
        }
    }

    static void setLong(byte[] byArray, int n4, long l2) {
        if (UNALIGNED) {
            PlatformDependent.putLong(byArray, n4, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? l2 : Long.reverseBytes(l2));
        } else {
            PlatformDependent.putByte(byArray, n4, (byte)(l2 >>> 56));
            PlatformDependent.putByte(byArray, n4 + 1, (byte)(l2 >>> 48));
            PlatformDependent.putByte(byArray, n4 + 2, (byte)(l2 >>> 40));
            PlatformDependent.putByte(byArray, n4 + 3, (byte)(l2 >>> 32));
            PlatformDependent.putByte(byArray, n4 + 4, (byte)(l2 >>> 24));
            PlatformDependent.putByte(byArray, n4 + 5, (byte)(l2 >>> 16));
            PlatformDependent.putByte(byArray, n4 + 6, (byte)(l2 >>> 8));
            PlatformDependent.putByte(byArray, n4 + 7, (byte)l2);
        }
    }

    static void setLongLE(byte[] byArray, int n4, long l2) {
        if (UNALIGNED) {
            PlatformDependent.putLong(byArray, n4, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Long.reverseBytes(l2) : l2);
        } else {
            PlatformDependent.putByte(byArray, n4, (byte)l2);
            PlatformDependent.putByte(byArray, n4 + 1, (byte)(l2 >>> 8));
            PlatformDependent.putByte(byArray, n4 + 2, (byte)(l2 >>> 16));
            PlatformDependent.putByte(byArray, n4 + 3, (byte)(l2 >>> 24));
            PlatformDependent.putByte(byArray, n4 + 4, (byte)(l2 >>> 32));
            PlatformDependent.putByte(byArray, n4 + 5, (byte)(l2 >>> 40));
            PlatformDependent.putByte(byArray, n4 + 6, (byte)(l2 >>> 48));
            PlatformDependent.putByte(byArray, n4 + 7, (byte)(l2 >>> 56));
        }
    }

    static void setZero(byte[] byArray, int n4, int n7) {
        if (n7 == 0) {
            return;
        }
        PlatformDependent.setMemory(byArray, n4, n7, (byte)0);
    }

    static ByteBuf copy(AbstractByteBuf abstractByteBuf, long l2, int n4, int n7) {
        abstractByteBuf.checkIndex(n4, n7);
        ByteBuf byteBuf = abstractByteBuf.alloc().directBuffer(n7, abstractByteBuf.maxCapacity());
        if (n7 != 0) {
            if (byteBuf.hasMemoryAddress()) {
                PlatformDependent.copyMemory(l2, byteBuf.memoryAddress(), n7);
                byteBuf.setIndex(0, n7);
            } else {
                byteBuf.writeBytes(abstractByteBuf, n4, n7);
            }
        }
        return byteBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int setBytes(AbstractByteBuf abstractByteBuf, long l2, int n4, InputStream inputStream, int n7) {
        abstractByteBuf.checkIndex(n4, n7);
        ByteBuf byteBuf = abstractByteBuf.alloc().heapBuffer(n7);
        try {
            byte[] byArray = byteBuf.array();
            int n8 = byteBuf.arrayOffset();
            int n10 = inputStream.read(byArray, n8, n7);
            if (n10 > 0) {
                PlatformDependent.copyMemory(byArray, n8, l2, (long)n10);
            }
            int n11 = n10;
            return n11;
        }
        finally {
            byteBuf.release();
        }
    }

    static void getBytes(AbstractByteBuf abstractByteBuf, long l2, int n4, ByteBuf byteBuf, int n7, int n8) {
        abstractByteBuf.checkIndex(n4, n8);
        ObjectUtil.checkNotNull(byteBuf, "dst");
        if (MathUtil.isOutOfBounds(n7, n8, byteBuf.capacity())) {
            throw new IndexOutOfBoundsException("dstIndex: " + n7);
        }
        if (byteBuf.hasMemoryAddress()) {
            PlatformDependent.copyMemory(l2, byteBuf.memoryAddress() + (long)n7, n8);
        } else if (byteBuf.hasArray()) {
            PlatformDependent.copyMemory(l2, byteBuf.array(), byteBuf.arrayOffset() + n7, (long)n8);
        } else {
            byteBuf.setBytes(n7, abstractByteBuf, n4, n8);
        }
    }

    static void getBytes(AbstractByteBuf abstractByteBuf, long l2, int n4, byte[] byArray, int n7, int n8) {
        abstractByteBuf.checkIndex(n4, n8);
        ObjectUtil.checkNotNull(byArray, "dst");
        if (MathUtil.isOutOfBounds(n7, n8, byArray.length)) {
            throw new IndexOutOfBoundsException("dstIndex: " + n7);
        }
        if (n8 != 0) {
            PlatformDependent.copyMemory(l2, byArray, n7, (long)n8);
        }
    }

    static void getBytes(AbstractByteBuf abstractByteBuf, long l2, int n4, ByteBuffer byteBuffer) {
        abstractByteBuf.checkIndex(n4, byteBuffer.remaining());
        if (byteBuffer.remaining() == 0) {
            return;
        }
        if (byteBuffer.isDirect()) {
            if (byteBuffer.isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            long l10 = PlatformDependent.directBufferAddress(byteBuffer);
            PlatformDependent.copyMemory(l2, l10 + (long)byteBuffer.position(), byteBuffer.remaining());
            byteBuffer.position(byteBuffer.position() + byteBuffer.remaining());
        } else if (byteBuffer.hasArray()) {
            PlatformDependent.copyMemory(l2, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), (long)byteBuffer.remaining());
            byteBuffer.position(byteBuffer.position() + byteBuffer.remaining());
        } else {
            byteBuffer.put(abstractByteBuf.nioBuffer());
        }
    }

    static void setBytes(AbstractByteBuf abstractByteBuf, long l2, int n4, ByteBuf byteBuf, int n7, int n8) {
        abstractByteBuf.checkIndex(n4, n8);
        ObjectUtil.checkNotNull(byteBuf, "src");
        if (MathUtil.isOutOfBounds(n7, n8, byteBuf.capacity())) {
            throw new IndexOutOfBoundsException("srcIndex: " + n7);
        }
        if (n8 != 0) {
            if (byteBuf.hasMemoryAddress()) {
                PlatformDependent.copyMemory(byteBuf.memoryAddress() + (long)n7, l2, n8);
            } else if (byteBuf.hasArray()) {
                PlatformDependent.copyMemory(byteBuf.array(), byteBuf.arrayOffset() + n7, l2, (long)n8);
            } else {
                byteBuf.getBytes(n7, abstractByteBuf, n4, n8);
            }
        }
    }

    static void setBytes(AbstractByteBuf abstractByteBuf, long l2, int n4, byte[] byArray, int n7, int n8) {
        abstractByteBuf.checkIndex(n4, n8);
        if (n8 != 0) {
            PlatformDependent.copyMemory(byArray, n7, l2, (long)n8);
        }
    }

    static void setBytes(AbstractByteBuf abstractByteBuf, long l2, int n4, ByteBuffer byteBuffer) {
        int n7 = byteBuffer.remaining();
        if (n7 == 0) {
            return;
        }
        if (byteBuffer.isDirect()) {
            abstractByteBuf.checkIndex(n4, n7);
            long l10 = PlatformDependent.directBufferAddress(byteBuffer);
            PlatformDependent.copyMemory(l10 + (long)byteBuffer.position(), l2, n7);
            byteBuffer.position(byteBuffer.position() + n7);
        } else if (byteBuffer.hasArray()) {
            abstractByteBuf.checkIndex(n4, n7);
            PlatformDependent.copyMemory(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), l2, (long)n7);
            byteBuffer.position(byteBuffer.position() + n7);
        } else if (n7 < 8) {
            UnsafeByteBufUtil.setSingleBytes(abstractByteBuf, l2, n4, byteBuffer, n7);
        } else {
            assert (abstractByteBuf.nioBufferCount() == 1);
            ByteBuffer byteBuffer2 = abstractByteBuf.internalNioBuffer(n4, n7);
            byteBuffer2.put(byteBuffer);
        }
    }

    private static void setSingleBytes(AbstractByteBuf abstractByteBuf, long l2, int n4, ByteBuffer byteBuffer, int n7) {
        abstractByteBuf.checkIndex(n4, n7);
        int n8 = byteBuffer.position();
        int n10 = byteBuffer.limit();
        long l10 = l2;
        for (int i3 = n8; i3 < n10; ++i3) {
            byte by2 = byteBuffer.get(i3);
            PlatformDependent.putByte(l10, by2);
            ++l10;
        }
        byteBuffer.position(n10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getBytes(AbstractByteBuf abstractByteBuf, long l2, int n4, OutputStream outputStream, int n7) {
        abstractByteBuf.checkIndex(n4, n7);
        if (n7 != 0) {
            int n8 = Math.min(n7, 8192);
            if (n8 <= 1024 || !abstractByteBuf.alloc().isDirectBufferPooled()) {
                UnsafeByteBufUtil.getBytes(l2, ByteBufUtil.threadLocalTempArray(n8), 0, n8, outputStream, n7);
            } else {
                ByteBuf byteBuf = abstractByteBuf.alloc().heapBuffer(n8);
                try {
                    byte[] byArray = byteBuf.array();
                    int n10 = byteBuf.arrayOffset();
                    UnsafeByteBufUtil.getBytes(l2, byArray, n10, n8, outputStream, n7);
                }
                finally {
                    byteBuf.release();
                }
            }
        }
    }

    private static void getBytes(long l2, byte[] byArray, int n4, int n7, OutputStream outputStream, int n8) {
        int n10;
        do {
            n10 = Math.min(n7, n8);
            PlatformDependent.copyMemory(l2, byArray, n4, (long)n10);
            outputStream.write(byArray, n4, n10);
            l2 += (long)n10;
        } while ((n8 -= n10) > 0);
    }

    static void setZero(long l2, int n4) {
        if (n4 == 0) {
            return;
        }
        PlatformDependent.setMemory(l2, n4, (byte)0);
    }

    static UnpooledUnsafeDirectByteBuf newUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, int n4, int n7) {
        if (PlatformDependent.useDirectBufferNoCleaner()) {
            return new UnpooledUnsafeNoCleanerDirectByteBuf(byteBufAllocator, n4, n7);
        }
        return new UnpooledUnsafeDirectByteBuf(byteBufAllocator, n4, n7);
    }

    private UnsafeByteBufUtil() {
    }
}

