/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

class UnpooledUnsafeNoCleanerDirectByteBuf
extends UnpooledUnsafeDirectByteBuf {
    UnpooledUnsafeNoCleanerDirectByteBuf(ByteBufAllocator byteBufAllocator, int n4, int n7) {
        super(byteBufAllocator, n4, n7);
    }

    @Override
    protected ByteBuffer allocateDirect(int n4) {
        return PlatformDependent.allocateDirectNoCleaner(n4);
    }

    ByteBuffer reallocateDirect(ByteBuffer byteBuffer, int n4) {
        return PlatformDependent.reallocateDirectNoCleaner(byteBuffer, n4);
    }

    @Override
    protected void freeDirect(ByteBuffer byteBuffer) {
        PlatformDependent.freeDirectNoCleaner(byteBuffer);
    }

    @Override
    public ByteBuf capacity(int n4) {
        this.checkNewCapacity(n4);
        int n7 = this.capacity();
        if (n4 == n7) {
            return this;
        }
        ByteBuffer byteBuffer = this.reallocateDirect(this.buffer, n4);
        if (n4 < n7) {
            if (this.readerIndex() < n4) {
                if (this.writerIndex() > n4) {
                    this.writerIndex(n4);
                }
            } else {
                this.setIndex(n4, n4);
            }
        }
        this.setByteBuffer(byteBuffer, false);
        return this;
    }
}

