/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.SwappedByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.UnpooledHeapByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.UnsafeByteBufUtil;
import io.grpc.netty.shaded.io.netty.buffer.UnsafeHeapSwappedByteBuf;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;

public class UnpooledUnsafeHeapByteBuf
extends UnpooledHeapByteBuf {
    public UnpooledUnsafeHeapByteBuf(ByteBufAllocator byteBufAllocator, int n4, int n7) {
        super(byteBufAllocator, n4, n7);
    }

    @Override
    protected byte[] allocateArray(int n4) {
        return PlatformDependent.allocateUninitializedArray(n4);
    }

    @Override
    public byte getByte(int n4) {
        this.checkIndex(n4);
        return this._getByte(n4);
    }

    @Override
    protected byte _getByte(int n4) {
        return UnsafeByteBufUtil.getByte(this.array, n4);
    }

    @Override
    public short getShort(int n4) {
        this.checkIndex(n4, 2);
        return this._getShort(n4);
    }

    @Override
    protected short _getShort(int n4) {
        return UnsafeByteBufUtil.getShort(this.array, n4);
    }

    @Override
    public short getShortLE(int n4) {
        this.checkIndex(n4, 2);
        return this._getShortLE(n4);
    }

    @Override
    protected short _getShortLE(int n4) {
        return UnsafeByteBufUtil.getShortLE(this.array, n4);
    }

    @Override
    public int getUnsignedMedium(int n4) {
        this.checkIndex(n4, 3);
        return this._getUnsignedMedium(n4);
    }

    @Override
    protected int _getUnsignedMedium(int n4) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.array, n4);
    }

    @Override
    public int getUnsignedMediumLE(int n4) {
        this.checkIndex(n4, 3);
        return this._getUnsignedMediumLE(n4);
    }

    @Override
    protected int _getUnsignedMediumLE(int n4) {
        return UnsafeByteBufUtil.getUnsignedMediumLE(this.array, n4);
    }

    @Override
    public int getInt(int n4) {
        this.checkIndex(n4, 4);
        return this._getInt(n4);
    }

    @Override
    protected int _getInt(int n4) {
        return UnsafeByteBufUtil.getInt(this.array, n4);
    }

    @Override
    public int getIntLE(int n4) {
        this.checkIndex(n4, 4);
        return this._getIntLE(n4);
    }

    @Override
    protected int _getIntLE(int n4) {
        return UnsafeByteBufUtil.getIntLE(this.array, n4);
    }

    @Override
    public long getLong(int n4) {
        this.checkIndex(n4, 8);
        return this._getLong(n4);
    }

    @Override
    protected long _getLong(int n4) {
        return UnsafeByteBufUtil.getLong(this.array, n4);
    }

    @Override
    public long getLongLE(int n4) {
        this.checkIndex(n4, 8);
        return this._getLongLE(n4);
    }

    @Override
    protected long _getLongLE(int n4) {
        return UnsafeByteBufUtil.getLongLE(this.array, n4);
    }

    @Override
    public ByteBuf setByte(int n4, int n7) {
        this.checkIndex(n4);
        this._setByte(n4, n7);
        return this;
    }

    @Override
    protected void _setByte(int n4, int n7) {
        UnsafeByteBufUtil.setByte(this.array, n4, n7);
    }

    @Override
    public ByteBuf setShort(int n4, int n7) {
        this.checkIndex(n4, 2);
        this._setShort(n4, n7);
        return this;
    }

    @Override
    protected void _setShort(int n4, int n7) {
        UnsafeByteBufUtil.setShort(this.array, n4, n7);
    }

    @Override
    public ByteBuf setShortLE(int n4, int n7) {
        this.checkIndex(n4, 2);
        this._setShortLE(n4, n7);
        return this;
    }

    @Override
    protected void _setShortLE(int n4, int n7) {
        UnsafeByteBufUtil.setShortLE(this.array, n4, n7);
    }

    @Override
    public ByteBuf setMedium(int n4, int n7) {
        this.checkIndex(n4, 3);
        this._setMedium(n4, n7);
        return this;
    }

    @Override
    protected void _setMedium(int n4, int n7) {
        UnsafeByteBufUtil.setMedium(this.array, n4, n7);
    }

    @Override
    public ByteBuf setMediumLE(int n4, int n7) {
        this.checkIndex(n4, 3);
        this._setMediumLE(n4, n7);
        return this;
    }

    @Override
    protected void _setMediumLE(int n4, int n7) {
        UnsafeByteBufUtil.setMediumLE(this.array, n4, n7);
    }

    @Override
    public ByteBuf setInt(int n4, int n7) {
        this.checkIndex(n4, 4);
        this._setInt(n4, n7);
        return this;
    }

    @Override
    protected void _setInt(int n4, int n7) {
        UnsafeByteBufUtil.setInt(this.array, n4, n7);
    }

    @Override
    public ByteBuf setIntLE(int n4, int n7) {
        this.checkIndex(n4, 4);
        this._setIntLE(n4, n7);
        return this;
    }

    @Override
    protected void _setIntLE(int n4, int n7) {
        UnsafeByteBufUtil.setIntLE(this.array, n4, n7);
    }

    @Override
    public ByteBuf setLong(int n4, long l2) {
        this.checkIndex(n4, 8);
        this._setLong(n4, l2);
        return this;
    }

    @Override
    protected void _setLong(int n4, long l2) {
        UnsafeByteBufUtil.setLong(this.array, n4, l2);
    }

    @Override
    public ByteBuf setLongLE(int n4, long l2) {
        this.checkIndex(n4, 8);
        this._setLongLE(n4, l2);
        return this;
    }

    @Override
    protected void _setLongLE(int n4, long l2) {
        UnsafeByteBufUtil.setLongLE(this.array, n4, l2);
    }

    @Override
    public ByteBuf setZero(int n4, int n7) {
        if (PlatformDependent.javaVersion() >= 7) {
            this.checkIndex(n4, n7);
            UnsafeByteBufUtil.setZero(this.array, n4, n7);
            return this;
        }
        return super.setZero(n4, n7);
    }

    @Override
    public ByteBuf writeZero(int n4) {
        if (PlatformDependent.javaVersion() >= 7) {
            this.ensureWritable(n4);
            int n7 = this.writerIndex;
            UnsafeByteBufUtil.setZero(this.array, n7, n4);
            this.writerIndex = n7 + n4;
            return this;
        }
        return super.writeZero(n4);
    }

    @Override
    @Deprecated
    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeHeapSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }
}

