/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.AbstractByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.SwappedByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.UnpooledDirectByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.UnsafeByteBufUtil;
import io.grpc.netty.shaded.io.netty.buffer.UnsafeDirectSwappedByteBuf;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class UnpooledUnsafeDirectByteBuf
extends UnpooledDirectByteBuf {
    long memoryAddress;

    public UnpooledUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, int n4, int n7) {
        super(byteBufAllocator, n4, n7);
    }

    protected UnpooledUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer, int n4) {
        super(byteBufAllocator, byteBuffer, n4, false, true);
    }

    UnpooledUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer, int n4, boolean bl3) {
        super(byteBufAllocator, byteBuffer, n4, bl3, false);
    }

    @Override
    final void setByteBuffer(ByteBuffer byteBuffer, boolean bl3) {
        super.setByteBuffer(byteBuffer, bl3);
        this.memoryAddress = PlatformDependent.directBufferAddress(byteBuffer);
    }

    @Override
    public boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public long memoryAddress() {
        this.ensureAccessible();
        return this.memoryAddress;
    }

    @Override
    public byte getByte(int n4) {
        this.checkIndex(n4);
        return this._getByte(n4);
    }

    @Override
    protected byte _getByte(int n4) {
        return UnsafeByteBufUtil.getByte(this.addr(n4));
    }

    @Override
    public short getShort(int n4) {
        this.checkIndex(n4, 2);
        return this._getShort(n4);
    }

    @Override
    protected short _getShort(int n4) {
        return UnsafeByteBufUtil.getShort(this.addr(n4));
    }

    @Override
    protected short _getShortLE(int n4) {
        return UnsafeByteBufUtil.getShortLE(this.addr(n4));
    }

    @Override
    public int getUnsignedMedium(int n4) {
        this.checkIndex(n4, 3);
        return this._getUnsignedMedium(n4);
    }

    @Override
    protected int _getUnsignedMedium(int n4) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr(n4));
    }

    @Override
    protected int _getUnsignedMediumLE(int n4) {
        return UnsafeByteBufUtil.getUnsignedMediumLE(this.addr(n4));
    }

    @Override
    public int getInt(int n4) {
        this.checkIndex(n4, 4);
        return this._getInt(n4);
    }

    @Override
    protected int _getInt(int n4) {
        return UnsafeByteBufUtil.getInt(this.addr(n4));
    }

    @Override
    protected int _getIntLE(int n4) {
        return UnsafeByteBufUtil.getIntLE(this.addr(n4));
    }

    @Override
    public long getLong(int n4) {
        this.checkIndex(n4, 8);
        return this._getLong(n4);
    }

    @Override
    protected long _getLong(int n4) {
        return UnsafeByteBufUtil.getLong(this.addr(n4));
    }

    @Override
    protected long _getLongLE(int n4) {
        return UnsafeByteBufUtil.getLongLE(this.addr(n4));
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, this.addr(n4), n4, byteBuf, n7, n8);
        return this;
    }

    @Override
    void getBytes(int n4, byte[] byArray, int n7, int n8, boolean bl3) {
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, this.addr(n4), n4, byArray, n7, n8);
    }

    @Override
    void getBytes(int n4, ByteBuffer byteBuffer, boolean bl3) {
        UnsafeByteBufUtil.getBytes(this, this.addr(n4), n4, byteBuffer);
    }

    @Override
    public ByteBuf setByte(int n4, int n7) {
        this.checkIndex(n4);
        this._setByte(n4, n7);
        return this;
    }

    @Override
    protected void _setByte(int n4, int n7) {
        UnsafeByteBufUtil.setByte(this.addr(n4), n7);
    }

    @Override
    public ByteBuf setShort(int n4, int n7) {
        this.checkIndex(n4, 2);
        this._setShort(n4, n7);
        return this;
    }

    @Override
    protected void _setShort(int n4, int n7) {
        UnsafeByteBufUtil.setShort(this.addr(n4), n7);
    }

    @Override
    protected void _setShortLE(int n4, int n7) {
        UnsafeByteBufUtil.setShortLE(this.addr(n4), n7);
    }

    @Override
    public ByteBuf setMedium(int n4, int n7) {
        this.checkIndex(n4, 3);
        this._setMedium(n4, n7);
        return this;
    }

    @Override
    protected void _setMedium(int n4, int n7) {
        UnsafeByteBufUtil.setMedium(this.addr(n4), n7);
    }

    @Override
    protected void _setMediumLE(int n4, int n7) {
        UnsafeByteBufUtil.setMediumLE(this.addr(n4), n7);
    }

    @Override
    public ByteBuf setInt(int n4, int n7) {
        this.checkIndex(n4, 4);
        this._setInt(n4, n7);
        return this;
    }

    @Override
    protected void _setInt(int n4, int n7) {
        UnsafeByteBufUtil.setInt(this.addr(n4), n7);
    }

    @Override
    protected void _setIntLE(int n4, int n7) {
        UnsafeByteBufUtil.setIntLE(this.addr(n4), n7);
    }

    @Override
    public ByteBuf setLong(int n4, long l2) {
        this.checkIndex(n4, 8);
        this._setLong(n4, l2);
        return this;
    }

    @Override
    protected void _setLong(int n4, long l2) {
        UnsafeByteBufUtil.setLong(this.addr(n4), l2);
    }

    @Override
    protected void _setLongLE(int n4, long l2) {
        UnsafeByteBufUtil.setLongLE(this.addr(n4), l2);
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, this.addr(n4), n4, byteBuf, n7, n8);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n4, byte[] byArray, int n7, int n8) {
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, this.addr(n4), n4, byArray, n7, n8);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuffer byteBuffer) {
        UnsafeByteBufUtil.setBytes(this, this.addr(n4), n4, byteBuffer);
        return this;
    }

    @Override
    void getBytes(int n4, OutputStream outputStream, int n7, boolean bl3) {
        UnsafeByteBufUtil.getBytes(this, this.addr(n4), n4, outputStream, n7);
    }

    @Override
    public int setBytes(int n4, InputStream inputStream, int n7) {
        return UnsafeByteBufUtil.setBytes(this, this.addr(n4), n4, inputStream, n7);
    }

    @Override
    public ByteBuf copy(int n4, int n7) {
        return UnsafeByteBufUtil.copy(this, this.addr(n4), n4, n7);
    }

    final long addr(int n4) {
        return this.memoryAddress + (long)n4;
    }

    @Override
    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeDirectSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }

    @Override
    public ByteBuf setZero(int n4, int n7) {
        this.checkIndex(n4, n7);
        UnsafeByteBufUtil.setZero(this.addr(n4), n7);
        return this;
    }

    @Override
    public ByteBuf writeZero(int n4) {
        this.ensureWritable(n4);
        int n7 = this.writerIndex;
        UnsafeByteBufUtil.setZero(this.addr(n7), n4);
        this.writerIndex = n7 + n4;
        return this;
    }
}

