/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.HeapByteBufUtil;
import io.grpc.netty.shaded.io.netty.util.internal.EmptyArrays;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class UnpooledHeapByteBuf
extends AbstractReferenceCountedByteBuf {
    private final ByteBufAllocator alloc;
    byte[] array;
    private ByteBuffer tmpNioBuf;

    public UnpooledHeapByteBuf(ByteBufAllocator byteBufAllocator, int n4, int n7) {
        super(n7);
        ObjectUtil.checkNotNull(byteBufAllocator, "alloc");
        if (n4 > n7) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", n4, n7));
        }
        this.alloc = byteBufAllocator;
        this.setArray(this.allocateArray(n4));
        this.setIndex(0, 0);
    }

    protected UnpooledHeapByteBuf(ByteBufAllocator byteBufAllocator, byte[] byArray, int n4) {
        super(n4);
        ObjectUtil.checkNotNull(byteBufAllocator, "alloc");
        ObjectUtil.checkNotNull(byArray, "initialArray");
        if (byArray.length > n4) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", byArray.length, n4));
        }
        this.alloc = byteBufAllocator;
        this.setArray(byArray);
        this.setIndex(0, byArray.length);
    }

    protected byte[] allocateArray(int n4) {
        return new byte[n4];
    }

    protected void freeArray(byte[] byArray) {
    }

    private void setArray(byte[] byArray) {
        this.array = byArray;
        this.tmpNioBuf = null;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public int capacity() {
        return this.array.length;
    }

    @Override
    public ByteBuf capacity(int n4) {
        this.checkNewCapacity(n4);
        int n7 = this.array.length;
        byte[] byArray = this.array;
        if (n4 > n7) {
            byte[] byArray2 = this.allocateArray(n4);
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.setArray(byArray2);
            this.freeArray(byArray);
        } else if (n4 < n7) {
            byte[] byArray3 = this.allocateArray(n4);
            int n8 = this.readerIndex();
            if (n8 < n4) {
                int n10 = this.writerIndex();
                if (n10 > n4) {
                    n10 = n4;
                    this.writerIndex(n10);
                }
                System.arraycopy(byArray, n8, byArray3, n8, n10 - n8);
            } else {
                this.setIndex(n4, n4);
            }
            this.setArray(byArray3);
            this.freeArray(byArray);
        }
        return this;
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public byte[] array() {
        this.ensureAccessible();
        return this.array;
    }

    @Override
    public int arrayOffset() {
        return 0;
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        this.checkDstIndex(n4, n8, n7, byteBuf.capacity());
        if (byteBuf.hasMemoryAddress()) {
            PlatformDependent.copyMemory(this.array, n4, byteBuf.memoryAddress() + (long)n7, (long)n8);
        } else if (byteBuf.hasArray()) {
            this.getBytes(n4, byteBuf.array(), byteBuf.arrayOffset() + n7, n8);
        } else {
            byteBuf.setBytes(n7, this.array, n4, n8);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, byte[] byArray, int n7, int n8) {
        this.checkDstIndex(n4, n8, n7, byArray.length);
        System.arraycopy(this.array, n4, byArray, n7, n8);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuffer byteBuffer) {
        this.ensureAccessible();
        byteBuffer.put(this.array, n4, byteBuffer.remaining());
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, OutputStream outputStream, int n7) {
        this.ensureAccessible();
        outputStream.write(this.array, n4, n7);
        return this;
    }

    @Override
    public int getBytes(int n4, GatheringByteChannel gatheringByteChannel, int n7) {
        this.ensureAccessible();
        return this.getBytes(n4, gatheringByteChannel, n7, false);
    }

    @Override
    public int getBytes(int n4, FileChannel fileChannel, long l2, int n7) {
        this.ensureAccessible();
        return this.getBytes(n4, fileChannel, l2, n7, false);
    }

    private int getBytes(int n4, GatheringByteChannel gatheringByteChannel, int n7, boolean bl3) {
        this.ensureAccessible();
        ByteBuffer byteBuffer = bl3 ? this.internalNioBuffer() : ByteBuffer.wrap(this.array);
        return gatheringByteChannel.write((ByteBuffer)byteBuffer.clear().position(n4).limit(n4 + n7));
    }

    private int getBytes(int n4, FileChannel fileChannel, long l2, int n7, boolean bl3) {
        this.ensureAccessible();
        ByteBuffer byteBuffer = bl3 ? this.internalNioBuffer() : ByteBuffer.wrap(this.array);
        return fileChannel.write((ByteBuffer)byteBuffer.clear().position(n4).limit(n4 + n7), l2);
    }

    @Override
    public int readBytes(GatheringByteChannel gatheringByteChannel, int n4) {
        this.checkReadableBytes(n4);
        int n7 = this.getBytes(this.readerIndex, gatheringByteChannel, n4, true);
        this.readerIndex += n7;
        return n7;
    }

    @Override
    public int readBytes(FileChannel fileChannel, long l2, int n4) {
        this.checkReadableBytes(n4);
        int n7 = this.getBytes(this.readerIndex, fileChannel, l2, n4, true);
        this.readerIndex += n7;
        return n7;
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        this.checkSrcIndex(n4, n8, n7, byteBuf.capacity());
        if (byteBuf.hasMemoryAddress()) {
            PlatformDependent.copyMemory(byteBuf.memoryAddress() + (long)n7, this.array, n4, (long)n8);
        } else if (byteBuf.hasArray()) {
            this.setBytes(n4, byteBuf.array(), byteBuf.arrayOffset() + n7, n8);
        } else {
            byteBuf.getBytes(n7, this.array, n4, n8);
        }
        return this;
    }

    @Override
    public ByteBuf setBytes(int n4, byte[] byArray, int n7, int n8) {
        this.checkSrcIndex(n4, n8, n7, byArray.length);
        System.arraycopy(byArray, n7, this.array, n4, n8);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuffer byteBuffer) {
        this.ensureAccessible();
        byteBuffer.get(this.array, n4, byteBuffer.remaining());
        return this;
    }

    @Override
    public int setBytes(int n4, InputStream inputStream, int n7) {
        this.ensureAccessible();
        return inputStream.read(this.array, n4, n7);
    }

    @Override
    public int setBytes(int n4, ScatteringByteChannel scatteringByteChannel, int n7) {
        this.ensureAccessible();
        try {
            return scatteringByteChannel.read((ByteBuffer)this.internalNioBuffer().clear().position(n4).limit(n4 + n7));
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public int setBytes(int n4, FileChannel fileChannel, long l2, int n7) {
        this.ensureAccessible();
        try {
            return fileChannel.read((ByteBuffer)this.internalNioBuffer().clear().position(n4).limit(n4 + n7), l2);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer nioBuffer(int n4, int n7) {
        this.ensureAccessible();
        return ByteBuffer.wrap(this.array, n4, n7).slice();
    }

    @Override
    public ByteBuffer[] nioBuffers(int n4, int n7) {
        return new ByteBuffer[]{this.nioBuffer(n4, n7)};
    }

    @Override
    public ByteBuffer internalNioBuffer(int n4, int n7) {
        this.checkIndex(n4, n7);
        return (ByteBuffer)this.internalNioBuffer().clear().position(n4).limit(n4 + n7);
    }

    @Override
    public byte getByte(int n4) {
        this.ensureAccessible();
        return this._getByte(n4);
    }

    @Override
    protected byte _getByte(int n4) {
        return HeapByteBufUtil.getByte(this.array, n4);
    }

    @Override
    public short getShort(int n4) {
        this.ensureAccessible();
        return this._getShort(n4);
    }

    @Override
    protected short _getShort(int n4) {
        return HeapByteBufUtil.getShort(this.array, n4);
    }

    @Override
    public short getShortLE(int n4) {
        this.ensureAccessible();
        return this._getShortLE(n4);
    }

    @Override
    protected short _getShortLE(int n4) {
        return HeapByteBufUtil.getShortLE(this.array, n4);
    }

    @Override
    public int getUnsignedMedium(int n4) {
        this.ensureAccessible();
        return this._getUnsignedMedium(n4);
    }

    @Override
    protected int _getUnsignedMedium(int n4) {
        return HeapByteBufUtil.getUnsignedMedium(this.array, n4);
    }

    @Override
    public int getUnsignedMediumLE(int n4) {
        this.ensureAccessible();
        return this._getUnsignedMediumLE(n4);
    }

    @Override
    protected int _getUnsignedMediumLE(int n4) {
        return HeapByteBufUtil.getUnsignedMediumLE(this.array, n4);
    }

    @Override
    public int getInt(int n4) {
        this.ensureAccessible();
        return this._getInt(n4);
    }

    @Override
    protected int _getInt(int n4) {
        return HeapByteBufUtil.getInt(this.array, n4);
    }

    @Override
    public int getIntLE(int n4) {
        this.ensureAccessible();
        return this._getIntLE(n4);
    }

    @Override
    protected int _getIntLE(int n4) {
        return HeapByteBufUtil.getIntLE(this.array, n4);
    }

    @Override
    public long getLong(int n4) {
        this.ensureAccessible();
        return this._getLong(n4);
    }

    @Override
    protected long _getLong(int n4) {
        return HeapByteBufUtil.getLong(this.array, n4);
    }

    @Override
    public long getLongLE(int n4) {
        this.ensureAccessible();
        return this._getLongLE(n4);
    }

    @Override
    protected long _getLongLE(int n4) {
        return HeapByteBufUtil.getLongLE(this.array, n4);
    }

    @Override
    public ByteBuf setByte(int n4, int n7) {
        this.ensureAccessible();
        this._setByte(n4, n7);
        return this;
    }

    @Override
    protected void _setByte(int n4, int n7) {
        HeapByteBufUtil.setByte(this.array, n4, n7);
    }

    @Override
    public ByteBuf setShort(int n4, int n7) {
        this.ensureAccessible();
        this._setShort(n4, n7);
        return this;
    }

    @Override
    protected void _setShort(int n4, int n7) {
        HeapByteBufUtil.setShort(this.array, n4, n7);
    }

    @Override
    public ByteBuf setShortLE(int n4, int n7) {
        this.ensureAccessible();
        this._setShortLE(n4, n7);
        return this;
    }

    @Override
    protected void _setShortLE(int n4, int n7) {
        HeapByteBufUtil.setShortLE(this.array, n4, n7);
    }

    @Override
    public ByteBuf setMedium(int n4, int n7) {
        this.ensureAccessible();
        this._setMedium(n4, n7);
        return this;
    }

    @Override
    protected void _setMedium(int n4, int n7) {
        HeapByteBufUtil.setMedium(this.array, n4, n7);
    }

    @Override
    public ByteBuf setMediumLE(int n4, int n7) {
        this.ensureAccessible();
        this._setMediumLE(n4, n7);
        return this;
    }

    @Override
    protected void _setMediumLE(int n4, int n7) {
        HeapByteBufUtil.setMediumLE(this.array, n4, n7);
    }

    @Override
    public ByteBuf setInt(int n4, int n7) {
        this.ensureAccessible();
        this._setInt(n4, n7);
        return this;
    }

    @Override
    protected void _setInt(int n4, int n7) {
        HeapByteBufUtil.setInt(this.array, n4, n7);
    }

    @Override
    public ByteBuf setIntLE(int n4, int n7) {
        this.ensureAccessible();
        this._setIntLE(n4, n7);
        return this;
    }

    @Override
    protected void _setIntLE(int n4, int n7) {
        HeapByteBufUtil.setIntLE(this.array, n4, n7);
    }

    @Override
    public ByteBuf setLong(int n4, long l2) {
        this.ensureAccessible();
        this._setLong(n4, l2);
        return this;
    }

    @Override
    protected void _setLong(int n4, long l2) {
        HeapByteBufUtil.setLong(this.array, n4, l2);
    }

    @Override
    public ByteBuf setLongLE(int n4, long l2) {
        this.ensureAccessible();
        this._setLongLE(n4, l2);
        return this;
    }

    @Override
    protected void _setLongLE(int n4, long l2) {
        HeapByteBufUtil.setLongLE(this.array, n4, l2);
    }

    @Override
    public ByteBuf copy(int n4, int n7) {
        this.checkIndex(n4, n7);
        byte[] byArray = PlatformDependent.allocateUninitializedArray(n7);
        System.arraycopy(this.array, n4, byArray, 0, n7);
        return new UnpooledHeapByteBuf(this.alloc(), byArray, this.maxCapacity());
    }

    private ByteBuffer internalNioBuffer() {
        ByteBuffer byteBuffer = this.tmpNioBuf;
        if (byteBuffer == null) {
            this.tmpNioBuf = byteBuffer = ByteBuffer.wrap(this.array);
        }
        return byteBuffer;
    }

    @Override
    protected void deallocate() {
        this.freeArray(this.array);
        this.array = EmptyArrays.EMPTY_BYTES;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }
}

