/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class UnpooledDirectByteBuf
extends AbstractReferenceCountedByteBuf {
    private final ByteBufAllocator alloc;
    ByteBuffer buffer;
    private ByteBuffer tmpNioBuf;
    private int capacity;
    private boolean doNotFree;

    public UnpooledDirectByteBuf(ByteBufAllocator byteBufAllocator, int n4, int n7) {
        super(n7);
        if (byteBufAllocator == null) {
            throw new NullPointerException("alloc");
        }
        ObjectUtil.checkPositiveOrZero(n4, "initialCapacity");
        ObjectUtil.checkPositiveOrZero(n7, "maxCapacity");
        if (n4 > n7) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", n4, n7));
        }
        this.alloc = byteBufAllocator;
        this.setByteBuffer(this.allocateDirect(n4), false);
    }

    protected UnpooledDirectByteBuf(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer, int n4) {
        this(byteBufAllocator, byteBuffer, n4, false, true);
    }

    UnpooledDirectByteBuf(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer, int n4, boolean bl3, boolean bl4) {
        super(n4);
        if (byteBufAllocator == null) {
            throw new NullPointerException("alloc");
        }
        if (byteBuffer == null) {
            throw new NullPointerException("initialBuffer");
        }
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("initialBuffer is not a direct buffer.");
        }
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("initialBuffer is a read-only buffer.");
        }
        int n7 = byteBuffer.remaining();
        if (n7 > n4) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", n7, n4));
        }
        this.alloc = byteBufAllocator;
        this.doNotFree = !bl3;
        this.setByteBuffer((bl4 ? byteBuffer.slice() : byteBuffer).order(ByteOrder.BIG_ENDIAN), false);
        this.writerIndex(n7);
    }

    protected ByteBuffer allocateDirect(int n4) {
        return ByteBuffer.allocateDirect(n4);
    }

    protected void freeDirect(ByteBuffer byteBuffer) {
        PlatformDependent.freeDirectBuffer(byteBuffer);
    }

    void setByteBuffer(ByteBuffer byteBuffer, boolean bl3) {
        ByteBuffer byteBuffer2;
        if (bl3 && (byteBuffer2 = this.buffer) != null) {
            if (this.doNotFree) {
                this.doNotFree = false;
            } else {
                this.freeDirect(byteBuffer2);
            }
        }
        this.buffer = byteBuffer;
        this.tmpNioBuf = null;
        this.capacity = byteBuffer.remaining();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public ByteBuf capacity(int n4) {
        this.checkNewCapacity(n4);
        int n7 = this.readerIndex();
        int n8 = this.writerIndex();
        int n10 = this.capacity;
        if (n4 > n10) {
            ByteBuffer byteBuffer = this.buffer;
            ByteBuffer byteBuffer2 = this.allocateDirect(n4);
            byteBuffer.position(0).limit(byteBuffer.capacity());
            byteBuffer2.position(0).limit(byteBuffer.capacity());
            byteBuffer2.put(byteBuffer);
            byteBuffer2.clear();
            this.setByteBuffer(byteBuffer2, true);
        } else if (n4 < n10) {
            ByteBuffer byteBuffer = this.buffer;
            ByteBuffer byteBuffer3 = this.allocateDirect(n4);
            if (n7 < n4) {
                if (n8 > n4) {
                    n8 = n4;
                    this.writerIndex(n8);
                }
                byteBuffer.position(n7).limit(n8);
                byteBuffer3.position(n7).limit(n8);
                byteBuffer3.put(byteBuffer);
                byteBuffer3.clear();
            } else {
                this.setIndex(n4, n4);
            }
            this.setByteBuffer(byteBuffer3, true);
        }
        return this;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getByte(int n4) {
        this.ensureAccessible();
        return this._getByte(n4);
    }

    @Override
    protected byte _getByte(int n4) {
        return this.buffer.get(n4);
    }

    @Override
    public short getShort(int n4) {
        this.ensureAccessible();
        return this._getShort(n4);
    }

    @Override
    protected short _getShort(int n4) {
        return this.buffer.getShort(n4);
    }

    @Override
    protected short _getShortLE(int n4) {
        return ByteBufUtil.swapShort(this.buffer.getShort(n4));
    }

    @Override
    public int getUnsignedMedium(int n4) {
        this.ensureAccessible();
        return this._getUnsignedMedium(n4);
    }

    @Override
    protected int _getUnsignedMedium(int n4) {
        return (this.getByte(n4) & 0xFF) << 16 | (this.getByte(n4 + 1) & 0xFF) << 8 | this.getByte(n4 + 2) & 0xFF;
    }

    @Override
    protected int _getUnsignedMediumLE(int n4) {
        return this.getByte(n4) & 0xFF | (this.getByte(n4 + 1) & 0xFF) << 8 | (this.getByte(n4 + 2) & 0xFF) << 16;
    }

    @Override
    public int getInt(int n4) {
        this.ensureAccessible();
        return this._getInt(n4);
    }

    @Override
    protected int _getInt(int n4) {
        return this.buffer.getInt(n4);
    }

    @Override
    protected int _getIntLE(int n4) {
        return ByteBufUtil.swapInt(this.buffer.getInt(n4));
    }

    @Override
    public long getLong(int n4) {
        this.ensureAccessible();
        return this._getLong(n4);
    }

    @Override
    protected long _getLong(int n4) {
        return this.buffer.getLong(n4);
    }

    @Override
    protected long _getLongLE(int n4) {
        return ByteBufUtil.swapLong(this.buffer.getLong(n4));
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        this.checkDstIndex(n4, n8, n7, byteBuf.capacity());
        if (byteBuf.hasArray()) {
            this.getBytes(n4, byteBuf.array(), byteBuf.arrayOffset() + n7, n8);
        } else if (byteBuf.nioBufferCount() > 0) {
            for (ByteBuffer byteBuffer : byteBuf.nioBuffers(n7, n8)) {
                int n10 = byteBuffer.remaining();
                this.getBytes(n4, byteBuffer);
                n4 += n10;
            }
        } else {
            byteBuf.setBytes(n7, this, n4, n8);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, byte[] byArray, int n7, int n8) {
        this.getBytes(n4, byArray, n7, n8, false);
        return this;
    }

    void getBytes(int n4, byte[] byArray, int n7, int n8, boolean bl3) {
        this.checkDstIndex(n4, n8, n7, byArray.length);
        ByteBuffer byteBuffer = bl3 ? this.internalNioBuffer() : this.buffer.duplicate();
        byteBuffer.clear().position(n4).limit(n4 + n8);
        byteBuffer.get(byArray, n7, n8);
    }

    @Override
    public ByteBuf readBytes(byte[] byArray, int n4, int n7) {
        this.checkReadableBytes(n7);
        this.getBytes(this.readerIndex, byArray, n4, n7, true);
        this.readerIndex += n7;
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuffer byteBuffer) {
        this.getBytes(n4, byteBuffer, false);
        return this;
    }

    void getBytes(int n4, ByteBuffer byteBuffer, boolean bl3) {
        this.checkIndex(n4, byteBuffer.remaining());
        ByteBuffer byteBuffer2 = bl3 ? this.internalNioBuffer() : this.buffer.duplicate();
        byteBuffer2.clear().position(n4).limit(n4 + byteBuffer.remaining());
        byteBuffer.put(byteBuffer2);
    }

    @Override
    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        int n4 = byteBuffer.remaining();
        this.checkReadableBytes(n4);
        this.getBytes(this.readerIndex, byteBuffer, true);
        this.readerIndex += n4;
        return this;
    }

    @Override
    public ByteBuf setByte(int n4, int n7) {
        this.ensureAccessible();
        this._setByte(n4, n7);
        return this;
    }

    @Override
    protected void _setByte(int n4, int n7) {
        this.buffer.put(n4, (byte)n7);
    }

    @Override
    public ByteBuf setShort(int n4, int n7) {
        this.ensureAccessible();
        this._setShort(n4, n7);
        return this;
    }

    @Override
    protected void _setShort(int n4, int n7) {
        this.buffer.putShort(n4, (short)n7);
    }

    @Override
    protected void _setShortLE(int n4, int n7) {
        this.buffer.putShort(n4, ByteBufUtil.swapShort((short)n7));
    }

    @Override
    public ByteBuf setMedium(int n4, int n7) {
        this.ensureAccessible();
        this._setMedium(n4, n7);
        return this;
    }

    @Override
    protected void _setMedium(int n4, int n7) {
        this.setByte(n4, (byte)(n7 >>> 16));
        this.setByte(n4 + 1, (byte)(n7 >>> 8));
        this.setByte(n4 + 2, (byte)n7);
    }

    @Override
    protected void _setMediumLE(int n4, int n7) {
        this.setByte(n4, (byte)n7);
        this.setByte(n4 + 1, (byte)(n7 >>> 8));
        this.setByte(n4 + 2, (byte)(n7 >>> 16));
    }

    @Override
    public ByteBuf setInt(int n4, int n7) {
        this.ensureAccessible();
        this._setInt(n4, n7);
        return this;
    }

    @Override
    protected void _setInt(int n4, int n7) {
        this.buffer.putInt(n4, n7);
    }

    @Override
    protected void _setIntLE(int n4, int n7) {
        this.buffer.putInt(n4, ByteBufUtil.swapInt(n7));
    }

    @Override
    public ByteBuf setLong(int n4, long l2) {
        this.ensureAccessible();
        this._setLong(n4, l2);
        return this;
    }

    @Override
    protected void _setLong(int n4, long l2) {
        this.buffer.putLong(n4, l2);
    }

    @Override
    protected void _setLongLE(int n4, long l2) {
        this.buffer.putLong(n4, ByteBufUtil.swapLong(l2));
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        this.checkSrcIndex(n4, n8, n7, byteBuf.capacity());
        if (byteBuf.nioBufferCount() > 0) {
            for (ByteBuffer byteBuffer : byteBuf.nioBuffers(n7, n8)) {
                int n10 = byteBuffer.remaining();
                this.setBytes(n4, byteBuffer);
                n4 += n10;
            }
        } else {
            byteBuf.getBytes(n7, this, n4, n8);
        }
        return this;
    }

    @Override
    public ByteBuf setBytes(int n4, byte[] byArray, int n7, int n8) {
        this.checkSrcIndex(n4, n8, n7, byArray.length);
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.clear().position(n4).limit(n4 + n8);
        byteBuffer.put(byArray, n7, n8);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuffer byteBuffer) {
        this.ensureAccessible();
        ByteBuffer byteBuffer2 = this.internalNioBuffer();
        if (byteBuffer == byteBuffer2) {
            byteBuffer = byteBuffer.duplicate();
        }
        byteBuffer2.clear().position(n4).limit(n4 + byteBuffer.remaining());
        byteBuffer2.put(byteBuffer);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, OutputStream outputStream, int n7) {
        this.getBytes(n4, outputStream, n7, false);
        return this;
    }

    void getBytes(int n4, OutputStream outputStream, int n7, boolean bl3) {
        this.ensureAccessible();
        if (n7 == 0) {
            return;
        }
        ByteBufUtil.readBytes(this.alloc(), bl3 ? this.internalNioBuffer() : this.buffer.duplicate(), n4, n7, outputStream);
    }

    @Override
    public ByteBuf readBytes(OutputStream outputStream, int n4) {
        this.checkReadableBytes(n4);
        this.getBytes(this.readerIndex, outputStream, n4, true);
        this.readerIndex += n4;
        return this;
    }

    @Override
    public int getBytes(int n4, GatheringByteChannel gatheringByteChannel, int n7) {
        return this.getBytes(n4, gatheringByteChannel, n7, false);
    }

    private int getBytes(int n4, GatheringByteChannel gatheringByteChannel, int n7, boolean bl3) {
        this.ensureAccessible();
        if (n7 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = bl3 ? this.internalNioBuffer() : this.buffer.duplicate();
        byteBuffer.clear().position(n4).limit(n4 + n7);
        return gatheringByteChannel.write(byteBuffer);
    }

    @Override
    public int getBytes(int n4, FileChannel fileChannel, long l2, int n7) {
        return this.getBytes(n4, fileChannel, l2, n7, false);
    }

    private int getBytes(int n4, FileChannel fileChannel, long l2, int n7, boolean bl3) {
        this.ensureAccessible();
        if (n7 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = bl3 ? this.internalNioBuffer() : this.buffer.duplicate();
        byteBuffer.clear().position(n4).limit(n4 + n7);
        return fileChannel.write(byteBuffer, l2);
    }

    @Override
    public int readBytes(GatheringByteChannel gatheringByteChannel, int n4) {
        this.checkReadableBytes(n4);
        int n7 = this.getBytes(this.readerIndex, gatheringByteChannel, n4, true);
        this.readerIndex += n7;
        return n7;
    }

    @Override
    public int readBytes(FileChannel fileChannel, long l2, int n4) {
        this.checkReadableBytes(n4);
        int n7 = this.getBytes(this.readerIndex, fileChannel, l2, n4, true);
        this.readerIndex += n7;
        return n7;
    }

    @Override
    public int setBytes(int n4, InputStream inputStream, int n7) {
        this.ensureAccessible();
        if (this.buffer.hasArray()) {
            return inputStream.read(this.buffer.array(), this.buffer.arrayOffset() + n4, n7);
        }
        byte[] byArray = ByteBufUtil.threadLocalTempArray(n7);
        int n8 = inputStream.read(byArray, 0, n7);
        if (n8 <= 0) {
            return n8;
        }
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.clear().position(n4);
        byteBuffer.put(byArray, 0, n8);
        return n8;
    }

    @Override
    public int setBytes(int n4, ScatteringByteChannel scatteringByteChannel, int n7) {
        this.ensureAccessible();
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.clear().position(n4).limit(n4 + n7);
        try {
            return scatteringByteChannel.read(byteBuffer);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public int setBytes(int n4, FileChannel fileChannel, long l2, int n7) {
        this.ensureAccessible();
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.clear().position(n4).limit(n4 + n7);
        try {
            return fileChannel.read(byteBuffer, l2);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer[] nioBuffers(int n4, int n7) {
        return new ByteBuffer[]{this.nioBuffer(n4, n7)};
    }

    @Override
    public ByteBuf copy(int n4, int n7) {
        ByteBuffer byteBuffer;
        this.ensureAccessible();
        try {
            byteBuffer = (ByteBuffer)this.buffer.duplicate().clear().position(n4).limit(n4 + n7);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (n4 + n7));
        }
        return this.alloc().directBuffer(n7, this.maxCapacity()).writeBytes(byteBuffer);
    }

    @Override
    public ByteBuffer internalNioBuffer(int n4, int n7) {
        this.checkIndex(n4, n7);
        return (ByteBuffer)this.internalNioBuffer().clear().position(n4).limit(n4 + n7);
    }

    private ByteBuffer internalNioBuffer() {
        ByteBuffer byteBuffer = this.tmpNioBuf;
        if (byteBuffer == null) {
            this.tmpNioBuf = byteBuffer = this.buffer.duplicate();
        }
        return byteBuffer;
    }

    @Override
    public ByteBuffer nioBuffer(int n4, int n7) {
        this.checkIndex(n4, n7);
        return ((ByteBuffer)this.buffer.duplicate().position(n4).limit(n4 + n7)).slice();
    }

    @Override
    protected void deallocate() {
        ByteBuffer byteBuffer = this.buffer;
        if (byteBuffer == null) {
            return;
        }
        this.buffer = null;
        if (!this.doNotFree) {
            this.freeDirect(byteBuffer);
        }
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }
}

