/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.buffer.CompositeByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.CompositeByteBuf$ByteWrapper;
import io.grpc.netty.shaded.io.netty.buffer.EmptyByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.FixedCompositeByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ReadOnlyByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ReadOnlyByteBufferBuf;
import io.grpc.netty.shaded.io.netty.buffer.ReadOnlyUnsafeDirectByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.UnpooledDirectByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.UnpooledHeapByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.UnreleasableByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.WrappedUnpooledUnsafeDirectByteBuf;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public final class Unpooled {
    private static final ByteBufAllocator ALLOC = UnpooledByteBufAllocator.DEFAULT;
    public static final ByteOrder BIG_ENDIAN = ByteOrder.BIG_ENDIAN;
    public static final ByteOrder LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN;
    public static final ByteBuf EMPTY_BUFFER = ALLOC.buffer(0, 0);

    public static ByteBuf buffer() {
        return ALLOC.heapBuffer();
    }

    public static ByteBuf directBuffer() {
        return ALLOC.directBuffer();
    }

    public static ByteBuf buffer(int n4) {
        return ALLOC.heapBuffer(n4);
    }

    public static ByteBuf directBuffer(int n4) {
        return ALLOC.directBuffer(n4);
    }

    public static ByteBuf buffer(int n4, int n7) {
        return ALLOC.heapBuffer(n4, n7);
    }

    public static ByteBuf directBuffer(int n4, int n7) {
        return ALLOC.directBuffer(n4, n7);
    }

    public static ByteBuf wrappedBuffer(byte[] byArray) {
        if (byArray.length == 0) {
            return EMPTY_BUFFER;
        }
        return new UnpooledHeapByteBuf(ALLOC, byArray, byArray.length);
    }

    public static ByteBuf wrappedBuffer(byte[] byArray, int n4, int n7) {
        if (n7 == 0) {
            return EMPTY_BUFFER;
        }
        if (n4 == 0 && n7 == byArray.length) {
            return Unpooled.wrappedBuffer(byArray);
        }
        return Unpooled.wrappedBuffer(byArray).slice(n4, n7);
    }

    public static ByteBuf wrappedBuffer(ByteBuffer byteBuffer) {
        if (!byteBuffer.hasRemaining()) {
            return EMPTY_BUFFER;
        }
        if (!byteBuffer.isDirect() && byteBuffer.hasArray()) {
            return Unpooled.wrappedBuffer(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining()).order(byteBuffer.order());
        }
        if (PlatformDependent.hasUnsafe()) {
            if (byteBuffer.isReadOnly()) {
                if (byteBuffer.isDirect()) {
                    return new ReadOnlyUnsafeDirectByteBuf(ALLOC, byteBuffer);
                }
                return new ReadOnlyByteBufferBuf(ALLOC, byteBuffer);
            }
            return new UnpooledUnsafeDirectByteBuf(ALLOC, byteBuffer, byteBuffer.remaining());
        }
        if (byteBuffer.isReadOnly()) {
            return new ReadOnlyByteBufferBuf(ALLOC, byteBuffer);
        }
        return new UnpooledDirectByteBuf(ALLOC, byteBuffer, byteBuffer.remaining());
    }

    public static ByteBuf wrappedBuffer(long l2, int n4, boolean bl3) {
        return new WrappedUnpooledUnsafeDirectByteBuf(ALLOC, l2, n4, bl3);
    }

    public static ByteBuf wrappedBuffer(ByteBuf byteBuf) {
        if (byteBuf.isReadable()) {
            return byteBuf.slice();
        }
        byteBuf.release();
        return EMPTY_BUFFER;
    }

    public static ByteBuf wrappedBuffer(byte[] ... byArray) {
        return Unpooled.wrappedBuffer(byArray.length, byArray);
    }

    public static ByteBuf wrappedBuffer(ByteBuf ... byteBufArray) {
        return Unpooled.wrappedBuffer(byteBufArray.length, byteBufArray);
    }

    public static ByteBuf wrappedBuffer(ByteBuffer ... byteBufferArray) {
        return Unpooled.wrappedBuffer(byteBufferArray.length, byteBufferArray);
    }

    static <T> ByteBuf wrappedBuffer(int n4, CompositeByteBuf$ByteWrapper<T> compositeByteBuf$ByteWrapper, T[] TArray) {
        switch (TArray.length) {
            case 0: {
                break;
            }
            case 1: {
                if (compositeByteBuf$ByteWrapper.isEmpty(TArray[0])) break;
                return compositeByteBuf$ByteWrapper.wrap(TArray[0]);
            }
            default: {
                int n7 = TArray.length;
                for (int i3 = 0; i3 < n7; ++i3) {
                    T t3 = TArray[i3];
                    if (t3 == null) {
                        return EMPTY_BUFFER;
                    }
                    if (compositeByteBuf$ByteWrapper.isEmpty(t3)) continue;
                    return new CompositeByteBuf(ALLOC, false, n4, compositeByteBuf$ByteWrapper, TArray, i3);
                }
            }
        }
        return EMPTY_BUFFER;
    }

    public static ByteBuf wrappedBuffer(int n4, byte[] ... byArray) {
        return Unpooled.wrappedBuffer(n4, CompositeByteBuf.BYTE_ARRAY_WRAPPER, byArray);
    }

    public static ByteBuf wrappedBuffer(int n4, ByteBuf ... byteBufArray) {
        switch (byteBufArray.length) {
            case 0: {
                break;
            }
            case 1: {
                ByteBuf byteBuf = byteBufArray[0];
                if (byteBuf.isReadable()) {
                    return Unpooled.wrappedBuffer(byteBuf.order(BIG_ENDIAN));
                }
                byteBuf.release();
                break;
            }
            default: {
                for (int i3 = 0; i3 < byteBufArray.length; ++i3) {
                    ByteBuf byteBuf = byteBufArray[i3];
                    if (byteBuf.isReadable()) {
                        return new CompositeByteBuf(ALLOC, false, n4, byteBufArray, i3);
                    }
                    byteBuf.release();
                }
            }
        }
        return EMPTY_BUFFER;
    }

    public static ByteBuf wrappedBuffer(int n4, ByteBuffer ... byteBufferArray) {
        return Unpooled.wrappedBuffer(n4, CompositeByteBuf.BYTE_BUFFER_WRAPPER, byteBufferArray);
    }

    public static CompositeByteBuf compositeBuffer() {
        return Unpooled.compositeBuffer(16);
    }

    public static CompositeByteBuf compositeBuffer(int n4) {
        return new CompositeByteBuf(ALLOC, false, n4);
    }

    public static ByteBuf copiedBuffer(byte[] byArray) {
        if (byArray.length == 0) {
            return EMPTY_BUFFER;
        }
        return Unpooled.wrappedBuffer((byte[])byArray.clone());
    }

    public static ByteBuf copiedBuffer(byte[] byArray, int n4, int n7) {
        if (n7 == 0) {
            return EMPTY_BUFFER;
        }
        byte[] byArray2 = PlatformDependent.allocateUninitializedArray(n7);
        System.arraycopy(byArray, n4, byArray2, 0, n7);
        return Unpooled.wrappedBuffer(byArray2);
    }

    public static ByteBuf copiedBuffer(ByteBuffer byteBuffer) {
        int n4 = byteBuffer.remaining();
        if (n4 == 0) {
            return EMPTY_BUFFER;
        }
        byte[] byArray = PlatformDependent.allocateUninitializedArray(n4);
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        byteBuffer2.get(byArray);
        return Unpooled.wrappedBuffer(byArray).order(byteBuffer2.order());
    }

    public static ByteBuf copiedBuffer(ByteBuf byteBuf) {
        int n4 = byteBuf.readableBytes();
        if (n4 > 0) {
            ByteBuf byteBuf2 = Unpooled.buffer(n4);
            byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n4);
            return byteBuf2;
        }
        return EMPTY_BUFFER;
    }

    public static ByteBuf copiedBuffer(byte[] ... byArray) {
        switch (byArray.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                if (byArray[0].length == 0) {
                    return EMPTY_BUFFER;
                }
                return Unpooled.copiedBuffer(byArray[0]);
            }
        }
        int n4 = 0;
        for (byte[] byArray2 : byArray) {
            if (Integer.MAX_VALUE - n4 < byArray2.length) {
                throw new IllegalArgumentException("The total length of the specified arrays is too big.");
            }
            n4 += byArray2.length;
        }
        if (n4 == 0) {
            return EMPTY_BUFFER;
        }
        byte[] byArray3 = PlatformDependent.allocateUninitializedArray(n4);
        int n7 = 0;
        for (int i3 = 0; i3 < byArray.length; ++i3) {
            byte[] byArray2;
            byArray2 = byArray[i3];
            System.arraycopy(byArray2, 0, byArray3, n7, byArray2.length);
            n7 += byArray2.length;
        }
        return Unpooled.wrappedBuffer(byArray3);
    }

    public static ByteBuf copiedBuffer(ByteBuf ... byteBufArray) {
        int n4;
        switch (byteBufArray.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                return Unpooled.copiedBuffer(byteBufArray[0]);
            }
        }
        ByteOrder byteOrder = null;
        int n7 = 0;
        for (ByteBuf byteBuf : byteBufArray) {
            n4 = byteBuf.readableBytes();
            if (n4 <= 0) continue;
            if (Integer.MAX_VALUE - n7 < n4) {
                throw new IllegalArgumentException("The total length of the specified buffers is too big.");
            }
            n7 += n4;
            if (byteOrder != null) {
                if (byteOrder.equals(byteBuf.order())) continue;
                throw new IllegalArgumentException("inconsistent byte order");
            }
            byteOrder = byteBuf.order();
        }
        if (n7 == 0) {
            return EMPTY_BUFFER;
        }
        byte[] byArray = PlatformDependent.allocateUninitializedArray(n7);
        int n8 = 0;
        for (int i3 = 0; i3 < byteBufArray.length; ++i3) {
            ByteBuf byteBuf;
            byteBuf = byteBufArray[i3];
            n4 = byteBuf.readableBytes();
            byteBuf.getBytes(byteBuf.readerIndex(), byArray, n8, n4);
            n8 += n4;
        }
        return Unpooled.wrappedBuffer(byArray).order(byteOrder);
    }

    public static ByteBuf copiedBuffer(ByteBuffer ... byteBufferArray) {
        int n4;
        switch (byteBufferArray.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                return Unpooled.copiedBuffer(byteBufferArray[0]);
            }
        }
        ByteOrder byteOrder = null;
        int n7 = 0;
        for (ByteBuffer byteBuffer : byteBufferArray) {
            n4 = byteBuffer.remaining();
            if (n4 <= 0) continue;
            if (Integer.MAX_VALUE - n7 < n4) {
                throw new IllegalArgumentException("The total length of the specified buffers is too big.");
            }
            n7 += n4;
            if (byteOrder != null) {
                if (byteOrder.equals(byteBuffer.order())) continue;
                throw new IllegalArgumentException("inconsistent byte order");
            }
            byteOrder = byteBuffer.order();
        }
        if (n7 == 0) {
            return EMPTY_BUFFER;
        }
        byte[] byArray = PlatformDependent.allocateUninitializedArray(n7);
        int n8 = 0;
        for (int i3 = 0; i3 < byteBufferArray.length; ++i3) {
            ByteBuffer byteBuffer;
            byteBuffer = byteBufferArray[i3].duplicate();
            n4 = byteBuffer.remaining();
            byteBuffer.get(byArray, n8, n4);
            n8 += n4;
        }
        return Unpooled.wrappedBuffer(byArray).order(byteOrder);
    }

    public static ByteBuf copiedBuffer(CharSequence charSequence, Charset charset) {
        if (charSequence == null) {
            throw new NullPointerException("string");
        }
        if (charSequence instanceof CharBuffer) {
            return Unpooled.copiedBuffer((CharBuffer)charSequence, charset);
        }
        return Unpooled.copiedBuffer(CharBuffer.wrap(charSequence), charset);
    }

    public static ByteBuf copiedBuffer(CharSequence charSequence, int n4, int n7, Charset charset) {
        if (charSequence == null) {
            throw new NullPointerException("string");
        }
        if (n7 == 0) {
            return EMPTY_BUFFER;
        }
        if (charSequence instanceof CharBuffer) {
            CharBuffer charBuffer = (CharBuffer)charSequence;
            if (charBuffer.hasArray()) {
                return Unpooled.copiedBuffer(charBuffer.array(), charBuffer.arrayOffset() + charBuffer.position() + n4, n7, charset);
            }
            charBuffer = charBuffer.slice();
            charBuffer.limit(n7);
            charBuffer.position(n4);
            return Unpooled.copiedBuffer(charBuffer, charset);
        }
        return Unpooled.copiedBuffer(CharBuffer.wrap(charSequence, n4, n4 + n7), charset);
    }

    public static ByteBuf copiedBuffer(char[] cArray, Charset charset) {
        if (cArray == null) {
            throw new NullPointerException("array");
        }
        return Unpooled.copiedBuffer(cArray, 0, cArray.length, charset);
    }

    public static ByteBuf copiedBuffer(char[] cArray, int n4, int n7, Charset charset) {
        if (cArray == null) {
            throw new NullPointerException("array");
        }
        if (n7 == 0) {
            return EMPTY_BUFFER;
        }
        return Unpooled.copiedBuffer(CharBuffer.wrap(cArray, n4, n7), charset);
    }

    private static ByteBuf copiedBuffer(CharBuffer charBuffer, Charset charset) {
        return ByteBufUtil.encodeString0(ALLOC, true, charBuffer, charset, 0);
    }

    @Deprecated
    public static ByteBuf unmodifiableBuffer(ByteBuf byteBuf) {
        ByteOrder byteOrder = byteBuf.order();
        if (byteOrder == BIG_ENDIAN) {
            return new ReadOnlyByteBuf(byteBuf);
        }
        return new ReadOnlyByteBuf(byteBuf.order(BIG_ENDIAN)).order(LITTLE_ENDIAN);
    }

    public static ByteBuf copyInt(int n4) {
        ByteBuf byteBuf = Unpooled.buffer(4);
        byteBuf.writeInt(n4);
        return byteBuf;
    }

    public static ByteBuf copyInt(int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(nArray.length * 4);
        for (int n4 : nArray) {
            byteBuf.writeInt(n4);
        }
        return byteBuf;
    }

    public static ByteBuf copyShort(int n4) {
        ByteBuf byteBuf = Unpooled.buffer(2);
        byteBuf.writeShort(n4);
        return byteBuf;
    }

    public static ByteBuf copyShort(short ... sArray) {
        if (sArray == null || sArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(sArray.length * 2);
        for (short s11 : sArray) {
            byteBuf.writeShort(s11);
        }
        return byteBuf;
    }

    public static ByteBuf copyShort(int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(nArray.length * 2);
        for (int n4 : nArray) {
            byteBuf.writeShort(n4);
        }
        return byteBuf;
    }

    public static ByteBuf copyMedium(int n4) {
        ByteBuf byteBuf = Unpooled.buffer(3);
        byteBuf.writeMedium(n4);
        return byteBuf;
    }

    public static ByteBuf copyMedium(int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(nArray.length * 3);
        for (int n4 : nArray) {
            byteBuf.writeMedium(n4);
        }
        return byteBuf;
    }

    public static ByteBuf copyLong(long l2) {
        ByteBuf byteBuf = Unpooled.buffer(8);
        byteBuf.writeLong(l2);
        return byteBuf;
    }

    public static ByteBuf copyLong(long ... lArray) {
        if (lArray == null || lArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(lArray.length * 8);
        for (long l2 : lArray) {
            byteBuf.writeLong(l2);
        }
        return byteBuf;
    }

    public static ByteBuf copyBoolean(boolean bl3) {
        ByteBuf byteBuf = Unpooled.buffer(1);
        byteBuf.writeBoolean(bl3);
        return byteBuf;
    }

    public static ByteBuf copyBoolean(boolean ... blArray) {
        if (blArray == null || blArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(blArray.length);
        for (boolean bl3 : blArray) {
            byteBuf.writeBoolean(bl3);
        }
        return byteBuf;
    }

    public static ByteBuf copyFloat(float f8) {
        ByteBuf byteBuf = Unpooled.buffer(4);
        byteBuf.writeFloat(f8);
        return byteBuf;
    }

    public static ByteBuf copyFloat(float ... fArray) {
        if (fArray == null || fArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(fArray.length * 4);
        for (float f8 : fArray) {
            byteBuf.writeFloat(f8);
        }
        return byteBuf;
    }

    public static ByteBuf copyDouble(double d8) {
        ByteBuf byteBuf = Unpooled.buffer(8);
        byteBuf.writeDouble(d8);
        return byteBuf;
    }

    public static ByteBuf copyDouble(double ... dArray) {
        if (dArray == null || dArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(dArray.length * 8);
        for (double d8 : dArray) {
            byteBuf.writeDouble(d8);
        }
        return byteBuf;
    }

    public static ByteBuf unreleasableBuffer(ByteBuf byteBuf) {
        return new UnreleasableByteBuf(byteBuf);
    }

    @Deprecated
    public static ByteBuf unmodifiableBuffer(ByteBuf ... byteBufArray) {
        return Unpooled.wrappedUnmodifiableBuffer(true, byteBufArray);
    }

    public static ByteBuf wrappedUnmodifiableBuffer(ByteBuf ... byteBufArray) {
        return Unpooled.wrappedUnmodifiableBuffer(false, byteBufArray);
    }

    private static ByteBuf wrappedUnmodifiableBuffer(boolean bl3, ByteBuf ... byteBufArray) {
        switch (byteBufArray.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                return byteBufArray[0].asReadOnly();
            }
        }
        if (bl3) {
            byteBufArray = (ByteBuf[])Arrays.copyOf(byteBufArray, byteBufArray.length, ByteBuf[].class);
        }
        return new FixedCompositeByteBuf(ALLOC, byteBufArray);
    }

    private Unpooled() {
    }

    static {
        assert (EMPTY_BUFFER instanceof EmptyByteBuf) : "EMPTY_BUFFER must be an EmptyByteBuf.";
    }
}

