/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.AbstractByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.AbstractPooledDerivedByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.SwappedByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.WrappedByteBuf;
import io.grpc.netty.shaded.io.netty.util.ResourceLeakTracker;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;

class SimpleLeakAwareByteBuf
extends WrappedByteBuf {
    private final ByteBuf trackedByteBuf;
    final ResourceLeakTracker<ByteBuf> leak;

    SimpleLeakAwareByteBuf(ByteBuf byteBuf, ByteBuf byteBuf2, ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        super(byteBuf);
        this.trackedByteBuf = ObjectUtil.checkNotNull(byteBuf2, "trackedByteBuf");
        this.leak = ObjectUtil.checkNotNull(resourceLeakTracker, "leak");
    }

    SimpleLeakAwareByteBuf(ByteBuf byteBuf, ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        this(byteBuf, byteBuf, resourceLeakTracker);
    }

    @Override
    public ByteBuf slice() {
        return this.newSharedLeakAwareByteBuf(super.slice());
    }

    @Override
    public ByteBuf retainedSlice() {
        return this.unwrappedDerived(super.retainedSlice());
    }

    @Override
    public ByteBuf retainedSlice(int n4, int n7) {
        return this.unwrappedDerived(super.retainedSlice(n4, n7));
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return this.unwrappedDerived(super.retainedDuplicate());
    }

    @Override
    public ByteBuf readRetainedSlice(int n4) {
        return this.unwrappedDerived(super.readRetainedSlice(n4));
    }

    @Override
    public ByteBuf slice(int n4, int n7) {
        return this.newSharedLeakAwareByteBuf(super.slice(n4, n7));
    }

    @Override
    public ByteBuf duplicate() {
        return this.newSharedLeakAwareByteBuf(super.duplicate());
    }

    @Override
    public ByteBuf readSlice(int n4) {
        return this.newSharedLeakAwareByteBuf(super.readSlice(n4));
    }

    @Override
    public ByteBuf asReadOnly() {
        return this.newSharedLeakAwareByteBuf(super.asReadOnly());
    }

    @Override
    public ByteBuf touch() {
        return this;
    }

    @Override
    public ByteBuf touch(Object object) {
        return this;
    }

    @Override
    public boolean release() {
        if (super.release()) {
            this.closeLeak();
            return true;
        }
        return false;
    }

    @Override
    public boolean release(int n4) {
        if (super.release(n4)) {
            this.closeLeak();
            return true;
        }
        return false;
    }

    private void closeLeak() {
        boolean bl3 = this.leak.close(this.trackedByteBuf);
        assert (bl3);
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        if (this.order() == byteOrder) {
            return this;
        }
        return this.newSharedLeakAwareByteBuf(super.order(byteOrder));
    }

    private ByteBuf unwrappedDerived(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = SimpleLeakAwareByteBuf.unwrapSwapped(byteBuf);
        if (byteBuf2 instanceof AbstractPooledDerivedByteBuf) {
            ((AbstractPooledDerivedByteBuf)byteBuf2).parent(this);
            ResourceLeakTracker<ByteBuf> resourceLeakTracker = AbstractByteBuf.leakDetector.track(byteBuf);
            if (resourceLeakTracker == null) {
                return byteBuf;
            }
            return this.newLeakAwareByteBuf(byteBuf, resourceLeakTracker);
        }
        return this.newSharedLeakAwareByteBuf(byteBuf);
    }

    private static ByteBuf unwrapSwapped(ByteBuf byteBuf) {
        if (byteBuf instanceof SwappedByteBuf) {
            while ((byteBuf = byteBuf.unwrap()) instanceof SwappedByteBuf) {
            }
            return byteBuf;
        }
        return byteBuf;
    }

    private SimpleLeakAwareByteBuf newSharedLeakAwareByteBuf(ByteBuf byteBuf) {
        return this.newLeakAwareByteBuf(byteBuf, this.trackedByteBuf, this.leak);
    }

    private SimpleLeakAwareByteBuf newLeakAwareByteBuf(ByteBuf byteBuf, ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        return this.newLeakAwareByteBuf(byteBuf, byteBuf, resourceLeakTracker);
    }

    protected SimpleLeakAwareByteBuf newLeakAwareByteBuf(ByteBuf byteBuf, ByteBuf byteBuf2, ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        return new SimpleLeakAwareByteBuf(byteBuf, byteBuf2, resourceLeakTracker);
    }
}

