/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.ReadOnlyByteBufferBuf;
import io.grpc.netty.shaded.io.netty.buffer.UnsafeByteBufUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

final class ReadOnlyUnsafeDirectByteBuf
extends ReadOnlyByteBufferBuf {
    private final long memoryAddress;

    ReadOnlyUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer) {
        super(byteBufAllocator, byteBuffer);
        this.memoryAddress = PlatformDependent.directBufferAddress(this.buffer);
    }

    @Override
    protected byte _getByte(int n4) {
        return UnsafeByteBufUtil.getByte(this.addr(n4));
    }

    @Override
    protected short _getShort(int n4) {
        return UnsafeByteBufUtil.getShort(this.addr(n4));
    }

    @Override
    protected int _getUnsignedMedium(int n4) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr(n4));
    }

    @Override
    protected int _getInt(int n4) {
        return UnsafeByteBufUtil.getInt(this.addr(n4));
    }

    @Override
    protected long _getLong(int n4) {
        return UnsafeByteBufUtil.getLong(this.addr(n4));
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        this.checkIndex(n4, n8);
        if (byteBuf == null) {
            throw new NullPointerException("dst");
        }
        if (n7 < 0 || n7 > byteBuf.capacity() - n8) {
            throw new IndexOutOfBoundsException("dstIndex: " + n7);
        }
        if (byteBuf.hasMemoryAddress()) {
            PlatformDependent.copyMemory(this.addr(n4), byteBuf.memoryAddress() + (long)n7, n8);
        } else if (byteBuf.hasArray()) {
            PlatformDependent.copyMemory(this.addr(n4), byteBuf.array(), byteBuf.arrayOffset() + n7, (long)n8);
        } else {
            byteBuf.setBytes(n7, this, n4, n8);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, byte[] byArray, int n7, int n8) {
        this.checkIndex(n4, n8);
        if (byArray == null) {
            throw new NullPointerException("dst");
        }
        if (n7 < 0 || n7 > byArray.length - n8) {
            throw new IndexOutOfBoundsException(String.format("dstIndex: %d, length: %d (expected: range(0, %d))", n7, n8, byArray.length));
        }
        if (n8 != 0) {
            PlatformDependent.copyMemory(this.addr(n4), byArray, n7, (long)n8);
        }
        return this;
    }

    @Override
    public ByteBuf copy(int n4, int n7) {
        this.checkIndex(n4, n7);
        ByteBuf byteBuf = this.alloc().directBuffer(n7, this.maxCapacity());
        if (n7 != 0) {
            if (byteBuf.hasMemoryAddress()) {
                PlatformDependent.copyMemory(this.addr(n4), byteBuf.memoryAddress(), n7);
                byteBuf.setIndex(0, n7);
            } else {
                byteBuf.writeBytes(this, n4, n7);
            }
        }
        return byteBuf;
    }

    @Override
    public boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public long memoryAddress() {
        return this.memoryAddress;
    }

    private long addr(int n4) {
        return this.memoryAddress + (long)n4;
    }
}

