/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

class ReadOnlyByteBufferBuf
extends AbstractReferenceCountedByteBuf {
    protected final ByteBuffer buffer;
    private final ByteBufAllocator allocator;
    private ByteBuffer tmpNioBuf;

    ReadOnlyByteBufferBuf(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer) {
        super(byteBuffer.remaining());
        if (!byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("must be a readonly buffer: " + StringUtil.simpleClassName(byteBuffer));
        }
        this.allocator = byteBufAllocator;
        this.buffer = byteBuffer.slice().order(ByteOrder.BIG_ENDIAN);
        this.writerIndex(this.buffer.limit());
    }

    @Override
    protected void deallocate() {
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isWritable(int n4) {
        return false;
    }

    @Override
    public ByteBuf ensureWritable(int n4) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int ensureWritable(int n4, boolean bl3) {
        return 1;
    }

    @Override
    public byte getByte(int n4) {
        this.ensureAccessible();
        return this._getByte(n4);
    }

    @Override
    protected byte _getByte(int n4) {
        return this.buffer.get(n4);
    }

    @Override
    public short getShort(int n4) {
        this.ensureAccessible();
        return this._getShort(n4);
    }

    @Override
    protected short _getShort(int n4) {
        return this.buffer.getShort(n4);
    }

    @Override
    public short getShortLE(int n4) {
        this.ensureAccessible();
        return this._getShortLE(n4);
    }

    @Override
    protected short _getShortLE(int n4) {
        return ByteBufUtil.swapShort(this.buffer.getShort(n4));
    }

    @Override
    public int getUnsignedMedium(int n4) {
        this.ensureAccessible();
        return this._getUnsignedMedium(n4);
    }

    @Override
    protected int _getUnsignedMedium(int n4) {
        return (this.getByte(n4) & 0xFF) << 16 | (this.getByte(n4 + 1) & 0xFF) << 8 | this.getByte(n4 + 2) & 0xFF;
    }

    @Override
    public int getUnsignedMediumLE(int n4) {
        this.ensureAccessible();
        return this._getUnsignedMediumLE(n4);
    }

    @Override
    protected int _getUnsignedMediumLE(int n4) {
        return this.getByte(n4) & 0xFF | (this.getByte(n4 + 1) & 0xFF) << 8 | (this.getByte(n4 + 2) & 0xFF) << 16;
    }

    @Override
    public int getInt(int n4) {
        this.ensureAccessible();
        return this._getInt(n4);
    }

    @Override
    protected int _getInt(int n4) {
        return this.buffer.getInt(n4);
    }

    @Override
    public int getIntLE(int n4) {
        this.ensureAccessible();
        return this._getIntLE(n4);
    }

    @Override
    protected int _getIntLE(int n4) {
        return ByteBufUtil.swapInt(this.buffer.getInt(n4));
    }

    @Override
    public long getLong(int n4) {
        this.ensureAccessible();
        return this._getLong(n4);
    }

    @Override
    protected long _getLong(int n4) {
        return this.buffer.getLong(n4);
    }

    @Override
    public long getLongLE(int n4) {
        this.ensureAccessible();
        return this._getLongLE(n4);
    }

    @Override
    protected long _getLongLE(int n4) {
        return ByteBufUtil.swapLong(this.buffer.getLong(n4));
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        this.checkDstIndex(n4, n8, n7, byteBuf.capacity());
        if (byteBuf.hasArray()) {
            this.getBytes(n4, byteBuf.array(), byteBuf.arrayOffset() + n7, n8);
        } else if (byteBuf.nioBufferCount() > 0) {
            for (ByteBuffer byteBuffer : byteBuf.nioBuffers(n7, n8)) {
                int n10 = byteBuffer.remaining();
                this.getBytes(n4, byteBuffer);
                n4 += n10;
            }
        } else {
            byteBuf.setBytes(n7, this, n4, n8);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, byte[] byArray, int n7, int n8) {
        this.checkDstIndex(n4, n8, n7, byArray.length);
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.clear().position(n4).limit(n4 + n8);
        byteBuffer.get(byArray, n7, n8);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuffer byteBuffer) {
        this.checkIndex(n4, byteBuffer.remaining());
        ByteBuffer byteBuffer2 = this.internalNioBuffer();
        byteBuffer2.clear().position(n4).limit(n4 + byteBuffer.remaining());
        byteBuffer.put(byteBuffer2);
        return this;
    }

    @Override
    public ByteBuf setByte(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setByte(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setShort(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setShort(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setShortLE(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setShortLE(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setMedium(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setMedium(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setMediumLE(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setMediumLE(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setInt(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setInt(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setIntLE(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setIntLE(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setLong(int n4, long l2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setLong(int n4, long l2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setLongLE(int n4, long l2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setLongLE(int n4, long l2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int capacity() {
        return this.maxCapacity();
    }

    @Override
    public ByteBuf capacity(int n4) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return this.buffer.isReadOnly();
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public ByteBuf getBytes(int n4, OutputStream outputStream, int n7) {
        this.ensureAccessible();
        if (n7 == 0) {
            return this;
        }
        if (this.buffer.hasArray()) {
            outputStream.write(this.buffer.array(), n4 + this.buffer.arrayOffset(), n7);
        } else {
            byte[] byArray = ByteBufUtil.threadLocalTempArray(n7);
            ByteBuffer byteBuffer = this.internalNioBuffer();
            byteBuffer.clear().position(n4);
            byteBuffer.get(byArray, 0, n7);
            outputStream.write(byArray, 0, n7);
        }
        return this;
    }

    @Override
    public int getBytes(int n4, GatheringByteChannel gatheringByteChannel, int n7) {
        this.ensureAccessible();
        if (n7 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.clear().position(n4).limit(n4 + n7);
        return gatheringByteChannel.write(byteBuffer);
    }

    @Override
    public int getBytes(int n4, FileChannel fileChannel, long l2, int n7) {
        this.ensureAccessible();
        if (n7 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.clear().position(n4).limit(n4 + n7);
        return fileChannel.write(byteBuffer, l2);
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int n4, byte[] byArray, int n7, int n8) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuffer byteBuffer) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int n4, InputStream inputStream, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int n4, ScatteringByteChannel scatteringByteChannel, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int n4, FileChannel fileChannel, long l2, int n7) {
        throw new ReadOnlyBufferException();
    }

    protected final ByteBuffer internalNioBuffer() {
        ByteBuffer byteBuffer = this.tmpNioBuf;
        if (byteBuffer == null) {
            this.tmpNioBuf = byteBuffer = this.buffer.duplicate();
        }
        return byteBuffer;
    }

    @Override
    public ByteBuf copy(int n4, int n7) {
        ByteBuffer byteBuffer;
        this.ensureAccessible();
        try {
            byteBuffer = (ByteBuffer)this.internalNioBuffer().clear().position(n4).limit(n4 + n7);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (n4 + n7));
        }
        ByteBuf byteBuf = byteBuffer.isDirect() ? this.alloc().directBuffer(n7) : this.alloc().heapBuffer(n7);
        byteBuf.writeBytes(byteBuffer);
        return byteBuf;
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer[] nioBuffers(int n4, int n7) {
        return new ByteBuffer[]{this.nioBuffer(n4, n7)};
    }

    @Override
    public ByteBuffer nioBuffer(int n4, int n7) {
        this.checkIndex(n4, n7);
        return (ByteBuffer)this.buffer.duplicate().position(n4).limit(n4 + n7);
    }

    @Override
    public ByteBuffer internalNioBuffer(int n4, int n7) {
        this.ensureAccessible();
        return (ByteBuffer)this.internalNioBuffer().clear().position(n4).limit(n4 + n7);
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }
}

