/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.AbstractByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.PoolChunk;
import io.grpc.netty.shaded.io.netty.buffer.PoolThreadCache;
import io.grpc.netty.shaded.io.netty.buffer.PooledByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.PooledUnsafeDirectByteBuf$1;
import io.grpc.netty.shaded.io.netty.buffer.SwappedByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.UnsafeByteBufUtil;
import io.grpc.netty.shaded.io.netty.buffer.UnsafeDirectSwappedByteBuf;
import io.grpc.netty.shaded.io.netty.util.Recycler;
import io.grpc.netty.shaded.io.netty.util.Recycler$Handle;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

final class PooledUnsafeDirectByteBuf
extends PooledByteBuf<ByteBuffer> {
    private static final Recycler<PooledUnsafeDirectByteBuf> RECYCLER = new PooledUnsafeDirectByteBuf$1();
    private long memoryAddress;

    static PooledUnsafeDirectByteBuf newInstance(int n4) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = RECYCLER.get();
        pooledUnsafeDirectByteBuf.reuse(n4);
        return pooledUnsafeDirectByteBuf;
    }

    private PooledUnsafeDirectByteBuf(Recycler$Handle<PooledUnsafeDirectByteBuf> recycler$Handle, int n4) {
        super(recycler$Handle, n4);
    }

    @Override
    void init(PoolChunk<ByteBuffer> poolChunk, ByteBuffer byteBuffer, long l2, int n4, int n7, int n8, PoolThreadCache poolThreadCache) {
        super.init(poolChunk, byteBuffer, l2, n4, n7, n8, poolThreadCache);
        this.initMemoryAddress();
    }

    @Override
    void initUnpooled(PoolChunk<ByteBuffer> poolChunk, int n4) {
        super.initUnpooled(poolChunk, n4);
        this.initMemoryAddress();
    }

    private void initMemoryAddress() {
        this.memoryAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.memory) + (long)this.offset;
    }

    @Override
    protected ByteBuffer newInternalNioBuffer(ByteBuffer byteBuffer) {
        return byteBuffer.duplicate();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    protected byte _getByte(int n4) {
        return UnsafeByteBufUtil.getByte(this.addr(n4));
    }

    @Override
    protected short _getShort(int n4) {
        return UnsafeByteBufUtil.getShort(this.addr(n4));
    }

    @Override
    protected short _getShortLE(int n4) {
        return UnsafeByteBufUtil.getShortLE(this.addr(n4));
    }

    @Override
    protected int _getUnsignedMedium(int n4) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr(n4));
    }

    @Override
    protected int _getUnsignedMediumLE(int n4) {
        return UnsafeByteBufUtil.getUnsignedMediumLE(this.addr(n4));
    }

    @Override
    protected int _getInt(int n4) {
        return UnsafeByteBufUtil.getInt(this.addr(n4));
    }

    @Override
    protected int _getIntLE(int n4) {
        return UnsafeByteBufUtil.getIntLE(this.addr(n4));
    }

    @Override
    protected long _getLong(int n4) {
        return UnsafeByteBufUtil.getLong(this.addr(n4));
    }

    @Override
    protected long _getLongLE(int n4) {
        return UnsafeByteBufUtil.getLongLE(this.addr(n4));
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, this.addr(n4), n4, byteBuf, n7, n8);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, byte[] byArray, int n7, int n8) {
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, this.addr(n4), n4, byArray, n7, n8);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuffer byteBuffer) {
        UnsafeByteBufUtil.getBytes(this, this.addr(n4), n4, byteBuffer);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, OutputStream outputStream, int n7) {
        UnsafeByteBufUtil.getBytes(this, this.addr(n4), n4, outputStream, n7);
        return this;
    }

    @Override
    protected void _setByte(int n4, int n7) {
        UnsafeByteBufUtil.setByte(this.addr(n4), (byte)n7);
    }

    @Override
    protected void _setShort(int n4, int n7) {
        UnsafeByteBufUtil.setShort(this.addr(n4), n7);
    }

    @Override
    protected void _setShortLE(int n4, int n7) {
        UnsafeByteBufUtil.setShortLE(this.addr(n4), n7);
    }

    @Override
    protected void _setMedium(int n4, int n7) {
        UnsafeByteBufUtil.setMedium(this.addr(n4), n7);
    }

    @Override
    protected void _setMediumLE(int n4, int n7) {
        UnsafeByteBufUtil.setMediumLE(this.addr(n4), n7);
    }

    @Override
    protected void _setInt(int n4, int n7) {
        UnsafeByteBufUtil.setInt(this.addr(n4), n7);
    }

    @Override
    protected void _setIntLE(int n4, int n7) {
        UnsafeByteBufUtil.setIntLE(this.addr(n4), n7);
    }

    @Override
    protected void _setLong(int n4, long l2) {
        UnsafeByteBufUtil.setLong(this.addr(n4), l2);
    }

    @Override
    protected void _setLongLE(int n4, long l2) {
        UnsafeByteBufUtil.setLongLE(this.addr(n4), l2);
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, this.addr(n4), n4, byteBuf, n7, n8);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n4, byte[] byArray, int n7, int n8) {
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, this.addr(n4), n4, byArray, n7, n8);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuffer byteBuffer) {
        UnsafeByteBufUtil.setBytes(this, this.addr(n4), n4, byteBuffer);
        return this;
    }

    @Override
    public int setBytes(int n4, InputStream inputStream, int n7) {
        return UnsafeByteBufUtil.setBytes(this, this.addr(n4), n4, inputStream, n7);
    }

    @Override
    public ByteBuf copy(int n4, int n7) {
        return UnsafeByteBufUtil.copy(this, this.addr(n4), n4, n7);
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public long memoryAddress() {
        this.ensureAccessible();
        return this.memoryAddress;
    }

    private long addr(int n4) {
        return this.memoryAddress + (long)n4;
    }

    @Override
    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeDirectSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }

    @Override
    public ByteBuf setZero(int n4, int n7) {
        this.checkIndex(n4, n7);
        UnsafeByteBufUtil.setZero(this.addr(n4), n7);
        return this;
    }

    @Override
    public ByteBuf writeZero(int n4) {
        this.ensureWritable(n4);
        int n7 = this.writerIndex;
        UnsafeByteBufUtil.setZero(this.addr(n7), n4);
        this.writerIndex = n7 + n4;
        return this;
    }

    /* synthetic */ PooledUnsafeDirectByteBuf(Recycler$Handle recycler$Handle, int n4, PooledUnsafeDirectByteBuf$1 pooledUnsafeDirectByteBuf$1) {
        this(recycler$Handle, n4);
    }
}

