/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.HeapByteBufUtil;
import io.grpc.netty.shaded.io.netty.buffer.PooledByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.PooledHeapByteBuf$1;
import io.grpc.netty.shaded.io.netty.util.Recycler;
import io.grpc.netty.shaded.io.netty.util.Recycler$Handle;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class PooledHeapByteBuf
extends PooledByteBuf<byte[]> {
    private static final Recycler<PooledHeapByteBuf> RECYCLER = new PooledHeapByteBuf$1();

    static PooledHeapByteBuf newInstance(int n4) {
        PooledHeapByteBuf pooledHeapByteBuf = RECYCLER.get();
        pooledHeapByteBuf.reuse(n4);
        return pooledHeapByteBuf;
    }

    PooledHeapByteBuf(Recycler$Handle<? extends PooledHeapByteBuf> recycler$Handle, int n4) {
        super(recycler$Handle, n4);
    }

    @Override
    public final boolean isDirect() {
        return false;
    }

    @Override
    protected byte _getByte(int n4) {
        return HeapByteBufUtil.getByte((byte[])this.memory, this.idx(n4));
    }

    @Override
    protected short _getShort(int n4) {
        return HeapByteBufUtil.getShort((byte[])this.memory, this.idx(n4));
    }

    @Override
    protected short _getShortLE(int n4) {
        return HeapByteBufUtil.getShortLE((byte[])this.memory, this.idx(n4));
    }

    @Override
    protected int _getUnsignedMedium(int n4) {
        return HeapByteBufUtil.getUnsignedMedium((byte[])this.memory, this.idx(n4));
    }

    @Override
    protected int _getUnsignedMediumLE(int n4) {
        return HeapByteBufUtil.getUnsignedMediumLE((byte[])this.memory, this.idx(n4));
    }

    @Override
    protected int _getInt(int n4) {
        return HeapByteBufUtil.getInt((byte[])this.memory, this.idx(n4));
    }

    @Override
    protected int _getIntLE(int n4) {
        return HeapByteBufUtil.getIntLE((byte[])this.memory, this.idx(n4));
    }

    @Override
    protected long _getLong(int n4) {
        return HeapByteBufUtil.getLong((byte[])this.memory, this.idx(n4));
    }

    @Override
    protected long _getLongLE(int n4) {
        return HeapByteBufUtil.getLongLE((byte[])this.memory, this.idx(n4));
    }

    @Override
    public final ByteBuf getBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        this.checkDstIndex(n4, n8, n7, byteBuf.capacity());
        if (byteBuf.hasMemoryAddress()) {
            PlatformDependent.copyMemory((byte[])this.memory, this.idx(n4), byteBuf.memoryAddress() + (long)n7, (long)n8);
        } else if (byteBuf.hasArray()) {
            this.getBytes(n4, byteBuf.array(), byteBuf.arrayOffset() + n7, n8);
        } else {
            byteBuf.setBytes(n7, (byte[])this.memory, this.idx(n4), n8);
        }
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n4, byte[] byArray, int n7, int n8) {
        this.checkDstIndex(n4, n8, n7, byArray.length);
        System.arraycopy(this.memory, this.idx(n4), byArray, n7, n8);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n4, ByteBuffer byteBuffer) {
        int n7 = byteBuffer.remaining();
        this.checkIndex(n4, n7);
        byteBuffer.put((byte[])this.memory, this.idx(n4), n7);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n4, OutputStream outputStream, int n7) {
        this.checkIndex(n4, n7);
        outputStream.write((byte[])this.memory, this.idx(n4), n7);
        return this;
    }

    @Override
    protected void _setByte(int n4, int n7) {
        HeapByteBufUtil.setByte((byte[])this.memory, this.idx(n4), n7);
    }

    @Override
    protected void _setShort(int n4, int n7) {
        HeapByteBufUtil.setShort((byte[])this.memory, this.idx(n4), n7);
    }

    @Override
    protected void _setShortLE(int n4, int n7) {
        HeapByteBufUtil.setShortLE((byte[])this.memory, this.idx(n4), n7);
    }

    @Override
    protected void _setMedium(int n4, int n7) {
        HeapByteBufUtil.setMedium((byte[])this.memory, this.idx(n4), n7);
    }

    @Override
    protected void _setMediumLE(int n4, int n7) {
        HeapByteBufUtil.setMediumLE((byte[])this.memory, this.idx(n4), n7);
    }

    @Override
    protected void _setInt(int n4, int n7) {
        HeapByteBufUtil.setInt((byte[])this.memory, this.idx(n4), n7);
    }

    @Override
    protected void _setIntLE(int n4, int n7) {
        HeapByteBufUtil.setIntLE((byte[])this.memory, this.idx(n4), n7);
    }

    @Override
    protected void _setLong(int n4, long l2) {
        HeapByteBufUtil.setLong((byte[])this.memory, this.idx(n4), l2);
    }

    @Override
    protected void _setLongLE(int n4, long l2) {
        HeapByteBufUtil.setLongLE((byte[])this.memory, this.idx(n4), l2);
    }

    @Override
    public final ByteBuf setBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        this.checkSrcIndex(n4, n8, n7, byteBuf.capacity());
        if (byteBuf.hasMemoryAddress()) {
            PlatformDependent.copyMemory(byteBuf.memoryAddress() + (long)n7, (byte[])this.memory, this.idx(n4), (long)n8);
        } else if (byteBuf.hasArray()) {
            this.setBytes(n4, byteBuf.array(), byteBuf.arrayOffset() + n7, n8);
        } else {
            byteBuf.getBytes(n7, (byte[])this.memory, this.idx(n4), n8);
        }
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n4, byte[] byArray, int n7, int n8) {
        this.checkSrcIndex(n4, n8, n7, byArray.length);
        System.arraycopy(byArray, n7, this.memory, this.idx(n4), n8);
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n4, ByteBuffer byteBuffer) {
        int n7 = byteBuffer.remaining();
        this.checkIndex(n4, n7);
        byteBuffer.get((byte[])this.memory, this.idx(n4), n7);
        return this;
    }

    @Override
    public final int setBytes(int n4, InputStream inputStream, int n7) {
        this.checkIndex(n4, n7);
        return inputStream.read((byte[])this.memory, this.idx(n4), n7);
    }

    @Override
    public final ByteBuf copy(int n4, int n7) {
        this.checkIndex(n4, n7);
        ByteBuf byteBuf = this.alloc().heapBuffer(n7, this.maxCapacity());
        return byteBuf.writeBytes((byte[])this.memory, this.idx(n4), n7);
    }

    @Override
    final ByteBuffer duplicateInternalNioBuffer(int n4, int n7) {
        this.checkIndex(n4, n7);
        return ByteBuffer.wrap((byte[])this.memory, this.idx(n4), n7).slice();
    }

    @Override
    public final boolean hasArray() {
        return true;
    }

    @Override
    public final byte[] array() {
        this.ensureAccessible();
        return (byte[])this.memory;
    }

    @Override
    public final int arrayOffset() {
        return this.offset;
    }

    @Override
    public final boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public final long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final ByteBuffer newInternalNioBuffer(byte[] byArray) {
        return ByteBuffer.wrap(byArray);
    }
}

