/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.buffer.PooledByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.PooledDirectByteBuf$1;
import io.grpc.netty.shaded.io.netty.util.Recycler;
import io.grpc.netty.shaded.io.netty.util.Recycler$Handle;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

final class PooledDirectByteBuf
extends PooledByteBuf<ByteBuffer> {
    private static final Recycler<PooledDirectByteBuf> RECYCLER = new PooledDirectByteBuf$1();

    static PooledDirectByteBuf newInstance(int n4) {
        PooledDirectByteBuf pooledDirectByteBuf = RECYCLER.get();
        pooledDirectByteBuf.reuse(n4);
        return pooledDirectByteBuf;
    }

    private PooledDirectByteBuf(Recycler$Handle<PooledDirectByteBuf> recycler$Handle, int n4) {
        super(recycler$Handle, n4);
    }

    @Override
    protected ByteBuffer newInternalNioBuffer(ByteBuffer byteBuffer) {
        return byteBuffer.duplicate();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    protected byte _getByte(int n4) {
        return ((ByteBuffer)this.memory).get(this.idx(n4));
    }

    @Override
    protected short _getShort(int n4) {
        return ((ByteBuffer)this.memory).getShort(this.idx(n4));
    }

    @Override
    protected short _getShortLE(int n4) {
        return ByteBufUtil.swapShort(this._getShort(n4));
    }

    @Override
    protected int _getUnsignedMedium(int n4) {
        n4 = this.idx(n4);
        return (((ByteBuffer)this.memory).get(n4) & 0xFF) << 16 | (((ByteBuffer)this.memory).get(n4 + 1) & 0xFF) << 8 | ((ByteBuffer)this.memory).get(n4 + 2) & 0xFF;
    }

    @Override
    protected int _getUnsignedMediumLE(int n4) {
        n4 = this.idx(n4);
        return ((ByteBuffer)this.memory).get(n4) & 0xFF | (((ByteBuffer)this.memory).get(n4 + 1) & 0xFF) << 8 | (((ByteBuffer)this.memory).get(n4 + 2) & 0xFF) << 16;
    }

    @Override
    protected int _getInt(int n4) {
        return ((ByteBuffer)this.memory).getInt(this.idx(n4));
    }

    @Override
    protected int _getIntLE(int n4) {
        return ByteBufUtil.swapInt(this._getInt(n4));
    }

    @Override
    protected long _getLong(int n4) {
        return ((ByteBuffer)this.memory).getLong(this.idx(n4));
    }

    @Override
    protected long _getLongLE(int n4) {
        return ByteBufUtil.swapLong(this._getLong(n4));
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        this.checkDstIndex(n4, n8, n7, byteBuf.capacity());
        if (byteBuf.hasArray()) {
            this.getBytes(n4, byteBuf.array(), byteBuf.arrayOffset() + n7, n8);
        } else if (byteBuf.nioBufferCount() > 0) {
            for (ByteBuffer byteBuffer : byteBuf.nioBuffers(n7, n8)) {
                int n10 = byteBuffer.remaining();
                this.getBytes(n4, byteBuffer);
                n4 += n10;
            }
        } else {
            byteBuf.setBytes(n7, this, n4, n8);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, byte[] byArray, int n7, int n8) {
        this.checkDstIndex(n4, n8, n7, byArray.length);
        this._internalNioBuffer(n4, n8, true).get(byArray, n7, n8);
        return this;
    }

    @Override
    public ByteBuf readBytes(byte[] byArray, int n4, int n7) {
        this.checkDstIndex(n7, n4, byArray.length);
        this._internalNioBuffer(this.readerIndex, n7, false).get(byArray, n4, n7);
        this.readerIndex += n7;
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuffer byteBuffer) {
        byteBuffer.put(this.duplicateInternalNioBuffer(n4, byteBuffer.remaining()));
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        int n4 = byteBuffer.remaining();
        this.checkReadableBytes(n4);
        byteBuffer.put(this._internalNioBuffer(this.readerIndex, n4, false));
        this.readerIndex += n4;
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, OutputStream outputStream, int n7) {
        this.getBytes(n4, outputStream, n7, false);
        return this;
    }

    private void getBytes(int n4, OutputStream outputStream, int n7, boolean bl3) {
        this.checkIndex(n4, n7);
        if (n7 == 0) {
            return;
        }
        ByteBufUtil.readBytes(this.alloc(), bl3 ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate(), this.idx(n4), n7, outputStream);
    }

    @Override
    public ByteBuf readBytes(OutputStream outputStream, int n4) {
        this.checkReadableBytes(n4);
        this.getBytes(this.readerIndex, outputStream, n4, true);
        this.readerIndex += n4;
        return this;
    }

    @Override
    protected void _setByte(int n4, int n7) {
        ((ByteBuffer)this.memory).put(this.idx(n4), (byte)n7);
    }

    @Override
    protected void _setShort(int n4, int n7) {
        ((ByteBuffer)this.memory).putShort(this.idx(n4), (short)n7);
    }

    @Override
    protected void _setShortLE(int n4, int n7) {
        this._setShort(n4, ByteBufUtil.swapShort((short)n7));
    }

    @Override
    protected void _setMedium(int n4, int n7) {
        n4 = this.idx(n4);
        ((ByteBuffer)this.memory).put(n4, (byte)(n7 >>> 16));
        ((ByteBuffer)this.memory).put(n4 + 1, (byte)(n7 >>> 8));
        ((ByteBuffer)this.memory).put(n4 + 2, (byte)n7);
    }

    @Override
    protected void _setMediumLE(int n4, int n7) {
        n4 = this.idx(n4);
        ((ByteBuffer)this.memory).put(n4, (byte)n7);
        ((ByteBuffer)this.memory).put(n4 + 1, (byte)(n7 >>> 8));
        ((ByteBuffer)this.memory).put(n4 + 2, (byte)(n7 >>> 16));
    }

    @Override
    protected void _setInt(int n4, int n7) {
        ((ByteBuffer)this.memory).putInt(this.idx(n4), n7);
    }

    @Override
    protected void _setIntLE(int n4, int n7) {
        this._setInt(n4, ByteBufUtil.swapInt(n7));
    }

    @Override
    protected void _setLong(int n4, long l2) {
        ((ByteBuffer)this.memory).putLong(this.idx(n4), l2);
    }

    @Override
    protected void _setLongLE(int n4, long l2) {
        this._setLong(n4, ByteBufUtil.swapLong(l2));
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        this.checkSrcIndex(n4, n8, n7, byteBuf.capacity());
        if (byteBuf.hasArray()) {
            this.setBytes(n4, byteBuf.array(), byteBuf.arrayOffset() + n7, n8);
        } else if (byteBuf.nioBufferCount() > 0) {
            for (ByteBuffer byteBuffer : byteBuf.nioBuffers(n7, n8)) {
                int n10 = byteBuffer.remaining();
                this.setBytes(n4, byteBuffer);
                n4 += n10;
            }
        } else {
            byteBuf.getBytes(n7, this, n4, n8);
        }
        return this;
    }

    @Override
    public ByteBuf setBytes(int n4, byte[] byArray, int n7, int n8) {
        this.checkSrcIndex(n4, n8, n7, byArray.length);
        this._internalNioBuffer(n4, n8, false).put(byArray, n7, n8);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuffer byteBuffer) {
        int n7 = byteBuffer.remaining();
        this.checkIndex(n4, n7);
        ByteBuffer byteBuffer2 = this.internalNioBuffer();
        if (byteBuffer == byteBuffer2) {
            byteBuffer = byteBuffer.duplicate();
        }
        n4 = this.idx(n4);
        byteBuffer2.clear().position(n4).limit(n4 + n7);
        byteBuffer2.put(byteBuffer);
        return this;
    }

    @Override
    public int setBytes(int n4, InputStream inputStream, int n7) {
        this.checkIndex(n4, n7);
        byte[] byArray = ByteBufUtil.threadLocalTempArray(n7);
        int n8 = inputStream.read(byArray, 0, n7);
        if (n8 <= 0) {
            return n8;
        }
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.clear().position(this.idx(n4));
        byteBuffer.put(byArray, 0, n8);
        return n8;
    }

    @Override
    public ByteBuf copy(int n4, int n7) {
        this.checkIndex(n4, n7);
        ByteBuf byteBuf = this.alloc().directBuffer(n7, this.maxCapacity());
        return byteBuf.writeBytes(this, n4, n7);
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    /* synthetic */ PooledDirectByteBuf(Recycler$Handle recycler$Handle, int n4, PooledDirectByteBuf$1 pooledDirectByteBuf$1) {
        this(recycler$Handle, n4);
    }
}

