/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.AbstractByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocatorMetricProvider;
import io.grpc.netty.shaded.io.netty.buffer.PoolArena;
import io.grpc.netty.shaded.io.netty.buffer.PoolArena$DirectArena;
import io.grpc.netty.shaded.io.netty.buffer.PoolArena$HeapArena;
import io.grpc.netty.shaded.io.netty.buffer.PoolArenaMetric;
import io.grpc.netty.shaded.io.netty.buffer.PoolThreadCache;
import io.grpc.netty.shaded.io.netty.buffer.PooledByteBufAllocator$1;
import io.grpc.netty.shaded.io.netty.buffer.PooledByteBufAllocator$PoolThreadLocalCache;
import io.grpc.netty.shaded.io.netty.buffer.PooledByteBufAllocatorMetric;
import io.grpc.netty.shaded.io.netty.buffer.UnpooledDirectByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.UnpooledHeapByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.UnsafeByteBufUtil;
import io.grpc.netty.shaded.io.netty.util.NettyRuntime;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PooledByteBufAllocator
extends AbstractByteBufAllocator
implements ByteBufAllocatorMetricProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PooledByteBufAllocator.class);
    private static final int DEFAULT_NUM_HEAP_ARENA;
    private static final int DEFAULT_NUM_DIRECT_ARENA;
    private static final int DEFAULT_PAGE_SIZE;
    private static final int DEFAULT_MAX_ORDER;
    private static final int DEFAULT_TINY_CACHE_SIZE;
    private static final int DEFAULT_SMALL_CACHE_SIZE;
    private static final int DEFAULT_NORMAL_CACHE_SIZE;
    private static final int DEFAULT_MAX_CACHED_BUFFER_CAPACITY;
    private static final int DEFAULT_CACHE_TRIM_INTERVAL;
    private static final long DEFAULT_CACHE_TRIM_INTERVAL_MILLIS;
    private static final boolean DEFAULT_USE_CACHE_FOR_ALL_THREADS;
    private static final int DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT;
    static final int DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK;
    private static final int MIN_PAGE_SIZE = 4096;
    private static final int MAX_CHUNK_SIZE = 0x40000000;
    private final Runnable trimTask = new PooledByteBufAllocator$1(this);
    public static final PooledByteBufAllocator DEFAULT;
    private final PoolArena<byte[]>[] heapArenas;
    private final PoolArena<ByteBuffer>[] directArenas;
    private final int tinyCacheSize;
    private final int smallCacheSize;
    private final int normalCacheSize;
    private final List<PoolArenaMetric> heapArenaMetrics;
    private final List<PoolArenaMetric> directArenaMetrics;
    private final PooledByteBufAllocator$PoolThreadLocalCache threadCache;
    private final int chunkSize;
    private final PooledByteBufAllocatorMetric metric;

    public PooledByteBufAllocator() {
        this(false);
    }

    public PooledByteBufAllocator(boolean bl3) {
        this(bl3, DEFAULT_NUM_HEAP_ARENA, DEFAULT_NUM_DIRECT_ARENA, DEFAULT_PAGE_SIZE, DEFAULT_MAX_ORDER);
    }

    public PooledByteBufAllocator(int n4, int n7, int n8, int n10) {
        this(false, n4, n7, n8, n10);
    }

    @Deprecated
    public PooledByteBufAllocator(boolean bl3, int n4, int n7, int n8, int n10) {
        this(bl3, n4, n7, n8, n10, DEFAULT_TINY_CACHE_SIZE, DEFAULT_SMALL_CACHE_SIZE, DEFAULT_NORMAL_CACHE_SIZE);
    }

    @Deprecated
    public PooledByteBufAllocator(boolean bl3, int n4, int n7, int n8, int n10, int n11, int n12, int n13) {
        this(bl3, n4, n7, n8, n10, n11, n12, n13, DEFAULT_USE_CACHE_FOR_ALL_THREADS, DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT);
    }

    public PooledByteBufAllocator(boolean bl3, int n4, int n7, int n8, int n10, int n11, int n12, int n13, boolean bl4) {
        this(bl3, n4, n7, n8, n10, n11, n12, n13, bl4, DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT);
    }

    public PooledByteBufAllocator(boolean bl3, int n4, int n7, int n8, int n10, int n11, int n12, int n13, boolean bl4, int n14) {
        super(bl3);
        PoolArena poolArena;
        int n15;
        ArrayList<PoolArena$HeapArena> arrayList;
        this.threadCache = new PooledByteBufAllocator$PoolThreadLocalCache(this, bl4);
        this.tinyCacheSize = n11;
        this.smallCacheSize = n12;
        this.normalCacheSize = n13;
        this.chunkSize = PooledByteBufAllocator.validateAndCalculateChunkSize(n8, n10);
        ObjectUtil.checkPositiveOrZero(n4, "nHeapArena");
        ObjectUtil.checkPositiveOrZero(n7, "nDirectArena");
        ObjectUtil.checkPositiveOrZero(n14, "directMemoryCacheAlignment");
        if (n14 > 0 && !PooledByteBufAllocator.isDirectMemoryCacheAlignmentSupported()) {
            throw new IllegalArgumentException("directMemoryCacheAlignment is not supported");
        }
        if ((n14 & -n14) != n14) {
            throw new IllegalArgumentException("directMemoryCacheAlignment: " + n14 + " (expected: power of two)");
        }
        int n16 = PooledByteBufAllocator.validateAndCalculatePageShifts(n8);
        if (n4 > 0) {
            this.heapArenas = PooledByteBufAllocator.newArenaArray(n4);
            arrayList = new ArrayList<PoolArena$HeapArena>(this.heapArenas.length);
            for (n15 = 0; n15 < this.heapArenas.length; ++n15) {
                this.heapArenas[n15] = poolArena = new PoolArena$HeapArena(this, n8, n10, n16, this.chunkSize, n14);
                arrayList.add((PoolArena$HeapArena)poolArena);
            }
            this.heapArenaMetrics = Collections.unmodifiableList(arrayList);
        } else {
            this.heapArenas = null;
            this.heapArenaMetrics = Collections.emptyList();
        }
        if (n7 > 0) {
            this.directArenas = PooledByteBufAllocator.newArenaArray(n7);
            arrayList = new ArrayList(this.directArenas.length);
            for (n15 = 0; n15 < this.directArenas.length; ++n15) {
                this.directArenas[n15] = poolArena = new PoolArena$DirectArena(this, n8, n10, n16, this.chunkSize, n14);
                arrayList.add((PoolArena$HeapArena)poolArena);
            }
            this.directArenaMetrics = Collections.unmodifiableList(arrayList);
        } else {
            this.directArenas = null;
            this.directArenaMetrics = Collections.emptyList();
        }
        this.metric = new PooledByteBufAllocatorMetric(this);
    }

    private static <T> PoolArena<T>[] newArenaArray(int n4) {
        return new PoolArena[n4];
    }

    private static int validateAndCalculatePageShifts(int n4) {
        if (n4 < 4096) {
            throw new IllegalArgumentException("pageSize: " + n4 + " (expected: " + 4096 + ")");
        }
        if ((n4 & n4 - 1) != 0) {
            throw new IllegalArgumentException("pageSize: " + n4 + " (expected: power of 2)");
        }
        return 31 - Integer.numberOfLeadingZeros(n4);
    }

    private static int validateAndCalculateChunkSize(int n4, int n7) {
        if (n7 > 14) {
            throw new IllegalArgumentException("maxOrder: " + n7 + " (expected: 0-14)");
        }
        int n8 = n4;
        for (int i3 = n7; i3 > 0; --i3) {
            if (n8 > 0x20000000) {
                throw new IllegalArgumentException(String.format("pageSize (%d) << maxOrder (%d) must not exceed %d", n4, n7, 0x40000000));
            }
            n8 <<= 1;
        }
        return n8;
    }

    @Override
    protected ByteBuf newHeapBuffer(int n4, int n7) {
        PoolThreadCache poolThreadCache = (PoolThreadCache)this.threadCache.get();
        PoolArena<byte[]> poolArena = poolThreadCache.heapArena;
        AbstractReferenceCountedByteBuf abstractReferenceCountedByteBuf = poolArena != null ? poolArena.allocate(poolThreadCache, n4, n7) : (PlatformDependent.hasUnsafe() ? new UnpooledUnsafeHeapByteBuf((ByteBufAllocator)this, n4, n7) : new UnpooledHeapByteBuf((ByteBufAllocator)this, n4, n7));
        return PooledByteBufAllocator.toLeakAwareBuffer(abstractReferenceCountedByteBuf);
    }

    @Override
    protected ByteBuf newDirectBuffer(int n4, int n7) {
        PoolThreadCache poolThreadCache = (PoolThreadCache)this.threadCache.get();
        PoolArena<ByteBuffer> poolArena = poolThreadCache.directArena;
        AbstractReferenceCountedByteBuf abstractReferenceCountedByteBuf = poolArena != null ? poolArena.allocate(poolThreadCache, n4, n7) : (PlatformDependent.hasUnsafe() ? UnsafeByteBufUtil.newUnsafeDirectByteBuf(this, n4, n7) : new UnpooledDirectByteBuf((ByteBufAllocator)this, n4, n7));
        return PooledByteBufAllocator.toLeakAwareBuffer(abstractReferenceCountedByteBuf);
    }

    public static int defaultNumHeapArena() {
        return DEFAULT_NUM_HEAP_ARENA;
    }

    public static int defaultNumDirectArena() {
        return DEFAULT_NUM_DIRECT_ARENA;
    }

    public static int defaultPageSize() {
        return DEFAULT_PAGE_SIZE;
    }

    public static int defaultMaxOrder() {
        return DEFAULT_MAX_ORDER;
    }

    public static boolean defaultUseCacheForAllThreads() {
        return DEFAULT_USE_CACHE_FOR_ALL_THREADS;
    }

    public static boolean defaultPreferDirect() {
        return PlatformDependent.directBufferPreferred();
    }

    public static int defaultTinyCacheSize() {
        return DEFAULT_TINY_CACHE_SIZE;
    }

    public static int defaultSmallCacheSize() {
        return DEFAULT_SMALL_CACHE_SIZE;
    }

    public static int defaultNormalCacheSize() {
        return DEFAULT_NORMAL_CACHE_SIZE;
    }

    public static boolean isDirectMemoryCacheAlignmentSupported() {
        return PlatformDependent.hasUnsafe();
    }

    @Override
    public boolean isDirectBufferPooled() {
        return this.directArenas != null;
    }

    @Deprecated
    public boolean hasThreadLocalCache() {
        return this.threadCache.isSet();
    }

    @Deprecated
    public void freeThreadLocalCache() {
        this.threadCache.remove();
    }

    @Override
    public PooledByteBufAllocatorMetric metric() {
        return this.metric;
    }

    @Deprecated
    public int numHeapArenas() {
        return this.heapArenaMetrics.size();
    }

    @Deprecated
    public int numDirectArenas() {
        return this.directArenaMetrics.size();
    }

    @Deprecated
    public List<PoolArenaMetric> heapArenas() {
        return this.heapArenaMetrics;
    }

    @Deprecated
    public List<PoolArenaMetric> directArenas() {
        return this.directArenaMetrics;
    }

    @Deprecated
    public int numThreadLocalCaches() {
        PoolArena<Object>[] poolArenaArray;
        PoolArena<Object>[] poolArenaArray2 = poolArenaArray = this.heapArenas != null ? this.heapArenas : this.directArenas;
        if (poolArenaArray == null) {
            return 0;
        }
        int n4 = 0;
        for (PoolArena<Object> poolArena : poolArenaArray) {
            n4 += poolArena.numThreadCaches.get();
        }
        return n4;
    }

    @Deprecated
    public int tinyCacheSize() {
        return this.tinyCacheSize;
    }

    @Deprecated
    public int smallCacheSize() {
        return this.smallCacheSize;
    }

    @Deprecated
    public int normalCacheSize() {
        return this.normalCacheSize;
    }

    @Deprecated
    public final int chunkSize() {
        return this.chunkSize;
    }

    final long usedHeapMemory() {
        return PooledByteBufAllocator.usedMemory(this.heapArenas);
    }

    final long usedDirectMemory() {
        return PooledByteBufAllocator.usedMemory(this.directArenas);
    }

    private static long usedMemory(PoolArena<?>[] poolArenaArray) {
        if (poolArenaArray == null) {
            return -1L;
        }
        long l2 = 0L;
        for (PoolArena<?> poolArena : poolArenaArray) {
            if ((l2 += poolArena.numActiveBytes()) >= 0L) continue;
            return Long.MAX_VALUE;
        }
        return l2;
    }

    final PoolThreadCache threadCache() {
        PoolThreadCache poolThreadCache = (PoolThreadCache)this.threadCache.get();
        assert (poolThreadCache != null);
        return poolThreadCache;
    }

    public boolean trimCurrentThreadCache() {
        PoolThreadCache poolThreadCache = (PoolThreadCache)this.threadCache.getIfExists();
        if (poolThreadCache != null) {
            poolThreadCache.trim();
            return true;
        }
        return false;
    }

    public String dumpStats() {
        int n4 = this.heapArenas == null ? 0 : this.heapArenas.length;
        StringBuilder stringBuilder = new StringBuilder(512).append(n4).append(" heap arena(s):").append(StringUtil.NEWLINE);
        if (n4 > 0) {
            for (PoolArena<byte[]> poolArena : this.heapArenas) {
                stringBuilder.append(poolArena);
            }
        }
        int n7 = this.directArenas == null ? 0 : this.directArenas.length;
        stringBuilder.append(n7).append(" direct arena(s):").append(StringUtil.NEWLINE);
        if (n7 > 0) {
            for (PoolArena<ByteBuffer> poolArena : this.directArenas) {
                stringBuilder.append(poolArena);
            }
        }
        return stringBuilder.toString();
    }

    static /* synthetic */ PoolArena[] access$000(PooledByteBufAllocator pooledByteBufAllocator) {
        return pooledByteBufAllocator.heapArenas;
    }

    static /* synthetic */ PoolArena[] access$100(PooledByteBufAllocator pooledByteBufAllocator) {
        return pooledByteBufAllocator.directArenas;
    }

    static /* synthetic */ int access$200(PooledByteBufAllocator pooledByteBufAllocator) {
        return pooledByteBufAllocator.tinyCacheSize;
    }

    static /* synthetic */ int access$300(PooledByteBufAllocator pooledByteBufAllocator) {
        return pooledByteBufAllocator.smallCacheSize;
    }

    static /* synthetic */ int access$400(PooledByteBufAllocator pooledByteBufAllocator) {
        return pooledByteBufAllocator.normalCacheSize;
    }

    static /* synthetic */ int access$500() {
        return DEFAULT_MAX_CACHED_BUFFER_CAPACITY;
    }

    static /* synthetic */ int access$600() {
        return DEFAULT_CACHE_TRIM_INTERVAL;
    }

    static /* synthetic */ long access$700() {
        return DEFAULT_CACHE_TRIM_INTERVAL_MILLIS;
    }

    static /* synthetic */ Runnable access$800(PooledByteBufAllocator pooledByteBufAllocator) {
        return pooledByteBufAllocator.trimTask;
    }

    static {
        int n4 = SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.allocator.pageSize", 8192);
        Throwable throwable = null;
        try {
            PooledByteBufAllocator.validateAndCalculatePageShifts(n4);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            n4 = 8192;
        }
        DEFAULT_PAGE_SIZE = n4;
        int n7 = SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.allocator.maxOrder", 11);
        Throwable throwable3 = null;
        try {
            PooledByteBufAllocator.validateAndCalculateChunkSize(DEFAULT_PAGE_SIZE, n7);
        }
        catch (Throwable throwable4) {
            throwable3 = throwable4;
            n7 = 11;
        }
        DEFAULT_MAX_ORDER = n7;
        Runtime runtime = Runtime.getRuntime();
        int n8 = NettyRuntime.availableProcessors() * 2;
        int n10 = DEFAULT_PAGE_SIZE << DEFAULT_MAX_ORDER;
        DEFAULT_NUM_HEAP_ARENA = Math.max(0, SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.allocator.numHeapArenas", (int)Math.min((long)n8, runtime.maxMemory() / (long)n10 / 2L / 3L)));
        DEFAULT_NUM_DIRECT_ARENA = Math.max(0, SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.allocator.numDirectArenas", (int)Math.min((long)n8, PlatformDependent.maxDirectMemory() / (long)n10 / 2L / 3L)));
        DEFAULT_TINY_CACHE_SIZE = SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.allocator.tinyCacheSize", 512);
        DEFAULT_SMALL_CACHE_SIZE = SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.allocator.smallCacheSize", 256);
        DEFAULT_NORMAL_CACHE_SIZE = SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.allocator.normalCacheSize", 64);
        DEFAULT_MAX_CACHED_BUFFER_CAPACITY = SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.allocator.maxCachedBufferCapacity", 32768);
        DEFAULT_CACHE_TRIM_INTERVAL = SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.allocator.cacheTrimInterval", 8192);
        DEFAULT_CACHE_TRIM_INTERVAL_MILLIS = SystemPropertyUtil.getLong("io.grpc.netty.shaded.io.netty.allocation.cacheTrimIntervalMillis", 0L);
        DEFAULT_USE_CACHE_FOR_ALL_THREADS = SystemPropertyUtil.getBoolean("io.grpc.netty.shaded.io.netty.allocator.useCacheForAllThreads", true);
        DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT = SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.allocator.directMemoryCacheAlignment", 0);
        DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK = SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.allocator.maxCachedByteBuffersPerChunk", 1023);
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.allocator.numHeapArenas: {}", (Object)DEFAULT_NUM_HEAP_ARENA);
            logger.debug("-Dio.netty.allocator.numDirectArenas: {}", (Object)DEFAULT_NUM_DIRECT_ARENA);
            if (throwable == null) {
                logger.debug("-Dio.netty.allocator.pageSize: {}", (Object)DEFAULT_PAGE_SIZE);
            } else {
                logger.debug("-Dio.netty.allocator.pageSize: {}", (Object)DEFAULT_PAGE_SIZE, (Object)throwable);
            }
            if (throwable3 == null) {
                logger.debug("-Dio.netty.allocator.maxOrder: {}", (Object)DEFAULT_MAX_ORDER);
            } else {
                logger.debug("-Dio.netty.allocator.maxOrder: {}", (Object)DEFAULT_MAX_ORDER, (Object)throwable3);
            }
            logger.debug("-Dio.netty.allocator.chunkSize: {}", (Object)(DEFAULT_PAGE_SIZE << DEFAULT_MAX_ORDER));
            logger.debug("-Dio.netty.allocator.tinyCacheSize: {}", (Object)DEFAULT_TINY_CACHE_SIZE);
            logger.debug("-Dio.netty.allocator.smallCacheSize: {}", (Object)DEFAULT_SMALL_CACHE_SIZE);
            logger.debug("-Dio.netty.allocator.normalCacheSize: {}", (Object)DEFAULT_NORMAL_CACHE_SIZE);
            logger.debug("-Dio.netty.allocator.maxCachedBufferCapacity: {}", (Object)DEFAULT_MAX_CACHED_BUFFER_CAPACITY);
            logger.debug("-Dio.netty.allocator.cacheTrimInterval: {}", (Object)DEFAULT_CACHE_TRIM_INTERVAL);
            logger.debug("-Dio.netty.allocator.cacheTrimIntervalMillis: {}", (Object)DEFAULT_CACHE_TRIM_INTERVAL_MILLIS);
            logger.debug("-Dio.netty.allocator.useCacheForAllThreads: {}", (Object)DEFAULT_USE_CACHE_FOR_ALL_THREADS);
            logger.debug("-Dio.netty.allocator.maxCachedByteBuffersPerChunk: {}", (Object)DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK);
        }
        DEFAULT = new PooledByteBufAllocator(PlatformDependent.directBufferPreferred());
    }
}

