/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.PoolChunk;
import io.grpc.netty.shaded.io.netty.buffer.PoolThreadCache;
import io.grpc.netty.shaded.io.netty.buffer.PooledDuplicatedByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.PooledSlicedByteBuf;
import io.grpc.netty.shaded.io.netty.util.Recycler$Handle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

abstract class PooledByteBuf<T>
extends AbstractReferenceCountedByteBuf {
    private final Recycler$Handle<PooledByteBuf<T>> recyclerHandle;
    protected PoolChunk<T> chunk;
    protected long handle;
    protected T memory;
    protected int offset;
    protected int length;
    int maxLength;
    PoolThreadCache cache;
    ByteBuffer tmpNioBuf;
    private ByteBufAllocator allocator;

    protected PooledByteBuf(Recycler$Handle<? extends PooledByteBuf<T>> recycler$Handle, int n4) {
        super(n4);
        this.recyclerHandle = recycler$Handle;
    }

    void init(PoolChunk<T> poolChunk, ByteBuffer byteBuffer, long l2, int n4, int n7, int n8, PoolThreadCache poolThreadCache) {
        this.init0(poolChunk, byteBuffer, l2, n4, n7, n8, poolThreadCache);
    }

    void initUnpooled(PoolChunk<T> poolChunk, int n4) {
        this.init0(poolChunk, null, 0L, poolChunk.offset, n4, n4, null);
    }

    private void init0(PoolChunk<T> poolChunk, ByteBuffer byteBuffer, long l2, int n4, int n7, int n8, PoolThreadCache poolThreadCache) {
        assert (l2 >= 0L);
        assert (poolChunk != null);
        this.chunk = poolChunk;
        this.memory = poolChunk.memory;
        this.tmpNioBuf = byteBuffer;
        this.allocator = poolChunk.arena.parent;
        this.cache = poolThreadCache;
        this.handle = l2;
        this.offset = n4;
        this.length = n7;
        this.maxLength = n8;
    }

    final void reuse(int n4) {
        this.maxCapacity(n4);
        this.resetRefCnt();
        this.setIndex0(0, 0);
        this.discardMarks();
    }

    @Override
    public final int capacity() {
        return this.length;
    }

    @Override
    public int maxFastWritableBytes() {
        return Math.min(this.maxLength, this.maxCapacity()) - this.writerIndex;
    }

    @Override
    public final ByteBuf capacity(int n4) {
        if (n4 == this.length) {
            this.ensureAccessible();
            return this;
        }
        this.checkNewCapacity(n4);
        if (!this.chunk.unpooled) {
            if (n4 > this.length) {
                if (n4 <= this.maxLength) {
                    this.length = n4;
                    return this;
                }
            } else if (n4 > this.maxLength >>> 1 && (this.maxLength > 512 || n4 > this.maxLength - 16)) {
                this.length = n4;
                this.setIndex(Math.min(this.readerIndex(), n4), Math.min(this.writerIndex(), n4));
                return this;
            }
        }
        this.chunk.arena.reallocate(this, n4, true);
        return this;
    }

    @Override
    public final ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public final ByteBuf unwrap() {
        return null;
    }

    @Override
    public final ByteBuf retainedDuplicate() {
        return PooledDuplicatedByteBuf.newInstance(this, this, this.readerIndex(), this.writerIndex());
    }

    @Override
    public final ByteBuf retainedSlice() {
        int n4 = this.readerIndex();
        return this.retainedSlice(n4, this.writerIndex() - n4);
    }

    @Override
    public final ByteBuf retainedSlice(int n4, int n7) {
        return PooledSlicedByteBuf.newInstance(this, this, n4, n7);
    }

    protected final ByteBuffer internalNioBuffer() {
        ByteBuffer byteBuffer = this.tmpNioBuf;
        if (byteBuffer == null) {
            this.tmpNioBuf = byteBuffer = this.newInternalNioBuffer(this.memory);
        }
        return byteBuffer;
    }

    protected abstract ByteBuffer newInternalNioBuffer(T var1);

    @Override
    protected final void deallocate() {
        if (this.handle >= 0L) {
            long l2 = this.handle;
            this.handle = -1L;
            this.memory = null;
            this.chunk.arena.free(this.chunk, this.tmpNioBuf, l2, this.maxLength, this.cache);
            this.tmpNioBuf = null;
            this.chunk = null;
            this.recycle();
        }
    }

    private void recycle() {
        this.recyclerHandle.recycle(this);
    }

    protected final int idx(int n4) {
        return this.offset + n4;
    }

    final ByteBuffer _internalNioBuffer(int n4, int n7, boolean bl3) {
        n4 = this.idx(n4);
        ByteBuffer byteBuffer = bl3 ? this.newInternalNioBuffer(this.memory) : this.internalNioBuffer();
        byteBuffer.limit(n4 + n7).position(n4);
        return byteBuffer;
    }

    ByteBuffer duplicateInternalNioBuffer(int n4, int n7) {
        this.checkIndex(n4, n7);
        return this._internalNioBuffer(n4, n7, true);
    }

    @Override
    public final ByteBuffer internalNioBuffer(int n4, int n7) {
        this.checkIndex(n4, n7);
        return this._internalNioBuffer(n4, n7, false);
    }

    @Override
    public final int nioBufferCount() {
        return 1;
    }

    @Override
    public final ByteBuffer nioBuffer(int n4, int n7) {
        return this.duplicateInternalNioBuffer(n4, n7).slice();
    }

    @Override
    public final ByteBuffer[] nioBuffers(int n4, int n7) {
        return new ByteBuffer[]{this.nioBuffer(n4, n7)};
    }

    @Override
    public final int getBytes(int n4, GatheringByteChannel gatheringByteChannel, int n7) {
        return gatheringByteChannel.write(this.duplicateInternalNioBuffer(n4, n7));
    }

    @Override
    public final int readBytes(GatheringByteChannel gatheringByteChannel, int n4) {
        this.checkReadableBytes(n4);
        int n7 = gatheringByteChannel.write(this._internalNioBuffer(this.readerIndex, n4, false));
        this.readerIndex += n7;
        return n7;
    }

    @Override
    public final int getBytes(int n4, FileChannel fileChannel, long l2, int n7) {
        return fileChannel.write(this.duplicateInternalNioBuffer(n4, n7), l2);
    }

    @Override
    public final int readBytes(FileChannel fileChannel, long l2, int n4) {
        this.checkReadableBytes(n4);
        int n7 = fileChannel.write(this._internalNioBuffer(this.readerIndex, n4, false), l2);
        this.readerIndex += n7;
        return n7;
    }

    @Override
    public final int setBytes(int n4, ScatteringByteChannel scatteringByteChannel, int n7) {
        try {
            return scatteringByteChannel.read(this.internalNioBuffer(n4, n7));
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public final int setBytes(int n4, FileChannel fileChannel, long l2, int n7) {
        try {
            return fileChannel.read(this.internalNioBuffer(n4, n7), l2);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }
}

