/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.PoolArena;
import io.grpc.netty.shaded.io.netty.buffer.PoolArena$SizeClass;
import io.grpc.netty.shaded.io.netty.buffer.PoolChunk;
import io.grpc.netty.shaded.io.netty.buffer.PoolThreadCache$MemoryRegionCache;
import io.grpc.netty.shaded.io.netty.buffer.PoolThreadCache$NormalMemoryRegionCache;
import io.grpc.netty.shaded.io.netty.buffer.PoolThreadCache$SubPageMemoryRegionCache;
import io.grpc.netty.shaded.io.netty.buffer.PooledByteBuf;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

final class PoolThreadCache {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PoolThreadCache.class);
    final PoolArena<byte[]> heapArena;
    final PoolArena<ByteBuffer> directArena;
    private final PoolThreadCache$MemoryRegionCache<byte[]>[] tinySubPageHeapCaches;
    private final PoolThreadCache$MemoryRegionCache<byte[]>[] smallSubPageHeapCaches;
    private final PoolThreadCache$MemoryRegionCache<ByteBuffer>[] tinySubPageDirectCaches;
    private final PoolThreadCache$MemoryRegionCache<ByteBuffer>[] smallSubPageDirectCaches;
    private final PoolThreadCache$MemoryRegionCache<byte[]>[] normalHeapCaches;
    private final PoolThreadCache$MemoryRegionCache<ByteBuffer>[] normalDirectCaches;
    private final int numShiftsNormalDirect;
    private final int numShiftsNormalHeap;
    private final int freeSweepAllocationThreshold;
    private final AtomicBoolean freed = new AtomicBoolean();
    private int allocations;

    PoolThreadCache(PoolArena<byte[]> poolArena, PoolArena<ByteBuffer> poolArena2, int n4, int n7, int n8, int n10, int n11) {
        ObjectUtil.checkPositiveOrZero(n10, "maxCachedBufferCapacity");
        this.freeSweepAllocationThreshold = n11;
        this.heapArena = poolArena;
        this.directArena = poolArena2;
        if (poolArena2 != null) {
            this.tinySubPageDirectCaches = PoolThreadCache.createSubPageCaches(n4, 32, PoolArena$SizeClass.Tiny);
            this.smallSubPageDirectCaches = PoolThreadCache.createSubPageCaches(n7, poolArena2.numSmallSubpagePools, PoolArena$SizeClass.Small);
            this.numShiftsNormalDirect = PoolThreadCache.log2(poolArena2.pageSize);
            this.normalDirectCaches = PoolThreadCache.createNormalCaches(n8, n10, poolArena2);
            poolArena2.numThreadCaches.getAndIncrement();
        } else {
            this.tinySubPageDirectCaches = null;
            this.smallSubPageDirectCaches = null;
            this.normalDirectCaches = null;
            this.numShiftsNormalDirect = -1;
        }
        if (poolArena != null) {
            this.tinySubPageHeapCaches = PoolThreadCache.createSubPageCaches(n4, 32, PoolArena$SizeClass.Tiny);
            this.smallSubPageHeapCaches = PoolThreadCache.createSubPageCaches(n7, poolArena.numSmallSubpagePools, PoolArena$SizeClass.Small);
            this.numShiftsNormalHeap = PoolThreadCache.log2(poolArena.pageSize);
            this.normalHeapCaches = PoolThreadCache.createNormalCaches(n8, n10, poolArena);
            poolArena.numThreadCaches.getAndIncrement();
        } else {
            this.tinySubPageHeapCaches = null;
            this.smallSubPageHeapCaches = null;
            this.normalHeapCaches = null;
            this.numShiftsNormalHeap = -1;
        }
        if ((this.tinySubPageDirectCaches != null || this.smallSubPageDirectCaches != null || this.normalDirectCaches != null || this.tinySubPageHeapCaches != null || this.smallSubPageHeapCaches != null || this.normalHeapCaches != null) && n11 < 1) {
            throw new IllegalArgumentException("freeSweepAllocationThreshold: " + n11 + " (expected: > 0)");
        }
    }

    private static <T> PoolThreadCache$MemoryRegionCache<T>[] createSubPageCaches(int n4, int n7, PoolArena$SizeClass poolArena$SizeClass) {
        if (n4 > 0 && n7 > 0) {
            PoolThreadCache$MemoryRegionCache[] poolThreadCache$MemoryRegionCacheArray = new PoolThreadCache$MemoryRegionCache[n7];
            for (int i3 = 0; i3 < poolThreadCache$MemoryRegionCacheArray.length; ++i3) {
                poolThreadCache$MemoryRegionCacheArray[i3] = new PoolThreadCache$SubPageMemoryRegionCache(n4, poolArena$SizeClass);
            }
            return poolThreadCache$MemoryRegionCacheArray;
        }
        return null;
    }

    private static <T> PoolThreadCache$MemoryRegionCache<T>[] createNormalCaches(int n4, int n7, PoolArena<T> poolArena) {
        if (n4 > 0 && n7 > 0) {
            int n8 = Math.min(poolArena.chunkSize, n7);
            int n10 = Math.max(1, PoolThreadCache.log2(n8 / poolArena.pageSize) + 1);
            PoolThreadCache$MemoryRegionCache[] poolThreadCache$MemoryRegionCacheArray = new PoolThreadCache$MemoryRegionCache[n10];
            for (int i3 = 0; i3 < poolThreadCache$MemoryRegionCacheArray.length; ++i3) {
                poolThreadCache$MemoryRegionCacheArray[i3] = new PoolThreadCache$NormalMemoryRegionCache(n4);
            }
            return poolThreadCache$MemoryRegionCacheArray;
        }
        return null;
    }

    private static int log2(int n4) {
        int n7 = 0;
        while (n4 > 1) {
            n4 >>= 1;
            ++n7;
        }
        return n7;
    }

    boolean allocateTiny(PoolArena<?> poolArena, PooledByteBuf<?> pooledByteBuf, int n4, int n7) {
        return this.allocate(this.cacheForTiny(poolArena, n7), pooledByteBuf, n4);
    }

    boolean allocateSmall(PoolArena<?> poolArena, PooledByteBuf<?> pooledByteBuf, int n4, int n7) {
        return this.allocate(this.cacheForSmall(poolArena, n7), pooledByteBuf, n4);
    }

    boolean allocateNormal(PoolArena<?> poolArena, PooledByteBuf<?> pooledByteBuf, int n4, int n7) {
        return this.allocate(this.cacheForNormal(poolArena, n7), pooledByteBuf, n4);
    }

    private boolean allocate(PoolThreadCache$MemoryRegionCache<?> poolThreadCache$MemoryRegionCache, PooledByteBuf pooledByteBuf, int n4) {
        if (poolThreadCache$MemoryRegionCache == null) {
            return false;
        }
        boolean bl3 = poolThreadCache$MemoryRegionCache.allocate(pooledByteBuf, n4);
        if (++this.allocations >= this.freeSweepAllocationThreshold) {
            this.allocations = 0;
            this.trim();
        }
        return bl3;
    }

    boolean add(PoolArena<?> poolArena, PoolChunk poolChunk, ByteBuffer byteBuffer, long l2, int n4, PoolArena$SizeClass poolArena$SizeClass) {
        PoolThreadCache$MemoryRegionCache<?> poolThreadCache$MemoryRegionCache = this.cache(poolArena, n4, poolArena$SizeClass);
        if (poolThreadCache$MemoryRegionCache == null) {
            return false;
        }
        return poolThreadCache$MemoryRegionCache.add(poolChunk, byteBuffer, l2);
    }

    private PoolThreadCache$MemoryRegionCache<?> cache(PoolArena<?> poolArena, int n4, PoolArena$SizeClass poolArena$SizeClass) {
        switch (poolArena$SizeClass) {
            case Normal: {
                return this.cacheForNormal(poolArena, n4);
            }
            case Small: {
                return this.cacheForSmall(poolArena, n4);
            }
            case Tiny: {
                return this.cacheForTiny(poolArena, n4);
            }
        }
        throw new Error();
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        finally {
            this.free(true);
        }
    }

    void free(boolean bl3) {
        if (this.freed.compareAndSet(false, true)) {
            int n4 = PoolThreadCache.free(this.tinySubPageDirectCaches, bl3) + PoolThreadCache.free(this.smallSubPageDirectCaches, bl3) + PoolThreadCache.free(this.normalDirectCaches, bl3) + PoolThreadCache.free(this.tinySubPageHeapCaches, bl3) + PoolThreadCache.free(this.smallSubPageHeapCaches, bl3) + PoolThreadCache.free(this.normalHeapCaches, bl3);
            if (n4 > 0 && logger.isDebugEnabled()) {
                logger.debug("Freed {} thread-local buffer(s) from thread: {}", (Object)n4, (Object)Thread.currentThread().getName());
            }
            if (this.directArena != null) {
                this.directArena.numThreadCaches.getAndDecrement();
            }
            if (this.heapArena != null) {
                this.heapArena.numThreadCaches.getAndDecrement();
            }
        }
    }

    private static int free(PoolThreadCache$MemoryRegionCache<?>[] poolThreadCache$MemoryRegionCacheArray, boolean bl3) {
        if (poolThreadCache$MemoryRegionCacheArray == null) {
            return 0;
        }
        int n4 = 0;
        for (PoolThreadCache$MemoryRegionCache<?> poolThreadCache$MemoryRegionCache : poolThreadCache$MemoryRegionCacheArray) {
            n4 += PoolThreadCache.free(poolThreadCache$MemoryRegionCache, bl3);
        }
        return n4;
    }

    private static int free(PoolThreadCache$MemoryRegionCache<?> poolThreadCache$MemoryRegionCache, boolean bl3) {
        if (poolThreadCache$MemoryRegionCache == null) {
            return 0;
        }
        return poolThreadCache$MemoryRegionCache.free(bl3);
    }

    void trim() {
        PoolThreadCache.trim(this.tinySubPageDirectCaches);
        PoolThreadCache.trim(this.smallSubPageDirectCaches);
        PoolThreadCache.trim(this.normalDirectCaches);
        PoolThreadCache.trim(this.tinySubPageHeapCaches);
        PoolThreadCache.trim(this.smallSubPageHeapCaches);
        PoolThreadCache.trim(this.normalHeapCaches);
    }

    private static void trim(PoolThreadCache$MemoryRegionCache<?>[] poolThreadCache$MemoryRegionCacheArray) {
        if (poolThreadCache$MemoryRegionCacheArray == null) {
            return;
        }
        for (PoolThreadCache$MemoryRegionCache<?> poolThreadCache$MemoryRegionCache : poolThreadCache$MemoryRegionCacheArray) {
            PoolThreadCache.trim(poolThreadCache$MemoryRegionCache);
        }
    }

    private static void trim(PoolThreadCache$MemoryRegionCache<?> poolThreadCache$MemoryRegionCache) {
        if (poolThreadCache$MemoryRegionCache == null) {
            return;
        }
        poolThreadCache$MemoryRegionCache.trim();
    }

    private PoolThreadCache$MemoryRegionCache<?> cacheForTiny(PoolArena<?> poolArena, int n4) {
        int n7 = PoolArena.tinyIdx(n4);
        if (poolArena.isDirect()) {
            return PoolThreadCache.cache(this.tinySubPageDirectCaches, n7);
        }
        return PoolThreadCache.cache(this.tinySubPageHeapCaches, n7);
    }

    private PoolThreadCache$MemoryRegionCache<?> cacheForSmall(PoolArena<?> poolArena, int n4) {
        int n7 = PoolArena.smallIdx(n4);
        if (poolArena.isDirect()) {
            return PoolThreadCache.cache(this.smallSubPageDirectCaches, n7);
        }
        return PoolThreadCache.cache(this.smallSubPageHeapCaches, n7);
    }

    private PoolThreadCache$MemoryRegionCache<?> cacheForNormal(PoolArena<?> poolArena, int n4) {
        if (poolArena.isDirect()) {
            int n7 = PoolThreadCache.log2(n4 >> this.numShiftsNormalDirect);
            return PoolThreadCache.cache(this.normalDirectCaches, n7);
        }
        int n8 = PoolThreadCache.log2(n4 >> this.numShiftsNormalHeap);
        return PoolThreadCache.cache(this.normalHeapCaches, n8);
    }

    private static <T> PoolThreadCache$MemoryRegionCache<T> cache(PoolThreadCache$MemoryRegionCache<T>[] poolThreadCache$MemoryRegionCacheArray, int n4) {
        if (poolThreadCache$MemoryRegionCacheArray == null || n4 > poolThreadCache$MemoryRegionCacheArray.length - 1) {
            return null;
        }
        return poolThreadCache$MemoryRegionCacheArray[n4];
    }
}

