/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.PoolArena$SizeClass;
import io.grpc.netty.shaded.io.netty.buffer.PoolChunk;
import io.grpc.netty.shaded.io.netty.buffer.PoolThreadCache$MemoryRegionCache$1;
import io.grpc.netty.shaded.io.netty.buffer.PoolThreadCache$MemoryRegionCache$Entry;
import io.grpc.netty.shaded.io.netty.buffer.PooledByteBuf;
import io.grpc.netty.shaded.io.netty.util.Recycler;
import io.grpc.netty.shaded.io.netty.util.internal.MathUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.util.Queue;

abstract class PoolThreadCache$MemoryRegionCache<T> {
    private final int size;
    private final Queue<PoolThreadCache$MemoryRegionCache$Entry<T>> queue;
    private final PoolArena$SizeClass sizeClass;
    private int allocations;
    private static final Recycler<PoolThreadCache$MemoryRegionCache$Entry> RECYCLER = new PoolThreadCache$MemoryRegionCache$1();

    PoolThreadCache$MemoryRegionCache(int n4, PoolArena$SizeClass poolArena$SizeClass) {
        this.size = MathUtil.safeFindNextPositivePowerOfTwo(n4);
        this.queue = PlatformDependent.newFixedMpscQueue(this.size);
        this.sizeClass = poolArena$SizeClass;
    }

    protected abstract void initBuf(PoolChunk<T> var1, ByteBuffer var2, long var3, PooledByteBuf<T> var5, int var6);

    public final boolean add(PoolChunk<T> poolChunk, ByteBuffer byteBuffer, long l2) {
        PoolThreadCache$MemoryRegionCache$Entry poolThreadCache$MemoryRegionCache$Entry = PoolThreadCache$MemoryRegionCache.newEntry(poolChunk, byteBuffer, l2);
        boolean bl3 = this.queue.offer(poolThreadCache$MemoryRegionCache$Entry);
        if (!bl3) {
            poolThreadCache$MemoryRegionCache$Entry.recycle();
        }
        return bl3;
    }

    public final boolean allocate(PooledByteBuf<T> pooledByteBuf, int n4) {
        PoolThreadCache$MemoryRegionCache$Entry<T> poolThreadCache$MemoryRegionCache$Entry = this.queue.poll();
        if (poolThreadCache$MemoryRegionCache$Entry == null) {
            return false;
        }
        this.initBuf(poolThreadCache$MemoryRegionCache$Entry.chunk, poolThreadCache$MemoryRegionCache$Entry.nioBuffer, poolThreadCache$MemoryRegionCache$Entry.handle, pooledByteBuf, n4);
        poolThreadCache$MemoryRegionCache$Entry.recycle();
        ++this.allocations;
        return true;
    }

    public final int free(boolean bl3) {
        return this.free(Integer.MAX_VALUE, bl3);
    }

    private int free(int n4, boolean bl3) {
        int n7;
        for (n7 = 0; n7 < n4; ++n7) {
            PoolThreadCache$MemoryRegionCache$Entry<T> poolThreadCache$MemoryRegionCache$Entry = this.queue.poll();
            if (poolThreadCache$MemoryRegionCache$Entry == null) {
                return n7;
            }
            this.freeEntry(poolThreadCache$MemoryRegionCache$Entry, bl3);
        }
        return n7;
    }

    public final void trim() {
        int n4 = this.size - this.allocations;
        this.allocations = 0;
        if (n4 > 0) {
            this.free(n4, false);
        }
    }

    private void freeEntry(PoolThreadCache$MemoryRegionCache$Entry poolThreadCache$MemoryRegionCache$Entry, boolean bl3) {
        PoolChunk poolChunk = poolThreadCache$MemoryRegionCache$Entry.chunk;
        long l2 = poolThreadCache$MemoryRegionCache$Entry.handle;
        ByteBuffer byteBuffer = poolThreadCache$MemoryRegionCache$Entry.nioBuffer;
        if (!bl3) {
            poolThreadCache$MemoryRegionCache$Entry.recycle();
        }
        poolChunk.arena.freeChunk(poolChunk, l2, this.sizeClass, byteBuffer, bl3);
    }

    private static PoolThreadCache$MemoryRegionCache$Entry newEntry(PoolChunk<?> poolChunk, ByteBuffer byteBuffer, long l2) {
        PoolThreadCache$MemoryRegionCache$Entry poolThreadCache$MemoryRegionCache$Entry = RECYCLER.get();
        poolThreadCache$MemoryRegionCache$Entry.chunk = poolChunk;
        poolThreadCache$MemoryRegionCache$Entry.nioBuffer = byteBuffer;
        poolThreadCache$MemoryRegionCache$Entry.handle = l2;
        return poolThreadCache$MemoryRegionCache$Entry;
    }
}

