/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.PoolArena;
import io.grpc.netty.shaded.io.netty.buffer.PoolChunk;
import io.grpc.netty.shaded.io.netty.buffer.PoolSubpageMetric;

final class PoolSubpage<T>
implements PoolSubpageMetric {
    final PoolChunk<T> chunk;
    private final int memoryMapIdx;
    private final int runOffset;
    private final int pageSize;
    private final long[] bitmap;
    PoolSubpage<T> prev;
    PoolSubpage<T> next;
    boolean doNotDestroy;
    int elemSize;
    private int maxNumElems;
    private int bitmapLength;
    private int nextAvail;
    private int numAvail;

    PoolSubpage(int n4) {
        this.chunk = null;
        this.memoryMapIdx = -1;
        this.runOffset = -1;
        this.elemSize = -1;
        this.pageSize = n4;
        this.bitmap = null;
    }

    PoolSubpage(PoolSubpage<T> poolSubpage, PoolChunk<T> poolChunk, int n4, int n7, int n8, int n10) {
        this.chunk = poolChunk;
        this.memoryMapIdx = n4;
        this.runOffset = n7;
        this.pageSize = n8;
        this.bitmap = new long[n8 >>> 10];
        this.init(poolSubpage, n10);
    }

    void init(PoolSubpage<T> poolSubpage, int n4) {
        this.doNotDestroy = true;
        this.elemSize = n4;
        if (n4 != 0) {
            this.maxNumElems = this.numAvail = this.pageSize / n4;
            this.nextAvail = 0;
            this.bitmapLength = this.maxNumElems >>> 6;
            if ((this.maxNumElems & 0x3F) != 0) {
                ++this.bitmapLength;
            }
            for (int i3 = 0; i3 < this.bitmapLength; ++i3) {
                this.bitmap[i3] = 0L;
            }
        }
        this.addToPool(poolSubpage);
    }

    long allocate() {
        if (this.elemSize == 0) {
            return this.toHandle(0);
        }
        if (this.numAvail == 0 || !this.doNotDestroy) {
            return -1L;
        }
        int n4 = this.getNextAvail();
        int n7 = n4 >>> 6;
        int n8 = n4 & 0x3F;
        assert ((this.bitmap[n7] >>> n8 & 1L) == 0L);
        int n10 = n7;
        this.bitmap[n10] = this.bitmap[n10] | 1L << n8;
        if (--this.numAvail == 0) {
            this.removeFromPool();
        }
        return this.toHandle(n4);
    }

    boolean free(PoolSubpage<T> poolSubpage, int n4) {
        if (this.elemSize == 0) {
            return true;
        }
        int n7 = n4 >>> 6;
        int n8 = n4 & 0x3F;
        assert ((this.bitmap[n7] >>> n8 & 1L) != 0L);
        int n10 = n7;
        this.bitmap[n10] = this.bitmap[n10] ^ 1L << n8;
        this.setNextAvail(n4);
        if (this.numAvail++ == 0) {
            this.addToPool(poolSubpage);
            return true;
        }
        if (this.numAvail != this.maxNumElems) {
            return true;
        }
        if (this.prev == this.next) {
            return true;
        }
        this.doNotDestroy = false;
        this.removeFromPool();
        return false;
    }

    private void addToPool(PoolSubpage<T> poolSubpage) {
        assert (this.prev == null && this.next == null);
        this.prev = poolSubpage;
        this.next = poolSubpage.next;
        this.next.prev = this;
        poolSubpage.next = this;
    }

    private void removeFromPool() {
        assert (this.prev != null && this.next != null);
        this.prev.next = this.next;
        this.next.prev = this.prev;
        this.next = null;
        this.prev = null;
    }

    private void setNextAvail(int n4) {
        this.nextAvail = n4;
    }

    private int getNextAvail() {
        int n4 = this.nextAvail;
        if (n4 >= 0) {
            this.nextAvail = -1;
            return n4;
        }
        return this.findNextAvail();
    }

    private int findNextAvail() {
        long[] lArray = this.bitmap;
        int n4 = this.bitmapLength;
        for (int i3 = 0; i3 < n4; ++i3) {
            long l2 = lArray[i3];
            if ((l2 ^ 0xFFFFFFFFFFFFFFFFL) == 0L) continue;
            return this.findNextAvail0(i3, l2);
        }
        return -1;
    }

    private int findNextAvail0(int n4, long l2) {
        int n7 = this.maxNumElems;
        int n8 = n4 << 6;
        for (int i3 = 0; i3 < 64; ++i3) {
            if ((l2 & 1L) == 0L) {
                int n10 = n8 | i3;
                if (n10 >= n7) break;
                return n10;
            }
            l2 >>>= 1;
        }
        return -1;
    }

    private long toHandle(int n4) {
        return 0x4000000000000000L | (long)n4 << 32 | (long)this.memoryMapIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int n4;
        int n7;
        int n8;
        boolean bl3;
        if (this.chunk == null) {
            bl3 = true;
            n8 = 0;
            n7 = 0;
            n4 = -1;
        } else {
            PoolArena poolArena = this.chunk.arena;
            synchronized (poolArena) {
                if (!this.doNotDestroy) {
                    bl3 = false;
                    n4 = -1;
                    n7 = -1;
                    n8 = -1;
                } else {
                    bl3 = true;
                    n8 = this.maxNumElems;
                    n7 = this.numAvail;
                    n4 = this.elemSize;
                }
            }
        }
        if (!bl3) {
            return "(" + this.memoryMapIdx + ": not in use)";
        }
        return "(" + this.memoryMapIdx + ": " + (n8 - n7) + '/' + n8 + ", offset: " + this.runOffset + ", length: " + this.pageSize + ", elemSize: " + n4 + ')';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int maxNumElements() {
        if (this.chunk == null) {
            return 0;
        }
        PoolArena poolArena = this.chunk.arena;
        synchronized (poolArena) {
            return this.maxNumElems;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int numAvailable() {
        if (this.chunk == null) {
            return 0;
        }
        PoolArena poolArena = this.chunk.arena;
        synchronized (poolArena) {
            return this.numAvail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int elementSize() {
        if (this.chunk == null) {
            return -1;
        }
        PoolArena poolArena = this.chunk.arena;
        synchronized (poolArena) {
            return this.elemSize;
        }
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    void destroy() {
        if (this.chunk != null) {
            this.chunk.destroy();
        }
    }
}

