/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.PoolArena;
import io.grpc.netty.shaded.io.netty.buffer.PoolChunkList;
import io.grpc.netty.shaded.io.netty.buffer.PoolChunkMetric;
import io.grpc.netty.shaded.io.netty.buffer.PoolSubpage;
import io.grpc.netty.shaded.io.netty.buffer.PooledByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.PooledByteBufAllocator;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;

final class PoolChunk<T>
implements PoolChunkMetric {
    private static final int INTEGER_SIZE_MINUS_ONE = 31;
    final PoolArena<T> arena;
    final T memory;
    final boolean unpooled;
    final int offset;
    private final byte[] memoryMap;
    private final byte[] depthMap;
    private final PoolSubpage<T>[] subpages;
    private final int subpageOverflowMask;
    private final int pageSize;
    private final int pageShifts;
    private final int maxOrder;
    private final int chunkSize;
    private final int log2ChunkSize;
    private final int maxSubpageAllocs;
    private final byte unusable;
    private final Deque<ByteBuffer> cachedNioBuffers;
    private int freeBytes;
    PoolChunkList<T> parent;
    PoolChunk<T> prev;
    PoolChunk<T> next;

    PoolChunk(PoolArena<T> poolArena, T t3, int n4, int n7, int n8, int n10, int n11) {
        this.unpooled = false;
        this.arena = poolArena;
        this.memory = t3;
        this.pageSize = n4;
        this.pageShifts = n8;
        this.maxOrder = n7;
        this.chunkSize = n10;
        this.offset = n11;
        this.unusable = (byte)(n7 + 1);
        this.log2ChunkSize = PoolChunk.log2(n10);
        this.subpageOverflowMask = ~(n4 - 1);
        this.freeBytes = n10;
        assert (n7 < 30) : "maxOrder should be < 30, but is: " + n7;
        this.maxSubpageAllocs = 1 << n7;
        this.memoryMap = new byte[this.maxSubpageAllocs << 1];
        this.depthMap = new byte[this.memoryMap.length];
        int n12 = 1;
        for (int i3 = 0; i3 <= n7; ++i3) {
            int n13 = 1 << i3;
            for (int i8 = 0; i8 < n13; ++i8) {
                this.memoryMap[n12] = (byte)i3;
                this.depthMap[n12] = (byte)i3;
                ++n12;
            }
        }
        this.subpages = this.newSubpageArray(this.maxSubpageAllocs);
        this.cachedNioBuffers = new ArrayDeque<ByteBuffer>(8);
    }

    PoolChunk(PoolArena<T> poolArena, T t3, int n4, int n7) {
        this.unpooled = true;
        this.arena = poolArena;
        this.memory = t3;
        this.offset = n7;
        this.memoryMap = null;
        this.depthMap = null;
        this.subpages = null;
        this.subpageOverflowMask = 0;
        this.pageSize = 0;
        this.pageShifts = 0;
        this.maxOrder = 0;
        this.unusable = (byte)(this.maxOrder + 1);
        this.chunkSize = n4;
        this.log2ChunkSize = PoolChunk.log2(this.chunkSize);
        this.maxSubpageAllocs = 0;
        this.cachedNioBuffers = null;
    }

    private PoolSubpage<T>[] newSubpageArray(int n4) {
        return new PoolSubpage[n4];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int usage() {
        int n4;
        PoolArena<T> poolArena = this.arena;
        synchronized (poolArena) {
            n4 = this.freeBytes;
        }
        return this.usage(n4);
    }

    private int usage(int n4) {
        if (n4 == 0) {
            return 100;
        }
        int n7 = (int)((long)n4 * 100L / (long)this.chunkSize);
        if (n7 == 0) {
            return 99;
        }
        return 100 - n7;
    }

    boolean allocate(PooledByteBuf<T> pooledByteBuf, int n4, int n7) {
        long l2 = (n7 & this.subpageOverflowMask) != 0 ? this.allocateRun(n7) : this.allocateSubpage(n7);
        if (l2 < 0L) {
            return false;
        }
        ByteBuffer byteBuffer = this.cachedNioBuffers != null ? this.cachedNioBuffers.pollLast() : null;
        this.initBuf(pooledByteBuf, byteBuffer, l2, n4);
        return true;
    }

    private void updateParentsAlloc(int n4) {
        while (n4 > 1) {
            byte by2;
            int n7 = n4 >>> 1;
            byte by3 = this.value(n4);
            byte by4 = by3 < (by2 = this.value(n4 ^ 1)) ? by3 : by2;
            this.setValue(n7, by4);
            n4 = n7;
        }
    }

    private void updateParentsFree(int n4) {
        int n7 = this.depth(n4) + 1;
        while (n4 > 1) {
            int n8 = n4 >>> 1;
            byte by2 = this.value(n4);
            byte by3 = this.value(n4 ^ 1);
            if (by2 == --n7 && by3 == n7) {
                this.setValue(n8, (byte)(n7 - 1));
            } else {
                byte by4 = by2 < by3 ? by2 : by3;
                this.setValue(n8, by4);
            }
            n4 = n8;
        }
    }

    private int allocateNode(int n4) {
        int n7 = 1;
        int n8 = -(1 << n4);
        byte by2 = this.value(n7);
        if (by2 > n4) {
            return -1;
        }
        while (by2 < n4 || (n7 & n8) == 0) {
            by2 = this.value(n7 <<= 1);
            if (by2 <= n4) continue;
            by2 = this.value(n7 ^= 1);
        }
        byte by3 = this.value(n7);
        assert (by3 == n4 && (n7 & n8) == 1 << n4) : String.format("val = %d, id & initial = %d, d = %d", by3, n7 & n8, n4);
        this.setValue(n7, this.unusable);
        this.updateParentsAlloc(n7);
        return n7;
    }

    private long allocateRun(int n4) {
        int n7 = this.maxOrder - (PoolChunk.log2(n4) - this.pageShifts);
        int n8 = this.allocateNode(n7);
        if (n8 < 0) {
            return n8;
        }
        this.freeBytes -= this.runLength(n8);
        return n8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long allocateSubpage(int n4) {
        PoolSubpage<T> poolSubpage = this.arena.findSubpagePoolHead(n4);
        int n7 = this.maxOrder;
        PoolSubpage<T> poolSubpage2 = poolSubpage;
        synchronized (poolSubpage2) {
            int n8 = this.allocateNode(n7);
            if (n8 < 0) {
                return n8;
            }
            PoolSubpage<T>[] poolSubpageArray = this.subpages;
            int n10 = this.pageSize;
            this.freeBytes -= n10;
            int n11 = this.subpageIdx(n8);
            PoolSubpage<T> poolSubpage3 = poolSubpageArray[n11];
            if (poolSubpage3 == null) {
                poolSubpage3 = new PoolSubpage<T>(poolSubpage, this, n8, this.runOffset(n8), n10, n4);
                poolSubpageArray[n11] = poolSubpage3;
            } else {
                poolSubpage3.init(poolSubpage, n4);
            }
            return poolSubpage3.allocate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(long l2, ByteBuffer byteBuffer) {
        int n4 = PoolChunk.memoryMapIdx(l2);
        int n7 = PoolChunk.bitmapIdx(l2);
        if (n7 != 0) {
            PoolSubpage<T> poolSubpage;
            PoolSubpage<T> poolSubpage2 = this.subpages[this.subpageIdx(n4)];
            assert (poolSubpage2 != null && poolSubpage2.doNotDestroy);
            PoolSubpage<T> poolSubpage3 = poolSubpage = this.arena.findSubpagePoolHead(poolSubpage2.elemSize);
            synchronized (poolSubpage3) {
                if (poolSubpage2.free(poolSubpage, n7 & 0x3FFFFFFF)) {
                    return;
                }
            }
        }
        this.freeBytes += this.runLength(n4);
        this.setValue(n4, this.depth(n4));
        this.updateParentsFree(n4);
        if (byteBuffer != null && this.cachedNioBuffers != null && this.cachedNioBuffers.size() < PooledByteBufAllocator.DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK) {
            this.cachedNioBuffers.offer(byteBuffer);
        }
    }

    void initBuf(PooledByteBuf<T> pooledByteBuf, ByteBuffer byteBuffer, long l2, int n4) {
        int n7 = PoolChunk.memoryMapIdx(l2);
        int n8 = PoolChunk.bitmapIdx(l2);
        if (n8 == 0) {
            byte by2 = this.value(n7);
            assert (by2 == this.unusable) : String.valueOf(by2);
            pooledByteBuf.init(this, byteBuffer, l2, this.runOffset(n7) + this.offset, n4, this.runLength(n7), this.arena.parent.threadCache());
        } else {
            this.initBufWithSubpage(pooledByteBuf, byteBuffer, l2, n8, n4);
        }
    }

    void initBufWithSubpage(PooledByteBuf<T> pooledByteBuf, ByteBuffer byteBuffer, long l2, int n4) {
        this.initBufWithSubpage(pooledByteBuf, byteBuffer, l2, PoolChunk.bitmapIdx(l2), n4);
    }

    private void initBufWithSubpage(PooledByteBuf<T> pooledByteBuf, ByteBuffer byteBuffer, long l2, int n4, int n7) {
        assert (n4 != 0);
        int n8 = PoolChunk.memoryMapIdx(l2);
        PoolSubpage<T> poolSubpage = this.subpages[this.subpageIdx(n8)];
        assert (poolSubpage.doNotDestroy);
        assert (n7 <= poolSubpage.elemSize);
        pooledByteBuf.init(this, byteBuffer, l2, this.runOffset(n8) + (n4 & 0x3FFFFFFF) * poolSubpage.elemSize + this.offset, n7, poolSubpage.elemSize, this.arena.parent.threadCache());
    }

    private byte value(int n4) {
        return this.memoryMap[n4];
    }

    private void setValue(int n4, byte by2) {
        this.memoryMap[n4] = by2;
    }

    private byte depth(int n4) {
        return this.depthMap[n4];
    }

    private static int log2(int n4) {
        return 31 - Integer.numberOfLeadingZeros(n4);
    }

    private int runLength(int n4) {
        return 1 << this.log2ChunkSize - this.depth(n4);
    }

    private int runOffset(int n4) {
        int n7 = n4 ^ 1 << this.depth(n4);
        return n7 * this.runLength(n4);
    }

    private int subpageIdx(int n4) {
        return n4 ^ this.maxSubpageAllocs;
    }

    private static int memoryMapIdx(long l2) {
        return (int)l2;
    }

    private static int bitmapIdx(long l2) {
        return (int)(l2 >>> 32);
    }

    @Override
    public int chunkSize() {
        return this.chunkSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int freeBytes() {
        PoolArena<T> poolArena = this.arena;
        synchronized (poolArena) {
            return this.freeBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int n4;
        PoolArena<T> poolArena = this.arena;
        synchronized (poolArena) {
            n4 = this.freeBytes;
        }
        return "Chunk(" + Integer.toHexString(System.identityHashCode(this)) + ": " + this.usage(n4) + "%, " + (this.chunkSize - n4) + '/' + this.chunkSize + ')';
    }

    void destroy() {
        this.arena.destroyChunk(this);
    }
}

