/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.PoolArena$SizeClass;
import io.grpc.netty.shaded.io.netty.buffer.PoolArenaMetric;
import io.grpc.netty.shaded.io.netty.buffer.PoolChunk;
import io.grpc.netty.shaded.io.netty.buffer.PoolChunkList;
import io.grpc.netty.shaded.io.netty.buffer.PoolChunkListMetric;
import io.grpc.netty.shaded.io.netty.buffer.PoolChunkMetric;
import io.grpc.netty.shaded.io.netty.buffer.PoolSubpage;
import io.grpc.netty.shaded.io.netty.buffer.PoolSubpageMetric;
import io.grpc.netty.shaded.io.netty.buffer.PoolThreadCache;
import io.grpc.netty.shaded.io.netty.buffer.PooledByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.PooledByteBufAllocator;
import io.grpc.netty.shaded.io.netty.util.internal.LongCounter;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

abstract class PoolArena<T>
implements PoolArenaMetric {
    static final boolean HAS_UNSAFE = PlatformDependent.hasUnsafe();
    static final int numTinySubpagePools = 32;
    final PooledByteBufAllocator parent;
    private final int maxOrder;
    final int pageSize;
    final int pageShifts;
    final int chunkSize;
    final int subpageOverflowMask;
    final int numSmallSubpagePools;
    final int directMemoryCacheAlignment;
    final int directMemoryCacheAlignmentMask;
    private final PoolSubpage<T>[] tinySubpagePools;
    private final PoolSubpage<T>[] smallSubpagePools;
    private final PoolChunkList<T> q050;
    private final PoolChunkList<T> q025;
    private final PoolChunkList<T> q000;
    private final PoolChunkList<T> qInit;
    private final PoolChunkList<T> q075;
    private final PoolChunkList<T> q100;
    private final List<PoolChunkListMetric> chunkListMetrics;
    private long allocationsNormal;
    private final LongCounter allocationsTiny = PlatformDependent.newLongCounter();
    private final LongCounter allocationsSmall = PlatformDependent.newLongCounter();
    private final LongCounter allocationsHuge = PlatformDependent.newLongCounter();
    private final LongCounter activeBytesHuge = PlatformDependent.newLongCounter();
    private long deallocationsTiny;
    private long deallocationsSmall;
    private long deallocationsNormal;
    private final LongCounter deallocationsHuge = PlatformDependent.newLongCounter();
    final AtomicInteger numThreadCaches = new AtomicInteger();

    protected PoolArena(PooledByteBufAllocator pooledByteBufAllocator, int n4, int n7, int n8, int n10, int n11) {
        int n12;
        this.parent = pooledByteBufAllocator;
        this.pageSize = n4;
        this.maxOrder = n7;
        this.pageShifts = n8;
        this.chunkSize = n10;
        this.directMemoryCacheAlignment = n11;
        this.directMemoryCacheAlignmentMask = n11 - 1;
        this.subpageOverflowMask = ~(n4 - 1);
        this.tinySubpagePools = this.newSubpagePoolArray(32);
        for (n12 = 0; n12 < this.tinySubpagePools.length; ++n12) {
            this.tinySubpagePools[n12] = this.newSubpagePoolHead(n4);
        }
        this.numSmallSubpagePools = n8 - 9;
        this.smallSubpagePools = this.newSubpagePoolArray(this.numSmallSubpagePools);
        for (n12 = 0; n12 < this.smallSubpagePools.length; ++n12) {
            this.smallSubpagePools[n12] = this.newSubpagePoolHead(n4);
        }
        this.q100 = new PoolChunkList(this, null, 100, Integer.MAX_VALUE, n10);
        this.q075 = new PoolChunkList<T>(this, this.q100, 75, 100, n10);
        this.q050 = new PoolChunkList<T>(this, this.q075, 50, 100, n10);
        this.q025 = new PoolChunkList<T>(this, this.q050, 25, 75, n10);
        this.q000 = new PoolChunkList<T>(this, this.q025, 1, 50, n10);
        this.qInit = new PoolChunkList<T>(this, this.q000, Integer.MIN_VALUE, 25, n10);
        this.q100.prevList(this.q075);
        this.q075.prevList(this.q050);
        this.q050.prevList(this.q025);
        this.q025.prevList(this.q000);
        this.q000.prevList(null);
        this.qInit.prevList(this.qInit);
        ArrayList<PoolChunkList<T>> arrayList = new ArrayList<PoolChunkList<T>>(6);
        arrayList.add(this.qInit);
        arrayList.add(this.q000);
        arrayList.add(this.q025);
        arrayList.add(this.q050);
        arrayList.add(this.q075);
        arrayList.add(this.q100);
        this.chunkListMetrics = Collections.unmodifiableList(arrayList);
    }

    private PoolSubpage<T> newSubpagePoolHead(int n4) {
        PoolSubpage poolSubpage = new PoolSubpage(n4);
        poolSubpage.prev = poolSubpage;
        poolSubpage.next = poolSubpage;
        return poolSubpage;
    }

    private PoolSubpage<T>[] newSubpagePoolArray(int n4) {
        return new PoolSubpage[n4];
    }

    abstract boolean isDirect();

    PooledByteBuf<T> allocate(PoolThreadCache poolThreadCache, int n4, int n7) {
        PooledByteBuf<T> pooledByteBuf = this.newByteBuf(n7);
        this.allocate(poolThreadCache, pooledByteBuf, n4);
        return pooledByteBuf;
    }

    static int tinyIdx(int n4) {
        return n4 >>> 4;
    }

    static int smallIdx(int n4) {
        int n7 = 0;
        int n8 = n4 >>> 10;
        while (n8 != 0) {
            n8 >>>= 1;
            ++n7;
        }
        return n7;
    }

    boolean isTinyOrSmall(int n4) {
        return (n4 & this.subpageOverflowMask) == 0;
    }

    static boolean isTiny(int n4) {
        return (n4 & 0xFFFFFE00) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocate(PoolThreadCache poolThreadCache, PooledByteBuf<T> pooledByteBuf, int n4) {
        int n7 = this.normalizeCapacity(n4);
        if (this.isTinyOrSmall(n7)) {
            PoolSubpage<T>[] poolSubpageArray;
            int n8;
            boolean bl3 = PoolArena.isTiny(n7);
            if (bl3) {
                if (poolThreadCache.allocateTiny(this, pooledByteBuf, n4, n7)) {
                    return;
                }
                n8 = PoolArena.tinyIdx(n7);
                poolSubpageArray = this.tinySubpagePools;
            } else {
                if (poolThreadCache.allocateSmall(this, pooledByteBuf, n4, n7)) {
                    return;
                }
                n8 = PoolArena.smallIdx(n7);
                poolSubpageArray = this.smallSubpagePools;
            }
            PoolSubpage<T> poolSubpage = poolSubpageArray[n8];
            Object object = poolSubpage;
            synchronized (object) {
                PoolSubpage poolSubpage2 = poolSubpage.next;
                if (poolSubpage2 != poolSubpage) {
                    assert (poolSubpage2.doNotDestroy && poolSubpage2.elemSize == n7);
                    long l2 = poolSubpage2.allocate();
                    assert (l2 >= 0L);
                    poolSubpage2.chunk.initBufWithSubpage(pooledByteBuf, null, l2, n4);
                    this.incTinySmallAllocation(bl3);
                    return;
                }
            }
            object = this;
            synchronized (object) {
                this.allocateNormal(pooledByteBuf, n4, n7);
            }
            this.incTinySmallAllocation(bl3);
            return;
        }
        if (n7 <= this.chunkSize) {
            if (poolThreadCache.allocateNormal(this, pooledByteBuf, n4, n7)) {
                return;
            }
            PoolArena poolArena = this;
            synchronized (poolArena) {
                this.allocateNormal(pooledByteBuf, n4, n7);
                ++this.allocationsNormal;
            }
        } else {
            this.allocateHuge(pooledByteBuf, n4);
        }
    }

    private void allocateNormal(PooledByteBuf<T> pooledByteBuf, int n4, int n7) {
        if (this.q050.allocate(pooledByteBuf, n4, n7) || this.q025.allocate(pooledByteBuf, n4, n7) || this.q000.allocate(pooledByteBuf, n4, n7) || this.qInit.allocate(pooledByteBuf, n4, n7) || this.q075.allocate(pooledByteBuf, n4, n7)) {
            return;
        }
        PoolChunk<T> poolChunk = this.newChunk(this.pageSize, this.maxOrder, this.pageShifts, this.chunkSize);
        boolean bl3 = poolChunk.allocate(pooledByteBuf, n4, n7);
        assert (bl3);
        this.qInit.add(poolChunk);
    }

    private void incTinySmallAllocation(boolean bl3) {
        if (bl3) {
            this.allocationsTiny.increment();
        } else {
            this.allocationsSmall.increment();
        }
    }

    private void allocateHuge(PooledByteBuf<T> pooledByteBuf, int n4) {
        PoolChunk<T> poolChunk = this.newUnpooledChunk(n4);
        this.activeBytesHuge.add(poolChunk.chunkSize());
        pooledByteBuf.initUnpooled(poolChunk, n4);
        this.allocationsHuge.increment();
    }

    void free(PoolChunk<T> poolChunk, ByteBuffer byteBuffer, long l2, int n4, PoolThreadCache poolThreadCache) {
        if (poolChunk.unpooled) {
            int n7 = poolChunk.chunkSize();
            this.destroyChunk(poolChunk);
            this.activeBytesHuge.add(-n7);
            this.deallocationsHuge.increment();
        } else {
            PoolArena$SizeClass poolArena$SizeClass = this.sizeClass(n4);
            if (poolThreadCache != null && poolThreadCache.add(this, poolChunk, byteBuffer, l2, n4, poolArena$SizeClass)) {
                return;
            }
            this.freeChunk(poolChunk, l2, poolArena$SizeClass, byteBuffer, false);
        }
    }

    private PoolArena$SizeClass sizeClass(int n4) {
        if (!this.isTinyOrSmall(n4)) {
            return PoolArena$SizeClass.Normal;
        }
        return PoolArena.isTiny(n4) ? PoolArena$SizeClass.Tiny : PoolArena$SizeClass.Small;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeChunk(PoolChunk<T> poolChunk, long l2, PoolArena$SizeClass poolArena$SizeClass, ByteBuffer byteBuffer, boolean bl3) {
        boolean bl4;
        PoolArena poolArena = this;
        synchronized (poolArena) {
            if (!bl3) {
                switch (poolArena$SizeClass) {
                    case Normal: {
                        ++this.deallocationsNormal;
                        break;
                    }
                    case Small: {
                        ++this.deallocationsSmall;
                        break;
                    }
                    case Tiny: {
                        ++this.deallocationsTiny;
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            bl4 = !poolChunk.parent.free(poolChunk, l2, byteBuffer);
        }
        if (bl4) {
            this.destroyChunk(poolChunk);
        }
    }

    PoolSubpage<T> findSubpagePoolHead(int n4) {
        PoolSubpage<T>[] poolSubpageArray;
        int n7;
        if (PoolArena.isTiny(n4)) {
            n7 = n4 >>> 4;
            poolSubpageArray = this.tinySubpagePools;
        } else {
            n7 = 0;
            n4 >>>= 10;
            while (n4 != 0) {
                n4 >>>= 1;
                ++n7;
            }
            poolSubpageArray = this.smallSubpagePools;
        }
        return poolSubpageArray[n7];
    }

    int normalizeCapacity(int n4) {
        ObjectUtil.checkPositiveOrZero(n4, "reqCapacity");
        if (n4 >= this.chunkSize) {
            return this.directMemoryCacheAlignment == 0 ? n4 : this.alignCapacity(n4);
        }
        if (!PoolArena.isTiny(n4)) {
            int n7 = n4;
            --n7;
            n7 |= n7 >>> 1;
            n7 |= n7 >>> 2;
            n7 |= n7 >>> 4;
            n7 |= n7 >>> 8;
            n7 |= n7 >>> 16;
            if (++n7 < 0) {
                n7 >>>= 1;
            }
            assert (this.directMemoryCacheAlignment == 0 || (n7 & this.directMemoryCacheAlignmentMask) == 0);
            return n7;
        }
        if (this.directMemoryCacheAlignment > 0) {
            return this.alignCapacity(n4);
        }
        if ((n4 & 0xF) == 0) {
            return n4;
        }
        return (n4 & 0xFFFFFFF0) + 16;
    }

    int alignCapacity(int n4) {
        int n7 = n4 & this.directMemoryCacheAlignmentMask;
        return n7 == 0 ? n4 : n4 + this.directMemoryCacheAlignment - n7;
    }

    void reallocate(PooledByteBuf<T> pooledByteBuf, int n4, boolean bl3) {
        if (n4 < 0 || n4 > pooledByteBuf.maxCapacity()) {
            throw new IllegalArgumentException("newCapacity: " + n4);
        }
        int n7 = pooledByteBuf.length;
        if (n7 == n4) {
            return;
        }
        PoolChunk poolChunk = pooledByteBuf.chunk;
        ByteBuffer byteBuffer = pooledByteBuf.tmpNioBuf;
        long l2 = pooledByteBuf.handle;
        Object t3 = pooledByteBuf.memory;
        int n8 = pooledByteBuf.offset;
        int n10 = pooledByteBuf.maxLength;
        int n11 = pooledByteBuf.readerIndex();
        int n12 = pooledByteBuf.writerIndex();
        this.allocate(this.parent.threadCache(), pooledByteBuf, n4);
        if (n4 > n7) {
            this.memoryCopy(t3, n8, pooledByteBuf.memory, pooledByteBuf.offset, n7);
        } else if (n4 < n7) {
            if (n11 < n4) {
                if (n12 > n4) {
                    n12 = n4;
                }
                this.memoryCopy(t3, n8 + n11, pooledByteBuf.memory, pooledByteBuf.offset + n11, n12 - n11);
            } else {
                n11 = n12 = n4;
            }
        }
        pooledByteBuf.setIndex(n11, n12);
        if (bl3) {
            this.free(poolChunk, byteBuffer, l2, n10, pooledByteBuf.cache);
        }
    }

    @Override
    public int numThreadCaches() {
        return this.numThreadCaches.get();
    }

    @Override
    public int numTinySubpages() {
        return this.tinySubpagePools.length;
    }

    @Override
    public int numSmallSubpages() {
        return this.smallSubpagePools.length;
    }

    @Override
    public int numChunkLists() {
        return this.chunkListMetrics.size();
    }

    @Override
    public List<PoolSubpageMetric> tinySubpages() {
        return PoolArena.subPageMetricList(this.tinySubpagePools);
    }

    @Override
    public List<PoolSubpageMetric> smallSubpages() {
        return PoolArena.subPageMetricList(this.smallSubpagePools);
    }

    @Override
    public List<PoolChunkListMetric> chunkLists() {
        return this.chunkListMetrics;
    }

    private static List<PoolSubpageMetric> subPageMetricList(PoolSubpage<?>[] poolSubpageArray) {
        ArrayList<PoolSubpageMetric> arrayList = new ArrayList<PoolSubpageMetric>();
        for (PoolSubpage<?> poolSubpage : poolSubpageArray) {
            if (poolSubpage.next == poolSubpage) continue;
            PoolSubpage poolSubpage2 = poolSubpage.next;
            do {
                arrayList.add(poolSubpage2);
            } while ((poolSubpage2 = poolSubpage2.next) != poolSubpage);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numAllocations() {
        long l2;
        PoolArena poolArena = this;
        synchronized (poolArena) {
            l2 = this.allocationsNormal;
        }
        return this.allocationsTiny.value() + this.allocationsSmall.value() + l2 + this.allocationsHuge.value();
    }

    @Override
    public long numTinyAllocations() {
        return this.allocationsTiny.value();
    }

    @Override
    public long numSmallAllocations() {
        return this.allocationsSmall.value();
    }

    @Override
    public synchronized long numNormalAllocations() {
        return this.allocationsNormal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numDeallocations() {
        long l2;
        PoolArena poolArena = this;
        synchronized (poolArena) {
            l2 = this.deallocationsTiny + this.deallocationsSmall + this.deallocationsNormal;
        }
        return l2 + this.deallocationsHuge.value();
    }

    @Override
    public synchronized long numTinyDeallocations() {
        return this.deallocationsTiny;
    }

    @Override
    public synchronized long numSmallDeallocations() {
        return this.deallocationsSmall;
    }

    @Override
    public synchronized long numNormalDeallocations() {
        return this.deallocationsNormal;
    }

    @Override
    public long numHugeAllocations() {
        return this.allocationsHuge.value();
    }

    @Override
    public long numHugeDeallocations() {
        return this.deallocationsHuge.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numActiveAllocations() {
        long l2 = this.allocationsTiny.value() + this.allocationsSmall.value() + this.allocationsHuge.value() - this.deallocationsHuge.value();
        PoolArena poolArena = this;
        synchronized (poolArena) {
        }
        return Math.max(l2 += this.allocationsNormal - (this.deallocationsTiny + this.deallocationsSmall + this.deallocationsNormal), 0L);
    }

    @Override
    public long numActiveTinyAllocations() {
        return Math.max(this.numTinyAllocations() - this.numTinyDeallocations(), 0L);
    }

    @Override
    public long numActiveSmallAllocations() {
        return Math.max(this.numSmallAllocations() - this.numSmallDeallocations(), 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numActiveNormalAllocations() {
        long l2;
        PoolArena poolArena = this;
        synchronized (poolArena) {
            l2 = this.allocationsNormal - this.deallocationsNormal;
        }
        return Math.max(l2, 0L);
    }

    @Override
    public long numActiveHugeAllocations() {
        return Math.max(this.numHugeAllocations() - this.numHugeDeallocations(), 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numActiveBytes() {
        long l2 = this.activeBytesHuge.value();
        PoolArena poolArena = this;
        synchronized (poolArena) {
            for (int i3 = 0; i3 < this.chunkListMetrics.size(); ++i3) {
                for (PoolChunkMetric poolChunkMetric : this.chunkListMetrics.get(i3)) {
                    l2 += (long)poolChunkMetric.chunkSize();
                }
            }
        }
        return Math.max(0L, l2);
    }

    protected abstract PoolChunk<T> newChunk(int var1, int var2, int var3, int var4);

    protected abstract PoolChunk<T> newUnpooledChunk(int var1);

    protected abstract PooledByteBuf<T> newByteBuf(int var1);

    protected abstract void memoryCopy(T var1, int var2, T var3, int var4, int var5);

    protected abstract void destroyChunk(PoolChunk<T> var1);

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Chunk(s) at 0~25%:").append(StringUtil.NEWLINE).append(this.qInit).append(StringUtil.NEWLINE).append("Chunk(s) at 0~50%:").append(StringUtil.NEWLINE).append(this.q000).append(StringUtil.NEWLINE).append("Chunk(s) at 25~75%:").append(StringUtil.NEWLINE).append(this.q025).append(StringUtil.NEWLINE).append("Chunk(s) at 50~100%:").append(StringUtil.NEWLINE).append(this.q050).append(StringUtil.NEWLINE).append("Chunk(s) at 75~100%:").append(StringUtil.NEWLINE).append(this.q075).append(StringUtil.NEWLINE).append("Chunk(s) at 100%:").append(StringUtil.NEWLINE).append(this.q100).append(StringUtil.NEWLINE).append("tiny subpages:");
        PoolArena.appendPoolSubPages(stringBuilder, this.tinySubpagePools);
        stringBuilder.append(StringUtil.NEWLINE).append("small subpages:");
        PoolArena.appendPoolSubPages(stringBuilder, this.smallSubpagePools);
        stringBuilder.append(StringUtil.NEWLINE);
        return stringBuilder.toString();
    }

    private static void appendPoolSubPages(StringBuilder stringBuilder, PoolSubpage<?>[] poolSubpageArray) {
        for (int i3 = 0; i3 < poolSubpageArray.length; ++i3) {
            PoolSubpage<?> poolSubpage = poolSubpageArray[i3];
            if (poolSubpage.next == poolSubpage) continue;
            stringBuilder.append(StringUtil.NEWLINE).append(i3).append(": ");
            PoolSubpage poolSubpage2 = poolSubpage.next;
            do {
                stringBuilder.append(poolSubpage2);
            } while ((poolSubpage2 = poolSubpage2.next) != poolSubpage);
        }
    }

    protected final void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            PoolArena.destroyPoolSubPages(this.smallSubpagePools);
            PoolArena.destroyPoolSubPages(this.tinySubpagePools);
            this.destroyPoolChunkLists(this.qInit, this.q000, this.q025, this.q050, this.q075, this.q100);
            throw throwable;
        }
        PoolArena.destroyPoolSubPages(this.smallSubpagePools);
        PoolArena.destroyPoolSubPages(this.tinySubpagePools);
        this.destroyPoolChunkLists(this.qInit, this.q000, this.q025, this.q050, this.q075, this.q100);
    }

    private static void destroyPoolSubPages(PoolSubpage<?>[] poolSubpageArray) {
        for (PoolSubpage<?> poolSubpage : poolSubpageArray) {
            poolSubpage.destroy();
        }
    }

    private void destroyPoolChunkLists(PoolChunkList<T> ... poolChunkListArray) {
        for (PoolChunkList<T> poolChunkList : poolChunkListArray) {
            poolChunkList.destroy(this);
        }
    }
}

