/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.PoolArena;
import io.grpc.netty.shaded.io.netty.buffer.PoolChunk;
import io.grpc.netty.shaded.io.netty.buffer.PooledByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.PooledByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.PooledDirectByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.PooledUnsafeDirectByteBuf;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

final class PoolArena$DirectArena
extends PoolArena<ByteBuffer> {
    PoolArena$DirectArena(PooledByteBufAllocator pooledByteBufAllocator, int n4, int n7, int n8, int n10, int n11) {
        super(pooledByteBufAllocator, n4, n7, n8, n10, n11);
    }

    @Override
    boolean isDirect() {
        return true;
    }

    int offsetCacheLine(ByteBuffer byteBuffer) {
        int n4 = HAS_UNSAFE ? (int)(PlatformDependent.directBufferAddress(byteBuffer) & (long)this.directMemoryCacheAlignmentMask) : 0;
        return this.directMemoryCacheAlignment - n4;
    }

    @Override
    protected PoolChunk<ByteBuffer> newChunk(int n4, int n7, int n8, int n10) {
        if (this.directMemoryCacheAlignment == 0) {
            return new PoolChunk<ByteBuffer>(this, PoolArena$DirectArena.allocateDirect(n10), n4, n7, n8, n10, 0);
        }
        ByteBuffer byteBuffer = PoolArena$DirectArena.allocateDirect(n10 + this.directMemoryCacheAlignment);
        return new PoolChunk<ByteBuffer>(this, byteBuffer, n4, n7, n8, n10, this.offsetCacheLine(byteBuffer));
    }

    @Override
    protected PoolChunk<ByteBuffer> newUnpooledChunk(int n4) {
        if (this.directMemoryCacheAlignment == 0) {
            return new PoolChunk<ByteBuffer>(this, PoolArena$DirectArena.allocateDirect(n4), n4, 0);
        }
        ByteBuffer byteBuffer = PoolArena$DirectArena.allocateDirect(n4 + this.directMemoryCacheAlignment);
        return new PoolChunk<ByteBuffer>(this, byteBuffer, n4, this.offsetCacheLine(byteBuffer));
    }

    private static ByteBuffer allocateDirect(int n4) {
        return PlatformDependent.useDirectBufferNoCleaner() ? PlatformDependent.allocateDirectNoCleaner(n4) : ByteBuffer.allocateDirect(n4);
    }

    @Override
    protected void destroyChunk(PoolChunk<ByteBuffer> poolChunk) {
        if (PlatformDependent.useDirectBufferNoCleaner()) {
            PlatformDependent.freeDirectNoCleaner((ByteBuffer)poolChunk.memory);
        } else {
            PlatformDependent.freeDirectBuffer((ByteBuffer)poolChunk.memory);
        }
    }

    @Override
    protected PooledByteBuf<ByteBuffer> newByteBuf(int n4) {
        if (HAS_UNSAFE) {
            return PooledUnsafeDirectByteBuf.newInstance(n4);
        }
        return PooledDirectByteBuf.newInstance(n4);
    }

    @Override
    protected void memoryCopy(ByteBuffer byteBuffer, int n4, ByteBuffer byteBuffer2, int n7, int n8) {
        if (n8 == 0) {
            return;
        }
        if (HAS_UNSAFE) {
            PlatformDependent.copyMemory(PlatformDependent.directBufferAddress(byteBuffer) + (long)n4, PlatformDependent.directBufferAddress(byteBuffer2) + (long)n7, n8);
        } else {
            byteBuffer = byteBuffer.duplicate();
            byteBuffer2 = byteBuffer2.duplicate();
            byteBuffer.position(n4).limit(n4 + n8);
            byteBuffer2.position(n7);
            byteBuffer2.put(byteBuffer);
        }
    }
}

