/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

final class HeapByteBufUtil {
    static byte getByte(byte[] byArray, int n4) {
        return byArray[n4];
    }

    static short getShort(byte[] byArray, int n4) {
        return (short)(byArray[n4] << 8 | byArray[n4 + 1] & 0xFF);
    }

    static short getShortLE(byte[] byArray, int n4) {
        return (short)(byArray[n4] & 0xFF | byArray[n4 + 1] << 8);
    }

    static int getUnsignedMedium(byte[] byArray, int n4) {
        return (byArray[n4] & 0xFF) << 16 | (byArray[n4 + 1] & 0xFF) << 8 | byArray[n4 + 2] & 0xFF;
    }

    static int getUnsignedMediumLE(byte[] byArray, int n4) {
        return byArray[n4] & 0xFF | (byArray[n4 + 1] & 0xFF) << 8 | (byArray[n4 + 2] & 0xFF) << 16;
    }

    static int getInt(byte[] byArray, int n4) {
        return (byArray[n4] & 0xFF) << 24 | (byArray[n4 + 1] & 0xFF) << 16 | (byArray[n4 + 2] & 0xFF) << 8 | byArray[n4 + 3] & 0xFF;
    }

    static int getIntLE(byte[] byArray, int n4) {
        return byArray[n4] & 0xFF | (byArray[n4 + 1] & 0xFF) << 8 | (byArray[n4 + 2] & 0xFF) << 16 | (byArray[n4 + 3] & 0xFF) << 24;
    }

    static long getLong(byte[] byArray, int n4) {
        return ((long)byArray[n4] & 0xFFL) << 56 | ((long)byArray[n4 + 1] & 0xFFL) << 48 | ((long)byArray[n4 + 2] & 0xFFL) << 40 | ((long)byArray[n4 + 3] & 0xFFL) << 32 | ((long)byArray[n4 + 4] & 0xFFL) << 24 | ((long)byArray[n4 + 5] & 0xFFL) << 16 | ((long)byArray[n4 + 6] & 0xFFL) << 8 | (long)byArray[n4 + 7] & 0xFFL;
    }

    static long getLongLE(byte[] byArray, int n4) {
        return (long)byArray[n4] & 0xFFL | ((long)byArray[n4 + 1] & 0xFFL) << 8 | ((long)byArray[n4 + 2] & 0xFFL) << 16 | ((long)byArray[n4 + 3] & 0xFFL) << 24 | ((long)byArray[n4 + 4] & 0xFFL) << 32 | ((long)byArray[n4 + 5] & 0xFFL) << 40 | ((long)byArray[n4 + 6] & 0xFFL) << 48 | ((long)byArray[n4 + 7] & 0xFFL) << 56;
    }

    static void setByte(byte[] byArray, int n4, int n7) {
        byArray[n4] = (byte)n7;
    }

    static void setShort(byte[] byArray, int n4, int n7) {
        byArray[n4] = (byte)(n7 >>> 8);
        byArray[n4 + 1] = (byte)n7;
    }

    static void setShortLE(byte[] byArray, int n4, int n7) {
        byArray[n4] = (byte)n7;
        byArray[n4 + 1] = (byte)(n7 >>> 8);
    }

    static void setMedium(byte[] byArray, int n4, int n7) {
        byArray[n4] = (byte)(n7 >>> 16);
        byArray[n4 + 1] = (byte)(n7 >>> 8);
        byArray[n4 + 2] = (byte)n7;
    }

    static void setMediumLE(byte[] byArray, int n4, int n7) {
        byArray[n4] = (byte)n7;
        byArray[n4 + 1] = (byte)(n7 >>> 8);
        byArray[n4 + 2] = (byte)(n7 >>> 16);
    }

    static void setInt(byte[] byArray, int n4, int n7) {
        byArray[n4] = (byte)(n7 >>> 24);
        byArray[n4 + 1] = (byte)(n7 >>> 16);
        byArray[n4 + 2] = (byte)(n7 >>> 8);
        byArray[n4 + 3] = (byte)n7;
    }

    static void setIntLE(byte[] byArray, int n4, int n7) {
        byArray[n4] = (byte)n7;
        byArray[n4 + 1] = (byte)(n7 >>> 8);
        byArray[n4 + 2] = (byte)(n7 >>> 16);
        byArray[n4 + 3] = (byte)(n7 >>> 24);
    }

    static void setLong(byte[] byArray, int n4, long l2) {
        byArray[n4] = (byte)(l2 >>> 56);
        byArray[n4 + 1] = (byte)(l2 >>> 48);
        byArray[n4 + 2] = (byte)(l2 >>> 40);
        byArray[n4 + 3] = (byte)(l2 >>> 32);
        byArray[n4 + 4] = (byte)(l2 >>> 24);
        byArray[n4 + 5] = (byte)(l2 >>> 16);
        byArray[n4 + 6] = (byte)(l2 >>> 8);
        byArray[n4 + 7] = (byte)l2;
    }

    static void setLongLE(byte[] byArray, int n4, long l2) {
        byArray[n4] = (byte)l2;
        byArray[n4 + 1] = (byte)(l2 >>> 8);
        byArray[n4 + 2] = (byte)(l2 >>> 16);
        byArray[n4 + 3] = (byte)(l2 >>> 24);
        byArray[n4 + 4] = (byte)(l2 >>> 32);
        byArray[n4 + 5] = (byte)(l2 >>> 40);
        byArray[n4 + 6] = (byte)(l2 >>> 48);
        byArray[n4 + 7] = (byte)(l2 >>> 56);
    }

    private HeapByteBufUtil() {
    }
}

