/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.FixedCompositeByteBuf$Component;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.util.internal.EmptyArrays;
import io.grpc.netty.shaded.io.netty.util.internal.RecyclableArrayList;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.Collections;

final class FixedCompositeByteBuf
extends AbstractReferenceCountedByteBuf {
    private static final ByteBuf[] EMPTY = new ByteBuf[]{Unpooled.EMPTY_BUFFER};
    private final int nioBufferCount;
    private final int capacity;
    private final ByteBufAllocator allocator;
    private final ByteOrder order;
    private final ByteBuf[] buffers;
    private final boolean direct;

    FixedCompositeByteBuf(ByteBufAllocator byteBufAllocator, ByteBuf ... byteBufArray) {
        super(Integer.MAX_VALUE);
        if (byteBufArray.length == 0) {
            this.buffers = EMPTY;
            this.order = ByteOrder.BIG_ENDIAN;
            this.nioBufferCount = 1;
            this.capacity = 0;
            this.direct = false;
        } else {
            ByteBuf byteBuf = byteBufArray[0];
            this.buffers = byteBufArray;
            boolean bl3 = true;
            int n4 = byteBuf.nioBufferCount();
            int n7 = byteBuf.readableBytes();
            this.order = byteBuf.order();
            for (int i3 = 1; i3 < byteBufArray.length; ++i3) {
                byteBuf = byteBufArray[i3];
                if (byteBufArray[i3].order() != this.order) {
                    throw new IllegalArgumentException("All ByteBufs need to have same ByteOrder");
                }
                n4 += byteBuf.nioBufferCount();
                n7 += byteBuf.readableBytes();
                if (byteBuf.isDirect()) continue;
                bl3 = false;
            }
            this.nioBufferCount = n4;
            this.capacity = n7;
            this.direct = bl3;
        }
        this.setIndex(0, this.capacity());
        this.allocator = byteBufAllocator;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isWritable(int n4) {
        return false;
    }

    @Override
    public ByteBuf discardReadBytes() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int n4, byte[] byArray, int n7, int n8) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuffer byteBuffer) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setByte(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setByte(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setShort(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setShort(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setShortLE(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setMedium(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setMedium(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setMediumLE(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setInt(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setInt(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setIntLE(int n4, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setLong(int n4, long l2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setLong(int n4, long l2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setLongLE(int n4, long l2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int n4, InputStream inputStream, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int n4, ScatteringByteChannel scatteringByteChannel, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int n4, FileChannel fileChannel, long l2, int n7) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int maxCapacity() {
        return this.capacity;
    }

    @Override
    public ByteBuf capacity(int n4) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    @Override
    public boolean isDirect() {
        return this.direct;
    }

    private FixedCompositeByteBuf$Component findComponent(int n4) {
        int n7 = 0;
        for (int i3 = 0; i3 < this.buffers.length; ++i3) {
            FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = null;
            ByteBuf byteBuf = this.buffers[i3];
            if (byteBuf instanceof FixedCompositeByteBuf$Component) {
                fixedCompositeByteBuf$Component = (FixedCompositeByteBuf$Component)byteBuf;
                byteBuf = fixedCompositeByteBuf$Component.buf;
            }
            if (n4 >= (n7 += byteBuf.readableBytes())) continue;
            if (fixedCompositeByteBuf$Component == null) {
                fixedCompositeByteBuf$Component = new FixedCompositeByteBuf$Component(i3, n7 - byteBuf.readableBytes(), byteBuf);
                this.buffers[i3] = fixedCompositeByteBuf$Component;
            }
            return fixedCompositeByteBuf$Component;
        }
        throw new IllegalStateException();
    }

    private ByteBuf buffer(int n4) {
        ByteBuf byteBuf = this.buffers[n4];
        return byteBuf instanceof FixedCompositeByteBuf$Component ? ((FixedCompositeByteBuf$Component)byteBuf).buf : byteBuf;
    }

    @Override
    public byte getByte(int n4) {
        return this._getByte(n4);
    }

    @Override
    protected byte _getByte(int n4) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n4);
        return fixedCompositeByteBuf$Component.buf.getByte(n4 - FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component));
    }

    @Override
    protected short _getShort(int n4) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n4);
        if (n4 + 2 <= FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component)) {
            return fixedCompositeByteBuf$Component.buf.getShort(n4 - FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (short)((this._getByte(n4) & 0xFF) << 8 | this._getByte(n4 + 1) & 0xFF);
        }
        return (short)(this._getByte(n4) & 0xFF | (this._getByte(n4 + 1) & 0xFF) << 8);
    }

    @Override
    protected short _getShortLE(int n4) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n4);
        if (n4 + 2 <= FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component)) {
            return fixedCompositeByteBuf$Component.buf.getShortLE(n4 - FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (short)(this._getByte(n4) & 0xFF | (this._getByte(n4 + 1) & 0xFF) << 8);
        }
        return (short)((this._getByte(n4) & 0xFF) << 8 | this._getByte(n4 + 1) & 0xFF);
    }

    @Override
    protected int _getUnsignedMedium(int n4) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n4);
        if (n4 + 3 <= FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component)) {
            return fixedCompositeByteBuf$Component.buf.getUnsignedMedium(n4 - FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(n4) & 0xFFFF) << 8 | this._getByte(n4 + 2) & 0xFF;
        }
        return this._getShort(n4) & 0xFFFF | (this._getByte(n4 + 2) & 0xFF) << 16;
    }

    @Override
    protected int _getUnsignedMediumLE(int n4) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n4);
        if (n4 + 3 <= FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component)) {
            return fixedCompositeByteBuf$Component.buf.getUnsignedMediumLE(n4 - FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return this._getShortLE(n4) & 0xFFFF | (this._getByte(n4 + 2) & 0xFF) << 16;
        }
        return (this._getShortLE(n4) & 0xFFFF) << 8 | this._getByte(n4 + 2) & 0xFF;
    }

    @Override
    protected int _getInt(int n4) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n4);
        if (n4 + 4 <= FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component)) {
            return fixedCompositeByteBuf$Component.buf.getInt(n4 - FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(n4) & 0xFFFF) << 16 | this._getShort(n4 + 2) & 0xFFFF;
        }
        return this._getShort(n4) & 0xFFFF | (this._getShort(n4 + 2) & 0xFFFF) << 16;
    }

    @Override
    protected int _getIntLE(int n4) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n4);
        if (n4 + 4 <= FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component)) {
            return fixedCompositeByteBuf$Component.buf.getIntLE(n4 - FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return this._getShortLE(n4) & 0xFFFF | (this._getShortLE(n4 + 2) & 0xFFFF) << 16;
        }
        return (this._getShortLE(n4) & 0xFFFF) << 16 | this._getShortLE(n4 + 2) & 0xFFFF;
    }

    @Override
    protected long _getLong(int n4) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n4);
        if (n4 + 8 <= FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component)) {
            return fixedCompositeByteBuf$Component.buf.getLong(n4 - FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return ((long)this._getInt(n4) & 0xFFFFFFFFL) << 32 | (long)this._getInt(n4 + 4) & 0xFFFFFFFFL;
        }
        return (long)this._getInt(n4) & 0xFFFFFFFFL | ((long)this._getInt(n4 + 4) & 0xFFFFFFFFL) << 32;
    }

    @Override
    protected long _getLongLE(int n4) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n4);
        if (n4 + 8 <= FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component)) {
            return fixedCompositeByteBuf$Component.buf.getLongLE(n4 - FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (long)this._getIntLE(n4) & 0xFFFFFFFFL | ((long)this._getIntLE(n4 + 4) & 0xFFFFFFFFL) << 32;
        }
        return ((long)this._getIntLE(n4) & 0xFFFFFFFFL) << 32 | (long)this._getIntLE(n4 + 4) & 0xFFFFFFFFL;
    }

    @Override
    public ByteBuf getBytes(int n4, byte[] byArray, int n7, int n8) {
        this.checkDstIndex(n4, n8, n7, byArray.length);
        if (n8 == 0) {
            return this;
        }
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n4);
        int n10 = FixedCompositeByteBuf$Component.access$200(fixedCompositeByteBuf$Component);
        int n11 = FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component);
        ByteBuf byteBuf = fixedCompositeByteBuf$Component.buf;
        while (true) {
            int n12 = Math.min(n8, byteBuf.readableBytes() - (n4 - n11));
            byteBuf.getBytes(n4 - n11, byArray, n7, n12);
            n4 += n12;
            n7 += n12;
            n11 += byteBuf.readableBytes();
            if ((n8 -= n12) <= 0) break;
            byteBuf = this.buffer(++n10);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf getBytes(int n4, ByteBuffer byteBuffer) {
        int n7 = byteBuffer.limit();
        int n8 = byteBuffer.remaining();
        this.checkIndex(n4, n8);
        if (n8 == 0) {
            return this;
        }
        try {
            FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n4);
            int n10 = FixedCompositeByteBuf$Component.access$200(fixedCompositeByteBuf$Component);
            int n11 = FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component);
            ByteBuf byteBuf = fixedCompositeByteBuf$Component.buf;
            while (true) {
                int n12 = Math.min(n8, byteBuf.readableBytes() - (n4 - n11));
                byteBuffer.limit(byteBuffer.position() + n12);
                byteBuf.getBytes(n4 - n11, byteBuffer);
                n4 += n12;
                n11 += byteBuf.readableBytes();
                if ((n8 -= n12) <= 0) {
                    break;
                }
                byteBuf = this.buffer(++n10);
            }
        }
        finally {
            byteBuffer.limit(n7);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        this.checkDstIndex(n4, n8, n7, byteBuf.capacity());
        if (n8 == 0) {
            return this;
        }
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n4);
        int n10 = FixedCompositeByteBuf$Component.access$200(fixedCompositeByteBuf$Component);
        int n11 = FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component);
        ByteBuf byteBuf2 = fixedCompositeByteBuf$Component.buf;
        while (true) {
            int n12 = Math.min(n8, byteBuf2.readableBytes() - (n4 - n11));
            byteBuf2.getBytes(n4 - n11, byteBuf, n7, n12);
            n4 += n12;
            n7 += n12;
            n11 += byteBuf2.readableBytes();
            if ((n8 -= n12) <= 0) break;
            byteBuf2 = this.buffer(++n10);
        }
        return this;
    }

    @Override
    public int getBytes(int n4, GatheringByteChannel gatheringByteChannel, int n7) {
        int n8 = this.nioBufferCount();
        if (n8 == 1) {
            return gatheringByteChannel.write(this.internalNioBuffer(n4, n7));
        }
        long l2 = gatheringByteChannel.write(this.nioBuffers(n4, n7));
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    @Override
    public int getBytes(int n4, FileChannel fileChannel, long l2, int n7) {
        int n8 = this.nioBufferCount();
        if (n8 == 1) {
            return fileChannel.write(this.internalNioBuffer(n4, n7), l2);
        }
        long l10 = 0L;
        for (ByteBuffer byteBuffer : this.nioBuffers(n4, n7)) {
            l10 += (long)fileChannel.write(byteBuffer, l2 + l10);
        }
        if (l10 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l10;
    }

    @Override
    public ByteBuf getBytes(int n4, OutputStream outputStream, int n7) {
        this.checkIndex(n4, n7);
        if (n7 == 0) {
            return this;
        }
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n4);
        int n8 = FixedCompositeByteBuf$Component.access$200(fixedCompositeByteBuf$Component);
        int n10 = FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component);
        ByteBuf byteBuf = fixedCompositeByteBuf$Component.buf;
        while (true) {
            int n11 = Math.min(n7, byteBuf.readableBytes() - (n4 - n10));
            byteBuf.getBytes(n4 - n10, outputStream, n11);
            n4 += n11;
            n10 += byteBuf.readableBytes();
            if ((n7 -= n11) <= 0) break;
            byteBuf = this.buffer(++n8);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf copy(int n4, int n7) {
        this.checkIndex(n4, n7);
        boolean bl3 = true;
        ByteBuf byteBuf = this.alloc().buffer(n7);
        try {
            byteBuf.writeBytes(this, n4, n7);
            bl3 = false;
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        finally {
            if (bl3) {
                byteBuf.release();
            }
        }
    }

    @Override
    public int nioBufferCount() {
        return this.nioBufferCount;
    }

    @Override
    public ByteBuffer nioBuffer(int n4, int n7) {
        Comparable<ByteBuf> comparable;
        this.checkIndex(n4, n7);
        if (this.buffers.length == 1 && ((ByteBuf)(comparable = this.buffer(0))).nioBufferCount() == 1) {
            return ((ByteBuf)comparable).nioBuffer(n4, n7);
        }
        comparable = ByteBuffer.allocate(n7).order(this.order());
        ByteBuffer[] byteBufferArray = this.nioBuffers(n4, n7);
        for (int i3 = 0; i3 < byteBufferArray.length; ++i3) {
            ((ByteBuffer)comparable).put(byteBufferArray[i3]);
        }
        ((ByteBuffer)comparable).flip();
        return comparable;
    }

    @Override
    public ByteBuffer internalNioBuffer(int n4, int n7) {
        if (this.buffers.length == 1) {
            return this.buffer(0).internalNioBuffer(n4, n7);
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer[] nioBuffers(int n4, int n7) {
        this.checkIndex(n4, n7);
        if (n7 == 0) {
            return EmptyArrays.EMPTY_BYTE_BUFFERS;
        }
        RecyclableArrayList recyclableArrayList = RecyclableArrayList.newInstance(this.buffers.length);
        try {
            FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n4);
            int n8 = FixedCompositeByteBuf$Component.access$200(fixedCompositeByteBuf$Component);
            int n10 = FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component);
            ByteBuf byteBuf = fixedCompositeByteBuf$Component.buf;
            while (true) {
                int n11 = Math.min(n7, byteBuf.readableBytes() - (n4 - n10));
                switch (byteBuf.nioBufferCount()) {
                    case 0: {
                        throw new UnsupportedOperationException();
                    }
                    case 1: {
                        recyclableArrayList.add(byteBuf.nioBuffer(n4 - n10, n11));
                        break;
                    }
                    default: {
                        Collections.addAll(recyclableArrayList, byteBuf.nioBuffers(n4 - n10, n11));
                    }
                }
                n4 += n11;
                n10 += byteBuf.readableBytes();
                if ((n7 -= n11) <= 0) break;
                byteBuf = this.buffer(++n8);
            }
            ByteBuffer[] byteBufferArray = recyclableArrayList.toArray(new ByteBuffer[0]);
            return byteBufferArray;
        }
        finally {
            recyclableArrayList.recycle();
        }
    }

    @Override
    public boolean hasArray() {
        switch (this.buffers.length) {
            case 0: {
                return true;
            }
            case 1: {
                return this.buffer(0).hasArray();
            }
        }
        return false;
    }

    @Override
    public byte[] array() {
        switch (this.buffers.length) {
            case 0: {
                return EmptyArrays.EMPTY_BYTES;
            }
            case 1: {
                return this.buffer(0).array();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        switch (this.buffers.length) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.buffer(0).arrayOffset();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasMemoryAddress() {
        switch (this.buffers.length) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.hasMemoryAddress();
            }
            case 1: {
                return this.buffer(0).hasMemoryAddress();
            }
        }
        return false;
    }

    @Override
    public long memoryAddress() {
        switch (this.buffers.length) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.memoryAddress();
            }
            case 1: {
                return this.buffer(0).memoryAddress();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected void deallocate() {
        for (int i3 = 0; i3 < this.buffers.length; ++i3) {
            this.buffer(i3).release();
        }
    }

    @Override
    public String toString() {
        String string = super.toString();
        string = string.substring(0, string.length() - 1);
        return string + ", components=" + this.buffers.length + ')';
    }
}

