/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.util.ByteProcessor;
import io.grpc.netty.shaded.io.netty.util.internal.EmptyArrays;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

public final class EmptyByteBuf
extends ByteBuf {
    static final int EMPTY_BYTE_BUF_HASH_CODE = 1;
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocateDirect(0);
    private static final long EMPTY_BYTE_BUFFER_ADDRESS;
    private final ByteBufAllocator alloc;
    private final ByteOrder order;
    private final String str;
    private EmptyByteBuf swapped;

    public EmptyByteBuf(ByteBufAllocator byteBufAllocator) {
        this(byteBufAllocator, ByteOrder.BIG_ENDIAN);
    }

    private EmptyByteBuf(ByteBufAllocator byteBufAllocator, ByteOrder byteOrder) {
        if (byteBufAllocator == null) {
            throw new NullPointerException("alloc");
        }
        this.alloc = byteBufAllocator;
        this.order = byteOrder;
        this.str = StringUtil.simpleClassName(this) + (byteOrder == ByteOrder.BIG_ENDIAN ? "BE" : "LE");
    }

    @Override
    public int capacity() {
        return 0;
    }

    @Override
    public ByteBuf capacity(int n4) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    @Override
    public ByteBuf asReadOnly() {
        return Unpooled.unmodifiableBuffer((ByteBuf)this);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public int maxCapacity() {
        return 0;
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        if (byteOrder == null) {
            throw new NullPointerException("endianness");
        }
        if (byteOrder == this.order()) {
            return this;
        }
        EmptyByteBuf emptyByteBuf = this.swapped;
        if (emptyByteBuf != null) {
            return emptyByteBuf;
        }
        this.swapped = emptyByteBuf = new EmptyByteBuf(this.alloc(), byteOrder);
        return emptyByteBuf;
    }

    @Override
    public int readerIndex() {
        return 0;
    }

    @Override
    public ByteBuf readerIndex(int n4) {
        return this.checkIndex(n4);
    }

    @Override
    public int writerIndex() {
        return 0;
    }

    @Override
    public ByteBuf writerIndex(int n4) {
        return this.checkIndex(n4);
    }

    @Override
    public ByteBuf setIndex(int n4, int n7) {
        this.checkIndex(n4);
        this.checkIndex(n7);
        return this;
    }

    @Override
    public int readableBytes() {
        return 0;
    }

    @Override
    public int writableBytes() {
        return 0;
    }

    @Override
    public int maxWritableBytes() {
        return 0;
    }

    @Override
    public boolean isReadable() {
        return false;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public ByteBuf clear() {
        return this;
    }

    @Override
    public ByteBuf markReaderIndex() {
        return this;
    }

    @Override
    public ByteBuf resetReaderIndex() {
        return this;
    }

    @Override
    public ByteBuf markWriterIndex() {
        return this;
    }

    @Override
    public ByteBuf resetWriterIndex() {
        return this;
    }

    @Override
    public ByteBuf discardReadBytes() {
        return this;
    }

    @Override
    public ByteBuf discardSomeReadBytes() {
        return this;
    }

    @Override
    public ByteBuf ensureWritable(int n4) {
        ObjectUtil.checkPositiveOrZero(n4, "minWritableBytes");
        if (n4 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public int ensureWritable(int n4, boolean bl3) {
        ObjectUtil.checkPositiveOrZero(n4, "minWritableBytes");
        if (n4 == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean getBoolean(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public byte getByte(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public short getUnsignedByte(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public short getShort(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public short getShortLE(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getUnsignedShort(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getUnsignedShortLE(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getMedium(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getMediumLE(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getUnsignedMedium(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getUnsignedMediumLE(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getInt(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getIntLE(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long getUnsignedInt(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long getUnsignedIntLE(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long getLong(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long getLongLE(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public char getChar(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public float getFloat(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public double getDouble(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuf byteBuf) {
        return this.checkIndex(n4, byteBuf.writableBytes());
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuf byteBuf, int n7) {
        return this.checkIndex(n4, n7);
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        return this.checkIndex(n4, n8);
    }

    @Override
    public ByteBuf getBytes(int n4, byte[] byArray) {
        return this.checkIndex(n4, byArray.length);
    }

    @Override
    public ByteBuf getBytes(int n4, byte[] byArray, int n7, int n8) {
        return this.checkIndex(n4, n8);
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuffer byteBuffer) {
        return this.checkIndex(n4, byteBuffer.remaining());
    }

    @Override
    public ByteBuf getBytes(int n4, OutputStream outputStream, int n7) {
        return this.checkIndex(n4, n7);
    }

    @Override
    public int getBytes(int n4, GatheringByteChannel gatheringByteChannel, int n7) {
        this.checkIndex(n4, n7);
        return 0;
    }

    @Override
    public int getBytes(int n4, FileChannel fileChannel, long l2, int n7) {
        this.checkIndex(n4, n7);
        return 0;
    }

    @Override
    public CharSequence getCharSequence(int n4, int n7, Charset charset) {
        this.checkIndex(n4, n7);
        return null;
    }

    @Override
    public ByteBuf setBoolean(int n4, boolean bl3) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setByte(int n4, int n7) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setShort(int n4, int n7) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setShortLE(int n4, int n7) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setMedium(int n4, int n7) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setMediumLE(int n4, int n7) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setInt(int n4, int n7) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setIntLE(int n4, int n7) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setLong(int n4, long l2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setLongLE(int n4, long l2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setChar(int n4, int n7) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setFloat(int n4, float f8) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setDouble(int n4, double d8) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuf byteBuf) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuf byteBuf, int n7) {
        return this.checkIndex(n4, n7);
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        return this.checkIndex(n4, n8);
    }

    @Override
    public ByteBuf setBytes(int n4, byte[] byArray) {
        return this.checkIndex(n4, byArray.length);
    }

    @Override
    public ByteBuf setBytes(int n4, byte[] byArray, int n7, int n8) {
        return this.checkIndex(n4, n8);
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuffer byteBuffer) {
        return this.checkIndex(n4, byteBuffer.remaining());
    }

    @Override
    public int setBytes(int n4, InputStream inputStream, int n7) {
        this.checkIndex(n4, n7);
        return 0;
    }

    @Override
    public int setBytes(int n4, ScatteringByteChannel scatteringByteChannel, int n7) {
        this.checkIndex(n4, n7);
        return 0;
    }

    @Override
    public int setBytes(int n4, FileChannel fileChannel, long l2, int n7) {
        this.checkIndex(n4, n7);
        return 0;
    }

    @Override
    public ByteBuf setZero(int n4, int n7) {
        return this.checkIndex(n4, n7);
    }

    @Override
    public int setCharSequence(int n4, CharSequence charSequence, Charset charset) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean readBoolean() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public byte readByte() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public short readUnsignedByte() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public short readShort() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public short readShortLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readUnsignedShort() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readUnsignedShortLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readMedium() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readMediumLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readUnsignedMedium() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readUnsignedMediumLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readInt() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readIntLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long readUnsignedInt() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long readUnsignedIntLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long readLong() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long readLongLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public char readChar() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public float readFloat() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public double readDouble() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf readBytes(int n4) {
        return this.checkLength(n4);
    }

    @Override
    public ByteBuf readSlice(int n4) {
        return this.checkLength(n4);
    }

    @Override
    public ByteBuf readRetainedSlice(int n4) {
        return this.checkLength(n4);
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf) {
        return this.checkLength(byteBuf.writableBytes());
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf, int n4) {
        return this.checkLength(n4);
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf, int n4, int n7) {
        return this.checkLength(n7);
    }

    @Override
    public ByteBuf readBytes(byte[] byArray) {
        return this.checkLength(byArray.length);
    }

    @Override
    public ByteBuf readBytes(byte[] byArray, int n4, int n7) {
        return this.checkLength(n7);
    }

    @Override
    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        return this.checkLength(byteBuffer.remaining());
    }

    @Override
    public ByteBuf readBytes(OutputStream outputStream, int n4) {
        return this.checkLength(n4);
    }

    @Override
    public int readBytes(GatheringByteChannel gatheringByteChannel, int n4) {
        this.checkLength(n4);
        return 0;
    }

    @Override
    public int readBytes(FileChannel fileChannel, long l2, int n4) {
        this.checkLength(n4);
        return 0;
    }

    @Override
    public CharSequence readCharSequence(int n4, Charset charset) {
        this.checkLength(n4);
        return "";
    }

    @Override
    public ByteBuf skipBytes(int n4) {
        return this.checkLength(n4);
    }

    @Override
    public ByteBuf writeBoolean(boolean bl3) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeByte(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeShort(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeShortLE(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeMedium(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeMediumLE(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeInt(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeIntLE(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeLong(long l2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeLongLE(long l2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeChar(int n4) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeFloat(float f8) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeDouble(double d8) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf) {
        return this.checkLength(byteBuf.readableBytes());
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf, int n4) {
        return this.checkLength(n4);
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf, int n4, int n7) {
        return this.checkLength(n7);
    }

    @Override
    public ByteBuf writeBytes(byte[] byArray) {
        return this.checkLength(byArray.length);
    }

    @Override
    public ByteBuf writeBytes(byte[] byArray, int n4, int n7) {
        return this.checkLength(n7);
    }

    @Override
    public ByteBuf writeBytes(ByteBuffer byteBuffer) {
        return this.checkLength(byteBuffer.remaining());
    }

    @Override
    public int writeBytes(InputStream inputStream, int n4) {
        this.checkLength(n4);
        return 0;
    }

    @Override
    public int writeBytes(ScatteringByteChannel scatteringByteChannel, int n4) {
        this.checkLength(n4);
        return 0;
    }

    @Override
    public int writeBytes(FileChannel fileChannel, long l2, int n4) {
        this.checkLength(n4);
        return 0;
    }

    @Override
    public ByteBuf writeZero(int n4) {
        return this.checkLength(n4);
    }

    @Override
    public int writeCharSequence(CharSequence charSequence, Charset charset) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int indexOf(int n4, int n7, byte by2) {
        this.checkIndex(n4);
        this.checkIndex(n7);
        return -1;
    }

    @Override
    public int bytesBefore(byte by2) {
        return -1;
    }

    @Override
    public int bytesBefore(int n4, byte by2) {
        this.checkLength(n4);
        return -1;
    }

    @Override
    public int bytesBefore(int n4, int n7, byte by2) {
        this.checkIndex(n4, n7);
        return -1;
    }

    @Override
    public int forEachByte(ByteProcessor byteProcessor) {
        return -1;
    }

    @Override
    public int forEachByte(int n4, int n7, ByteProcessor byteProcessor) {
        this.checkIndex(n4, n7);
        return -1;
    }

    @Override
    public int forEachByteDesc(ByteProcessor byteProcessor) {
        return -1;
    }

    @Override
    public int forEachByteDesc(int n4, int n7, ByteProcessor byteProcessor) {
        this.checkIndex(n4, n7);
        return -1;
    }

    @Override
    public ByteBuf copy() {
        return this;
    }

    @Override
    public ByteBuf copy(int n4, int n7) {
        return this.checkIndex(n4, n7);
    }

    @Override
    public ByteBuf slice() {
        return this;
    }

    @Override
    public ByteBuf retainedSlice() {
        return this;
    }

    @Override
    public ByteBuf slice(int n4, int n7) {
        return this.checkIndex(n4, n7);
    }

    @Override
    public ByteBuf retainedSlice(int n4, int n7) {
        return this.checkIndex(n4, n7);
    }

    @Override
    public ByteBuf duplicate() {
        return this;
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return this;
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer nioBuffer() {
        return EMPTY_BYTE_BUFFER;
    }

    @Override
    public ByteBuffer nioBuffer(int n4, int n7) {
        this.checkIndex(n4, n7);
        return this.nioBuffer();
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        return new ByteBuffer[]{EMPTY_BYTE_BUFFER};
    }

    @Override
    public ByteBuffer[] nioBuffers(int n4, int n7) {
        this.checkIndex(n4, n7);
        return this.nioBuffers();
    }

    @Override
    public ByteBuffer internalNioBuffer(int n4, int n7) {
        return EMPTY_BYTE_BUFFER;
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public byte[] array() {
        return EmptyArrays.EMPTY_BYTES;
    }

    @Override
    public int arrayOffset() {
        return 0;
    }

    @Override
    public boolean hasMemoryAddress() {
        return EMPTY_BYTE_BUFFER_ADDRESS != 0L;
    }

    @Override
    public long memoryAddress() {
        if (this.hasMemoryAddress()) {
            return EMPTY_BYTE_BUFFER_ADDRESS;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString(Charset charset) {
        return "";
    }

    @Override
    public String toString(int n4, int n7, Charset charset) {
        this.checkIndex(n4, n7);
        return this.toString(charset);
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ByteBuf && !((ByteBuf)object).isReadable();
    }

    @Override
    public int compareTo(ByteBuf byteBuf) {
        return byteBuf.isReadable() ? -1 : 0;
    }

    @Override
    public String toString() {
        return this.str;
    }

    @Override
    public boolean isReadable(int n4) {
        return false;
    }

    @Override
    public boolean isWritable(int n4) {
        return false;
    }

    @Override
    public int refCnt() {
        return 1;
    }

    @Override
    public ByteBuf retain() {
        return this;
    }

    @Override
    public ByteBuf retain(int n4) {
        return this;
    }

    @Override
    public ByteBuf touch() {
        return this;
    }

    @Override
    public ByteBuf touch(Object object) {
        return this;
    }

    @Override
    public boolean release() {
        return false;
    }

    @Override
    public boolean release(int n4) {
        return false;
    }

    private ByteBuf checkIndex(int n4) {
        if (n4 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    private ByteBuf checkIndex(int n4, int n7) {
        ObjectUtil.checkPositiveOrZero(n7, "length");
        if (n4 != 0 || n7 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    private ByteBuf checkLength(int n4) {
        ObjectUtil.checkPositiveOrZero(n4, "length");
        if (n4 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    static {
        long l2 = 0L;
        try {
            if (PlatformDependent.hasUnsafe()) {
                l2 = PlatformDependent.directBufferAddress(EMPTY_BYTE_BUFFER);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        EMPTY_BYTE_BUFFER_ADDRESS = l2;
    }
}

