/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.AbstractByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.AbstractUnpooledSlicedByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.CompositeByteBuf$1;
import io.grpc.netty.shaded.io.netty.buffer.CompositeByteBuf$2;
import io.grpc.netty.shaded.io.netty.buffer.CompositeByteBuf$ByteWrapper;
import io.grpc.netty.shaded.io.netty.buffer.CompositeByteBuf$Component;
import io.grpc.netty.shaded.io.netty.buffer.CompositeByteBuf$CompositeByteBufIterator;
import io.grpc.netty.shaded.io.netty.buffer.PooledSlicedByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.util.ByteProcessor;
import io.grpc.netty.shaded.io.netty.util.IllegalReferenceCountException;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import io.grpc.netty.shaded.io.netty.util.internal.EmptyArrays;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.RecyclableArrayList;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CompositeByteBuf
extends AbstractReferenceCountedByteBuf
implements Iterable<ByteBuf> {
    private static final ByteBuffer EMPTY_NIO_BUFFER = Unpooled.EMPTY_BUFFER.nioBuffer();
    private static final Iterator<ByteBuf> EMPTY_ITERATOR = Collections.emptyList().iterator();
    private final ByteBufAllocator alloc;
    private final boolean direct;
    private final int maxNumComponents;
    private int componentCount;
    private CompositeByteBuf$Component[] components;
    private boolean freed;
    static final CompositeByteBuf$ByteWrapper<byte[]> BYTE_ARRAY_WRAPPER = new CompositeByteBuf$1();
    static final CompositeByteBuf$ByteWrapper<ByteBuffer> BYTE_BUFFER_WRAPPER = new CompositeByteBuf$2();
    private CompositeByteBuf$Component lastAccessed;

    private CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl3, int n4, int n7) {
        super(Integer.MAX_VALUE);
        if (byteBufAllocator == null) {
            throw new NullPointerException("alloc");
        }
        if (n4 < 1) {
            throw new IllegalArgumentException("maxNumComponents: " + n4 + " (expected: >= 1)");
        }
        this.alloc = byteBufAllocator;
        this.direct = bl3;
        this.maxNumComponents = n4;
        this.components = CompositeByteBuf.newCompArray(n7, n4);
    }

    public CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl3, int n4) {
        this(byteBufAllocator, bl3, n4, 0);
    }

    public CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl3, int n4, ByteBuf ... byteBufArray) {
        this(byteBufAllocator, bl3, n4, byteBufArray, 0);
    }

    CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl3, int n4, ByteBuf[] byteBufArray, int n7) {
        this(byteBufAllocator, bl3, n4, byteBufArray.length - n7);
        this.addComponents0(false, 0, byteBufArray, n7);
        this.consolidateIfNeeded();
        this.setIndex0(0, this.capacity());
    }

    public CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl3, int n4, Iterable<ByteBuf> iterable) {
        this(byteBufAllocator, bl3, n4, iterable instanceof Collection ? ((Collection)iterable).size() : 0);
        this.addComponents(false, 0, iterable);
        this.setIndex(0, this.capacity());
    }

    <T> CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl3, int n4, CompositeByteBuf$ByteWrapper<T> compositeByteBuf$ByteWrapper, T[] TArray, int n7) {
        this(byteBufAllocator, bl3, n4, TArray.length - n7);
        this.addComponents0(false, 0, compositeByteBuf$ByteWrapper, TArray, n7);
        this.consolidateIfNeeded();
        this.setIndex(0, this.capacity());
    }

    private static CompositeByteBuf$Component[] newCompArray(int n4, int n7) {
        int n8 = Math.min(16, n7);
        return new CompositeByteBuf$Component[Math.max(n4, n8)];
    }

    CompositeByteBuf(ByteBufAllocator byteBufAllocator) {
        super(Integer.MAX_VALUE);
        this.alloc = byteBufAllocator;
        this.direct = false;
        this.maxNumComponents = 0;
        this.components = null;
    }

    public CompositeByteBuf addComponent(ByteBuf byteBuf) {
        return this.addComponent(false, byteBuf);
    }

    public CompositeByteBuf addComponents(ByteBuf ... byteBufArray) {
        return this.addComponents(false, byteBufArray);
    }

    public CompositeByteBuf addComponents(Iterable<ByteBuf> iterable) {
        return this.addComponents(false, iterable);
    }

    public CompositeByteBuf addComponent(int n4, ByteBuf byteBuf) {
        return this.addComponent(false, n4, byteBuf);
    }

    public CompositeByteBuf addComponent(boolean bl3, ByteBuf byteBuf) {
        return this.addComponent(bl3, this.componentCount, byteBuf);
    }

    public CompositeByteBuf addComponents(boolean bl3, ByteBuf ... byteBufArray) {
        ObjectUtil.checkNotNull(byteBufArray, "buffers");
        this.addComponents0(bl3, this.componentCount, byteBufArray, 0);
        this.consolidateIfNeeded();
        return this;
    }

    public CompositeByteBuf addComponents(boolean bl3, Iterable<ByteBuf> iterable) {
        return this.addComponents(bl3, this.componentCount, iterable);
    }

    public CompositeByteBuf addComponent(boolean bl3, int n4, ByteBuf byteBuf) {
        ObjectUtil.checkNotNull(byteBuf, "buffer");
        this.addComponent0(bl3, n4, byteBuf);
        this.consolidateIfNeeded();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addComponent0(boolean bl3, int n4, ByteBuf byteBuf) {
        assert (byteBuf != null);
        boolean bl4 = false;
        try {
            this.checkComponentIndex(n4);
            CompositeByteBuf$Component compositeByteBuf$Component = this.newComponent(byteBuf, 0);
            int n7 = compositeByteBuf$Component.length();
            this.addComp(n4, compositeByteBuf$Component);
            bl4 = true;
            if (n7 > 0 && n4 < this.componentCount - 1) {
                this.updateComponentOffsets(n4);
            } else if (n4 > 0) {
                compositeByteBuf$Component.reposition(this.components[n4 - 1].endOffset);
            }
            if (bl3) {
                this.writerIndex += n7;
            }
            int n8 = n4;
            return n8;
        }
        finally {
            if (!bl4) {
                byteBuf.release();
            }
        }
    }

    private CompositeByteBuf$Component newComponent(ByteBuf byteBuf, int n4) {
        if (checkAccessible && !byteBuf.isAccessible()) {
            throw new IllegalReferenceCountException(0);
        }
        int n7 = byteBuf.readerIndex();
        int n8 = byteBuf.readableBytes();
        ByteBuf byteBuf2 = null;
        if (byteBuf instanceof AbstractUnpooledSlicedByteBuf) {
            n7 += ((AbstractUnpooledSlicedByteBuf)byteBuf).idx(0);
            byteBuf2 = byteBuf;
            byteBuf = byteBuf.unwrap();
        } else if (byteBuf instanceof PooledSlicedByteBuf) {
            n7 += ((PooledSlicedByteBuf)byteBuf).adjustment;
            byteBuf2 = byteBuf;
            byteBuf = byteBuf.unwrap();
        }
        return new CompositeByteBuf$Component(byteBuf.order(ByteOrder.BIG_ENDIAN), n7, n4, n8, byteBuf2);
    }

    public CompositeByteBuf addComponents(int n4, ByteBuf ... byteBufArray) {
        ObjectUtil.checkNotNull(byteBufArray, "buffers");
        this.addComponents0(false, n4, byteBufArray, 0);
        this.consolidateIfNeeded();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeByteBuf addComponents0(boolean bl3, int n4, ByteBuf[] byteBufArray, int n7) {
        int n8 = byteBufArray.length;
        int n10 = n8 - n7;
        int n11 = Integer.MAX_VALUE;
        try {
            ByteBuf byteBuf;
            this.checkComponentIndex(n4);
            this.shiftComps(n4, n10);
            int n12 = n4 > 0 ? this.components[n4 - 1].endOffset : 0;
            n11 = n4;
            while (n7 < n8 && (byteBuf = byteBufArray[n7]) != null) {
                CompositeByteBuf$Component compositeByteBuf$Component;
                this.components[n11] = compositeByteBuf$Component = this.newComponent(byteBuf, n12);
                n12 = compositeByteBuf$Component.endOffset;
                ++n7;
                ++n11;
            }
            byteBuf = this;
            return byteBuf;
        }
        finally {
            if (n11 < this.componentCount) {
                if (n11 < n4 + n10) {
                    this.removeCompRange(n11, n4 + n10);
                    while (n7 < n8) {
                        ReferenceCountUtil.safeRelease(byteBufArray[n7]);
                        ++n7;
                    }
                }
                this.updateComponentOffsets(n11);
            }
            if (bl3 && n11 > n4 && n11 <= this.componentCount) {
                this.writerIndex += this.components[n11 - 1].endOffset - this.components[n4].offset;
            }
        }
    }

    private <T> int addComponents0(boolean bl3, int n4, CompositeByteBuf$ByteWrapper<T> compositeByteBuf$ByteWrapper, T[] TArray, int n7) {
        T t3;
        this.checkComponentIndex(n4);
        int n8 = TArray.length;
        for (int i3 = n7; i3 < n8 && (t3 = TArray[i3]) != null; ++i3) {
            int n10;
            if (compositeByteBuf$ByteWrapper.isEmpty(t3) || (n4 = this.addComponent0(bl3, n4, compositeByteBuf$ByteWrapper.wrap(t3)) + 1) <= (n10 = this.componentCount)) continue;
            n4 = n10;
        }
        return n4;
    }

    public CompositeByteBuf addComponents(int n4, Iterable<ByteBuf> iterable) {
        return this.addComponents(false, n4, iterable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeByteBuf addFlattenedComponents(boolean bl3, ByteBuf byteBuf) {
        int n4;
        ObjectUtil.checkNotNull(byteBuf, "buffer");
        int n7 = byteBuf.readerIndex();
        int n8 = byteBuf.writerIndex();
        if (n7 == n8) {
            byteBuf.release();
            return this;
        }
        if (!(byteBuf instanceof CompositeByteBuf)) {
            this.addComponent0(bl3, this.componentCount, byteBuf);
            this.consolidateIfNeeded();
            return this;
        }
        CompositeByteBuf compositeByteBuf = (CompositeByteBuf)byteBuf;
        compositeByteBuf.checkIndex(n7, n8 - n7);
        CompositeByteBuf$Component[] compositeByteBuf$ComponentArray = compositeByteBuf.components;
        int n10 = this.componentCount;
        int n11 = this.writerIndex;
        try {
            int n12 = compositeByteBuf.toComponentIndex0(n7);
            n4 = this.capacity();
            while (true) {
                CompositeByteBuf$Component compositeByteBuf$Component = compositeByteBuf$ComponentArray[n12];
                int n13 = compositeByteBuf$Component.offset;
                int n14 = Math.max(n7, n13);
                int n15 = Math.min(n8, compositeByteBuf$Component.endOffset);
                int n16 = n15 - n14;
                if (n16 > 0) {
                    this.addComp(this.componentCount, new CompositeByteBuf$Component(compositeByteBuf$Component.buf.retain(), compositeByteBuf$Component.idx(n14), n4, n16, null));
                }
                if (n8 == n15) break;
                n4 += n16;
                ++n12;
            }
            if (bl3) {
                this.writerIndex = n11 + (n8 - n7);
            }
            this.consolidateIfNeeded();
            byteBuf.release();
            byteBuf = null;
            CompositeByteBuf compositeByteBuf2 = this;
            return compositeByteBuf2;
        }
        finally {
            if (byteBuf != null) {
                if (bl3) {
                    this.writerIndex = n11;
                }
                for (n4 = this.componentCount - 1; n4 >= n10; --n4) {
                    this.components[n4].free();
                    this.removeComp(n4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeByteBuf addComponents(boolean bl3, int n4, Iterable<ByteBuf> iterable) {
        if (iterable instanceof ByteBuf) {
            return this.addComponent(bl3, n4, (ByteBuf)((Object)iterable));
        }
        ObjectUtil.checkNotNull(iterable, "buffers");
        Iterator<ByteBuf> iterator = iterable.iterator();
        try {
            this.checkComponentIndex(n4);
            while (iterator.hasNext()) {
                ByteBuf byteBuf = iterator.next();
                if (byteBuf == null) {
                    break;
                }
                n4 = this.addComponent0(bl3, n4, byteBuf) + 1;
                n4 = Math.min(n4, this.componentCount);
            }
        }
        finally {
            while (iterator.hasNext()) {
                ReferenceCountUtil.safeRelease(iterator.next());
            }
        }
        this.consolidateIfNeeded();
        return this;
    }

    private void consolidateIfNeeded() {
        int n4 = this.componentCount;
        if (n4 > this.maxNumComponents) {
            int n7 = this.components[n4 - 1].endOffset;
            ByteBuf byteBuf = this.allocBuffer(n7);
            this.lastAccessed = null;
            for (int i3 = 0; i3 < n4; ++i3) {
                this.components[i3].transferTo(byteBuf);
            }
            this.components[0] = new CompositeByteBuf$Component(byteBuf, 0, 0, n7, byteBuf);
            this.removeCompRange(1, n4);
        }
    }

    private void checkComponentIndex(int n4) {
        this.ensureAccessible();
        if (n4 < 0 || n4 > this.componentCount) {
            throw new IndexOutOfBoundsException(String.format("cIndex: %d (expected: >= 0 && <= numComponents(%d))", n4, this.componentCount));
        }
    }

    private void checkComponentIndex(int n4, int n7) {
        this.ensureAccessible();
        if (n4 < 0 || n4 + n7 > this.componentCount) {
            throw new IndexOutOfBoundsException(String.format("cIndex: %d, numComponents: %d (expected: cIndex >= 0 && cIndex + numComponents <= totalNumComponents(%d))", n4, n7, this.componentCount));
        }
    }

    private void updateComponentOffsets(int n4) {
        int n7;
        int n8 = this.componentCount;
        if (n8 <= n4) {
            return;
        }
        int n10 = n7 = n4 > 0 ? this.components[n4 - 1].endOffset : 0;
        while (n4 < n8) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n4];
            compositeByteBuf$Component.reposition(n7);
            n7 = compositeByteBuf$Component.endOffset;
            ++n4;
        }
    }

    public CompositeByteBuf removeComponent(int n4) {
        this.checkComponentIndex(n4);
        CompositeByteBuf$Component compositeByteBuf$Component = this.components[n4];
        if (this.lastAccessed == compositeByteBuf$Component) {
            this.lastAccessed = null;
        }
        compositeByteBuf$Component.free();
        this.removeComp(n4);
        if (compositeByteBuf$Component.length() > 0) {
            this.updateComponentOffsets(n4);
        }
        return this;
    }

    public CompositeByteBuf removeComponents(int n4, int n7) {
        this.checkComponentIndex(n4, n7);
        if (n7 == 0) {
            return this;
        }
        int n8 = n4 + n7;
        boolean bl3 = false;
        for (int i3 = n4; i3 < n8; ++i3) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[i3];
            if (compositeByteBuf$Component.length() > 0) {
                bl3 = true;
            }
            if (this.lastAccessed == compositeByteBuf$Component) {
                this.lastAccessed = null;
            }
            compositeByteBuf$Component.free();
        }
        this.removeCompRange(n4, n8);
        if (bl3) {
            this.updateComponentOffsets(n4);
        }
        return this;
    }

    @Override
    public Iterator<ByteBuf> iterator() {
        this.ensureAccessible();
        return this.componentCount == 0 ? EMPTY_ITERATOR : new CompositeByteBuf$CompositeByteBufIterator(this, null);
    }

    @Override
    protected int forEachByteAsc0(int n4, int n7, ByteProcessor byteProcessor) {
        if (n7 <= n4) {
            return -1;
        }
        int n8 = this.toComponentIndex0(n4);
        int n10 = n7 - n4;
        while (n10 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n8];
            if (compositeByteBuf$Component.offset != compositeByteBuf$Component.endOffset) {
                int n11;
                ByteBuf byteBuf = compositeByteBuf$Component.buf;
                int n12 = compositeByteBuf$Component.idx(n4);
                int n13 = Math.min(n10, compositeByteBuf$Component.endOffset - n4);
                int n14 = n11 = byteBuf instanceof AbstractByteBuf ? ((AbstractByteBuf)byteBuf).forEachByteAsc0(n12, n12 + n13, byteProcessor) : byteBuf.forEachByte(n12, n13, byteProcessor);
                if (n11 != -1) {
                    return n11 - compositeByteBuf$Component.adjustment;
                }
                n4 += n13;
                n10 -= n13;
            }
            ++n8;
        }
        return -1;
    }

    @Override
    protected int forEachByteDesc0(int n4, int n7, ByteProcessor byteProcessor) {
        if (n7 > n4) {
            return -1;
        }
        int n8 = this.toComponentIndex0(n4);
        int n10 = 1 + n4 - n7;
        while (n10 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n8];
            if (compositeByteBuf$Component.offset != compositeByteBuf$Component.endOffset) {
                int n11;
                ByteBuf byteBuf = compositeByteBuf$Component.buf;
                int n12 = compositeByteBuf$Component.idx(n10 + n7);
                int n13 = Math.min(n10, n12);
                int n14 = n12 - n13;
                int n15 = n11 = byteBuf instanceof AbstractByteBuf ? ((AbstractByteBuf)byteBuf).forEachByteDesc0(n12 - 1, n14, byteProcessor) : byteBuf.forEachByteDesc(n14, n13, byteProcessor);
                if (n11 != -1) {
                    return n11 - compositeByteBuf$Component.adjustment;
                }
                n10 -= n13;
            }
            --n8;
        }
        return -1;
    }

    public List<ByteBuf> decompose(int n4, int n7) {
        ByteBuf byteBuf;
        this.checkIndex(n4, n7);
        if (n7 == 0) {
            return Collections.emptyList();
        }
        int n8 = this.toComponentIndex0(n4);
        int n10 = n7;
        CompositeByteBuf$Component compositeByteBuf$Component = this.components[n8];
        if ((n10 -= (byteBuf = compositeByteBuf$Component.buf.slice(compositeByteBuf$Component.idx(n4), Math.min(compositeByteBuf$Component.endOffset - n4, n10))).readableBytes()) == 0) {
            return Collections.singletonList(byteBuf);
        }
        ArrayList<ByteBuf> arrayList = new ArrayList<ByteBuf>(this.componentCount - n8);
        arrayList.add(byteBuf);
        do {
            CompositeByteBuf$Component compositeByteBuf$Component2 = this.components[++n8];
            byteBuf = compositeByteBuf$Component2.buf.slice(compositeByteBuf$Component2.idx(compositeByteBuf$Component2.offset), Math.min(compositeByteBuf$Component2.length(), n10));
            arrayList.add(byteBuf);
        } while ((n10 -= byteBuf.readableBytes()) > 0);
        return arrayList;
    }

    @Override
    public boolean isDirect() {
        int n4 = this.componentCount;
        if (n4 == 0) {
            return false;
        }
        for (int i3 = 0; i3 < n4; ++i3) {
            if (this.components[i3].buf.isDirect()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasArray() {
        switch (this.componentCount) {
            case 0: {
                return true;
            }
            case 1: {
                return this.components[0].buf.hasArray();
            }
        }
        return false;
    }

    @Override
    public byte[] array() {
        switch (this.componentCount) {
            case 0: {
                return EmptyArrays.EMPTY_BYTES;
            }
            case 1: {
                return this.components[0].buf.array();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        switch (this.componentCount) {
            case 0: {
                return 0;
            }
            case 1: {
                CompositeByteBuf$Component compositeByteBuf$Component = this.components[0];
                return compositeByteBuf$Component.idx(compositeByteBuf$Component.buf.arrayOffset());
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasMemoryAddress() {
        switch (this.componentCount) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.hasMemoryAddress();
            }
            case 1: {
                return this.components[0].buf.hasMemoryAddress();
            }
        }
        return false;
    }

    @Override
    public long memoryAddress() {
        switch (this.componentCount) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.memoryAddress();
            }
            case 1: {
                CompositeByteBuf$Component compositeByteBuf$Component = this.components[0];
                return compositeByteBuf$Component.buf.memoryAddress() + (long)compositeByteBuf$Component.adjustment;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int capacity() {
        int n4 = this.componentCount;
        return n4 > 0 ? this.components[n4 - 1].endOffset : 0;
    }

    @Override
    public CompositeByteBuf capacity(int n4) {
        this.checkNewCapacity(n4);
        int n7 = this.componentCount;
        int n8 = this.capacity();
        if (n4 > n8) {
            int n10 = n4 - n8;
            ByteBuf byteBuf = this.allocBuffer(n10).setIndex(0, n10);
            this.addComponent0(false, n7, byteBuf);
            if (this.componentCount >= this.maxNumComponents) {
                this.consolidateIfNeeded();
            }
        } else if (n4 < n8) {
            int n11;
            this.lastAccessed = null;
            int n12 = n8 - n4;
            for (n11 = n7 - 1; n11 >= 0; --n11) {
                CompositeByteBuf$Component compositeByteBuf$Component = this.components[n11];
                int n13 = compositeByteBuf$Component.length();
                if (n12 < n13) {
                    compositeByteBuf$Component.endOffset -= n12;
                    ByteBuf byteBuf = CompositeByteBuf$Component.access$100(compositeByteBuf$Component);
                    if (byteBuf == null) break;
                    CompositeByteBuf$Component.access$102(compositeByteBuf$Component, byteBuf.slice(0, compositeByteBuf$Component.length()));
                    break;
                }
                compositeByteBuf$Component.free();
                n12 -= n13;
            }
            this.removeCompRange(n11 + 1, n7);
            if (this.readerIndex() > n4) {
                this.setIndex0(n4, n4);
            } else if (this.writerIndex > n4) {
                this.writerIndex = n4;
            }
        }
        return this;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    public int numComponents() {
        return this.componentCount;
    }

    public int maxNumComponents() {
        return this.maxNumComponents;
    }

    public int toComponentIndex(int n4) {
        this.checkIndex(n4);
        return this.toComponentIndex0(n4);
    }

    private int toComponentIndex0(int n4) {
        int n7;
        int n8 = this.componentCount;
        if (n4 == 0) {
            for (n7 = 0; n7 < n8; ++n7) {
                if (this.components[n7].endOffset <= 0) continue;
                return n7;
            }
        }
        if (n8 <= 2) {
            return n8 == 1 || n4 < this.components[0].endOffset ? 0 : 1;
        }
        n7 = 0;
        int n10 = n8;
        while (n7 <= n10) {
            int n11 = n7 + n10 >>> 1;
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n11];
            if (n4 >= compositeByteBuf$Component.endOffset) {
                n7 = n11 + 1;
                continue;
            }
            if (n4 < compositeByteBuf$Component.offset) {
                n10 = n11 - 1;
                continue;
            }
            return n11;
        }
        throw new Error("should not reach here");
    }

    public int toByteIndex(int n4) {
        this.checkComponentIndex(n4);
        return this.components[n4].offset;
    }

    @Override
    public byte getByte(int n4) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent(n4);
        return compositeByteBuf$Component.buf.getByte(compositeByteBuf$Component.idx(n4));
    }

    @Override
    protected byte _getByte(int n4) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n4);
        return compositeByteBuf$Component.buf.getByte(compositeByteBuf$Component.idx(n4));
    }

    @Override
    protected short _getShort(int n4) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n4);
        if (n4 + 2 <= compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component.buf.getShort(compositeByteBuf$Component.idx(n4));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (short)((this._getByte(n4) & 0xFF) << 8 | this._getByte(n4 + 1) & 0xFF);
        }
        return (short)(this._getByte(n4) & 0xFF | (this._getByte(n4 + 1) & 0xFF) << 8);
    }

    @Override
    protected short _getShortLE(int n4) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n4);
        if (n4 + 2 <= compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component.buf.getShortLE(compositeByteBuf$Component.idx(n4));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (short)(this._getByte(n4) & 0xFF | (this._getByte(n4 + 1) & 0xFF) << 8);
        }
        return (short)((this._getByte(n4) & 0xFF) << 8 | this._getByte(n4 + 1) & 0xFF);
    }

    @Override
    protected int _getUnsignedMedium(int n4) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n4);
        if (n4 + 3 <= compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component.buf.getUnsignedMedium(compositeByteBuf$Component.idx(n4));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(n4) & 0xFFFF) << 8 | this._getByte(n4 + 2) & 0xFF;
        }
        return this._getShort(n4) & 0xFFFF | (this._getByte(n4 + 2) & 0xFF) << 16;
    }

    @Override
    protected int _getUnsignedMediumLE(int n4) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n4);
        if (n4 + 3 <= compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component.buf.getUnsignedMediumLE(compositeByteBuf$Component.idx(n4));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return this._getShortLE(n4) & 0xFFFF | (this._getByte(n4 + 2) & 0xFF) << 16;
        }
        return (this._getShortLE(n4) & 0xFFFF) << 8 | this._getByte(n4 + 2) & 0xFF;
    }

    @Override
    protected int _getInt(int n4) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n4);
        if (n4 + 4 <= compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component.buf.getInt(compositeByteBuf$Component.idx(n4));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(n4) & 0xFFFF) << 16 | this._getShort(n4 + 2) & 0xFFFF;
        }
        return this._getShort(n4) & 0xFFFF | (this._getShort(n4 + 2) & 0xFFFF) << 16;
    }

    @Override
    protected int _getIntLE(int n4) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n4);
        if (n4 + 4 <= compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component.buf.getIntLE(compositeByteBuf$Component.idx(n4));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return this._getShortLE(n4) & 0xFFFF | (this._getShortLE(n4 + 2) & 0xFFFF) << 16;
        }
        return (this._getShortLE(n4) & 0xFFFF) << 16 | this._getShortLE(n4 + 2) & 0xFFFF;
    }

    @Override
    protected long _getLong(int n4) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n4);
        if (n4 + 8 <= compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component.buf.getLong(compositeByteBuf$Component.idx(n4));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return ((long)this._getInt(n4) & 0xFFFFFFFFL) << 32 | (long)this._getInt(n4 + 4) & 0xFFFFFFFFL;
        }
        return (long)this._getInt(n4) & 0xFFFFFFFFL | ((long)this._getInt(n4 + 4) & 0xFFFFFFFFL) << 32;
    }

    @Override
    protected long _getLongLE(int n4) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n4);
        if (n4 + 8 <= compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component.buf.getLongLE(compositeByteBuf$Component.idx(n4));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (long)this._getIntLE(n4) & 0xFFFFFFFFL | ((long)this._getIntLE(n4 + 4) & 0xFFFFFFFFL) << 32;
        }
        return ((long)this._getIntLE(n4) & 0xFFFFFFFFL) << 32 | (long)this._getIntLE(n4 + 4) & 0xFFFFFFFFL;
    }

    @Override
    public CompositeByteBuf getBytes(int n4, byte[] byArray, int n7, int n8) {
        this.checkDstIndex(n4, n8, n7, byArray.length);
        if (n8 == 0) {
            return this;
        }
        int n10 = this.toComponentIndex0(n4);
        while (n8 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n10];
            int n11 = Math.min(n8, compositeByteBuf$Component.endOffset - n4);
            compositeByteBuf$Component.buf.getBytes(compositeByteBuf$Component.idx(n4), byArray, n7, n11);
            n4 += n11;
            n7 += n11;
            n8 -= n11;
            ++n10;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeByteBuf getBytes(int n4, ByteBuffer byteBuffer) {
        int n7 = byteBuffer.limit();
        int n8 = byteBuffer.remaining();
        this.checkIndex(n4, n8);
        if (n8 == 0) {
            return this;
        }
        int n10 = this.toComponentIndex0(n4);
        try {
            while (n8 > 0) {
                CompositeByteBuf$Component compositeByteBuf$Component = this.components[n10];
                int n11 = Math.min(n8, compositeByteBuf$Component.endOffset - n4);
                byteBuffer.limit(byteBuffer.position() + n11);
                compositeByteBuf$Component.buf.getBytes(compositeByteBuf$Component.idx(n4), byteBuffer);
                n4 += n11;
                n8 -= n11;
                ++n10;
            }
        }
        finally {
            byteBuffer.limit(n7);
        }
        return this;
    }

    @Override
    public CompositeByteBuf getBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        this.checkDstIndex(n4, n8, n7, byteBuf.capacity());
        if (n8 == 0) {
            return this;
        }
        int n10 = this.toComponentIndex0(n4);
        while (n8 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n10];
            int n11 = Math.min(n8, compositeByteBuf$Component.endOffset - n4);
            compositeByteBuf$Component.buf.getBytes(compositeByteBuf$Component.idx(n4), byteBuf, n7, n11);
            n4 += n11;
            n7 += n11;
            n8 -= n11;
            ++n10;
        }
        return this;
    }

    @Override
    public int getBytes(int n4, GatheringByteChannel gatheringByteChannel, int n7) {
        int n8 = this.nioBufferCount();
        if (n8 == 1) {
            return gatheringByteChannel.write(this.internalNioBuffer(n4, n7));
        }
        long l2 = gatheringByteChannel.write(this.nioBuffers(n4, n7));
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    @Override
    public int getBytes(int n4, FileChannel fileChannel, long l2, int n7) {
        int n8 = this.nioBufferCount();
        if (n8 == 1) {
            return fileChannel.write(this.internalNioBuffer(n4, n7), l2);
        }
        long l10 = 0L;
        for (ByteBuffer byteBuffer : this.nioBuffers(n4, n7)) {
            l10 += (long)fileChannel.write(byteBuffer, l2 + l10);
        }
        if (l10 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l10;
    }

    @Override
    public CompositeByteBuf getBytes(int n4, OutputStream outputStream, int n7) {
        this.checkIndex(n4, n7);
        if (n7 == 0) {
            return this;
        }
        int n8 = this.toComponentIndex0(n4);
        while (n7 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n8];
            int n10 = Math.min(n7, compositeByteBuf$Component.endOffset - n4);
            compositeByteBuf$Component.buf.getBytes(compositeByteBuf$Component.idx(n4), outputStream, n10);
            n4 += n10;
            n7 -= n10;
            ++n8;
        }
        return this;
    }

    @Override
    public CompositeByteBuf setByte(int n4, int n7) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent(n4);
        compositeByteBuf$Component.buf.setByte(compositeByteBuf$Component.idx(n4), n7);
        return this;
    }

    @Override
    protected void _setByte(int n4, int n7) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n4);
        compositeByteBuf$Component.buf.setByte(compositeByteBuf$Component.idx(n4), n7);
    }

    @Override
    public CompositeByteBuf setShort(int n4, int n7) {
        this.checkIndex(n4, 2);
        this._setShort(n4, n7);
        return this;
    }

    @Override
    protected void _setShort(int n4, int n7) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n4);
        if (n4 + 2 <= compositeByteBuf$Component.endOffset) {
            compositeByteBuf$Component.buf.setShort(compositeByteBuf$Component.idx(n4), n7);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setByte(n4, (byte)(n7 >>> 8));
            this._setByte(n4 + 1, (byte)n7);
        } else {
            this._setByte(n4, (byte)n7);
            this._setByte(n4 + 1, (byte)(n7 >>> 8));
        }
    }

    @Override
    protected void _setShortLE(int n4, int n7) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n4);
        if (n4 + 2 <= compositeByteBuf$Component.endOffset) {
            compositeByteBuf$Component.buf.setShortLE(compositeByteBuf$Component.idx(n4), n7);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setByte(n4, (byte)n7);
            this._setByte(n4 + 1, (byte)(n7 >>> 8));
        } else {
            this._setByte(n4, (byte)(n7 >>> 8));
            this._setByte(n4 + 1, (byte)n7);
        }
    }

    @Override
    public CompositeByteBuf setMedium(int n4, int n7) {
        this.checkIndex(n4, 3);
        this._setMedium(n4, n7);
        return this;
    }

    @Override
    protected void _setMedium(int n4, int n7) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n4);
        if (n4 + 3 <= compositeByteBuf$Component.endOffset) {
            compositeByteBuf$Component.buf.setMedium(compositeByteBuf$Component.idx(n4), n7);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setShort(n4, (short)(n7 >> 8));
            this._setByte(n4 + 2, (byte)n7);
        } else {
            this._setShort(n4, (short)n7);
            this._setByte(n4 + 2, (byte)(n7 >>> 16));
        }
    }

    @Override
    protected void _setMediumLE(int n4, int n7) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n4);
        if (n4 + 3 <= compositeByteBuf$Component.endOffset) {
            compositeByteBuf$Component.buf.setMediumLE(compositeByteBuf$Component.idx(n4), n7);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setShortLE(n4, (short)n7);
            this._setByte(n4 + 2, (byte)(n7 >>> 16));
        } else {
            this._setShortLE(n4, (short)(n7 >> 8));
            this._setByte(n4 + 2, (byte)n7);
        }
    }

    @Override
    public CompositeByteBuf setInt(int n4, int n7) {
        this.checkIndex(n4, 4);
        this._setInt(n4, n7);
        return this;
    }

    @Override
    protected void _setInt(int n4, int n7) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n4);
        if (n4 + 4 <= compositeByteBuf$Component.endOffset) {
            compositeByteBuf$Component.buf.setInt(compositeByteBuf$Component.idx(n4), n7);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setShort(n4, (short)(n7 >>> 16));
            this._setShort(n4 + 2, (short)n7);
        } else {
            this._setShort(n4, (short)n7);
            this._setShort(n4 + 2, (short)(n7 >>> 16));
        }
    }

    @Override
    protected void _setIntLE(int n4, int n7) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n4);
        if (n4 + 4 <= compositeByteBuf$Component.endOffset) {
            compositeByteBuf$Component.buf.setIntLE(compositeByteBuf$Component.idx(n4), n7);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setShortLE(n4, (short)n7);
            this._setShortLE(n4 + 2, (short)(n7 >>> 16));
        } else {
            this._setShortLE(n4, (short)(n7 >>> 16));
            this._setShortLE(n4 + 2, (short)n7);
        }
    }

    @Override
    public CompositeByteBuf setLong(int n4, long l2) {
        this.checkIndex(n4, 8);
        this._setLong(n4, l2);
        return this;
    }

    @Override
    protected void _setLong(int n4, long l2) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n4);
        if (n4 + 8 <= compositeByteBuf$Component.endOffset) {
            compositeByteBuf$Component.buf.setLong(compositeByteBuf$Component.idx(n4), l2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setInt(n4, (int)(l2 >>> 32));
            this._setInt(n4 + 4, (int)l2);
        } else {
            this._setInt(n4, (int)l2);
            this._setInt(n4 + 4, (int)(l2 >>> 32));
        }
    }

    @Override
    protected void _setLongLE(int n4, long l2) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n4);
        if (n4 + 8 <= compositeByteBuf$Component.endOffset) {
            compositeByteBuf$Component.buf.setLongLE(compositeByteBuf$Component.idx(n4), l2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setIntLE(n4, (int)l2);
            this._setIntLE(n4 + 4, (int)(l2 >>> 32));
        } else {
            this._setIntLE(n4, (int)(l2 >>> 32));
            this._setIntLE(n4 + 4, (int)l2);
        }
    }

    @Override
    public CompositeByteBuf setBytes(int n4, byte[] byArray, int n7, int n8) {
        this.checkSrcIndex(n4, n8, n7, byArray.length);
        if (n8 == 0) {
            return this;
        }
        int n10 = this.toComponentIndex0(n4);
        while (n8 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n10];
            int n11 = Math.min(n8, compositeByteBuf$Component.endOffset - n4);
            compositeByteBuf$Component.buf.setBytes(compositeByteBuf$Component.idx(n4), byArray, n7, n11);
            n4 += n11;
            n7 += n11;
            n8 -= n11;
            ++n10;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeByteBuf setBytes(int n4, ByteBuffer byteBuffer) {
        int n7 = byteBuffer.limit();
        int n8 = byteBuffer.remaining();
        this.checkIndex(n4, n8);
        if (n8 == 0) {
            return this;
        }
        int n10 = this.toComponentIndex0(n4);
        try {
            while (n8 > 0) {
                CompositeByteBuf$Component compositeByteBuf$Component = this.components[n10];
                int n11 = Math.min(n8, compositeByteBuf$Component.endOffset - n4);
                byteBuffer.limit(byteBuffer.position() + n11);
                compositeByteBuf$Component.buf.setBytes(compositeByteBuf$Component.idx(n4), byteBuffer);
                n4 += n11;
                n8 -= n11;
                ++n10;
            }
        }
        finally {
            byteBuffer.limit(n7);
        }
        return this;
    }

    @Override
    public CompositeByteBuf setBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        this.checkSrcIndex(n4, n8, n7, byteBuf.capacity());
        if (n8 == 0) {
            return this;
        }
        int n10 = this.toComponentIndex0(n4);
        while (n8 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n10];
            int n11 = Math.min(n8, compositeByteBuf$Component.endOffset - n4);
            compositeByteBuf$Component.buf.setBytes(compositeByteBuf$Component.idx(n4), byteBuf, n7, n11);
            n4 += n11;
            n7 += n11;
            n8 -= n11;
            ++n10;
        }
        return this;
    }

    @Override
    public int setBytes(int n4, InputStream inputStream, int n7) {
        this.checkIndex(n4, n7);
        if (n7 == 0) {
            return inputStream.read(EmptyArrays.EMPTY_BYTES);
        }
        int n8 = this.toComponentIndex0(n4);
        int n10 = 0;
        do {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n8];
            int n11 = Math.min(n7, compositeByteBuf$Component.endOffset - n4);
            if (n11 == 0) {
                ++n8;
                continue;
            }
            int n12 = compositeByteBuf$Component.buf.setBytes(compositeByteBuf$Component.idx(n4), inputStream, n11);
            if (n12 < 0) {
                if (n10 != 0) break;
                return -1;
            }
            n4 += n12;
            n7 -= n12;
            n10 += n12;
            if (n12 != n11) continue;
            ++n8;
        } while (n7 > 0);
        return n10;
    }

    @Override
    public int setBytes(int n4, ScatteringByteChannel scatteringByteChannel, int n7) {
        this.checkIndex(n4, n7);
        if (n7 == 0) {
            return scatteringByteChannel.read(EMPTY_NIO_BUFFER);
        }
        int n8 = this.toComponentIndex0(n4);
        int n10 = 0;
        do {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n8];
            int n11 = Math.min(n7, compositeByteBuf$Component.endOffset - n4);
            if (n11 == 0) {
                ++n8;
                continue;
            }
            int n12 = compositeByteBuf$Component.buf.setBytes(compositeByteBuf$Component.idx(n4), scatteringByteChannel, n11);
            if (n12 == 0) break;
            if (n12 < 0) {
                if (n10 != 0) break;
                return -1;
            }
            n4 += n12;
            n7 -= n12;
            n10 += n12;
            if (n12 != n11) continue;
            ++n8;
        } while (n7 > 0);
        return n10;
    }

    @Override
    public int setBytes(int n4, FileChannel fileChannel, long l2, int n7) {
        this.checkIndex(n4, n7);
        if (n7 == 0) {
            return fileChannel.read(EMPTY_NIO_BUFFER, l2);
        }
        int n8 = this.toComponentIndex0(n4);
        int n10 = 0;
        do {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n8];
            int n11 = Math.min(n7, compositeByteBuf$Component.endOffset - n4);
            if (n11 == 0) {
                ++n8;
                continue;
            }
            int n12 = compositeByteBuf$Component.buf.setBytes(compositeByteBuf$Component.idx(n4), fileChannel, l2 + (long)n10, n11);
            if (n12 == 0) break;
            if (n12 < 0) {
                if (n10 != 0) break;
                return -1;
            }
            n4 += n12;
            n7 -= n12;
            n10 += n12;
            if (n12 != n11) continue;
            ++n8;
        } while (n7 > 0);
        return n10;
    }

    @Override
    public ByteBuf copy(int n4, int n7) {
        this.checkIndex(n4, n7);
        ByteBuf byteBuf = this.allocBuffer(n7);
        if (n7 != 0) {
            this.copyTo(n4, n7, this.toComponentIndex0(n4), byteBuf);
        }
        return byteBuf;
    }

    private void copyTo(int n4, int n7, int n8, ByteBuf byteBuf) {
        int n10 = 0;
        int n11 = n8;
        while (n7 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n11];
            int n12 = Math.min(n7, compositeByteBuf$Component.endOffset - n4);
            compositeByteBuf$Component.buf.getBytes(compositeByteBuf$Component.idx(n4), byteBuf, n10, n12);
            n4 += n12;
            n10 += n12;
            n7 -= n12;
            ++n11;
        }
        byteBuf.writerIndex(byteBuf.capacity());
    }

    public ByteBuf component(int n4) {
        this.checkComponentIndex(n4);
        return this.components[n4].duplicate();
    }

    public ByteBuf componentAtOffset(int n4) {
        return this.findComponent(n4).duplicate();
    }

    public ByteBuf internalComponent(int n4) {
        this.checkComponentIndex(n4);
        return this.components[n4].slice();
    }

    public ByteBuf internalComponentAtOffset(int n4) {
        return this.findComponent(n4).slice();
    }

    private CompositeByteBuf$Component findComponent(int n4) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.lastAccessed;
        if (compositeByteBuf$Component != null && n4 >= compositeByteBuf$Component.offset && n4 < compositeByteBuf$Component.endOffset) {
            this.ensureAccessible();
            return compositeByteBuf$Component;
        }
        this.checkIndex(n4);
        return this.findIt(n4);
    }

    private CompositeByteBuf$Component findComponent0(int n4) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.lastAccessed;
        if (compositeByteBuf$Component != null && n4 >= compositeByteBuf$Component.offset && n4 < compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component;
        }
        return this.findIt(n4);
    }

    private CompositeByteBuf$Component findIt(int n4) {
        int n7 = 0;
        int n8 = this.componentCount;
        while (n7 <= n8) {
            int n10 = n7 + n8 >>> 1;
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n10];
            if (n4 >= compositeByteBuf$Component.endOffset) {
                n7 = n10 + 1;
                continue;
            }
            if (n4 < compositeByteBuf$Component.offset) {
                n8 = n10 - 1;
                continue;
            }
            this.lastAccessed = compositeByteBuf$Component;
            return compositeByteBuf$Component;
        }
        throw new Error("should not reach here");
    }

    @Override
    public int nioBufferCount() {
        int n4 = this.componentCount;
        switch (n4) {
            case 0: {
                return 1;
            }
            case 1: {
                return this.components[0].buf.nioBufferCount();
            }
        }
        int n7 = 0;
        for (int i3 = 0; i3 < n4; ++i3) {
            n7 += this.components[i3].buf.nioBufferCount();
        }
        return n7;
    }

    @Override
    public ByteBuffer internalNioBuffer(int n4, int n7) {
        switch (this.componentCount) {
            case 0: {
                return EMPTY_NIO_BUFFER;
            }
            case 1: {
                return this.components[0].internalNioBuffer(n4, n7);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer nioBuffer(int n4, int n7) {
        Comparable<ByteBuf> comparable;
        ByteBuffer[] byteBufferArray;
        this.checkIndex(n4, n7);
        switch (this.componentCount) {
            case 0: {
                return EMPTY_NIO_BUFFER;
            }
            case 1: {
                byteBufferArray = this.components[0];
                comparable = byteBufferArray.buf;
                if (((ByteBuf)comparable).nioBufferCount() != 1) break;
                return ((ByteBuf)comparable).nioBuffer(byteBufferArray.idx(n4), n7);
            }
        }
        byteBufferArray = this.nioBuffers(n4, n7);
        if (byteBufferArray.length == 1) {
            return byteBufferArray[0];
        }
        comparable = ByteBuffer.allocate(n7).order(this.order());
        for (ByteBuffer byteBuffer : byteBufferArray) {
            ((ByteBuffer)comparable).put(byteBuffer);
        }
        ((ByteBuffer)comparable).flip();
        return comparable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer[] nioBuffers(int n4, int n7) {
        this.checkIndex(n4, n7);
        if (n7 == 0) {
            return new ByteBuffer[]{EMPTY_NIO_BUFFER};
        }
        RecyclableArrayList recyclableArrayList = RecyclableArrayList.newInstance(this.componentCount);
        try {
            ByteBuffer[] byteBufferArray;
            int n8 = this.toComponentIndex0(n4);
            while (n7 > 0) {
                byteBufferArray = this.components[n8];
                ByteBuf byteBuf = byteBufferArray.buf;
                int n10 = Math.min(n7, byteBufferArray.endOffset - n4);
                switch (byteBuf.nioBufferCount()) {
                    case 0: {
                        throw new UnsupportedOperationException();
                    }
                    case 1: {
                        recyclableArrayList.add(byteBuf.nioBuffer(byteBufferArray.idx(n4), n10));
                        break;
                    }
                    default: {
                        Collections.addAll(recyclableArrayList, byteBuf.nioBuffers(byteBufferArray.idx(n4), n10));
                    }
                }
                n4 += n10;
                n7 -= n10;
                ++n8;
            }
            byteBufferArray = recyclableArrayList.toArray(new ByteBuffer[0]);
            return byteBufferArray;
        }
        finally {
            recyclableArrayList.recycle();
        }
    }

    public CompositeByteBuf consolidate() {
        this.ensureAccessible();
        int n4 = this.componentCount;
        if (n4 <= 1) {
            return this;
        }
        int n7 = this.components[n4 - 1].endOffset;
        ByteBuf byteBuf = this.allocBuffer(n7);
        for (int i3 = 0; i3 < n4; ++i3) {
            this.components[i3].transferTo(byteBuf);
        }
        this.lastAccessed = null;
        this.components[0] = new CompositeByteBuf$Component(byteBuf, 0, 0, n7, byteBuf);
        this.removeCompRange(1, n4);
        return this;
    }

    public CompositeByteBuf consolidate(int n4, int n7) {
        this.checkComponentIndex(n4, n7);
        if (n7 <= 1) {
            return this;
        }
        int n8 = n4 + n7;
        CompositeByteBuf$Component compositeByteBuf$Component = this.components[n8 - 1];
        int n10 = compositeByteBuf$Component.endOffset - this.components[n4].offset;
        ByteBuf byteBuf = this.allocBuffer(n10);
        for (int i3 = n4; i3 < n8; ++i3) {
            this.components[i3].transferTo(byteBuf);
        }
        this.lastAccessed = null;
        this.removeCompRange(n4 + 1, n8);
        this.components[n4] = new CompositeByteBuf$Component(byteBuf, 0, 0, n10, byteBuf);
        this.updateComponentOffsets(n4);
        return this;
    }

    public CompositeByteBuf discardReadComponents() {
        int n4;
        this.ensureAccessible();
        int n7 = this.readerIndex();
        if (n7 == 0) {
            return this;
        }
        int n8 = this.writerIndex();
        if (n7 == n8 && n8 == this.capacity()) {
            int n10 = this.componentCount;
            for (int i3 = 0; i3 < n10; ++i3) {
                this.components[i3].free();
            }
            this.lastAccessed = null;
            this.clearComps();
            this.setIndex(0, 0);
            this.adjustMarkers(n7);
            return this;
        }
        CompositeByteBuf$Component compositeByteBuf$Component = null;
        int n11 = this.componentCount;
        for (n4 = 0; n4 < n11; ++n4) {
            compositeByteBuf$Component = this.components[n4];
            if (compositeByteBuf$Component.endOffset > n7) break;
            compositeByteBuf$Component.free();
        }
        if (n4 == 0) {
            return this;
        }
        CompositeByteBuf$Component compositeByteBuf$Component2 = this.lastAccessed;
        if (compositeByteBuf$Component2 != null && compositeByteBuf$Component2.endOffset <= n7) {
            this.lastAccessed = null;
        }
        this.removeCompRange(0, n4);
        int n12 = compositeByteBuf$Component.offset;
        this.updateComponentOffsets(0);
        this.setIndex(n7 - n12, n8 - n12);
        this.adjustMarkers(n12);
        return this;
    }

    @Override
    public CompositeByteBuf discardReadBytes() {
        CompositeByteBuf$Component compositeByteBuf$Component;
        int n4;
        this.ensureAccessible();
        int n7 = this.readerIndex();
        if (n7 == 0) {
            return this;
        }
        int n8 = this.writerIndex();
        if (n7 == n8 && n8 == this.capacity()) {
            int n10 = this.componentCount;
            for (int i3 = 0; i3 < n10; ++i3) {
                this.components[i3].free();
            }
            this.lastAccessed = null;
            this.clearComps();
            this.setIndex(0, 0);
            this.adjustMarkers(n7);
            return this;
        }
        CompositeByteBuf$Component compositeByteBuf$Component2 = null;
        int n11 = this.componentCount;
        for (n4 = 0; n4 < n11; ++n4) {
            compositeByteBuf$Component2 = this.components[n4];
            if (compositeByteBuf$Component2.endOffset > n7) break;
            compositeByteBuf$Component2.free();
        }
        n11 = n7 - compositeByteBuf$Component2.offset;
        compositeByteBuf$Component2.offset = 0;
        compositeByteBuf$Component2.endOffset -= n7;
        compositeByteBuf$Component2.adjustment += n7;
        ByteBuf byteBuf = CompositeByteBuf$Component.access$100(compositeByteBuf$Component2);
        if (byteBuf != null) {
            CompositeByteBuf$Component.access$102(compositeByteBuf$Component2, byteBuf.slice(n11, compositeByteBuf$Component2.length()));
        }
        if ((compositeByteBuf$Component = this.lastAccessed) != null && compositeByteBuf$Component.endOffset <= n7) {
            this.lastAccessed = null;
        }
        this.removeCompRange(0, n4);
        this.updateComponentOffsets(0);
        this.setIndex(0, n8 - n7);
        this.adjustMarkers(n7);
        return this;
    }

    private ByteBuf allocBuffer(int n4) {
        return this.direct ? this.alloc().directBuffer(n4) : this.alloc().heapBuffer(n4);
    }

    @Override
    public String toString() {
        String string = super.toString();
        string = string.substring(0, string.length() - 1);
        return string + ", components=" + this.componentCount + ')';
    }

    @Override
    public CompositeByteBuf readerIndex(int n4) {
        super.readerIndex(n4);
        return this;
    }

    @Override
    public CompositeByteBuf writerIndex(int n4) {
        super.writerIndex(n4);
        return this;
    }

    @Override
    public CompositeByteBuf setIndex(int n4, int n7) {
        super.setIndex(n4, n7);
        return this;
    }

    @Override
    public CompositeByteBuf clear() {
        super.clear();
        return this;
    }

    @Override
    public CompositeByteBuf markReaderIndex() {
        super.markReaderIndex();
        return this;
    }

    @Override
    public CompositeByteBuf resetReaderIndex() {
        super.resetReaderIndex();
        return this;
    }

    @Override
    public CompositeByteBuf markWriterIndex() {
        super.markWriterIndex();
        return this;
    }

    @Override
    public CompositeByteBuf resetWriterIndex() {
        super.resetWriterIndex();
        return this;
    }

    @Override
    public CompositeByteBuf ensureWritable(int n4) {
        super.ensureWritable(n4);
        return this;
    }

    @Override
    public CompositeByteBuf getBytes(int n4, ByteBuf byteBuf) {
        return this.getBytes(n4, byteBuf, byteBuf.writableBytes());
    }

    @Override
    public CompositeByteBuf getBytes(int n4, ByteBuf byteBuf, int n7) {
        this.getBytes(n4, byteBuf, byteBuf.writerIndex(), n7);
        byteBuf.writerIndex(byteBuf.writerIndex() + n7);
        return this;
    }

    @Override
    public CompositeByteBuf getBytes(int n4, byte[] byArray) {
        return this.getBytes(n4, byArray, 0, byArray.length);
    }

    @Override
    public CompositeByteBuf setBoolean(int n4, boolean bl3) {
        return this.setByte(n4, bl3 ? 1 : 0);
    }

    @Override
    public CompositeByteBuf setChar(int n4, int n7) {
        return this.setShort(n4, n7);
    }

    @Override
    public CompositeByteBuf setFloat(int n4, float f8) {
        return this.setInt(n4, Float.floatToRawIntBits(f8));
    }

    @Override
    public CompositeByteBuf setDouble(int n4, double d8) {
        return this.setLong(n4, Double.doubleToRawLongBits(d8));
    }

    @Override
    public CompositeByteBuf setBytes(int n4, ByteBuf byteBuf) {
        super.setBytes(n4, byteBuf, byteBuf.readableBytes());
        return this;
    }

    @Override
    public CompositeByteBuf setBytes(int n4, ByteBuf byteBuf, int n7) {
        super.setBytes(n4, byteBuf, n7);
        return this;
    }

    @Override
    public CompositeByteBuf setBytes(int n4, byte[] byArray) {
        return this.setBytes(n4, byArray, 0, byArray.length);
    }

    @Override
    public CompositeByteBuf setZero(int n4, int n7) {
        super.setZero(n4, n7);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuf byteBuf) {
        super.readBytes(byteBuf, byteBuf.writableBytes());
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuf byteBuf, int n4) {
        super.readBytes(byteBuf, n4);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuf byteBuf, int n4, int n7) {
        super.readBytes(byteBuf, n4, n7);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(byte[] byArray) {
        super.readBytes(byArray, 0, byArray.length);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(byte[] byArray, int n4, int n7) {
        super.readBytes(byArray, n4, n7);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuffer byteBuffer) {
        super.readBytes(byteBuffer);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(OutputStream outputStream, int n4) {
        super.readBytes(outputStream, n4);
        return this;
    }

    @Override
    public CompositeByteBuf skipBytes(int n4) {
        super.skipBytes(n4);
        return this;
    }

    @Override
    public CompositeByteBuf writeBoolean(boolean bl3) {
        this.writeByte(bl3 ? 1 : 0);
        return this;
    }

    @Override
    public CompositeByteBuf writeByte(int n4) {
        this.ensureWritable0(1);
        this._setByte(this.writerIndex++, n4);
        return this;
    }

    @Override
    public CompositeByteBuf writeShort(int n4) {
        super.writeShort(n4);
        return this;
    }

    @Override
    public CompositeByteBuf writeMedium(int n4) {
        super.writeMedium(n4);
        return this;
    }

    @Override
    public CompositeByteBuf writeInt(int n4) {
        super.writeInt(n4);
        return this;
    }

    @Override
    public CompositeByteBuf writeLong(long l2) {
        super.writeLong(l2);
        return this;
    }

    @Override
    public CompositeByteBuf writeChar(int n4) {
        super.writeShort(n4);
        return this;
    }

    @Override
    public CompositeByteBuf writeFloat(float f8) {
        super.writeInt(Float.floatToRawIntBits(f8));
        return this;
    }

    @Override
    public CompositeByteBuf writeDouble(double d8) {
        super.writeLong(Double.doubleToRawLongBits(d8));
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuf byteBuf) {
        super.writeBytes(byteBuf, byteBuf.readableBytes());
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuf byteBuf, int n4) {
        super.writeBytes(byteBuf, n4);
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuf byteBuf, int n4, int n7) {
        super.writeBytes(byteBuf, n4, n7);
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(byte[] byArray) {
        super.writeBytes(byArray, 0, byArray.length);
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(byte[] byArray, int n4, int n7) {
        super.writeBytes(byArray, n4, n7);
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuffer byteBuffer) {
        super.writeBytes(byteBuffer);
        return this;
    }

    @Override
    public CompositeByteBuf writeZero(int n4) {
        super.writeZero(n4);
        return this;
    }

    @Override
    public CompositeByteBuf retain(int n4) {
        super.retain(n4);
        return this;
    }

    @Override
    public CompositeByteBuf retain() {
        super.retain();
        return this;
    }

    @Override
    public CompositeByteBuf touch() {
        return this;
    }

    @Override
    public CompositeByteBuf touch(Object object) {
        return this;
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        return this.nioBuffers(this.readerIndex(), this.readableBytes());
    }

    @Override
    public CompositeByteBuf discardSomeReadBytes() {
        return this.discardReadComponents();
    }

    @Override
    protected void deallocate() {
        if (this.freed) {
            return;
        }
        this.freed = true;
        int n4 = this.componentCount;
        for (int i3 = 0; i3 < n4; ++i3) {
            this.components[i3].free();
        }
    }

    @Override
    boolean isAccessible() {
        return !this.freed;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    private void clearComps() {
        this.removeCompRange(0, this.componentCount);
    }

    private void removeComp(int n4) {
        this.removeCompRange(n4, n4 + 1);
    }

    private void removeCompRange(int n4, int n7) {
        int n8;
        if (n4 >= n7) {
            return;
        }
        int n10 = this.componentCount;
        assert (n4 >= 0 && n7 <= n10);
        if (n7 < n10) {
            System.arraycopy(this.components, n7, this.components, n4, n10 - n7);
        }
        for (int i3 = n8 = n10 - n7 + n4; i3 < n10; ++i3) {
            this.components[i3] = null;
        }
        this.componentCount = n8;
    }

    private void addComp(int n4, CompositeByteBuf$Component compositeByteBuf$Component) {
        this.shiftComps(n4, 1);
        this.components[n4] = compositeByteBuf$Component;
    }

    private void shiftComps(int n4, int n7) {
        int n8 = this.componentCount;
        int n10 = n8 + n7;
        assert (n4 >= 0 && n4 <= n8 && n7 > 0);
        if (n10 > this.components.length) {
            CompositeByteBuf$Component[] compositeByteBuf$ComponentArray;
            int n11 = Math.max(n8 + (n8 >> 1), n10);
            if (n4 == n8) {
                compositeByteBuf$ComponentArray = (CompositeByteBuf$Component[])Arrays.copyOf(this.components, n11, CompositeByteBuf$Component[].class);
            } else {
                compositeByteBuf$ComponentArray = new CompositeByteBuf$Component[n11];
                if (n4 > 0) {
                    System.arraycopy(this.components, 0, compositeByteBuf$ComponentArray, 0, n4);
                }
                if (n4 < n8) {
                    System.arraycopy(this.components, n4, compositeByteBuf$ComponentArray, n4 + n7, n8 - n4);
                }
            }
            this.components = compositeByteBuf$ComponentArray;
        } else if (n4 < n8) {
            System.arraycopy(this.components, n4, this.components, n4 + n7, n8 - n4);
        }
        this.componentCount = n10;
    }

    static /* synthetic */ CompositeByteBuf$Component[] access$200(CompositeByteBuf compositeByteBuf) {
        return compositeByteBuf.components;
    }
}

