/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.AbstractByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.AbstractByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil$1;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil$2;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil$HexUtil;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil$ThreadLocalDirectByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil$ThreadLocalUnsafeDirectByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.PooledByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.WrappedByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.WrappedCompositeByteBuf;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.netty.shaded.io.netty.util.ByteProcessor;
import io.grpc.netty.shaded.io.netty.util.ByteProcessor$IndexOfProcessor;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import io.grpc.netty.shaded.io.netty.util.concurrent.FastThreadLocal;
import io.grpc.netty.shaded.io.netty.util.internal.MathUtil;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.Locale;

public final class ByteBufUtil {
    private static final InternalLogger logger;
    private static final FastThreadLocal<byte[]> BYTE_ARRAYS;
    private static final byte WRITE_UTF_UNKNOWN = 63;
    private static final int MAX_CHAR_BUFFER_SIZE;
    private static final int THREAD_LOCAL_BUFFER_SIZE;
    private static final int MAX_BYTES_PER_CHAR_UTF8;
    static final int WRITE_CHUNK_SIZE = 8192;
    static final ByteBufAllocator DEFAULT_ALLOCATOR;
    static final int MAX_TL_ARRAY_LEN = 1024;
    private static final ByteProcessor FIND_NON_ASCII;

    static byte[] threadLocalTempArray(int n4) {
        return n4 <= 1024 ? BYTE_ARRAYS.get() : PlatformDependent.allocateUninitializedArray(n4);
    }

    public static String hexDump(ByteBuf byteBuf) {
        return ByteBufUtil.hexDump(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    public static String hexDump(ByteBuf byteBuf, int n4, int n7) {
        return ByteBufUtil$HexUtil.access$000(byteBuf, n4, n7);
    }

    public static String hexDump(byte[] byArray) {
        return ByteBufUtil.hexDump(byArray, 0, byArray.length);
    }

    public static String hexDump(byte[] byArray, int n4, int n7) {
        return ByteBufUtil$HexUtil.access$100(byArray, n4, n7);
    }

    public static byte decodeHexByte(CharSequence charSequence, int n4) {
        return StringUtil.decodeHexByte(charSequence, n4);
    }

    public static byte[] decodeHexDump(CharSequence charSequence) {
        return StringUtil.decodeHexDump(charSequence, 0, charSequence.length());
    }

    public static byte[] decodeHexDump(CharSequence charSequence, int n4, int n7) {
        return StringUtil.decodeHexDump(charSequence, n4, n7);
    }

    public static boolean ensureWritableSuccess(int n4) {
        return n4 == 0 || n4 == 2;
    }

    public static int hashCode(ByteBuf byteBuf) {
        int n4;
        int n7 = byteBuf.readableBytes();
        int n8 = n7 >>> 2;
        int n10 = n7 & 3;
        int n11 = 1;
        int n12 = byteBuf.readerIndex();
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            for (n4 = n8; n4 > 0; --n4) {
                n11 = 31 * n11 + byteBuf.getInt(n12);
                n12 += 4;
            }
        } else {
            for (n4 = n8; n4 > 0; --n4) {
                n11 = 31 * n11 + ByteBufUtil.swapInt(byteBuf.getInt(n12));
                n12 += 4;
            }
        }
        for (n4 = n10; n4 > 0; --n4) {
            n11 = 31 * n11 + byteBuf.getByte(n12++);
        }
        if (n11 == 0) {
            n11 = 1;
        }
        return n11;
    }

    public static int indexOf(ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n4 = byteBuf2.readableBytes() - byteBuf.readableBytes() + 1;
        for (int i3 = 0; i3 < n4; ++i3) {
            if (!ByteBufUtil.equals(byteBuf, byteBuf.readerIndex(), byteBuf2, byteBuf2.readerIndex() + i3, byteBuf.readableBytes())) continue;
            return byteBuf2.readerIndex() + i3;
        }
        return -1;
    }

    public static boolean equals(ByteBuf byteBuf, int n4, ByteBuf byteBuf2, int n7, int n8) {
        int n10;
        if (n4 < 0 || n7 < 0 || n8 < 0) {
            throw new IllegalArgumentException("All indexes and lengths must be non-negative");
        }
        if (byteBuf.writerIndex() - n8 < n4 || byteBuf2.writerIndex() - n8 < n7) {
            return false;
        }
        int n11 = n8 >>> 3;
        int n12 = n8 & 7;
        if (byteBuf.order() == byteBuf2.order()) {
            for (n10 = n11; n10 > 0; --n10) {
                if (byteBuf.getLong(n4) != byteBuf2.getLong(n7)) {
                    return false;
                }
                n4 += 8;
                n7 += 8;
            }
        } else {
            for (n10 = n11; n10 > 0; --n10) {
                if (byteBuf.getLong(n4) != ByteBufUtil.swapLong(byteBuf2.getLong(n7))) {
                    return false;
                }
                n4 += 8;
                n7 += 8;
            }
        }
        for (n10 = n12; n10 > 0; --n10) {
            if (byteBuf.getByte(n4) != byteBuf2.getByte(n7)) {
                return false;
            }
            ++n4;
            ++n7;
        }
        return true;
    }

    public static boolean equals(ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n4 = byteBuf.readableBytes();
        if (n4 != byteBuf2.readableBytes()) {
            return false;
        }
        return ByteBufUtil.equals(byteBuf, byteBuf.readerIndex(), byteBuf2, byteBuf2.readerIndex(), n4);
    }

    public static int compare(ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n4;
        int n7 = byteBuf.readableBytes();
        int n8 = byteBuf2.readableBytes();
        int n10 = Math.min(n7, n8);
        int n11 = n10 >>> 2;
        int n12 = n10 & 3;
        int n13 = byteBuf.readerIndex();
        int n14 = byteBuf2.readerIndex();
        if (n11 > 0) {
            long l2;
            n4 = byteBuf.order() == ByteOrder.BIG_ENDIAN ? 1 : 0;
            int n15 = n11 << 2;
            if (byteBuf.order() == byteBuf2.order()) {
                l2 = n4 != 0 ? ByteBufUtil.compareUintBigEndian(byteBuf, byteBuf2, n13, n14, n15) : ByteBufUtil.compareUintLittleEndian(byteBuf, byteBuf2, n13, n14, n15);
            } else {
                long l10 = l2 = n4 != 0 ? ByteBufUtil.compareUintBigEndianA(byteBuf, byteBuf2, n13, n14, n15) : ByteBufUtil.compareUintBigEndianB(byteBuf, byteBuf2, n13, n14, n15);
            }
            if (l2 != 0L) {
                return (int)Math.min(Integer.MAX_VALUE, Math.max(Integer.MIN_VALUE, l2));
            }
            n13 += n15;
            n14 += n15;
        }
        n4 = n13 + n12;
        while (n13 < n4) {
            int n16 = byteBuf.getUnsignedByte(n13) - byteBuf2.getUnsignedByte(n14);
            if (n16 != 0) {
                return n16;
            }
            ++n13;
            ++n14;
        }
        return n7 - n8;
    }

    private static long compareUintBigEndian(ByteBuf byteBuf, ByteBuf byteBuf2, int n4, int n7, int n8) {
        int n10 = n4 + n8;
        while (n4 < n10) {
            long l2 = byteBuf.getUnsignedInt(n4) - byteBuf2.getUnsignedInt(n7);
            if (l2 != 0L) {
                return l2;
            }
            n4 += 4;
            n7 += 4;
        }
        return 0L;
    }

    private static long compareUintLittleEndian(ByteBuf byteBuf, ByteBuf byteBuf2, int n4, int n7, int n8) {
        int n10 = n4 + n8;
        while (n4 < n10) {
            long l2 = byteBuf.getUnsignedIntLE(n4) - byteBuf2.getUnsignedIntLE(n7);
            if (l2 != 0L) {
                return l2;
            }
            n4 += 4;
            n7 += 4;
        }
        return 0L;
    }

    private static long compareUintBigEndianA(ByteBuf byteBuf, ByteBuf byteBuf2, int n4, int n7, int n8) {
        int n10 = n4 + n8;
        while (n4 < n10) {
            long l2 = byteBuf.getUnsignedInt(n4) - byteBuf2.getUnsignedIntLE(n7);
            if (l2 != 0L) {
                return l2;
            }
            n4 += 4;
            n7 += 4;
        }
        return 0L;
    }

    private static long compareUintBigEndianB(ByteBuf byteBuf, ByteBuf byteBuf2, int n4, int n7, int n8) {
        int n10 = n4 + n8;
        while (n4 < n10) {
            long l2 = byteBuf.getUnsignedIntLE(n4) - byteBuf2.getUnsignedInt(n7);
            if (l2 != 0L) {
                return l2;
            }
            n4 += 4;
            n7 += 4;
        }
        return 0L;
    }

    public static int indexOf(ByteBuf byteBuf, int n4, int n7, byte by2) {
        if (n4 <= n7) {
            return ByteBufUtil.firstIndexOf(byteBuf, n4, n7, by2);
        }
        return ByteBufUtil.lastIndexOf(byteBuf, n4, n7, by2);
    }

    public static short swapShort(short s11) {
        return Short.reverseBytes(s11);
    }

    public static int swapMedium(int n4) {
        int n7 = n4 << 16 & 0xFF0000 | n4 & 0xFF00 | n4 >>> 16 & 0xFF;
        if ((n7 & 0x800000) != 0) {
            n7 |= 0xFF000000;
        }
        return n7;
    }

    public static int swapInt(int n4) {
        return Integer.reverseBytes(n4);
    }

    public static long swapLong(long l2) {
        return Long.reverseBytes(l2);
    }

    public static ByteBuf writeShortBE(ByteBuf byteBuf, int n4) {
        return byteBuf.order() == ByteOrder.BIG_ENDIAN ? byteBuf.writeShort(n4) : byteBuf.writeShortLE(n4);
    }

    public static ByteBuf setShortBE(ByteBuf byteBuf, int n4, int n7) {
        return byteBuf.order() == ByteOrder.BIG_ENDIAN ? byteBuf.setShort(n4, n7) : byteBuf.setShortLE(n4, n7);
    }

    public static ByteBuf writeMediumBE(ByteBuf byteBuf, int n4) {
        return byteBuf.order() == ByteOrder.BIG_ENDIAN ? byteBuf.writeMedium(n4) : byteBuf.writeMediumLE(n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf readBytes(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, int n4) {
        boolean bl3 = true;
        ByteBuf byteBuf2 = byteBufAllocator.buffer(n4);
        try {
            byteBuf.readBytes(byteBuf2);
            bl3 = false;
            ByteBuf byteBuf3 = byteBuf2;
            return byteBuf3;
        }
        finally {
            if (bl3) {
                byteBuf2.release();
            }
        }
    }

    private static int firstIndexOf(ByteBuf byteBuf, int n4, int n7, byte by2) {
        if ((n4 = Math.max(n4, 0)) >= n7 || byteBuf.capacity() == 0) {
            return -1;
        }
        return byteBuf.forEachByte(n4, n7 - n4, new ByteProcessor$IndexOfProcessor(by2));
    }

    private static int lastIndexOf(ByteBuf byteBuf, int n4, int n7, byte by2) {
        int n8 = byteBuf.capacity();
        if ((n4 = Math.min(n4, n8)) < 0 || n8 == 0) {
            return -1;
        }
        return byteBuf.forEachByteDesc(n7, n4 - n7, new ByteProcessor$IndexOfProcessor(by2));
    }

    private static CharSequence checkCharSequenceBounds(CharSequence charSequence, int n4, int n7) {
        if (MathUtil.isOutOfBounds(n4, n7 - n4, charSequence.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n4 + ") <= end (" + n7 + ") <= seq.length(" + charSequence.length() + ')');
        }
        return charSequence;
    }

    public static ByteBuf writeUtf8(ByteBufAllocator byteBufAllocator, CharSequence charSequence) {
        ByteBuf byteBuf = byteBufAllocator.buffer(ByteBufUtil.utf8MaxBytes(charSequence));
        ByteBufUtil.writeUtf8(byteBuf, charSequence);
        return byteBuf;
    }

    public static int writeUtf8(ByteBuf byteBuf, CharSequence charSequence) {
        int n4 = charSequence.length();
        return ByteBufUtil.reserveAndWriteUtf8Seq(byteBuf, charSequence, 0, n4, ByteBufUtil.utf8MaxBytes(n4));
    }

    public static int writeUtf8(ByteBuf byteBuf, CharSequence charSequence, int n4, int n7) {
        ByteBufUtil.checkCharSequenceBounds(charSequence, n4, n7);
        return ByteBufUtil.reserveAndWriteUtf8Seq(byteBuf, charSequence, n4, n7, ByteBufUtil.utf8MaxBytes(n7 - n4));
    }

    public static int reserveAndWriteUtf8(ByteBuf byteBuf, CharSequence charSequence, int n4) {
        return ByteBufUtil.reserveAndWriteUtf8Seq(byteBuf, charSequence, 0, charSequence.length(), n4);
    }

    public static int reserveAndWriteUtf8(ByteBuf byteBuf, CharSequence charSequence, int n4, int n7, int n8) {
        return ByteBufUtil.reserveAndWriteUtf8Seq(byteBuf, ByteBufUtil.checkCharSequenceBounds(charSequence, n4, n7), n4, n7, n8);
    }

    private static int reserveAndWriteUtf8Seq(ByteBuf byteBuf, CharSequence charSequence, int n4, int n7, int n8) {
        while (true) {
            if (byteBuf instanceof WrappedCompositeByteBuf) {
                byteBuf = byteBuf.unwrap();
                continue;
            }
            if (byteBuf instanceof AbstractByteBuf) {
                AbstractByteBuf abstractByteBuf = (AbstractByteBuf)byteBuf;
                abstractByteBuf.ensureWritable0(n8);
                int n10 = ByteBufUtil.writeUtf8(abstractByteBuf, abstractByteBuf.writerIndex, charSequence, n4, n7);
                abstractByteBuf.writerIndex += n10;
                return n10;
            }
            if (!(byteBuf instanceof WrappedByteBuf)) break;
            byteBuf = byteBuf.unwrap();
        }
        byte[] byArray = charSequence.subSequence(n4, n7).toString().getBytes(CharsetUtil.UTF_8);
        byteBuf.writeBytes(byArray);
        return byArray.length;
    }

    static int writeUtf8(AbstractByteBuf abstractByteBuf, int n4, CharSequence charSequence, int n7) {
        return ByteBufUtil.writeUtf8(abstractByteBuf, n4, charSequence, 0, n7);
    }

    static int writeUtf8(AbstractByteBuf abstractByteBuf, int n4, CharSequence charSequence, int n7, int n8) {
        int n10 = n4;
        for (int i3 = n7; i3 < n8; ++i3) {
            char c10 = charSequence.charAt(i3);
            if (c10 < '\u0080') {
                abstractByteBuf._setByte(n4++, (byte)c10);
                continue;
            }
            if (c10 < '\u0800') {
                abstractByteBuf._setByte(n4++, (byte)(0xC0 | c10 >> 6));
                abstractByteBuf._setByte(n4++, (byte)(0x80 | c10 & 0x3F));
                continue;
            }
            if (StringUtil.isSurrogate(c10)) {
                char c11;
                if (!Character.isHighSurrogate(c10)) {
                    abstractByteBuf._setByte(n4++, 63);
                    continue;
                }
                try {
                    c11 = charSequence.charAt(++i3);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    abstractByteBuf._setByte(n4++, 63);
                    break;
                }
                n4 = ByteBufUtil.writeUtf8Surrogate(abstractByteBuf, n4, c10, c11);
                continue;
            }
            abstractByteBuf._setByte(n4++, (byte)(0xE0 | c10 >> 12));
            abstractByteBuf._setByte(n4++, (byte)(0x80 | c10 >> 6 & 0x3F));
            abstractByteBuf._setByte(n4++, (byte)(0x80 | c10 & 0x3F));
        }
        return n4 - n10;
    }

    private static int writeUtf8Surrogate(AbstractByteBuf abstractByteBuf, int n4, char c10, char c11) {
        if (!Character.isLowSurrogate(c11)) {
            abstractByteBuf._setByte(n4++, 63);
            abstractByteBuf._setByte(n4++, Character.isHighSurrogate(c11) ? 63 : (int)c11);
            return n4;
        }
        int n7 = Character.toCodePoint(c10, c11);
        abstractByteBuf._setByte(n4++, (byte)(0xF0 | n7 >> 18));
        abstractByteBuf._setByte(n4++, (byte)(0x80 | n7 >> 12 & 0x3F));
        abstractByteBuf._setByte(n4++, (byte)(0x80 | n7 >> 6 & 0x3F));
        abstractByteBuf._setByte(n4++, (byte)(0x80 | n7 & 0x3F));
        return n4;
    }

    public static int utf8MaxBytes(int n4) {
        return n4 * MAX_BYTES_PER_CHAR_UTF8;
    }

    public static int utf8MaxBytes(CharSequence charSequence) {
        return ByteBufUtil.utf8MaxBytes(charSequence.length());
    }

    public static int utf8Bytes(CharSequence charSequence) {
        return ByteBufUtil.utf8ByteCount(charSequence, 0, charSequence.length());
    }

    public static int utf8Bytes(CharSequence charSequence, int n4, int n7) {
        return ByteBufUtil.utf8ByteCount(ByteBufUtil.checkCharSequenceBounds(charSequence, n4, n7), n4, n7);
    }

    private static int utf8ByteCount(CharSequence charSequence, int n4, int n7) {
        int n8;
        if (charSequence instanceof AsciiString) {
            return n7 - n4;
        }
        for (n8 = n4; n8 < n7 && charSequence.charAt(n8) < '\u0080'; ++n8) {
        }
        return n8 < n7 ? n8 - n4 + ByteBufUtil.utf8BytesNonAscii(charSequence, n8, n7) : n8 - n4;
    }

    private static int utf8BytesNonAscii(CharSequence charSequence, int n4, int n7) {
        int n8 = 0;
        for (int i3 = n4; i3 < n7; ++i3) {
            char c10 = charSequence.charAt(i3);
            if (c10 < '\u0800') {
                n8 += (127 - c10 >>> 31) + 1;
                continue;
            }
            if (StringUtil.isSurrogate(c10)) {
                char c11;
                if (!Character.isHighSurrogate(c10)) {
                    ++n8;
                    continue;
                }
                try {
                    c11 = charSequence.charAt(++i3);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    ++n8;
                    break;
                }
                if (!Character.isLowSurrogate(c11)) {
                    n8 += 2;
                    continue;
                }
                n8 += 4;
                continue;
            }
            n8 += 3;
        }
        return n8;
    }

    public static ByteBuf writeAscii(ByteBufAllocator byteBufAllocator, CharSequence charSequence) {
        ByteBuf byteBuf = byteBufAllocator.buffer(charSequence.length());
        ByteBufUtil.writeAscii(byteBuf, charSequence);
        return byteBuf;
    }

    public static int writeAscii(ByteBuf byteBuf, CharSequence charSequence) {
        int n4 = charSequence.length();
        if (!(charSequence instanceof AsciiString)) {
            while (true) {
                if (byteBuf instanceof WrappedCompositeByteBuf) {
                    byteBuf = byteBuf.unwrap();
                    continue;
                }
                if (byteBuf instanceof AbstractByteBuf) {
                    AbstractByteBuf abstractByteBuf = (AbstractByteBuf)byteBuf;
                    abstractByteBuf.ensureWritable0(n4);
                    int n7 = ByteBufUtil.writeAscii(abstractByteBuf, abstractByteBuf.writerIndex, charSequence, n4);
                    abstractByteBuf.writerIndex += n7;
                    return n7;
                }
                if (!(byteBuf instanceof WrappedByteBuf)) break;
                byteBuf = byteBuf.unwrap();
            }
            byte[] byArray = charSequence.toString().getBytes(CharsetUtil.US_ASCII);
            byteBuf.writeBytes(byArray);
            return byArray.length;
        }
        AsciiString asciiString = (AsciiString)charSequence;
        byteBuf.writeBytes(asciiString.array(), asciiString.arrayOffset(), n4);
        return n4;
    }

    static int writeAscii(AbstractByteBuf abstractByteBuf, int n4, CharSequence charSequence, int n7) {
        for (int i3 = 0; i3 < n7; ++i3) {
            abstractByteBuf._setByte(n4++, AsciiString.c2b(charSequence.charAt(i3)));
        }
        return n7;
    }

    public static ByteBuf encodeString(ByteBufAllocator byteBufAllocator, CharBuffer charBuffer, Charset charset) {
        return ByteBufUtil.encodeString0(byteBufAllocator, false, charBuffer, charset, 0);
    }

    public static ByteBuf encodeString(ByteBufAllocator byteBufAllocator, CharBuffer charBuffer, Charset charset, int n4) {
        return ByteBufUtil.encodeString0(byteBufAllocator, false, charBuffer, charset, n4);
    }

    static ByteBuf encodeString0(ByteBufAllocator byteBufAllocator, boolean bl3, CharBuffer charBuffer, Charset charset, int n4) {
        CharsetEncoder charsetEncoder = CharsetUtil.encoder(charset);
        int n7 = (int)((double)charBuffer.remaining() * (double)charsetEncoder.maxBytesPerChar()) + n4;
        boolean bl4 = true;
        ByteBuf byteBuf = bl3 ? byteBufAllocator.heapBuffer(n7) : byteBufAllocator.buffer(n7);
        try {
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(byteBuf.readerIndex(), n7);
            int n8 = byteBuffer.position();
            CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
            if (!coderResult.isUnderflow()) {
                coderResult.throwException();
            }
            if (!(coderResult = charsetEncoder.flush(byteBuffer)).isUnderflow()) {
                coderResult.throwException();
            }
            byteBuf.writerIndex(byteBuf.writerIndex() + byteBuffer.position() - n8);
            bl4 = false;
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IllegalStateException(characterCodingException);
        }
        finally {
            if (bl4) {
                byteBuf.release();
            }
        }
    }

    static String decodeString(ByteBuf byteBuf, int n4, int n7, Charset charset) {
        int n8;
        byte[] byArray;
        if (n7 == 0) {
            return "";
        }
        if (byteBuf.hasArray()) {
            byArray = byteBuf.array();
            n8 = byteBuf.arrayOffset() + n4;
        } else {
            byArray = ByteBufUtil.threadLocalTempArray(n7);
            n8 = 0;
            byteBuf.getBytes(n4, byArray, 0, n7);
        }
        if (CharsetUtil.US_ASCII.equals(charset)) {
            return new String(byArray, 0, n8, n7);
        }
        return new String(byArray, n8, n7, charset);
    }

    public static ByteBuf threadLocalDirectBuffer() {
        if (THREAD_LOCAL_BUFFER_SIZE <= 0) {
            return null;
        }
        if (PlatformDependent.hasUnsafe()) {
            return ByteBufUtil$ThreadLocalUnsafeDirectByteBuf.newInstance();
        }
        return ByteBufUtil$ThreadLocalDirectByteBuf.newInstance();
    }

    public static byte[] getBytes(ByteBuf byteBuf) {
        return ByteBufUtil.getBytes(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    public static byte[] getBytes(ByteBuf byteBuf, int n4, int n7) {
        return ByteBufUtil.getBytes(byteBuf, n4, n7, true);
    }

    public static byte[] getBytes(ByteBuf byteBuf, int n4, int n7, boolean bl3) {
        int n8 = byteBuf.capacity();
        if (MathUtil.isOutOfBounds(n4, n7, n8)) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n4 + ") <= start + length(" + n7 + ") <= buf.capacity(" + n8 + ')');
        }
        if (byteBuf.hasArray()) {
            if (bl3 || n4 != 0 || n7 != n8) {
                int n10 = byteBuf.arrayOffset() + n4;
                return Arrays.copyOfRange(byteBuf.array(), n10, n10 + n7);
            }
            return byteBuf.array();
        }
        byte[] byArray = PlatformDependent.allocateUninitializedArray(n7);
        byteBuf.getBytes(n4, byArray);
        return byArray;
    }

    public static void copy(AsciiString asciiString, ByteBuf byteBuf) {
        ByteBufUtil.copy(asciiString, 0, byteBuf, asciiString.length());
    }

    public static void copy(AsciiString asciiString, int n4, ByteBuf byteBuf, int n7, int n8) {
        if (MathUtil.isOutOfBounds(n4, n8, asciiString.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + n4 + ") <= srcIdx + length(" + n8 + ") <= srcLen(" + asciiString.length() + ')');
        }
        ObjectUtil.checkNotNull(byteBuf, "dst").setBytes(n7, asciiString.array(), n4 + asciiString.arrayOffset(), n8);
    }

    public static void copy(AsciiString asciiString, int n4, ByteBuf byteBuf, int n7) {
        if (MathUtil.isOutOfBounds(n4, n7, asciiString.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + n4 + ") <= srcIdx + length(" + n7 + ") <= srcLen(" + asciiString.length() + ')');
        }
        ObjectUtil.checkNotNull(byteBuf, "dst").writeBytes(asciiString.array(), n4 + asciiString.arrayOffset(), n7);
    }

    public static String prettyHexDump(ByteBuf byteBuf) {
        return ByteBufUtil.prettyHexDump(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    public static String prettyHexDump(ByteBuf byteBuf, int n4, int n7) {
        return ByteBufUtil$HexUtil.access$200(byteBuf, n4, n7);
    }

    public static void appendPrettyHexDump(StringBuilder stringBuilder, ByteBuf byteBuf) {
        ByteBufUtil.appendPrettyHexDump(stringBuilder, byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    public static void appendPrettyHexDump(StringBuilder stringBuilder, ByteBuf byteBuf, int n4, int n7) {
        ByteBufUtil$HexUtil.access$300(stringBuilder, byteBuf, n4, n7);
    }

    public static boolean isText(ByteBuf byteBuf, Charset charset) {
        return ByteBufUtil.isText(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes(), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isText(ByteBuf byteBuf, int n4, int n7, Charset charset) {
        ObjectUtil.checkNotNull(byteBuf, "buf");
        ObjectUtil.checkNotNull(charset, "charset");
        int n8 = byteBuf.readerIndex() + byteBuf.readableBytes();
        if (n4 < 0 || n7 < 0 || n4 > n8 - n7) {
            throw new IndexOutOfBoundsException("index: " + n4 + " length: " + n7);
        }
        if (charset.equals(CharsetUtil.UTF_8)) {
            return ByteBufUtil.isUtf8(byteBuf, n4, n7);
        }
        if (charset.equals(CharsetUtil.US_ASCII)) {
            return ByteBufUtil.isAscii(byteBuf, n4, n7);
        }
        CharsetDecoder charsetDecoder = CharsetUtil.decoder(charset, CodingErrorAction.REPORT, CodingErrorAction.REPORT);
        try {
            if (byteBuf.nioBufferCount() == 1) {
                charsetDecoder.decode(byteBuf.nioBuffer(n4, n7));
            } else {
                ByteBuf byteBuf2 = byteBuf.alloc().heapBuffer(n7);
                try {
                    byteBuf2.writeBytes(byteBuf, n4, n7);
                    charsetDecoder.decode(byteBuf2.internalNioBuffer(byteBuf2.readerIndex(), n7));
                }
                finally {
                    byteBuf2.release();
                }
            }
            return true;
        }
        catch (CharacterCodingException characterCodingException) {
            return false;
        }
    }

    private static boolean isAscii(ByteBuf byteBuf, int n4, int n7) {
        return byteBuf.forEachByte(n4, n7, FIND_NON_ASCII) == -1;
    }

    private static boolean isUtf8(ByteBuf byteBuf, int n4, int n7) {
        int n8 = n4 + n7;
        while (n4 < n8) {
            byte by2;
            byte by3;
            byte by4;
            if (((by4 = byteBuf.getByte(n4++)) & 0x80) == 0) continue;
            if ((by4 & 0xE0) == 192) {
                if (n4 >= n8) {
                    return false;
                }
                if (((by3 = byteBuf.getByte(n4++)) & 0xC0) != 128) {
                    return false;
                }
                if ((by4 & 0xFF) >= 194) continue;
                return false;
            }
            if ((by4 & 0xF0) == 224) {
                if (n4 > n8 - 2) {
                    return false;
                }
                by3 = byteBuf.getByte(n4++);
                by2 = byteBuf.getByte(n4++);
                if ((by3 & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                    return false;
                }
                if ((by4 & 0xF) == 0 && (by3 & 0xFF) < 160) {
                    return false;
                }
                if ((by4 & 0xF) != 13 || (by3 & 0xFF) <= 159) continue;
                return false;
            }
            if ((by4 & 0xF8) == 240) {
                if (n4 > n8 - 3) {
                    return false;
                }
                by3 = byteBuf.getByte(n4++);
                by2 = byteBuf.getByte(n4++);
                byte by5 = byteBuf.getByte(n4++);
                if ((by3 & 0xC0) != 128 || (by2 & 0xC0) != 128 || (by5 & 0xC0) != 128) {
                    return false;
                }
                if ((by4 & 0xFF) <= 244 && ((by4 & 0xFF) != 240 || (by3 & 0xFF) >= 144) && ((by4 & 0xFF) != 244 || (by3 & 0xFF) <= 143)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readBytes(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer, int n4, int n7, OutputStream outputStream) {
        if (byteBuffer.hasArray()) {
            outputStream.write(byteBuffer.array(), n4 + byteBuffer.arrayOffset(), n7);
        } else {
            int n8 = Math.min(n7, 8192);
            byteBuffer.clear().position(n4);
            if (n7 <= 1024 || !byteBufAllocator.isDirectBufferPooled()) {
                ByteBufUtil.getBytes(byteBuffer, ByteBufUtil.threadLocalTempArray(n8), 0, n8, outputStream, n7);
            } else {
                ByteBuf byteBuf = byteBufAllocator.heapBuffer(n8);
                try {
                    byte[] byArray = byteBuf.array();
                    int n10 = byteBuf.arrayOffset();
                    ByteBufUtil.getBytes(byteBuffer, byArray, n10, n8, outputStream, n7);
                }
                finally {
                    byteBuf.release();
                }
            }
        }
    }

    private static void getBytes(ByteBuffer byteBuffer, byte[] byArray, int n4, int n7, OutputStream outputStream, int n8) {
        int n10;
        do {
            n10 = Math.min(n7, n8);
            byteBuffer.get(byArray, n4, n10);
            outputStream.write(byArray, n4, n10);
        } while ((n8 -= n10) > 0);
    }

    private ByteBufUtil() {
    }

    static /* synthetic */ int access$500() {
        return THREAD_LOCAL_BUFFER_SIZE;
    }

    static {
        AbstractByteBufAllocator abstractByteBufAllocator;
        logger = InternalLoggerFactory.getInstance(ByteBufUtil.class);
        BYTE_ARRAYS = new ByteBufUtil$1();
        MAX_BYTES_PER_CHAR_UTF8 = (int)CharsetUtil.encoder(CharsetUtil.UTF_8).maxBytesPerChar();
        String string = SystemPropertyUtil.get("io.grpc.netty.shaded.io.netty.allocator.type", PlatformDependent.isAndroid() ? "unpooled" : "pooled");
        if ("unpooled".equals(string = string.toLowerCase(Locale.US).trim())) {
            abstractByteBufAllocator = UnpooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: {}", (Object)string);
        } else if ("pooled".equals(string)) {
            abstractByteBufAllocator = PooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: {}", (Object)string);
        } else {
            abstractByteBufAllocator = PooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: pooled (unknown: {})", (Object)string);
        }
        DEFAULT_ALLOCATOR = abstractByteBufAllocator;
        THREAD_LOCAL_BUFFER_SIZE = SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.threadLocalDirectBufferSize", 0);
        logger.debug("-Dio.netty.threadLocalDirectBufferSize: {}", (Object)THREAD_LOCAL_BUFFER_SIZE);
        MAX_CHAR_BUFFER_SIZE = SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.maxThreadLocalCharBufferSize", 16384);
        logger.debug("-Dio.netty.maxThreadLocalCharBufferSize: {}", (Object)MAX_CHAR_BUFFER_SIZE);
        FIND_NON_ASCII = new ByteBufUtil$2();
    }
}

