/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.util.internal.MathUtil;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;

final class ByteBufUtil$HexUtil {
    private static final char[] BYTE2CHAR;
    private static final char[] HEXDUMP_TABLE;
    private static final String[] HEXPADDING;
    private static final String[] HEXDUMP_ROWPREFIXES;
    private static final String[] BYTE2HEX;
    private static final String[] BYTEPADDING;

    private ByteBufUtil$HexUtil() {
    }

    private static String hexDump(ByteBuf byteBuf, int n4, int n7) {
        ObjectUtil.checkPositiveOrZero(n7, "length");
        if (n7 == 0) {
            return "";
        }
        int n8 = n4 + n7;
        char[] cArray = new char[n7 << 1];
        int n10 = n4;
        int n11 = 0;
        while (n10 < n8) {
            System.arraycopy(HEXDUMP_TABLE, byteBuf.getUnsignedByte(n10) << 1, cArray, n11, 2);
            ++n10;
            n11 += 2;
        }
        return new String(cArray);
    }

    private static String hexDump(byte[] byArray, int n4, int n7) {
        ObjectUtil.checkPositiveOrZero(n7, "length");
        if (n7 == 0) {
            return "";
        }
        int n8 = n4 + n7;
        char[] cArray = new char[n7 << 1];
        int n10 = n4;
        int n11 = 0;
        while (n10 < n8) {
            System.arraycopy(HEXDUMP_TABLE, (byArray[n10] & 0xFF) << 1, cArray, n11, 2);
            ++n10;
            n11 += 2;
        }
        return new String(cArray);
    }

    private static String prettyHexDump(ByteBuf byteBuf, int n4, int n7) {
        if (n7 == 0) {
            return "";
        }
        int n8 = n7 / 16 + ((n7 & 0xF) == 0 ? 0 : 1) + 4;
        StringBuilder stringBuilder = new StringBuilder(n8 * 80);
        ByteBufUtil$HexUtil.appendPrettyHexDump(stringBuilder, byteBuf, n4, n7);
        return stringBuilder.toString();
    }

    private static void appendPrettyHexDump(StringBuilder stringBuilder, ByteBuf byteBuf, int n4, int n7) {
        int n8;
        int n10;
        int n11;
        if (MathUtil.isOutOfBounds(n4, n7, byteBuf.capacity())) {
            throw new IndexOutOfBoundsException("expected: 0 <= offset(" + n4 + ") <= offset + length(" + n7 + ") <= buf.capacity(" + byteBuf.capacity() + ')');
        }
        if (n7 == 0) {
            return;
        }
        stringBuilder.append("         +-------------------------------------------------+" + StringUtil.NEWLINE + "         |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |" + StringUtil.NEWLINE + "+--------+-------------------------------------------------+----------------+");
        int n12 = n4;
        int n13 = n7 >>> 4;
        int n14 = n7 & 0xF;
        for (n11 = 0; n11 < n13; ++n11) {
            int n15;
            n10 = (n11 << 4) + n12;
            ByteBufUtil$HexUtil.appendHexDumpRowPrefix(stringBuilder, n11, n10);
            n8 = n10 + 16;
            for (n15 = n10; n15 < n8; ++n15) {
                stringBuilder.append(BYTE2HEX[byteBuf.getUnsignedByte(n15)]);
            }
            stringBuilder.append(" |");
            for (n15 = n10; n15 < n8; ++n15) {
                stringBuilder.append(BYTE2CHAR[byteBuf.getUnsignedByte(n15)]);
            }
            stringBuilder.append('|');
        }
        if (n14 != 0) {
            n11 = (n13 << 4) + n12;
            ByteBufUtil$HexUtil.appendHexDumpRowPrefix(stringBuilder, n13, n11);
            n10 = n11 + n14;
            for (n8 = n11; n8 < n10; ++n8) {
                stringBuilder.append(BYTE2HEX[byteBuf.getUnsignedByte(n8)]);
            }
            stringBuilder.append(HEXPADDING[n14]);
            stringBuilder.append(" |");
            for (n8 = n11; n8 < n10; ++n8) {
                stringBuilder.append(BYTE2CHAR[byteBuf.getUnsignedByte(n8)]);
            }
            stringBuilder.append(BYTEPADDING[n14]);
            stringBuilder.append('|');
        }
        stringBuilder.append(StringUtil.NEWLINE + "+--------+-------------------------------------------------+----------------+");
    }

    private static void appendHexDumpRowPrefix(StringBuilder stringBuilder, int n4, int n7) {
        if (n4 < HEXDUMP_ROWPREFIXES.length) {
            stringBuilder.append(HEXDUMP_ROWPREFIXES[n4]);
        } else {
            stringBuilder.append(StringUtil.NEWLINE);
            stringBuilder.append(Long.toHexString((long)n7 & 0xFFFFFFFFL | 0x100000000L));
            stringBuilder.setCharAt(stringBuilder.length() - 9, '|');
            stringBuilder.append('|');
        }
    }

    static /* synthetic */ String access$000(ByteBuf byteBuf, int n4, int n7) {
        return ByteBufUtil$HexUtil.hexDump(byteBuf, n4, n7);
    }

    static /* synthetic */ String access$100(byte[] byArray, int n4, int n7) {
        return ByteBufUtil$HexUtil.hexDump(byArray, n4, n7);
    }

    static /* synthetic */ String access$200(ByteBuf byteBuf, int n4, int n7) {
        return ByteBufUtil$HexUtil.prettyHexDump(byteBuf, n4, n7);
    }

    static /* synthetic */ void access$300(StringBuilder stringBuilder, ByteBuf byteBuf, int n4, int n7) {
        ByteBufUtil$HexUtil.appendPrettyHexDump(stringBuilder, byteBuf, n4, n7);
    }

    static {
        int n4;
        StringBuilder stringBuilder;
        int n7;
        BYTE2CHAR = new char[256];
        HEXDUMP_TABLE = new char[1024];
        HEXPADDING = new String[16];
        HEXDUMP_ROWPREFIXES = new String[4096];
        BYTE2HEX = new String[256];
        BYTEPADDING = new String[16];
        char[] cArray = "0123456789abcdef".toCharArray();
        for (n7 = 0; n7 < 256; ++n7) {
            ByteBufUtil$HexUtil.HEXDUMP_TABLE[n7 << 1] = cArray[n7 >>> 4 & 0xF];
            ByteBufUtil$HexUtil.HEXDUMP_TABLE[(n7 << 1) + 1] = cArray[n7 & 0xF];
        }
        for (n7 = 0; n7 < HEXPADDING.length; ++n7) {
            int n8 = HEXPADDING.length - n7;
            stringBuilder = new StringBuilder(n8 * 3);
            for (n4 = 0; n4 < n8; ++n4) {
                stringBuilder.append("   ");
            }
            ByteBufUtil$HexUtil.HEXPADDING[n7] = stringBuilder.toString();
        }
        for (n7 = 0; n7 < HEXDUMP_ROWPREFIXES.length; ++n7) {
            StringBuilder stringBuilder2 = new StringBuilder(12);
            stringBuilder2.append(StringUtil.NEWLINE);
            stringBuilder2.append(Long.toHexString((long)(n7 << 4) & 0xFFFFFFFFL | 0x100000000L));
            stringBuilder2.setCharAt(stringBuilder2.length() - 9, '|');
            stringBuilder2.append('|');
            ByteBufUtil$HexUtil.HEXDUMP_ROWPREFIXES[n7] = stringBuilder2.toString();
        }
        for (n7 = 0; n7 < BYTE2HEX.length; ++n7) {
            ByteBufUtil$HexUtil.BYTE2HEX[n7] = ' ' + StringUtil.byteToHexStringPadded(n7);
        }
        for (n7 = 0; n7 < BYTEPADDING.length; ++n7) {
            int n10 = BYTEPADDING.length - n7;
            stringBuilder = new StringBuilder(n10);
            for (n4 = 0; n4 < n10; ++n4) {
                stringBuilder.append(' ');
            }
            ByteBufUtil$HexUtil.BYTEPADDING[n7] = stringBuilder.toString();
        }
        for (n7 = 0; n7 < BYTE2CHAR.length; ++n7) {
            ByteBufUtil$HexUtil.BYTE2CHAR[n7] = n7 <= 31 || n7 >= 127 ? 46 : (char)n7;
        }
    }
}

