/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.OutputStream;

public class ByteBufOutputStream
extends OutputStream
implements DataOutput {
    private final ByteBuf buffer;
    private final int startIndex;
    private final DataOutputStream utf8out = new DataOutputStream(this);

    public ByteBufOutputStream(ByteBuf byteBuf) {
        if (byteBuf == null) {
            throw new NullPointerException("buffer");
        }
        this.buffer = byteBuf;
        this.startIndex = byteBuf.writerIndex();
    }

    public int writtenBytes() {
        return this.buffer.writerIndex() - this.startIndex;
    }

    @Override
    public void write(byte[] byArray, int n4, int n7) {
        if (n7 == 0) {
            return;
        }
        this.buffer.writeBytes(byArray, n4, n7);
    }

    @Override
    public void write(byte[] byArray) {
        this.buffer.writeBytes(byArray);
    }

    @Override
    public void write(int n4) {
        this.buffer.writeByte(n4);
    }

    @Override
    public void writeBoolean(boolean bl3) {
        this.buffer.writeBoolean(bl3);
    }

    @Override
    public void writeByte(int n4) {
        this.buffer.writeByte(n4);
    }

    @Override
    public void writeBytes(String string) {
        this.buffer.writeCharSequence(string, CharsetUtil.US_ASCII);
    }

    @Override
    public void writeChar(int n4) {
        this.buffer.writeChar(n4);
    }

    @Override
    public void writeChars(String string) {
        int n4 = string.length();
        for (int i3 = 0; i3 < n4; ++i3) {
            this.buffer.writeChar(string.charAt(i3));
        }
    }

    @Override
    public void writeDouble(double d8) {
        this.buffer.writeDouble(d8);
    }

    @Override
    public void writeFloat(float f8) {
        this.buffer.writeFloat(f8);
    }

    @Override
    public void writeInt(int n4) {
        this.buffer.writeInt(n4);
    }

    @Override
    public void writeLong(long l2) {
        this.buffer.writeLong(l2);
    }

    @Override
    public void writeShort(int n4) {
        this.buffer.writeShort((short)n4);
    }

    @Override
    public void writeUTF(String string) {
        this.utf8out.writeUTF(string);
    }

    public ByteBuf buffer() {
        return this.buffer;
    }
}

