/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.InputStream;

public class ByteBufInputStream
extends InputStream
implements DataInput {
    private final ByteBuf buffer;
    private final int startIndex;
    private final int endIndex;
    private boolean closed;
    private final boolean releaseOnClose;
    private StringBuilder lineBuf;

    public ByteBufInputStream(ByteBuf byteBuf) {
        this(byteBuf, byteBuf.readableBytes());
    }

    public ByteBufInputStream(ByteBuf byteBuf, int n4) {
        this(byteBuf, n4, false);
    }

    public ByteBufInputStream(ByteBuf byteBuf, boolean bl3) {
        this(byteBuf, byteBuf.readableBytes(), bl3);
    }

    public ByteBufInputStream(ByteBuf byteBuf, int n4, boolean bl3) {
        if (byteBuf == null) {
            throw new NullPointerException("buffer");
        }
        if (n4 < 0) {
            if (bl3) {
                byteBuf.release();
            }
            throw new IllegalArgumentException("length: " + n4);
        }
        if (n4 > byteBuf.readableBytes()) {
            if (bl3) {
                byteBuf.release();
            }
            throw new IndexOutOfBoundsException("Too many bytes to be read - Needs " + n4 + ", maximum is " + byteBuf.readableBytes());
        }
        this.releaseOnClose = bl3;
        this.buffer = byteBuf;
        this.startIndex = byteBuf.readerIndex();
        this.endIndex = this.startIndex + n4;
        byteBuf.markReaderIndex();
    }

    public int readBytes() {
        return this.buffer.readerIndex() - this.startIndex;
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            if (this.releaseOnClose && !this.closed) {
                this.closed = true;
                this.buffer.release();
            }
        }
    }

    @Override
    public int available() {
        return this.endIndex - this.buffer.readerIndex();
    }

    @Override
    public void mark(int n4) {
        this.buffer.markReaderIndex();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        int n4 = this.available();
        if (n4 == 0) {
            return -1;
        }
        return this.buffer.readByte() & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n4, int n7) {
        int n8 = this.available();
        if (n8 == 0) {
            return -1;
        }
        n7 = Math.min(n8, n7);
        this.buffer.readBytes(byArray, n4, n7);
        return n7;
    }

    @Override
    public void reset() {
        this.buffer.resetReaderIndex();
    }

    @Override
    public long skip(long l2) {
        if (l2 > Integer.MAX_VALUE) {
            return this.skipBytes(Integer.MAX_VALUE);
        }
        return this.skipBytes((int)l2);
    }

    @Override
    public boolean readBoolean() {
        this.checkAvailable(1);
        return this.read() != 0;
    }

    @Override
    public byte readByte() {
        int n4 = this.available();
        if (n4 == 0) {
            throw new EOFException();
        }
        return this.buffer.readByte();
    }

    @Override
    public char readChar() {
        return (char)this.readShort();
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public void readFully(byte[] byArray) {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n4, int n7) {
        this.checkAvailable(n7);
        this.buffer.readBytes(byArray, n4, n7);
    }

    @Override
    public int readInt() {
        this.checkAvailable(4);
        return this.buffer.readInt();
    }

    @Override
    public String readLine() {
        int n4 = this.available();
        if (n4 == 0) {
            return null;
        }
        if (this.lineBuf != null) {
            this.lineBuf.setLength(0);
        }
        block4: while (true) {
            short s11 = this.buffer.readUnsignedByte();
            --n4;
            switch (s11) {
                case 10: {
                    break block4;
                }
                case 13: {
                    if (n4 <= 0 || (char)this.buffer.getUnsignedByte(this.buffer.readerIndex()) != '\n') break block4;
                    this.buffer.skipBytes(1);
                    --n4;
                    break block4;
                }
                default: {
                    if (this.lineBuf == null) {
                        this.lineBuf = new StringBuilder();
                    }
                    this.lineBuf.append((char)s11);
                    if (n4 > 0) continue block4;
                }
            }
            break;
        }
        return this.lineBuf != null && this.lineBuf.length() > 0 ? this.lineBuf.toString() : "";
    }

    @Override
    public long readLong() {
        this.checkAvailable(8);
        return this.buffer.readLong();
    }

    @Override
    public short readShort() {
        this.checkAvailable(2);
        return this.buffer.readShort();
    }

    @Override
    public String readUTF() {
        return DataInputStream.readUTF(this);
    }

    @Override
    public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int skipBytes(int n4) {
        int n7 = Math.min(this.available(), n4);
        this.buffer.skipBytes(n7);
        return n7;
    }

    private void checkAvailable(int n4) {
        if (n4 < 0) {
            throw new IndexOutOfBoundsException("fieldSize cannot be a negative number");
        }
        if (n4 > this.available()) {
            throw new EOFException("fieldSize is too long! Length is " + n4 + ", but maximum is " + this.available());
        }
    }
}

