/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.AbstractByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.SwappedByteBuf;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.nio.ByteOrder;

abstract class AbstractUnsafeSwappedByteBuf
extends SwappedByteBuf {
    private final boolean nativeByteOrder;
    private final AbstractByteBuf wrapped;

    AbstractUnsafeSwappedByteBuf(AbstractByteBuf abstractByteBuf) {
        super(abstractByteBuf);
        assert (PlatformDependent.isUnaligned());
        this.wrapped = abstractByteBuf;
        this.nativeByteOrder = PlatformDependent.BIG_ENDIAN_NATIVE_ORDER == (this.order() == ByteOrder.BIG_ENDIAN);
    }

    @Override
    public final long getLong(int n4) {
        this.wrapped.checkIndex(n4, 8);
        long l2 = this._getLong(this.wrapped, n4);
        return this.nativeByteOrder ? l2 : Long.reverseBytes(l2);
    }

    @Override
    public final float getFloat(int n4) {
        return Float.intBitsToFloat(this.getInt(n4));
    }

    @Override
    public final double getDouble(int n4) {
        return Double.longBitsToDouble(this.getLong(n4));
    }

    @Override
    public final char getChar(int n4) {
        return (char)this.getShort(n4);
    }

    @Override
    public final long getUnsignedInt(int n4) {
        return (long)this.getInt(n4) & 0xFFFFFFFFL;
    }

    @Override
    public final int getInt(int n4) {
        this.wrapped.checkIndex(n4, 4);
        int n7 = this._getInt(this.wrapped, n4);
        return this.nativeByteOrder ? n7 : Integer.reverseBytes(n7);
    }

    @Override
    public final int getUnsignedShort(int n4) {
        return this.getShort(n4) & 0xFFFF;
    }

    @Override
    public final short getShort(int n4) {
        this.wrapped.checkIndex(n4, 2);
        short s11 = this._getShort(this.wrapped, n4);
        return this.nativeByteOrder ? s11 : Short.reverseBytes(s11);
    }

    @Override
    public final ByteBuf setShort(int n4, int n7) {
        this.wrapped.checkIndex(n4, 2);
        this._setShort(this.wrapped, n4, this.nativeByteOrder ? (short)n7 : Short.reverseBytes((short)n7));
        return this;
    }

    @Override
    public final ByteBuf setInt(int n4, int n7) {
        this.wrapped.checkIndex(n4, 4);
        this._setInt(this.wrapped, n4, this.nativeByteOrder ? n7 : Integer.reverseBytes(n7));
        return this;
    }

    @Override
    public final ByteBuf setLong(int n4, long l2) {
        this.wrapped.checkIndex(n4, 8);
        this._setLong(this.wrapped, n4, this.nativeByteOrder ? l2 : Long.reverseBytes(l2));
        return this;
    }

    @Override
    public final ByteBuf setChar(int n4, int n7) {
        this.setShort(n4, n7);
        return this;
    }

    @Override
    public final ByteBuf setFloat(int n4, float f8) {
        this.setInt(n4, Float.floatToRawIntBits(f8));
        return this;
    }

    @Override
    public final ByteBuf setDouble(int n4, double d8) {
        this.setLong(n4, Double.doubleToRawLongBits(d8));
        return this;
    }

    @Override
    public final ByteBuf writeShort(int n4) {
        this.wrapped.ensureWritable0(2);
        this._setShort(this.wrapped, this.wrapped.writerIndex, this.nativeByteOrder ? (short)n4 : Short.reverseBytes((short)n4));
        this.wrapped.writerIndex += 2;
        return this;
    }

    @Override
    public final ByteBuf writeInt(int n4) {
        this.wrapped.ensureWritable0(4);
        this._setInt(this.wrapped, this.wrapped.writerIndex, this.nativeByteOrder ? n4 : Integer.reverseBytes(n4));
        this.wrapped.writerIndex += 4;
        return this;
    }

    @Override
    public final ByteBuf writeLong(long l2) {
        this.wrapped.ensureWritable0(8);
        this._setLong(this.wrapped, this.wrapped.writerIndex, this.nativeByteOrder ? l2 : Long.reverseBytes(l2));
        this.wrapped.writerIndex += 8;
        return this;
    }

    @Override
    public final ByteBuf writeChar(int n4) {
        this.writeShort(n4);
        return this;
    }

    @Override
    public final ByteBuf writeFloat(float f8) {
        this.writeInt(Float.floatToRawIntBits(f8));
        return this;
    }

    @Override
    public final ByteBuf writeDouble(double d8) {
        this.writeLong(Double.doubleToRawLongBits(d8));
        return this;
    }

    protected abstract short _getShort(AbstractByteBuf var1, int var2);

    protected abstract int _getInt(AbstractByteBuf var1, int var2);

    protected abstract long _getLong(AbstractByteBuf var1, int var2);

    protected abstract void _setShort(AbstractByteBuf var1, int var2, short var3);

    protected abstract void _setInt(AbstractByteBuf var1, int var2, int var3);

    protected abstract void _setLong(AbstractByteBuf var1, int var2, long var3);
}

