/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.AbstractDerivedByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.DuplicatedByteBuf;
import io.grpc.netty.shaded.io.netty.util.ByteProcessor;
import io.grpc.netty.shaded.io.netty.util.internal.MathUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

abstract class AbstractUnpooledSlicedByteBuf
extends AbstractDerivedByteBuf {
    private final ByteBuf buffer;
    private final int adjustment;

    AbstractUnpooledSlicedByteBuf(ByteBuf byteBuf, int n4, int n7) {
        super(n7);
        AbstractUnpooledSlicedByteBuf.checkSliceOutOfBounds(n4, n7, byteBuf);
        if (byteBuf instanceof AbstractUnpooledSlicedByteBuf) {
            this.buffer = ((AbstractUnpooledSlicedByteBuf)byteBuf).buffer;
            this.adjustment = ((AbstractUnpooledSlicedByteBuf)byteBuf).adjustment + n4;
        } else if (byteBuf instanceof DuplicatedByteBuf) {
            this.buffer = byteBuf.unwrap();
            this.adjustment = n4;
        } else {
            this.buffer = byteBuf;
            this.adjustment = n4;
        }
        this.initLength(n7);
        this.writerIndex(n7);
    }

    void initLength(int n4) {
    }

    int length() {
        return this.capacity();
    }

    @Override
    public ByteBuf unwrap() {
        return this.buffer;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.unwrap().alloc();
    }

    @Override
    @Deprecated
    public ByteOrder order() {
        return this.unwrap().order();
    }

    @Override
    public boolean isDirect() {
        return this.unwrap().isDirect();
    }

    @Override
    public ByteBuf capacity(int n4) {
        throw new UnsupportedOperationException("sliced buffer");
    }

    @Override
    public boolean hasArray() {
        return this.unwrap().hasArray();
    }

    @Override
    public byte[] array() {
        return this.unwrap().array();
    }

    @Override
    public int arrayOffset() {
        return this.idx(this.unwrap().arrayOffset());
    }

    @Override
    public boolean hasMemoryAddress() {
        return this.unwrap().hasMemoryAddress();
    }

    @Override
    public long memoryAddress() {
        return this.unwrap().memoryAddress() + (long)this.adjustment;
    }

    @Override
    public byte getByte(int n4) {
        this.checkIndex0(n4, 1);
        return this.unwrap().getByte(this.idx(n4));
    }

    @Override
    protected byte _getByte(int n4) {
        return this.unwrap().getByte(this.idx(n4));
    }

    @Override
    public short getShort(int n4) {
        this.checkIndex0(n4, 2);
        return this.unwrap().getShort(this.idx(n4));
    }

    @Override
    protected short _getShort(int n4) {
        return this.unwrap().getShort(this.idx(n4));
    }

    @Override
    public short getShortLE(int n4) {
        this.checkIndex0(n4, 2);
        return this.unwrap().getShortLE(this.idx(n4));
    }

    @Override
    protected short _getShortLE(int n4) {
        return this.unwrap().getShortLE(this.idx(n4));
    }

    @Override
    public int getUnsignedMedium(int n4) {
        this.checkIndex0(n4, 3);
        return this.unwrap().getUnsignedMedium(this.idx(n4));
    }

    @Override
    protected int _getUnsignedMedium(int n4) {
        return this.unwrap().getUnsignedMedium(this.idx(n4));
    }

    @Override
    public int getUnsignedMediumLE(int n4) {
        this.checkIndex0(n4, 3);
        return this.unwrap().getUnsignedMediumLE(this.idx(n4));
    }

    @Override
    protected int _getUnsignedMediumLE(int n4) {
        return this.unwrap().getUnsignedMediumLE(this.idx(n4));
    }

    @Override
    public int getInt(int n4) {
        this.checkIndex0(n4, 4);
        return this.unwrap().getInt(this.idx(n4));
    }

    @Override
    protected int _getInt(int n4) {
        return this.unwrap().getInt(this.idx(n4));
    }

    @Override
    public int getIntLE(int n4) {
        this.checkIndex0(n4, 4);
        return this.unwrap().getIntLE(this.idx(n4));
    }

    @Override
    protected int _getIntLE(int n4) {
        return this.unwrap().getIntLE(this.idx(n4));
    }

    @Override
    public long getLong(int n4) {
        this.checkIndex0(n4, 8);
        return this.unwrap().getLong(this.idx(n4));
    }

    @Override
    protected long _getLong(int n4) {
        return this.unwrap().getLong(this.idx(n4));
    }

    @Override
    public long getLongLE(int n4) {
        this.checkIndex0(n4, 8);
        return this.unwrap().getLongLE(this.idx(n4));
    }

    @Override
    protected long _getLongLE(int n4) {
        return this.unwrap().getLongLE(this.idx(n4));
    }

    @Override
    public ByteBuf duplicate() {
        return this.unwrap().duplicate().setIndex(this.idx(this.readerIndex()), this.idx(this.writerIndex()));
    }

    @Override
    public ByteBuf copy(int n4, int n7) {
        this.checkIndex0(n4, n7);
        return this.unwrap().copy(this.idx(n4), n7);
    }

    @Override
    public ByteBuf slice(int n4, int n7) {
        this.checkIndex0(n4, n7);
        return this.unwrap().slice(this.idx(n4), n7);
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        this.checkIndex0(n4, n8);
        this.unwrap().getBytes(this.idx(n4), byteBuf, n7, n8);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, byte[] byArray, int n7, int n8) {
        this.checkIndex0(n4, n8);
        this.unwrap().getBytes(this.idx(n4), byArray, n7, n8);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuffer byteBuffer) {
        this.checkIndex0(n4, byteBuffer.remaining());
        this.unwrap().getBytes(this.idx(n4), byteBuffer);
        return this;
    }

    @Override
    public ByteBuf setByte(int n4, int n7) {
        this.checkIndex0(n4, 1);
        this.unwrap().setByte(this.idx(n4), n7);
        return this;
    }

    @Override
    public CharSequence getCharSequence(int n4, int n7, Charset charset) {
        this.checkIndex0(n4, n7);
        return this.unwrap().getCharSequence(this.idx(n4), n7, charset);
    }

    @Override
    protected void _setByte(int n4, int n7) {
        this.unwrap().setByte(this.idx(n4), n7);
    }

    @Override
    public ByteBuf setShort(int n4, int n7) {
        this.checkIndex0(n4, 2);
        this.unwrap().setShort(this.idx(n4), n7);
        return this;
    }

    @Override
    protected void _setShort(int n4, int n7) {
        this.unwrap().setShort(this.idx(n4), n7);
    }

    @Override
    public ByteBuf setShortLE(int n4, int n7) {
        this.checkIndex0(n4, 2);
        this.unwrap().setShortLE(this.idx(n4), n7);
        return this;
    }

    @Override
    protected void _setShortLE(int n4, int n7) {
        this.unwrap().setShortLE(this.idx(n4), n7);
    }

    @Override
    public ByteBuf setMedium(int n4, int n7) {
        this.checkIndex0(n4, 3);
        this.unwrap().setMedium(this.idx(n4), n7);
        return this;
    }

    @Override
    protected void _setMedium(int n4, int n7) {
        this.unwrap().setMedium(this.idx(n4), n7);
    }

    @Override
    public ByteBuf setMediumLE(int n4, int n7) {
        this.checkIndex0(n4, 3);
        this.unwrap().setMediumLE(this.idx(n4), n7);
        return this;
    }

    @Override
    protected void _setMediumLE(int n4, int n7) {
        this.unwrap().setMediumLE(this.idx(n4), n7);
    }

    @Override
    public ByteBuf setInt(int n4, int n7) {
        this.checkIndex0(n4, 4);
        this.unwrap().setInt(this.idx(n4), n7);
        return this;
    }

    @Override
    protected void _setInt(int n4, int n7) {
        this.unwrap().setInt(this.idx(n4), n7);
    }

    @Override
    public ByteBuf setIntLE(int n4, int n7) {
        this.checkIndex0(n4, 4);
        this.unwrap().setIntLE(this.idx(n4), n7);
        return this;
    }

    @Override
    protected void _setIntLE(int n4, int n7) {
        this.unwrap().setIntLE(this.idx(n4), n7);
    }

    @Override
    public ByteBuf setLong(int n4, long l2) {
        this.checkIndex0(n4, 8);
        this.unwrap().setLong(this.idx(n4), l2);
        return this;
    }

    @Override
    protected void _setLong(int n4, long l2) {
        this.unwrap().setLong(this.idx(n4), l2);
    }

    @Override
    public ByteBuf setLongLE(int n4, long l2) {
        this.checkIndex0(n4, 8);
        this.unwrap().setLongLE(this.idx(n4), l2);
        return this;
    }

    @Override
    protected void _setLongLE(int n4, long l2) {
        this.unwrap().setLongLE(this.idx(n4), l2);
    }

    @Override
    public ByteBuf setBytes(int n4, byte[] byArray, int n7, int n8) {
        this.checkIndex0(n4, n8);
        this.unwrap().setBytes(this.idx(n4), byArray, n7, n8);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        this.checkIndex0(n4, n8);
        this.unwrap().setBytes(this.idx(n4), byteBuf, n7, n8);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuffer byteBuffer) {
        this.checkIndex0(n4, byteBuffer.remaining());
        this.unwrap().setBytes(this.idx(n4), byteBuffer);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, OutputStream outputStream, int n7) {
        this.checkIndex0(n4, n7);
        this.unwrap().getBytes(this.idx(n4), outputStream, n7);
        return this;
    }

    @Override
    public int getBytes(int n4, GatheringByteChannel gatheringByteChannel, int n7) {
        this.checkIndex0(n4, n7);
        return this.unwrap().getBytes(this.idx(n4), gatheringByteChannel, n7);
    }

    @Override
    public int getBytes(int n4, FileChannel fileChannel, long l2, int n7) {
        this.checkIndex0(n4, n7);
        return this.unwrap().getBytes(this.idx(n4), fileChannel, l2, n7);
    }

    @Override
    public int setBytes(int n4, InputStream inputStream, int n7) {
        this.checkIndex0(n4, n7);
        return this.unwrap().setBytes(this.idx(n4), inputStream, n7);
    }

    @Override
    public int setBytes(int n4, ScatteringByteChannel scatteringByteChannel, int n7) {
        this.checkIndex0(n4, n7);
        return this.unwrap().setBytes(this.idx(n4), scatteringByteChannel, n7);
    }

    @Override
    public int setBytes(int n4, FileChannel fileChannel, long l2, int n7) {
        this.checkIndex0(n4, n7);
        return this.unwrap().setBytes(this.idx(n4), fileChannel, l2, n7);
    }

    @Override
    public int nioBufferCount() {
        return this.unwrap().nioBufferCount();
    }

    @Override
    public ByteBuffer nioBuffer(int n4, int n7) {
        this.checkIndex0(n4, n7);
        return this.unwrap().nioBuffer(this.idx(n4), n7);
    }

    @Override
    public ByteBuffer[] nioBuffers(int n4, int n7) {
        this.checkIndex0(n4, n7);
        return this.unwrap().nioBuffers(this.idx(n4), n7);
    }

    @Override
    public int forEachByte(int n4, int n7, ByteProcessor byteProcessor) {
        this.checkIndex0(n4, n7);
        int n8 = this.unwrap().forEachByte(this.idx(n4), n7, byteProcessor);
        if (n8 >= this.adjustment) {
            return n8 - this.adjustment;
        }
        return -1;
    }

    @Override
    public int forEachByteDesc(int n4, int n7, ByteProcessor byteProcessor) {
        this.checkIndex0(n4, n7);
        int n8 = this.unwrap().forEachByteDesc(this.idx(n4), n7, byteProcessor);
        if (n8 >= this.adjustment) {
            return n8 - this.adjustment;
        }
        return -1;
    }

    final int idx(int n4) {
        return n4 + this.adjustment;
    }

    static void checkSliceOutOfBounds(int n4, int n7, ByteBuf byteBuf) {
        if (MathUtil.isOutOfBounds(n4, n7, byteBuf.capacity())) {
            throw new IndexOutOfBoundsException(byteBuf + ".slice(" + n4 + ", " + n7 + ')');
        }
    }
}

