/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.AbstractByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.AdvancedLeakAwareByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.AdvancedLeakAwareCompositeByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.CompositeByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.EmptyByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.SimpleLeakAwareByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.SimpleLeakAwareCompositeByteBuf;
import io.grpc.netty.shaded.io.netty.util.ResourceLeakDetector;
import io.grpc.netty.shaded.io.netty.util.ResourceLeakTracker;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;

public abstract class AbstractByteBufAllocator
implements ByteBufAllocator {
    static final int DEFAULT_INITIAL_CAPACITY = 256;
    static final int DEFAULT_MAX_CAPACITY = Integer.MAX_VALUE;
    static final int DEFAULT_MAX_COMPONENTS = 16;
    static final int CALCULATE_THRESHOLD = 0x400000;
    private final boolean directByDefault;
    private final ByteBuf emptyBuf;

    protected static ByteBuf toLeakAwareBuffer(ByteBuf byteBuf) {
        switch (ResourceLeakDetector.getLevel()) {
            case SIMPLE: {
                ResourceLeakTracker<ByteBuf> resourceLeakTracker = AbstractByteBuf.leakDetector.track(byteBuf);
                if (resourceLeakTracker == null) break;
                byteBuf = new SimpleLeakAwareByteBuf(byteBuf, resourceLeakTracker);
                break;
            }
            case ADVANCED: 
            case PARANOID: {
                ResourceLeakTracker<ByteBuf> resourceLeakTracker = AbstractByteBuf.leakDetector.track(byteBuf);
                if (resourceLeakTracker == null) break;
                byteBuf = new AdvancedLeakAwareByteBuf(byteBuf, resourceLeakTracker);
                break;
            }
        }
        return byteBuf;
    }

    protected static CompositeByteBuf toLeakAwareBuffer(CompositeByteBuf compositeByteBuf) {
        switch (ResourceLeakDetector.getLevel()) {
            case SIMPLE: {
                ResourceLeakTracker<ByteBuf> resourceLeakTracker = AbstractByteBuf.leakDetector.track(compositeByteBuf);
                if (resourceLeakTracker == null) break;
                compositeByteBuf = new SimpleLeakAwareCompositeByteBuf(compositeByteBuf, resourceLeakTracker);
                break;
            }
            case ADVANCED: 
            case PARANOID: {
                ResourceLeakTracker<ByteBuf> resourceLeakTracker = AbstractByteBuf.leakDetector.track(compositeByteBuf);
                if (resourceLeakTracker == null) break;
                compositeByteBuf = new AdvancedLeakAwareCompositeByteBuf(compositeByteBuf, resourceLeakTracker);
                break;
            }
        }
        return compositeByteBuf;
    }

    protected AbstractByteBufAllocator() {
        this(false);
    }

    protected AbstractByteBufAllocator(boolean bl3) {
        this.directByDefault = bl3 && PlatformDependent.hasUnsafe();
        this.emptyBuf = new EmptyByteBuf(this);
    }

    @Override
    public ByteBuf buffer() {
        if (this.directByDefault) {
            return this.directBuffer();
        }
        return this.heapBuffer();
    }

    @Override
    public ByteBuf buffer(int n4) {
        if (this.directByDefault) {
            return this.directBuffer(n4);
        }
        return this.heapBuffer(n4);
    }

    @Override
    public ByteBuf buffer(int n4, int n7) {
        if (this.directByDefault) {
            return this.directBuffer(n4, n7);
        }
        return this.heapBuffer(n4, n7);
    }

    @Override
    public ByteBuf ioBuffer() {
        if (PlatformDependent.hasUnsafe() || this.isDirectBufferPooled()) {
            return this.directBuffer(256);
        }
        return this.heapBuffer(256);
    }

    @Override
    public ByteBuf ioBuffer(int n4) {
        if (PlatformDependent.hasUnsafe() || this.isDirectBufferPooled()) {
            return this.directBuffer(n4);
        }
        return this.heapBuffer(n4);
    }

    @Override
    public ByteBuf ioBuffer(int n4, int n7) {
        if (PlatformDependent.hasUnsafe() || this.isDirectBufferPooled()) {
            return this.directBuffer(n4, n7);
        }
        return this.heapBuffer(n4, n7);
    }

    @Override
    public ByteBuf heapBuffer() {
        return this.heapBuffer(256, Integer.MAX_VALUE);
    }

    @Override
    public ByteBuf heapBuffer(int n4) {
        return this.heapBuffer(n4, Integer.MAX_VALUE);
    }

    @Override
    public ByteBuf heapBuffer(int n4, int n7) {
        if (n4 == 0 && n7 == 0) {
            return this.emptyBuf;
        }
        AbstractByteBufAllocator.validate(n4, n7);
        return this.newHeapBuffer(n4, n7);
    }

    @Override
    public ByteBuf directBuffer() {
        return this.directBuffer(256, Integer.MAX_VALUE);
    }

    @Override
    public ByteBuf directBuffer(int n4) {
        return this.directBuffer(n4, Integer.MAX_VALUE);
    }

    @Override
    public ByteBuf directBuffer(int n4, int n7) {
        if (n4 == 0 && n7 == 0) {
            return this.emptyBuf;
        }
        AbstractByteBufAllocator.validate(n4, n7);
        return this.newDirectBuffer(n4, n7);
    }

    @Override
    public CompositeByteBuf compositeBuffer() {
        if (this.directByDefault) {
            return this.compositeDirectBuffer();
        }
        return this.compositeHeapBuffer();
    }

    @Override
    public CompositeByteBuf compositeBuffer(int n4) {
        if (this.directByDefault) {
            return this.compositeDirectBuffer(n4);
        }
        return this.compositeHeapBuffer(n4);
    }

    @Override
    public CompositeByteBuf compositeHeapBuffer() {
        return this.compositeHeapBuffer(16);
    }

    @Override
    public CompositeByteBuf compositeHeapBuffer(int n4) {
        return AbstractByteBufAllocator.toLeakAwareBuffer(new CompositeByteBuf(this, false, n4));
    }

    @Override
    public CompositeByteBuf compositeDirectBuffer() {
        return this.compositeDirectBuffer(16);
    }

    @Override
    public CompositeByteBuf compositeDirectBuffer(int n4) {
        return AbstractByteBufAllocator.toLeakAwareBuffer(new CompositeByteBuf(this, true, n4));
    }

    private static void validate(int n4, int n7) {
        ObjectUtil.checkPositiveOrZero(n4, "initialCapacity");
        if (n4 > n7) {
            throw new IllegalArgumentException(String.format("initialCapacity: %d (expected: not greater than maxCapacity(%d)", n4, n7));
        }
    }

    protected abstract ByteBuf newHeapBuffer(int var1, int var2);

    protected abstract ByteBuf newDirectBuffer(int var1, int var2);

    public String toString() {
        return StringUtil.simpleClassName(this) + "(directByDefault: " + this.directByDefault + ')';
    }

    @Override
    public int calculateNewCapacity(int n4, int n7) {
        int n8;
        ObjectUtil.checkPositiveOrZero(n4, "minNewCapacity");
        if (n4 > n7) {
            throw new IllegalArgumentException(String.format("minNewCapacity: %d (expected: not greater than maxCapacity(%d)", n4, n7));
        }
        int n10 = 0x400000;
        if (n4 == 0x400000) {
            return 0x400000;
        }
        if (n4 > 0x400000) {
            int n11 = n4 / 0x400000 * 0x400000;
            n11 = n11 > n7 - 0x400000 ? n7 : (n11 += 0x400000);
            return n11;
        }
        for (n8 = 64; n8 < n4; n8 <<= 1) {
        }
        return Math.min(n8, n7);
    }

    static {
        ResourceLeakDetector.addExclusions(AbstractByteBufAllocator.class, "toLeakAwareBuffer");
    }
}

