/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.buffer;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.buffer.SwappedByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.buffer.UnpooledDuplicatedByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.UnpooledSlicedByteBuf;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.netty.shaded.io.netty.util.ByteProcessor;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import io.grpc.netty.shaded.io.netty.util.IllegalReferenceCountException;
import io.grpc.netty.shaded.io.netty.util.ResourceLeakDetector;
import io.grpc.netty.shaded.io.netty.util.ResourceLeakDetectorFactory;
import io.grpc.netty.shaded.io.netty.util.internal.MathUtil;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

public abstract class AbstractByteBuf
extends ByteBuf {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractByteBuf.class);
    private static final String LEGACY_PROP_CHECK_ACCESSIBLE = "io.grpc.netty.shaded.io.netty.buffer.bytebuf.checkAccessible";
    private static final String PROP_CHECK_ACCESSIBLE = "io.grpc.netty.shaded.io.netty.buffer.checkAccessible";
    static final boolean checkAccessible = SystemPropertyUtil.contains("io.grpc.netty.shaded.io.netty.buffer.checkAccessible") ? SystemPropertyUtil.getBoolean("io.grpc.netty.shaded.io.netty.buffer.checkAccessible", true) : SystemPropertyUtil.getBoolean("io.grpc.netty.shaded.io.netty.buffer.bytebuf.checkAccessible", true);
    private static final String PROP_CHECK_BOUNDS = "io.grpc.netty.shaded.io.netty.buffer.checkBounds";
    private static final boolean checkBounds = SystemPropertyUtil.getBoolean("io.grpc.netty.shaded.io.netty.buffer.checkBounds", true);
    static final ResourceLeakDetector<ByteBuf> leakDetector;
    int readerIndex;
    int writerIndex;
    private int markedReaderIndex;
    private int markedWriterIndex;
    private int maxCapacity;

    protected AbstractByteBuf(int n4) {
        ObjectUtil.checkPositiveOrZero(n4, "maxCapacity");
        this.maxCapacity = n4;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteBuf asReadOnly() {
        if (this.isReadOnly()) {
            return this;
        }
        return Unpooled.unmodifiableBuffer((ByteBuf)this);
    }

    @Override
    public int maxCapacity() {
        return this.maxCapacity;
    }

    protected final void maxCapacity(int n4) {
        this.maxCapacity = n4;
    }

    @Override
    public int readerIndex() {
        return this.readerIndex;
    }

    private static void checkIndexBounds(int n4, int n7, int n8) {
        if (n4 < 0 || n4 > n7 || n7 > n8) {
            throw new IndexOutOfBoundsException(String.format("readerIndex: %d, writerIndex: %d (expected: 0 <= readerIndex <= writerIndex <= capacity(%d))", n4, n7, n8));
        }
    }

    @Override
    public ByteBuf readerIndex(int n4) {
        if (checkBounds) {
            AbstractByteBuf.checkIndexBounds(n4, this.writerIndex, this.capacity());
        }
        this.readerIndex = n4;
        return this;
    }

    @Override
    public int writerIndex() {
        return this.writerIndex;
    }

    @Override
    public ByteBuf writerIndex(int n4) {
        if (checkBounds) {
            AbstractByteBuf.checkIndexBounds(this.readerIndex, n4, this.capacity());
        }
        this.writerIndex = n4;
        return this;
    }

    @Override
    public ByteBuf setIndex(int n4, int n7) {
        if (checkBounds) {
            AbstractByteBuf.checkIndexBounds(n4, n7, this.capacity());
        }
        this.setIndex0(n4, n7);
        return this;
    }

    @Override
    public ByteBuf clear() {
        this.writerIndex = 0;
        this.readerIndex = 0;
        return this;
    }

    @Override
    public boolean isReadable() {
        return this.writerIndex > this.readerIndex;
    }

    @Override
    public boolean isReadable(int n4) {
        return this.writerIndex - this.readerIndex >= n4;
    }

    @Override
    public boolean isWritable() {
        return this.capacity() > this.writerIndex;
    }

    @Override
    public boolean isWritable(int n4) {
        return this.capacity() - this.writerIndex >= n4;
    }

    @Override
    public int readableBytes() {
        return this.writerIndex - this.readerIndex;
    }

    @Override
    public int writableBytes() {
        return this.capacity() - this.writerIndex;
    }

    @Override
    public int maxWritableBytes() {
        return this.maxCapacity() - this.writerIndex;
    }

    @Override
    public ByteBuf markReaderIndex() {
        this.markedReaderIndex = this.readerIndex;
        return this;
    }

    @Override
    public ByteBuf resetReaderIndex() {
        this.readerIndex(this.markedReaderIndex);
        return this;
    }

    @Override
    public ByteBuf markWriterIndex() {
        this.markedWriterIndex = this.writerIndex;
        return this;
    }

    @Override
    public ByteBuf resetWriterIndex() {
        this.writerIndex(this.markedWriterIndex);
        return this;
    }

    @Override
    public ByteBuf discardReadBytes() {
        this.ensureAccessible();
        if (this.readerIndex == 0) {
            return this;
        }
        if (this.readerIndex != this.writerIndex) {
            this.setBytes(0, this, this.readerIndex, this.writerIndex - this.readerIndex);
            this.writerIndex -= this.readerIndex;
            this.adjustMarkers(this.readerIndex);
            this.readerIndex = 0;
        } else {
            this.adjustMarkers(this.readerIndex);
            this.readerIndex = 0;
            this.writerIndex = 0;
        }
        return this;
    }

    @Override
    public ByteBuf discardSomeReadBytes() {
        this.ensureAccessible();
        if (this.readerIndex == 0) {
            return this;
        }
        if (this.readerIndex == this.writerIndex) {
            this.adjustMarkers(this.readerIndex);
            this.readerIndex = 0;
            this.writerIndex = 0;
            return this;
        }
        if (this.readerIndex >= this.capacity() >>> 1) {
            this.setBytes(0, this, this.readerIndex, this.writerIndex - this.readerIndex);
            this.writerIndex -= this.readerIndex;
            this.adjustMarkers(this.readerIndex);
            this.readerIndex = 0;
        }
        return this;
    }

    protected final void adjustMarkers(int n4) {
        int n7 = this.markedReaderIndex;
        if (n7 <= n4) {
            this.markedReaderIndex = 0;
            int n8 = this.markedWriterIndex;
            this.markedWriterIndex = n8 <= n4 ? 0 : n8 - n4;
        } else {
            this.markedReaderIndex = n7 - n4;
            this.markedWriterIndex -= n4;
        }
    }

    @Override
    public ByteBuf ensureWritable(int n4) {
        ObjectUtil.checkPositiveOrZero(n4, "minWritableBytes");
        this.ensureWritable0(n4);
        return this;
    }

    final void ensureWritable0(int n4) {
        int n7;
        this.ensureAccessible();
        if (n4 <= this.writableBytes()) {
            return;
        }
        int n8 = this.writerIndex();
        if (checkBounds && n4 > this.maxCapacity - n8) {
            throw new IndexOutOfBoundsException(String.format("writerIndex(%d) + minWritableBytes(%d) exceeds maxCapacity(%d): %s", n8, n4, this.maxCapacity, this));
        }
        int n10 = n8 + n4;
        int n11 = this.alloc().calculateNewCapacity(n10, this.maxCapacity);
        if (n11 > (n7 = n8 + this.maxFastWritableBytes()) && n10 <= n7) {
            n11 = n7;
        }
        this.capacity(n11);
    }

    @Override
    public int ensureWritable(int n4, boolean bl3) {
        int n7;
        int n8;
        this.ensureAccessible();
        ObjectUtil.checkPositiveOrZero(n4, "minWritableBytes");
        if (n4 <= this.writableBytes()) {
            return 0;
        }
        int n10 = this.maxCapacity();
        if (n4 > n10 - (n8 = this.writerIndex())) {
            if (!bl3 || this.capacity() == n10) {
                return 1;
            }
            this.capacity(n10);
            return 3;
        }
        int n11 = n8 + n4;
        int n12 = this.alloc().calculateNewCapacity(n11, n10);
        if (n12 > (n7 = n8 + this.maxFastWritableBytes()) && n11 <= n7) {
            n12 = n7;
        }
        this.capacity(n12);
        return 2;
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        if (byteOrder == this.order()) {
            return this;
        }
        if (byteOrder == null) {
            throw new NullPointerException("endianness");
        }
        return this.newSwappedByteBuf();
    }

    protected SwappedByteBuf newSwappedByteBuf() {
        return new SwappedByteBuf(this);
    }

    @Override
    public byte getByte(int n4) {
        this.checkIndex(n4);
        return this._getByte(n4);
    }

    protected abstract byte _getByte(int var1);

    @Override
    public boolean getBoolean(int n4) {
        return this.getByte(n4) != 0;
    }

    @Override
    public short getUnsignedByte(int n4) {
        return (short)(this.getByte(n4) & 0xFF);
    }

    @Override
    public short getShort(int n4) {
        this.checkIndex(n4, 2);
        return this._getShort(n4);
    }

    protected abstract short _getShort(int var1);

    @Override
    public short getShortLE(int n4) {
        this.checkIndex(n4, 2);
        return this._getShortLE(n4);
    }

    protected abstract short _getShortLE(int var1);

    @Override
    public int getUnsignedShort(int n4) {
        return this.getShort(n4) & 0xFFFF;
    }

    @Override
    public int getUnsignedShortLE(int n4) {
        return this.getShortLE(n4) & 0xFFFF;
    }

    @Override
    public int getUnsignedMedium(int n4) {
        this.checkIndex(n4, 3);
        return this._getUnsignedMedium(n4);
    }

    protected abstract int _getUnsignedMedium(int var1);

    @Override
    public int getUnsignedMediumLE(int n4) {
        this.checkIndex(n4, 3);
        return this._getUnsignedMediumLE(n4);
    }

    protected abstract int _getUnsignedMediumLE(int var1);

    @Override
    public int getMedium(int n4) {
        int n7 = this.getUnsignedMedium(n4);
        if ((n7 & 0x800000) != 0) {
            n7 |= 0xFF000000;
        }
        return n7;
    }

    @Override
    public int getMediumLE(int n4) {
        int n7 = this.getUnsignedMediumLE(n4);
        if ((n7 & 0x800000) != 0) {
            n7 |= 0xFF000000;
        }
        return n7;
    }

    @Override
    public int getInt(int n4) {
        this.checkIndex(n4, 4);
        return this._getInt(n4);
    }

    protected abstract int _getInt(int var1);

    @Override
    public int getIntLE(int n4) {
        this.checkIndex(n4, 4);
        return this._getIntLE(n4);
    }

    protected abstract int _getIntLE(int var1);

    @Override
    public long getUnsignedInt(int n4) {
        return (long)this.getInt(n4) & 0xFFFFFFFFL;
    }

    @Override
    public long getUnsignedIntLE(int n4) {
        return (long)this.getIntLE(n4) & 0xFFFFFFFFL;
    }

    @Override
    public long getLong(int n4) {
        this.checkIndex(n4, 8);
        return this._getLong(n4);
    }

    protected abstract long _getLong(int var1);

    @Override
    public long getLongLE(int n4) {
        this.checkIndex(n4, 8);
        return this._getLongLE(n4);
    }

    protected abstract long _getLongLE(int var1);

    @Override
    public char getChar(int n4) {
        return (char)this.getShort(n4);
    }

    @Override
    public float getFloat(int n4) {
        return Float.intBitsToFloat(this.getInt(n4));
    }

    @Override
    public double getDouble(int n4) {
        return Double.longBitsToDouble(this.getLong(n4));
    }

    @Override
    public ByteBuf getBytes(int n4, byte[] byArray) {
        this.getBytes(n4, byArray, 0, byArray.length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuf byteBuf) {
        this.getBytes(n4, byteBuf, byteBuf.writableBytes());
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuf byteBuf, int n7) {
        this.getBytes(n4, byteBuf, byteBuf.writerIndex(), n7);
        byteBuf.writerIndex(byteBuf.writerIndex() + n7);
        return this;
    }

    @Override
    public CharSequence getCharSequence(int n4, int n7, Charset charset) {
        if (CharsetUtil.US_ASCII.equals(charset) || CharsetUtil.ISO_8859_1.equals(charset)) {
            return new AsciiString(ByteBufUtil.getBytes(this, n4, n7, true), false);
        }
        return this.toString(n4, n7, charset);
    }

    @Override
    public CharSequence readCharSequence(int n4, Charset charset) {
        CharSequence charSequence = this.getCharSequence(this.readerIndex, n4, charset);
        this.readerIndex += n4;
        return charSequence;
    }

    @Override
    public ByteBuf setByte(int n4, int n7) {
        this.checkIndex(n4);
        this._setByte(n4, n7);
        return this;
    }

    protected abstract void _setByte(int var1, int var2);

    @Override
    public ByteBuf setBoolean(int n4, boolean bl3) {
        this.setByte(n4, bl3 ? 1 : 0);
        return this;
    }

    @Override
    public ByteBuf setShort(int n4, int n7) {
        this.checkIndex(n4, 2);
        this._setShort(n4, n7);
        return this;
    }

    protected abstract void _setShort(int var1, int var2);

    @Override
    public ByteBuf setShortLE(int n4, int n7) {
        this.checkIndex(n4, 2);
        this._setShortLE(n4, n7);
        return this;
    }

    protected abstract void _setShortLE(int var1, int var2);

    @Override
    public ByteBuf setChar(int n4, int n7) {
        this.setShort(n4, n7);
        return this;
    }

    @Override
    public ByteBuf setMedium(int n4, int n7) {
        this.checkIndex(n4, 3);
        this._setMedium(n4, n7);
        return this;
    }

    protected abstract void _setMedium(int var1, int var2);

    @Override
    public ByteBuf setMediumLE(int n4, int n7) {
        this.checkIndex(n4, 3);
        this._setMediumLE(n4, n7);
        return this;
    }

    protected abstract void _setMediumLE(int var1, int var2);

    @Override
    public ByteBuf setInt(int n4, int n7) {
        this.checkIndex(n4, 4);
        this._setInt(n4, n7);
        return this;
    }

    protected abstract void _setInt(int var1, int var2);

    @Override
    public ByteBuf setIntLE(int n4, int n7) {
        this.checkIndex(n4, 4);
        this._setIntLE(n4, n7);
        return this;
    }

    protected abstract void _setIntLE(int var1, int var2);

    @Override
    public ByteBuf setFloat(int n4, float f8) {
        this.setInt(n4, Float.floatToRawIntBits(f8));
        return this;
    }

    @Override
    public ByteBuf setLong(int n4, long l2) {
        this.checkIndex(n4, 8);
        this._setLong(n4, l2);
        return this;
    }

    protected abstract void _setLong(int var1, long var2);

    @Override
    public ByteBuf setLongLE(int n4, long l2) {
        this.checkIndex(n4, 8);
        this._setLongLE(n4, l2);
        return this;
    }

    protected abstract void _setLongLE(int var1, long var2);

    @Override
    public ByteBuf setDouble(int n4, double d8) {
        this.setLong(n4, Double.doubleToRawLongBits(d8));
        return this;
    }

    @Override
    public ByteBuf setBytes(int n4, byte[] byArray) {
        this.setBytes(n4, byArray, 0, byArray.length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuf byteBuf) {
        this.setBytes(n4, byteBuf, byteBuf.readableBytes());
        return this;
    }

    private static void checkReadableBounds(ByteBuf byteBuf, int n4) {
        if (n4 > byteBuf.readableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds src.readableBytes(%d) where src is: %s", n4, byteBuf.readableBytes(), byteBuf));
        }
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuf byteBuf, int n7) {
        this.checkIndex(n4, n7);
        if (byteBuf == null) {
            throw new NullPointerException("src");
        }
        if (checkBounds) {
            AbstractByteBuf.checkReadableBounds(byteBuf, n7);
        }
        this.setBytes(n4, byteBuf, byteBuf.readerIndex(), n7);
        byteBuf.readerIndex(byteBuf.readerIndex() + n7);
        return this;
    }

    @Override
    public ByteBuf setZero(int n4, int n7) {
        int n8;
        if (n7 == 0) {
            return this;
        }
        this.checkIndex(n4, n7);
        int n10 = n7 >>> 3;
        int n11 = n7 & 7;
        for (n8 = n10; n8 > 0; --n8) {
            this._setLong(n4, 0L);
            n4 += 8;
        }
        if (n11 == 4) {
            this._setInt(n4, 0);
        } else if (n11 < 4) {
            for (n8 = n11; n8 > 0; --n8) {
                this._setByte(n4, 0);
                ++n4;
            }
        } else {
            this._setInt(n4, 0);
            n4 += 4;
            for (n8 = n11 - 4; n8 > 0; --n8) {
                this._setByte(n4, 0);
                ++n4;
            }
        }
        return this;
    }

    @Override
    public int setCharSequence(int n4, CharSequence charSequence, Charset charset) {
        return this.setCharSequence0(n4, charSequence, charset, false);
    }

    private int setCharSequence0(int n4, CharSequence charSequence, Charset charset, boolean bl3) {
        if (charset.equals(CharsetUtil.UTF_8)) {
            int n7 = ByteBufUtil.utf8MaxBytes(charSequence);
            if (bl3) {
                this.ensureWritable0(n7);
                this.checkIndex0(n4, n7);
            } else {
                this.checkIndex(n4, n7);
            }
            return ByteBufUtil.writeUtf8(this, n4, charSequence, charSequence.length());
        }
        if (charset.equals(CharsetUtil.US_ASCII) || charset.equals(CharsetUtil.ISO_8859_1)) {
            int n8 = charSequence.length();
            if (bl3) {
                this.ensureWritable0(n8);
                this.checkIndex0(n4, n8);
            } else {
                this.checkIndex(n4, n8);
            }
            return ByteBufUtil.writeAscii(this, n4, charSequence, n8);
        }
        byte[] byArray = charSequence.toString().getBytes(charset);
        if (bl3) {
            this.ensureWritable0(byArray.length);
        }
        this.setBytes(n4, byArray);
        return byArray.length;
    }

    @Override
    public byte readByte() {
        this.checkReadableBytes0(1);
        int n4 = this.readerIndex;
        byte by2 = this._getByte(n4);
        this.readerIndex = n4 + 1;
        return by2;
    }

    @Override
    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    @Override
    public short readUnsignedByte() {
        return (short)(this.readByte() & 0xFF);
    }

    @Override
    public short readShort() {
        this.checkReadableBytes0(2);
        short s11 = this._getShort(this.readerIndex);
        this.readerIndex += 2;
        return s11;
    }

    @Override
    public short readShortLE() {
        this.checkReadableBytes0(2);
        short s11 = this._getShortLE(this.readerIndex);
        this.readerIndex += 2;
        return s11;
    }

    @Override
    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int readUnsignedShortLE() {
        return this.readShortLE() & 0xFFFF;
    }

    @Override
    public int readMedium() {
        int n4 = this.readUnsignedMedium();
        if ((n4 & 0x800000) != 0) {
            n4 |= 0xFF000000;
        }
        return n4;
    }

    @Override
    public int readMediumLE() {
        int n4 = this.readUnsignedMediumLE();
        if ((n4 & 0x800000) != 0) {
            n4 |= 0xFF000000;
        }
        return n4;
    }

    @Override
    public int readUnsignedMedium() {
        this.checkReadableBytes0(3);
        int n4 = this._getUnsignedMedium(this.readerIndex);
        this.readerIndex += 3;
        return n4;
    }

    @Override
    public int readUnsignedMediumLE() {
        this.checkReadableBytes0(3);
        int n4 = this._getUnsignedMediumLE(this.readerIndex);
        this.readerIndex += 3;
        return n4;
    }

    @Override
    public int readInt() {
        this.checkReadableBytes0(4);
        int n4 = this._getInt(this.readerIndex);
        this.readerIndex += 4;
        return n4;
    }

    @Override
    public int readIntLE() {
        this.checkReadableBytes0(4);
        int n4 = this._getIntLE(this.readerIndex);
        this.readerIndex += 4;
        return n4;
    }

    @Override
    public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readUnsignedIntLE() {
        return (long)this.readIntLE() & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() {
        this.checkReadableBytes0(8);
        long l2 = this._getLong(this.readerIndex);
        this.readerIndex += 8;
        return l2;
    }

    @Override
    public long readLongLE() {
        this.checkReadableBytes0(8);
        long l2 = this._getLongLE(this.readerIndex);
        this.readerIndex += 8;
        return l2;
    }

    @Override
    public char readChar() {
        return (char)this.readShort();
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public ByteBuf readBytes(int n4) {
        this.checkReadableBytes(n4);
        if (n4 == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf byteBuf = this.alloc().buffer(n4, this.maxCapacity);
        byteBuf.writeBytes(this, this.readerIndex, n4);
        this.readerIndex += n4;
        return byteBuf;
    }

    @Override
    public ByteBuf readSlice(int n4) {
        this.checkReadableBytes(n4);
        ByteBuf byteBuf = this.slice(this.readerIndex, n4);
        this.readerIndex += n4;
        return byteBuf;
    }

    @Override
    public ByteBuf readRetainedSlice(int n4) {
        this.checkReadableBytes(n4);
        ByteBuf byteBuf = this.retainedSlice(this.readerIndex, n4);
        this.readerIndex += n4;
        return byteBuf;
    }

    @Override
    public ByteBuf readBytes(byte[] byArray, int n4, int n7) {
        this.checkReadableBytes(n7);
        this.getBytes(this.readerIndex, byArray, n4, n7);
        this.readerIndex += n7;
        return this;
    }

    @Override
    public ByteBuf readBytes(byte[] byArray) {
        this.readBytes(byArray, 0, byArray.length);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf) {
        this.readBytes(byteBuf, byteBuf.writableBytes());
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf, int n4) {
        if (checkBounds && n4 > byteBuf.writableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds dst.writableBytes(%d) where dst is: %s", n4, byteBuf.writableBytes(), byteBuf));
        }
        this.readBytes(byteBuf, byteBuf.writerIndex(), n4);
        byteBuf.writerIndex(byteBuf.writerIndex() + n4);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf, int n4, int n7) {
        this.checkReadableBytes(n7);
        this.getBytes(this.readerIndex, byteBuf, n4, n7);
        this.readerIndex += n7;
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        int n4 = byteBuffer.remaining();
        this.checkReadableBytes(n4);
        this.getBytes(this.readerIndex, byteBuffer);
        this.readerIndex += n4;
        return this;
    }

    @Override
    public int readBytes(GatheringByteChannel gatheringByteChannel, int n4) {
        this.checkReadableBytes(n4);
        int n7 = this.getBytes(this.readerIndex, gatheringByteChannel, n4);
        this.readerIndex += n7;
        return n7;
    }

    @Override
    public int readBytes(FileChannel fileChannel, long l2, int n4) {
        this.checkReadableBytes(n4);
        int n7 = this.getBytes(this.readerIndex, fileChannel, l2, n4);
        this.readerIndex += n7;
        return n7;
    }

    @Override
    public ByteBuf readBytes(OutputStream outputStream, int n4) {
        this.checkReadableBytes(n4);
        this.getBytes(this.readerIndex, outputStream, n4);
        this.readerIndex += n4;
        return this;
    }

    @Override
    public ByteBuf skipBytes(int n4) {
        this.checkReadableBytes(n4);
        this.readerIndex += n4;
        return this;
    }

    @Override
    public ByteBuf writeBoolean(boolean bl3) {
        this.writeByte(bl3 ? 1 : 0);
        return this;
    }

    @Override
    public ByteBuf writeByte(int n4) {
        this.ensureWritable0(1);
        this._setByte(this.writerIndex++, n4);
        return this;
    }

    @Override
    public ByteBuf writeShort(int n4) {
        this.ensureWritable0(2);
        this._setShort(this.writerIndex, n4);
        this.writerIndex += 2;
        return this;
    }

    @Override
    public ByteBuf writeShortLE(int n4) {
        this.ensureWritable0(2);
        this._setShortLE(this.writerIndex, n4);
        this.writerIndex += 2;
        return this;
    }

    @Override
    public ByteBuf writeMedium(int n4) {
        this.ensureWritable0(3);
        this._setMedium(this.writerIndex, n4);
        this.writerIndex += 3;
        return this;
    }

    @Override
    public ByteBuf writeMediumLE(int n4) {
        this.ensureWritable0(3);
        this._setMediumLE(this.writerIndex, n4);
        this.writerIndex += 3;
        return this;
    }

    @Override
    public ByteBuf writeInt(int n4) {
        this.ensureWritable0(4);
        this._setInt(this.writerIndex, n4);
        this.writerIndex += 4;
        return this;
    }

    @Override
    public ByteBuf writeIntLE(int n4) {
        this.ensureWritable0(4);
        this._setIntLE(this.writerIndex, n4);
        this.writerIndex += 4;
        return this;
    }

    @Override
    public ByteBuf writeLong(long l2) {
        this.ensureWritable0(8);
        this._setLong(this.writerIndex, l2);
        this.writerIndex += 8;
        return this;
    }

    @Override
    public ByteBuf writeLongLE(long l2) {
        this.ensureWritable0(8);
        this._setLongLE(this.writerIndex, l2);
        this.writerIndex += 8;
        return this;
    }

    @Override
    public ByteBuf writeChar(int n4) {
        this.writeShort(n4);
        return this;
    }

    @Override
    public ByteBuf writeFloat(float f8) {
        this.writeInt(Float.floatToRawIntBits(f8));
        return this;
    }

    @Override
    public ByteBuf writeDouble(double d8) {
        this.writeLong(Double.doubleToRawLongBits(d8));
        return this;
    }

    @Override
    public ByteBuf writeBytes(byte[] byArray, int n4, int n7) {
        this.ensureWritable(n7);
        this.setBytes(this.writerIndex, byArray, n4, n7);
        this.writerIndex += n7;
        return this;
    }

    @Override
    public ByteBuf writeBytes(byte[] byArray) {
        this.writeBytes(byArray, 0, byArray.length);
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf) {
        this.writeBytes(byteBuf, byteBuf.readableBytes());
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf, int n4) {
        if (checkBounds) {
            AbstractByteBuf.checkReadableBounds(byteBuf, n4);
        }
        this.writeBytes(byteBuf, byteBuf.readerIndex(), n4);
        byteBuf.readerIndex(byteBuf.readerIndex() + n4);
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf, int n4, int n7) {
        this.ensureWritable(n7);
        this.setBytes(this.writerIndex, byteBuf, n4, n7);
        this.writerIndex += n7;
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuffer byteBuffer) {
        int n4 = byteBuffer.remaining();
        this.ensureWritable0(n4);
        this.setBytes(this.writerIndex, byteBuffer);
        this.writerIndex += n4;
        return this;
    }

    @Override
    public int writeBytes(InputStream inputStream, int n4) {
        this.ensureWritable(n4);
        int n7 = this.setBytes(this.writerIndex, inputStream, n4);
        if (n7 > 0) {
            this.writerIndex += n7;
        }
        return n7;
    }

    @Override
    public int writeBytes(ScatteringByteChannel scatteringByteChannel, int n4) {
        this.ensureWritable(n4);
        int n7 = this.setBytes(this.writerIndex, scatteringByteChannel, n4);
        if (n7 > 0) {
            this.writerIndex += n7;
        }
        return n7;
    }

    @Override
    public int writeBytes(FileChannel fileChannel, long l2, int n4) {
        this.ensureWritable(n4);
        int n7 = this.setBytes(this.writerIndex, fileChannel, l2, n4);
        if (n7 > 0) {
            this.writerIndex += n7;
        }
        return n7;
    }

    @Override
    public ByteBuf writeZero(int n4) {
        int n7;
        if (n4 == 0) {
            return this;
        }
        this.ensureWritable(n4);
        int n8 = this.writerIndex;
        this.checkIndex0(n8, n4);
        int n10 = n4 >>> 3;
        int n11 = n4 & 7;
        for (n7 = n10; n7 > 0; --n7) {
            this._setLong(n8, 0L);
            n8 += 8;
        }
        if (n11 == 4) {
            this._setInt(n8, 0);
            n8 += 4;
        } else if (n11 < 4) {
            for (n7 = n11; n7 > 0; --n7) {
                this._setByte(n8, 0);
                ++n8;
            }
        } else {
            this._setInt(n8, 0);
            n8 += 4;
            for (n7 = n11 - 4; n7 > 0; --n7) {
                this._setByte(n8, 0);
                ++n8;
            }
        }
        this.writerIndex = n8;
        return this;
    }

    @Override
    public int writeCharSequence(CharSequence charSequence, Charset charset) {
        int n4 = this.setCharSequence0(this.writerIndex, charSequence, charset, true);
        this.writerIndex += n4;
        return n4;
    }

    @Override
    public ByteBuf copy() {
        return this.copy(this.readerIndex, this.readableBytes());
    }

    @Override
    public ByteBuf duplicate() {
        this.ensureAccessible();
        return new UnpooledDuplicatedByteBuf(this);
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return this.duplicate().retain();
    }

    @Override
    public ByteBuf slice() {
        return this.slice(this.readerIndex, this.readableBytes());
    }

    @Override
    public ByteBuf retainedSlice() {
        return this.slice().retain();
    }

    @Override
    public ByteBuf slice(int n4, int n7) {
        this.ensureAccessible();
        return new UnpooledSlicedByteBuf(this, n4, n7);
    }

    @Override
    public ByteBuf retainedSlice(int n4, int n7) {
        return this.slice(n4, n7).retain();
    }

    @Override
    public ByteBuffer nioBuffer() {
        return this.nioBuffer(this.readerIndex, this.readableBytes());
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        return this.nioBuffers(this.readerIndex, this.readableBytes());
    }

    @Override
    public String toString(Charset charset) {
        return this.toString(this.readerIndex, this.readableBytes(), charset);
    }

    @Override
    public String toString(int n4, int n7, Charset charset) {
        return ByteBufUtil.decodeString(this, n4, n7, charset);
    }

    @Override
    public int indexOf(int n4, int n7, byte by2) {
        return ByteBufUtil.indexOf(this, n4, n7, by2);
    }

    @Override
    public int bytesBefore(byte by2) {
        return this.bytesBefore(this.readerIndex(), this.readableBytes(), by2);
    }

    @Override
    public int bytesBefore(int n4, byte by2) {
        this.checkReadableBytes(n4);
        return this.bytesBefore(this.readerIndex(), n4, by2);
    }

    @Override
    public int bytesBefore(int n4, int n7, byte by2) {
        int n8 = this.indexOf(n4, n4 + n7, by2);
        if (n8 < 0) {
            return -1;
        }
        return n8 - n4;
    }

    @Override
    public int forEachByte(ByteProcessor byteProcessor) {
        this.ensureAccessible();
        try {
            return this.forEachByteAsc0(this.readerIndex, this.writerIndex, byteProcessor);
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
            return -1;
        }
    }

    @Override
    public int forEachByte(int n4, int n7, ByteProcessor byteProcessor) {
        this.checkIndex(n4, n7);
        try {
            return this.forEachByteAsc0(n4, n4 + n7, byteProcessor);
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
            return -1;
        }
    }

    int forEachByteAsc0(int n4, int n7, ByteProcessor byteProcessor) {
        while (n4 < n7) {
            if (!byteProcessor.process(this._getByte(n4))) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    @Override
    public int forEachByteDesc(ByteProcessor byteProcessor) {
        this.ensureAccessible();
        try {
            return this.forEachByteDesc0(this.writerIndex - 1, this.readerIndex, byteProcessor);
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
            return -1;
        }
    }

    @Override
    public int forEachByteDesc(int n4, int n7, ByteProcessor byteProcessor) {
        this.checkIndex(n4, n7);
        try {
            return this.forEachByteDesc0(n4 + n7 - 1, n4, byteProcessor);
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
            return -1;
        }
    }

    int forEachByteDesc0(int n4, int n7, ByteProcessor byteProcessor) {
        while (n4 >= n7) {
            if (!byteProcessor.process(this._getByte(n4))) {
                return n4;
            }
            --n4;
        }
        return -1;
    }

    @Override
    public int hashCode() {
        return ByteBufUtil.hashCode(this);
    }

    @Override
    public boolean equals(Object object) {
        return this == object || object instanceof ByteBuf && ByteBufUtil.equals(this, (ByteBuf)object);
    }

    @Override
    public int compareTo(ByteBuf byteBuf) {
        return ByteBufUtil.compare(this, byteBuf);
    }

    @Override
    public String toString() {
        ByteBuf byteBuf;
        if (this.refCnt() == 0) {
            return StringUtil.simpleClassName(this) + "(freed)";
        }
        StringBuilder stringBuilder = new StringBuilder().append(StringUtil.simpleClassName(this)).append("(ridx: ").append(this.readerIndex).append(", widx: ").append(this.writerIndex).append(", cap: ").append(this.capacity());
        if (this.maxCapacity != Integer.MAX_VALUE) {
            stringBuilder.append('/').append(this.maxCapacity);
        }
        if ((byteBuf = this.unwrap()) != null) {
            stringBuilder.append(", unwrapped: ").append(byteBuf);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    protected final void checkIndex(int n4) {
        this.checkIndex(n4, 1);
    }

    protected final void checkIndex(int n4, int n7) {
        this.ensureAccessible();
        this.checkIndex0(n4, n7);
    }

    private static void checkRangeBounds(String string, int n4, int n7, int n8) {
        if (MathUtil.isOutOfBounds(n4, n7, n8)) {
            throw new IndexOutOfBoundsException(String.format("%s: %d, length: %d (expected: range(0, %d))", string, n4, n7, n8));
        }
    }

    final void checkIndex0(int n4, int n7) {
        if (checkBounds) {
            AbstractByteBuf.checkRangeBounds("index", n4, n7, this.capacity());
        }
    }

    protected final void checkSrcIndex(int n4, int n7, int n8, int n10) {
        this.checkIndex(n4, n7);
        if (checkBounds) {
            AbstractByteBuf.checkRangeBounds("srcIndex", n8, n7, n10);
        }
    }

    protected final void checkDstIndex(int n4, int n7, int n8, int n10) {
        this.checkIndex(n4, n7);
        if (checkBounds) {
            AbstractByteBuf.checkRangeBounds("dstIndex", n8, n7, n10);
        }
    }

    protected final void checkDstIndex(int n4, int n7, int n8) {
        this.checkReadableBytes(n4);
        if (checkBounds) {
            AbstractByteBuf.checkRangeBounds("dstIndex", n7, n4, n8);
        }
    }

    protected final void checkReadableBytes(int n4) {
        ObjectUtil.checkPositiveOrZero(n4, "minimumReadableBytes");
        this.checkReadableBytes0(n4);
    }

    protected final void checkNewCapacity(int n4) {
        this.ensureAccessible();
        if (checkBounds && (n4 < 0 || n4 > this.maxCapacity())) {
            throw new IllegalArgumentException("newCapacity: " + n4 + " (expected: 0-" + this.maxCapacity() + ')');
        }
    }

    private void checkReadableBytes0(int n4) {
        this.ensureAccessible();
        if (checkBounds && this.readerIndex > this.writerIndex - n4) {
            throw new IndexOutOfBoundsException(String.format("readerIndex(%d) + length(%d) exceeds writerIndex(%d): %s", this.readerIndex, n4, this.writerIndex, this));
        }
    }

    protected final void ensureAccessible() {
        if (checkAccessible && !this.isAccessible()) {
            throw new IllegalReferenceCountException(0);
        }
    }

    final void setIndex0(int n4, int n7) {
        this.readerIndex = n4;
        this.writerIndex = n7;
    }

    final void discardMarks() {
        this.markedWriterIndex = 0;
        this.markedReaderIndex = 0;
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-D{}: {}", (Object)PROP_CHECK_ACCESSIBLE, (Object)checkAccessible);
            logger.debug("-D{}: {}", (Object)PROP_CHECK_BOUNDS, (Object)checkBounds);
        }
        leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ByteBuf.class);
    }
}

