/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.bootstrap;

import io.grpc.netty.shaded.io.netty.bootstrap.AbstractBootstrap;
import io.grpc.netty.shaded.io.netty.bootstrap.ServerBootstrap$1;
import io.grpc.netty.shaded.io.netty.bootstrap.ServerBootstrapConfig;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.ServerChannel;
import io.grpc.netty.shaded.io.netty.util.AbstractConstant;
import io.grpc.netty.shaded.io.netty.util.AttributeKey;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.LinkedHashMap;
import java.util.Map;

public class ServerBootstrap
extends AbstractBootstrap<ServerBootstrap, ServerChannel> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ServerBootstrap.class);
    private final Map<ChannelOption<?>, Object> childOptions = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> childAttrs = new LinkedHashMap();
    private final ServerBootstrapConfig config = new ServerBootstrapConfig(this);
    private volatile EventLoopGroup childGroup;
    private volatile ChannelHandler childHandler;

    public ServerBootstrap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerBootstrap(ServerBootstrap serverBootstrap) {
        super(serverBootstrap);
        this.childGroup = serverBootstrap.childGroup;
        this.childHandler = serverBootstrap.childHandler;
        Map<AbstractConstant, Object> map = serverBootstrap.childOptions;
        synchronized (map) {
            this.childOptions.putAll(serverBootstrap.childOptions);
        }
        map = serverBootstrap.childAttrs;
        synchronized (map) {
            this.childAttrs.putAll(serverBootstrap.childAttrs);
        }
    }

    @Override
    public ServerBootstrap group(EventLoopGroup eventLoopGroup) {
        return this.group(eventLoopGroup, eventLoopGroup);
    }

    public ServerBootstrap group(EventLoopGroup eventLoopGroup, EventLoopGroup eventLoopGroup2) {
        super.group(eventLoopGroup);
        ObjectUtil.checkNotNull(eventLoopGroup2, "childGroup");
        if (this.childGroup != null) {
            throw new IllegalStateException("childGroup set already");
        }
        this.childGroup = eventLoopGroup2;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ServerBootstrap childOption(ChannelOption<T> channelOption, T t3) {
        ObjectUtil.checkNotNull(channelOption, "childOption");
        if (t3 == null) {
            Map<ChannelOption<?>, Object> map = this.childOptions;
            synchronized (map) {
                this.childOptions.remove(channelOption);
            }
        }
        Map<ChannelOption<?>, Object> map = this.childOptions;
        synchronized (map) {
            this.childOptions.put(channelOption, t3);
        }
        return this;
    }

    public <T> ServerBootstrap childAttr(AttributeKey<T> attributeKey, T t3) {
        ObjectUtil.checkNotNull(attributeKey, "childKey");
        if (t3 == null) {
            this.childAttrs.remove(attributeKey);
        } else {
            this.childAttrs.put(attributeKey, t3);
        }
        return this;
    }

    public ServerBootstrap childHandler(ChannelHandler channelHandler) {
        this.childHandler = ObjectUtil.checkNotNull(channelHandler, "childHandler");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void init(Channel channel) {
        Map.Entry[] entryArray;
        Map.Entry[] entryArray2;
        Map<ChannelOption<?>, Object> map = this.options0();
        Map<AbstractConstant, Object> map2 = map;
        synchronized (map2) {
            ServerBootstrap.setChannelOptions(channel, map, logger);
        }
        map2 = this.attrs0();
        Object object2 = map2;
        synchronized (object2) {
            for (Map.Entry<AbstractConstant, Object> object3 : map2.entrySet()) {
                entryArray2 = (Map.Entry[])object3.getKey();
                channel.attr(entryArray2).set(object3.getValue());
            }
        }
        object2 = channel.pipeline();
        EventLoopGroup eventLoopGroup = this.childGroup;
        ChannelHandler channelHandler = this.childHandler;
        Map<AbstractConstant, Object> map3 = this.childOptions;
        synchronized (map3) {
            entryArray2 = this.childOptions.entrySet().toArray(ServerBootstrap.newOptionArray(0));
        }
        map3 = this.childAttrs;
        synchronized (map3) {
            entryArray = this.childAttrs.entrySet().toArray(ServerBootstrap.newAttrArray(0));
        }
        object2.addLast(new ServerBootstrap$1(this, eventLoopGroup, channelHandler, entryArray2, entryArray));
    }

    @Override
    public ServerBootstrap validate() {
        super.validate();
        if (this.childHandler == null) {
            throw new IllegalStateException("childHandler not set");
        }
        if (this.childGroup == null) {
            logger.warn("childGroup is not set. Using parentGroup instead.");
            this.childGroup = this.config.group();
        }
        return this;
    }

    private static Map.Entry<AttributeKey<?>, Object>[] newAttrArray(int n4) {
        return new Map.Entry[n4];
    }

    private static Map.Entry<ChannelOption<?>, Object>[] newOptionArray(int n4) {
        return new Map.Entry[n4];
    }

    @Override
    public ServerBootstrap clone() {
        return new ServerBootstrap(this);
    }

    @Deprecated
    public EventLoopGroup childGroup() {
        return this.childGroup;
    }

    final ChannelHandler childHandler() {
        return this.childHandler;
    }

    final Map<ChannelOption<?>, Object> childOptions() {
        return ServerBootstrap.copiedMap(this.childOptions);
    }

    final Map<AttributeKey<?>, Object> childAttrs() {
        return ServerBootstrap.copiedMap(this.childAttrs);
    }

    public final ServerBootstrapConfig config() {
        return this.config;
    }

    static /* synthetic */ ServerBootstrapConfig access$000(ServerBootstrap serverBootstrap) {
        return serverBootstrap.config;
    }

    static /* synthetic */ InternalLogger access$100() {
        return logger;
    }
}

