/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.bootstrap;

import io.grpc.netty.shaded.io.netty.bootstrap.AbstractBootstrap;
import io.grpc.netty.shaded.io.netty.bootstrap.ServerBootstrap;
import io.grpc.netty.shaded.io.netty.bootstrap.ServerBootstrap$ServerBootstrapAcceptor$1;
import io.grpc.netty.shaded.io.netty.bootstrap.ServerBootstrap$ServerBootstrapAcceptor$2;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelConfig;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.util.AttributeKey;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class ServerBootstrap$ServerBootstrapAcceptor
extends ChannelInboundHandlerAdapter {
    private final EventLoopGroup childGroup;
    private final ChannelHandler childHandler;
    private final Map.Entry<ChannelOption<?>, Object>[] childOptions;
    private final Map.Entry<AttributeKey<?>, Object>[] childAttrs;
    private final Runnable enableAutoReadTask;

    ServerBootstrap$ServerBootstrapAcceptor(Channel channel, EventLoopGroup eventLoopGroup, ChannelHandler channelHandler, Map.Entry<ChannelOption<?>, Object>[] entryArray, Map.Entry<AttributeKey<?>, Object>[] entryArray2) {
        this.childGroup = eventLoopGroup;
        this.childHandler = channelHandler;
        this.childOptions = entryArray;
        this.childAttrs = entryArray2;
        this.enableAutoReadTask = new ServerBootstrap$ServerBootstrapAcceptor$1(this, channel);
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        Channel channel = (Channel)object;
        channel.pipeline().addLast(this.childHandler);
        AbstractBootstrap.setChannelOptions(channel, this.childOptions, ServerBootstrap.access$100());
        for (Map.Entry<AttributeKey<?>, Object> entry : this.childAttrs) {
            channel.attr(entry.getKey()).set(entry.getValue());
        }
        try {
            this.childGroup.register(channel).addListener(new ServerBootstrap$ServerBootstrapAcceptor$2(this, channel));
        }
        catch (Throwable throwable) {
            ServerBootstrap$ServerBootstrapAcceptor.forceClose(channel, throwable);
        }
    }

    private static void forceClose(Channel channel, Throwable throwable) {
        channel.unsafe().closeForcibly();
        ServerBootstrap.access$100().warn("Failed to register an accepted channel: {}", (Object)channel, (Object)throwable);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        ChannelConfig channelConfig = channelHandlerContext.channel().config();
        if (channelConfig.isAutoRead()) {
            channelConfig.setAutoRead(false);
            channelHandlerContext.channel().eventLoop().schedule(this.enableAutoReadTask, 1L, TimeUnit.SECONDS);
        }
        channelHandlerContext.fireExceptionCaught(throwable);
    }

    static /* synthetic */ void access$200(Channel channel, Throwable throwable) {
        ServerBootstrap$ServerBootstrapAcceptor.forceClose(channel, throwable);
    }
}

