/*
 * Decompiled with CFR 0.152.
 */
package com.perfdog.core.ios.libpdusb.plist;

import com.perfdog.core.ios.libpdusb.ctypes.Result;
import com.perfdog.core.ios.libpdusb.ctypes.ResultLong;
import com.perfdog.core.ios.libpdusb.ctypes.ResultStrings;
import com.perfdog.core.ios.libpdusb.plist.PlistBool;
import com.perfdog.core.ios.libpdusb.plist.PlistData;
import com.perfdog.core.ios.libpdusb.plist.PlistDate;
import com.perfdog.core.ios.libpdusb.plist.PlistInt;
import com.perfdog.core.ios.libpdusb.plist.PlistNode;
import com.perfdog.core.ios.libpdusb.plist.PlistReal;
import com.perfdog.core.ios.libpdusb.plist.PlistString;
import com.perfdog.core.ios.libpdusb.plist.PlistUid;
import com.wex;
import java.util.List;

public class PlistDictionary
extends PlistNode {
    PlistDictionary(long l2) {
        super(l2);
    }

    public static PlistDictionary makeDictionary() {
        ResultLong resultLong = PlistDictionary.nativeMake();
        wex.ej(resultLong);
        return new PlistDictionary(resultLong.get());
    }

    public List<String> getKeys() {
        ResultStrings resultStrings = PlistDictionary.nativeGetKeys(this.getHandle());
        wex.ej(resultStrings);
        return resultStrings.get();
    }

    public Boolean getBool(String string) {
        try (PlistBool plistBool = (PlistBool)this.get(string);){
            if (plistBool != null) {
                Boolean bl3 = plistBool.getValue();
                return bl3;
            }
            Boolean bl4 = null;
            return bl4;
        }
    }

    public Long getInt(String string) {
        try (PlistInt plistInt = (PlistInt)this.get(string);){
            if (plistInt != null) {
                Long l2 = plistInt.getValue();
                return l2;
            }
            Long l10 = null;
            return l10;
        }
    }

    public Long getUid(String string) {
        try (PlistUid plistUid = (PlistUid)this.get(string);){
            if (plistUid != null) {
                Long l2 = plistUid.getValue();
                return l2;
            }
            Long l10 = null;
            return l10;
        }
    }

    public String getString(String string) {
        try (PlistString plistString = (PlistString)this.get(string);){
            if (plistString != null) {
                String string2 = plistString.getValue();
                return string2;
            }
            String string3 = null;
            return string3;
        }
    }

    public Double getReal(String string) {
        try (PlistReal plistReal = (PlistReal)this.get(string);){
            if (plistReal != null) {
                Double d8 = plistReal.getValue();
                return d8;
            }
            Double d10 = null;
            return d10;
        }
    }

    public Double getDate(String string) {
        try (PlistDate plistDate = (PlistDate)this.get(string);){
            if (plistDate != null) {
                Double d8 = plistDate.getValue();
                return d8;
            }
            Double d10 = null;
            return d10;
        }
    }

    public byte[] getData(String string) {
        try (PlistData plistData = (PlistData)this.get(string);){
            if (plistData != null) {
                byte[] byArray = plistData.getValue();
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
    }

    public PlistNode get(String string) {
        ResultLong resultLong = PlistDictionary.nativeGet(this.getHandle(), string);
        wex.ej(resultLong);
        return PlistDictionary.makeNode(resultLong.get());
    }

    public void insertBool(String string, boolean bl3) {
        try (PlistBool plistBool = PlistBool.makeBool(bl3);){
            this.insert(string, plistBool);
        }
    }

    public void insertInt(String string, long l2) {
        try (PlistInt plistInt = PlistInt.makeInt(l2);){
            this.insert(string, plistInt);
        }
    }

    public void insertUid(String string, long l2) {
        try (PlistUid plistUid = PlistUid.makeUid(l2);){
            this.insert(string, plistUid);
        }
    }

    public void insertString(String string, String string2) {
        try (PlistString plistString = PlistString.makeString(string2);){
            this.insert(string, plistString);
        }
    }

    public void insertReal(String string, double d8) {
        try (PlistReal plistReal = PlistReal.makeReal(d8);){
            this.insert(string, plistReal);
        }
    }

    public void insertDate(String string, double d8) {
        try (PlistDate plistDate = PlistDate.makeDate(d8);){
            this.insert(string, plistDate);
        }
    }

    public void insertData(String string, byte[] byArray) {
        try (PlistData plistData = PlistData.makeData(byArray);){
            this.insert(string, plistData);
        }
    }

    public void insert(String string, PlistNode plistNode) {
        Result result = PlistDictionary.nativeInsert(this.getHandle(), string, plistNode.getHandle());
        wex.ej(result);
    }

    private static native ResultLong nativeMake();

    private static native ResultStrings nativeGetKeys(long var0);

    private static native ResultLong nativeGet(long var0, String var2);

    private static native Result nativeInsert(long var0, String var2, long var3);
}

