/*
 * Decompiled with CFR 0.152.
 */
package com.perfdog.core.ios.libpdusb.plist;

import com.perfdog.core.ios.libpdusb.ctypes.Result;
import com.perfdog.core.ios.libpdusb.ctypes.ResultLong;
import com.perfdog.core.ios.libpdusb.plist.PlistBool;
import com.perfdog.core.ios.libpdusb.plist.PlistData;
import com.perfdog.core.ios.libpdusb.plist.PlistDate;
import com.perfdog.core.ios.libpdusb.plist.PlistInt;
import com.perfdog.core.ios.libpdusb.plist.PlistNode;
import com.perfdog.core.ios.libpdusb.plist.PlistReal;
import com.perfdog.core.ios.libpdusb.plist.PlistString;
import com.perfdog.core.ios.libpdusb.plist.PlistUid;
import com.wex;

public class PlistArray
extends PlistNode {
    PlistArray(long l2) {
        super(l2);
    }

    public static PlistArray makeArray() {
        ResultLong resultLong = PlistArray.nativeMake();
        wex.ej(resultLong);
        return new PlistArray(resultLong.get());
    }

    public int getCount() {
        ResultLong resultLong = PlistArray.nativeGetCount(this.getHandle());
        wex.ej(resultLong);
        return (int)resultLong.get();
    }

    public boolean getBool(int n4) {
        try (PlistBool plistBool = (PlistBool)this.get(n4);){
            boolean bl3 = plistBool.getValue();
            return bl3;
        }
    }

    public long getInt(int n4) {
        try (PlistInt plistInt = (PlistInt)this.get(n4);){
            long l2 = plistInt.getValue();
            return l2;
        }
    }

    public long getUid(int n4) {
        try (PlistUid plistUid = (PlistUid)this.get(n4);){
            long l2 = plistUid.getValue();
            return l2;
        }
    }

    public double getReal(int n4) {
        try (PlistReal plistReal = (PlistReal)this.get(n4);){
            double d8 = plistReal.getValue();
            return d8;
        }
    }

    public String getString(int n4) {
        try (PlistString plistString = (PlistString)this.get(n4);){
            String string = plistString.getValue();
            return string;
        }
    }

    public double getDate(int n4) {
        try (PlistDate plistDate = (PlistDate)this.get(n4);){
            double d8 = plistDate.getValue();
            return d8;
        }
    }

    public byte[] getData(int n4) {
        try (PlistData plistData = (PlistData)this.get(n4);){
            byte[] byArray = plistData.getValue();
            return byArray;
        }
    }

    public PlistNode get(int n4) {
        ResultLong resultLong = PlistArray.nativeGet(this.getHandle(), n4);
        wex.ej(resultLong);
        return PlistArray.makeNode(resultLong.get());
    }

    public void appendBool(boolean bl3) {
        try (PlistBool plistBool = PlistBool.makeBool(bl3);){
            this.append(plistBool);
        }
    }

    public void appendInt(long l2) {
        try (PlistInt plistInt = PlistInt.makeInt(l2);){
            this.append(plistInt);
        }
    }

    public void appendUid(long l2) {
        try (PlistUid plistUid = PlistUid.makeUid(l2);){
            this.append(plistUid);
        }
    }

    public void appendReal(double d8) {
        try (PlistReal plistReal = PlistReal.makeReal(d8);){
            this.append(plistReal);
        }
    }

    public void appendString(String string) {
        try (PlistString plistString = PlistString.makeString(string);){
            this.append(plistString);
        }
    }

    public void appendDate(double d8) {
        try (PlistDate plistDate = PlistDate.makeDate(d8);){
            this.append(plistDate);
        }
    }

    public void appendData(byte[] byArray) {
        try (PlistData plistData = PlistData.makeData(byArray);){
            this.append(plistData);
        }
    }

    public void append(PlistNode plistNode) {
        Result result = PlistArray.nativeAppend(this.getHandle(), plistNode.getHandle());
        wex.ej(result);
    }

    private static native ResultLong nativeMake();

    private static native ResultLong nativeGetCount(long var0);

    private static native ResultLong nativeGet(long var0, int var2);

    private static native Result nativeAppend(long var0, long var2);
}

