/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.validation;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.scene.control.Control;
import org.controlsfx.tools.ValueExtractor;
import org.controlsfx.validation.ValidationMessage;
import org.controlsfx.validation.ValidationResult;
import org.controlsfx.validation.Validator;
import org.controlsfx.validation.decoration.GraphicValidationDecoration;
import org.controlsfx.validation.decoration.ValidationDecoration;

public class ValidationSupport {
    private static final String CTRL_REQUIRED_FLAG = "$org.controlsfx.validation.required$";
    private ObservableSet<Control> controls = FXCollections.observableSet((Object[])new Control[0]);
    private ObservableMap<Control, ValidationResult> validationResults = FXCollections.observableMap(new WeakHashMap());
    private AtomicBoolean dataChanged = new AtomicBoolean(false);
    private BooleanProperty errorDecorationEnabledProperty = new SimpleBooleanProperty(true){

        protected void invalidated() {
            ValidationSupport.this.redecorate();
        }
    };
    private ReadOnlyObjectWrapper<ValidationResult> validationResultProperty = new ReadOnlyObjectWrapper();
    private BooleanProperty invalidProperty = new SimpleBooleanProperty();
    private ObjectProperty<ValidationDecoration> validationDecoratorProperty = new SimpleObjectProperty<ValidationDecoration>((Object)this, "validationDecorator", (ValidationDecoration)new GraphicValidationDecoration()){

        protected void invalidated() {
            ValidationSupport.this.redecorate();
        }
    };

    public static void setRequired(Control c, boolean required) {
        c.getProperties().put((Object)CTRL_REQUIRED_FLAG, (Object)required);
    }

    public static boolean isRequired(Control c) {
        Object value = c.getProperties().get((Object)CTRL_REQUIRED_FLAG);
        return value instanceof Boolean ? (Boolean)value : false;
    }

    public ValidationSupport() {
        this.validationResultProperty().addListener((o, oldValue, validationResult) -> {
            this.invalidProperty.set(!validationResult.getErrors().isEmpty());
            this.redecorate();
        });
        this.validationResults.addListener(change -> this.validationResultProperty.set((Object)ValidationResult.fromResults(this.validationResults.values())));
    }

    public void initInitialDecoration() {
        this.dataChanged.set(true);
        this.redecorate();
    }

    public void redecorate() {
        Optional<ValidationDecoration> odecorator = Optional.ofNullable(this.getValidationDecorator());
        for (Control target : this.getRegisteredControls()) {
            odecorator.ifPresent(decorator -> {
                decorator.removeDecorations(target);
                decorator.applyRequiredDecoration(target);
                if (this.dataChanged.get() && this.isErrorDecorationEnabled()) {
                    this.getHighestMessage(target).ifPresent(msg -> decorator.applyValidationDecoration((ValidationMessage)msg));
                }
            });
        }
    }

    public BooleanProperty errorDecorationEnabledProperty() {
        return this.errorDecorationEnabledProperty;
    }

    public void setErrorDecorationEnabled(boolean enabled) {
        this.errorDecorationEnabledProperty.set(enabled);
    }

    private boolean isErrorDecorationEnabled() {
        return this.errorDecorationEnabledProperty.get();
    }

    public ValidationResult getValidationResult() {
        return (ValidationResult)this.validationResultProperty.get();
    }

    public ReadOnlyObjectProperty<ValidationResult> validationResultProperty() {
        return this.validationResultProperty.getReadOnlyProperty();
    }

    public Boolean isInvalid() {
        return this.invalidProperty.get();
    }

    public ReadOnlyBooleanProperty invalidProperty() {
        return this.invalidProperty;
    }

    public ObjectProperty<ValidationDecoration> validationDecoratorProperty() {
        return this.validationDecoratorProperty;
    }

    public ValidationDecoration getValidationDecorator() {
        return (ValidationDecoration)this.validationDecoratorProperty.get();
    }

    public void setValidationDecorator(ValidationDecoration decorator) {
        this.validationDecoratorProperty.set((Object)decorator);
    }

    public <T> boolean registerValidator(Control c, boolean required, Validator<T> validator) {
        Optional.ofNullable(c).ifPresent(ctrl -> ctrl.getProperties().addListener((MapChangeListener)new MapChangeListener<Object, Object>(){

            public void onChanged(MapChangeListener.Change<? extends Object, ? extends Object> change) {
                if (ValidationSupport.CTRL_REQUIRED_FLAG.equals(change.getKey())) {
                    ValidationSupport.this.redecorate();
                }
            }
        }));
        ValidationSupport.setRequired(c, required);
        return ValueExtractor.getObservableValueExtractor(c).map(e -> {
            ObservableValue observable = (ObservableValue)e.call((Object)c);
            Consumer<Object> updateResults = value -> Platform.runLater(() -> {
                ValidationResult cfr_ignored_0 = (ValidationResult)this.validationResults.put((Object)c, (Object)((ValidationResult)validator.apply(c, value)));
            });
            this.controls.add((Object)c);
            observable.addListener((o, oldValue, newValue) -> {
                this.dataChanged.set(true);
                updateResults.accept(newValue);
            });
            updateResults.accept(observable.getValue());
            return e;
        }).isPresent();
    }

    public <T> boolean registerValidator(Control c, Validator<T> validator) {
        return this.registerValidator(c, true, validator);
    }

    public Set<Control> getRegisteredControls() {
        return Collections.unmodifiableSet(this.controls);
    }

    public Optional<ValidationMessage> getHighestMessage(Control target) {
        return Optional.ofNullable((ValidationResult)this.validationResults.get((Object)target)).flatMap(result -> result.getMessages().stream().max(ValidationMessage.COMPARATOR));
    }
}

