/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.meexplorer.breadcrumb;

import com.genuitec.eclipse.meexplorer.breadcrumb.BreadCrumbItem;
import com.genuitec.eclipse.meexplorer.breadcrumb.BreadCrumbItemDropDownViewer;
import com.genuitec.eclipse.meexplorer.breadcrumb.BreadCrumbToolbarLabelProvider;
import com.genuitec.eclipse.meexplorer.breadcrumb.e4.BreadCrumbModelManager;
import com.genuitec.eclipse.meexplorer.navigator.ElementHandlerManager;
import com.genuitec.eclipse.meexplorer.navigator.IElementHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.navigator.CommonViewerSorter;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.NavigatorContentServiceFactory;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;

public class MEBreadCrumbViewer
extends StructuredViewer
implements ISelectionListener {
    private static final String BREADCRUMB_VIEWERID = "com.genuitec.eclipse.meexplorer.menavigator.breadcrumb";
    private static final String BREADCRUMB_DROPDOWN_VIEWERID = "com.genuitec.eclipse.meexplorer.menavigator.breadcrumb.dropdown";
    private Composite container;
    private ArrayList<BreadCrumbItem> breadCrumbItems;
    private IWorkbenchWindow activeWorkbenchWindow;
    private MToolControl breadcrumbCtrl;
    private IResourceChangeListener resourceChangeListener;
    private boolean isBCInitialized = false;
    private boolean suppressInputChange = false;
    private Object oldInput;
    private ViewerFilter[] dropDownViewerFilters;
    private ILabelProvider itemLabelProvider;
    private CommonViewerSorter bcViewerSorter;

    public MEBreadCrumbViewer(IWorkbenchWindow window, MToolControl breadcrumbCtrl, Composite parent, int style) {
        this.activeWorkbenchWindow = window;
        this.breadcrumbCtrl = breadcrumbCtrl;
        this.breadCrumbItems = new ArrayList();
        this.container = new Composite(parent, 0);
        this.container.setLayoutData((Object)new GridData(16384, 4, true, true));
        GridLayout gridLayout = new GridLayout(100, false);
        gridLayout.marginLeft = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.container.setLayout((Layout)gridLayout);
        INavigatorContentService service = NavigatorContentServiceFactory.INSTANCE.createContentService(BREADCRUMB_VIEWERID, (StructuredViewer)this);
        String[] contentbindings = service.getVisibleExtensionIds();
        if (contentbindings.length > 0) {
            this.setContentProvider((IContentProvider)service.createCommonContentProvider());
        } else {
            this.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        }
        this.setLabelProvider((IBaseLabelProvider)new BreadCrumbToolbarLabelProvider(this));
        this.bcViewerSorter = new CommonViewerSorter();
        this.bcViewerSorter.setContentService(service);
        this.itemLabelProvider = service.createCommonLabelProvider();
        INavigatorContentService service1 = NavigatorContentServiceFactory.INSTANCE.createContentService(BREADCRUMB_DROPDOWN_VIEWERID);
        this.dropDownViewerFilters = service1.getFilterService().getVisibleFilters(true);
        this.createResourceChangeListener();
        this.handleSelectionListener();
        parent.setData(BREADCRUMB_VIEWERID, (Object)this);
    }

    public CommonViewerSorter getBcViewerSorter() {
        return this.bcViewerSorter;
    }

    private void createResourceChangeListener() {
        this.resourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta delta = event.getDelta();
                if (delta == null) {
                    return;
                }
                if (MEBreadCrumbViewer.this.getInput() instanceof IResource || MEBreadCrumbViewer.this.getInput() instanceof IAdaptable) {
                    IResource viewerinput = null;
                    if (MEBreadCrumbViewer.this.getInput() instanceof IResource) {
                        viewerinput = (IResource)MEBreadCrumbViewer.this.getInput();
                    } else if (MEBreadCrumbViewer.this.getInput() instanceof IAdaptable) {
                        viewerinput = (IResource)((IAdaptable)MEBreadCrumbViewer.this.getInput()).getAdapter(IResource.class);
                    }
                    if (viewerinput == null) {
                        return;
                    }
                    final IResourceDelta resourseDelta = delta.findMember(viewerinput.getFullPath());
                    if (resourseDelta == null || resourseDelta.getKind() != 2) {
                        return;
                    }
                    final boolean resourceDeleted = (0x2000 & resourseDelta.getFlags()) == 0;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (resourceDeleted) {
                                IResource parentResource;
                                IResource deletedResource = resourseDelta.getResource();
                                if (deletedResource != null && (parentResource = MEBreadCrumbViewer.this.getParentResource(deletedResource)) != null) {
                                    MEBreadCrumbViewer.this.setInput(parentResource);
                                }
                            } else {
                                IResource newResource = ResourcesPlugin.getWorkspace().getRoot().findMember(resourseDelta.getMovedToPath());
                                if (newResource != null) {
                                    MEBreadCrumbViewer.this.setInput(newResource);
                                }
                            }
                        }
                    });
                }
            }
        };
    }

    private IResource getParentResource(IResource deletedResource) {
        IContainer parentResource = deletedResource.getParent();
        if (parentResource == null) {
            return null;
        }
        if (parentResource.exists()) {
            return parentResource;
        }
        return this.getParentResource((IResource)parentResource);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.closeDropDownViewers();
        Object inputtoSet = null;
        if (part instanceof ViewPart) {
            inputtoSet = this.getViewInput((IViewPart)part);
        }
        if (part instanceof IEditorPart) {
            inputtoSet = this.getEditorInput((IEditorPart)part);
        }
        if (inputtoSet != null && !this.getControl().isDisposed()) {
            this.setInput(inputtoSet);
        }
    }

    private Object getViewInput(IViewPart part) {
        ISelectionProvider selectionProvider = part.getViewSite().getSelectionProvider();
        if (selectionProvider == null) {
            return null;
        }
        ISelection selection = selectionProvider.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object selectionFromView = ((IStructuredSelection)selection).getFirstElement();
            return selectionFromView;
        }
        return null;
    }

    private Object getEditorInput(IEditorPart part) {
        IEditorInput editorInput = part.getEditorInput();
        if (editorInput instanceof FileEditorInput) {
            return ((FileEditorInput)editorInput).getFile();
        }
        return null;
    }

    public void dispose() {
        this.activeWorkbenchWindow.getSelectionService().removePostSelectionListener((ISelectionListener)this);
        this.getLabelProvider().dispose();
        this.getContentProvider().dispose();
    }

    protected Widget doFindInputItem(Object element) {
        if (element == null) {
            return null;
        }
        if (element == this.getInput() || element.equals(this.getInput())) {
            return this.doFindItem(element);
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        if (element == null) {
            return null;
        }
        for (BreadCrumbItem breadCrumbItem : this.breadCrumbItems) {
            if (breadCrumbItem.getData() != element && !element.equals(breadCrumbItem.getData())) continue;
            return breadCrumbItem;
        }
        return null;
    }

    protected void doUpdateItem(Widget widget, Object arg1, boolean arg2) {
        if (widget instanceof BreadCrumbItem) {
            BreadCrumbItem item = (BreadCrumbItem)widget;
            item.refresh();
        }
    }

    protected List getSelectionFromWidget() {
        return Collections.EMPTY_LIST;
    }

    protected void internalRefresh(Object arg0) {
    }

    public void reveal(Object arg0) {
    }

    protected void setSelectionToWidget(List arg0, boolean arg1) {
    }

    protected void inputChanged(Object fInput, Object oldInput) {
        ITreeContentProvider contentProvider;
        Object parent;
        if (fInput.equals(oldInput)) {
            return;
        }
        if (this.suppressInputChange) {
            if (fInput != this.oldInput) {
                this.setInput(this.oldInput);
            }
            return;
        }
        this.closeDropDownViewers();
        if (!(fInput instanceof IWorkspaceRoot)) {
            for (IElementHandler elementHandler : ElementHandlerManager.getInstance().getElementHandlerList()) {
                Object adaptedElement = elementHandler.getAdaptedElement(fInput);
                if (adaptedElement == null) continue;
                fInput = adaptedElement;
                break;
            }
        }
        if ((parent = (contentProvider = (ITreeContentProvider)this.getContentProvider()).getParent(fInput)) == null) {
            return;
        }
        if (fInput instanceof IResource) {
            IResource tmp = (IResource)fInput;
            while (tmp != null) {
                if (tmp.isHidden()) {
                    return;
                }
                tmp = tmp.getParent();
            }
        }
        this.activeWorkbenchWindow.getSelectionService().removePostSelectionListener((ISelectionListener)this);
        int i = 0;
        while (i < this.breadCrumbItems.size()) {
            this.breadCrumbItems.get(i).dispose();
            ++i;
        }
        this.breadCrumbItems.clear();
        this.setSelection((ISelection)new StructuredSelection(fInput));
        this.buildItemChain(fInput);
        this.hideLastItemPathSeparator();
        this.container.pack();
        this.container.layout(true);
        this.activeWorkbenchWindow.getSelectionService().addPostSelectionListener((ISelectionListener)this);
    }

    private void hideLastItemPathSeparator() {
        if (this.breadCrumbItems.size() > 0) {
            BreadCrumbItem lastItem = this.breadCrumbItems.get(this.breadCrumbItems.size() - 1);
            lastItem.getPathSeparatorIconLabel1().setVisible(false);
        }
    }

    private int buildItemChain(Object element) {
        if (element == null) {
            return 0;
        }
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.getContentProvider();
        Object parent = contentProvider.getParent(element);
        int index = this.buildItemChain(parent);
        if (parent == null) {
            return 0;
        }
        BreadCrumbItem item = this.createItem(element);
        item.setItemLabelProvider(this.itemLabelProvider);
        item.setItemContentProvider((IContentProvider)contentProvider);
        item.refresh();
        return index + 1;
    }

    private BreadCrumbItem createItem(Object element) {
        Object elementToSet = element;
        BreadCrumbItem item = new BreadCrumbItem(this.container, this);
        item.setData(elementToSet);
        this.breadCrumbItems.add(item);
        return item;
    }

    public Control getControl() {
        return this.container;
    }

    public void openLastItemDropDownViewer() {
        if (this.breadCrumbItems.size() > 0) {
            BreadCrumbItem lastItem = this.breadCrumbItems.get(this.breadCrumbItems.size() - 1);
            lastItem.updateItemSelection();
            if (lastItem.handleBreadCrumbItemSelection()) {
                this.suppressInputChange = true;
                this.oldInput = this.getInput();
            }
        }
    }

    public void shellOpened() {
        this.suppressInputChange = false;
    }

    public void handleDropDownViewerSelection(Object selectedNode) {
        this.setInput(selectedNode);
        this.openLastItemDropDownViewer();
    }

    protected void handleDispose(DisposeEvent event) {
        this.getLabelProvider().dispose();
        this.getContentProvider().dispose();
        super.handleDispose(event);
    }

    private void handleSelectionListener() {
        boolean toggleState = BreadCrumbModelManager.getInstance().getIsBreadcrumbVisible(this.breadcrumbCtrl);
        if (toggleState) {
            this.activeWorkbenchWindow.getSelectionService().addPostSelectionListener((ISelectionListener)this);
            ((BreadCrumbToolbarLabelProvider)this.getLabelProvider()).registerLabelProvListener(true);
            if (!this.isBCInitialized && (this.activeWorkbenchWindow.getSelectionService().getSelection() == null || this.activeWorkbenchWindow.getSelectionService().getSelection().isEmpty())) {
                this.setInput(ResourcesPlugin.getWorkspace().getRoot());
            } else {
                this.selectionChanged(this.activeWorkbenchWindow.getActivePage().getActivePart(), this.activeWorkbenchWindow.getSelectionService().getSelection());
            }
            this.isBCInitialized = true;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.addResourceChangeListener(this.resourceChangeListener, 1);
        } else {
            this.activeWorkbenchWindow.getSelectionService().removePostSelectionListener((ISelectionListener)this);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.removeResourceChangeListener(this.resourceChangeListener);
            ((BreadCrumbToolbarLabelProvider)this.getLabelProvider()).registerLabelProvListener(false);
            this.closeDropDownViewers();
        }
        this.activeWorkbenchWindow.getShell().layout(true);
    }

    public ArrayList<BreadCrumbItem> getBreadCrumbItems() {
        return this.breadCrumbItems;
    }

    public void closeDropDownViewers() {
        int i = 0;
        while (i < this.breadCrumbItems.size()) {
            BreadCrumbItemDropDownViewer dropdown = this.breadCrumbItems.get(i).getDropDownViewer();
            if (dropdown != null && !dropdown.getShell().isDisposed()) {
                dropdown.getShell().close();
                dropdown.getShell().dispose();
            }
            ++i;
        }
    }

    public Composite getContainer() {
        return this.container;
    }

    public IWorkbenchWindow getActiveWorkbenchWindow() {
        return this.activeWorkbenchWindow;
    }

    public ViewerFilter[] getDropDownViewerFilters() {
        return this.dropDownViewerFilters;
    }

    public static void refresh(MToolControl breadcrumb) {
        Object viewer = ((Control)breadcrumb.getWidget()).getData(BREADCRUMB_VIEWERID);
        if (viewer instanceof MEBreadCrumbViewer) {
            ((MEBreadCrumbViewer)((Object)viewer)).handleSelectionListener();
        }
    }
}

