/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.meexplorer.breadcrumb;

import com.genuitec.eclipse.core.util.PlatformUIUtil;
import com.genuitec.eclipse.meexplorer.MEExplorerPlugin;
import com.genuitec.eclipse.meexplorer.breadcrumb.BreadCrumbItemDropDownViewer;
import com.genuitec.eclipse.meexplorer.breadcrumb.MEBreadCrumbViewer;
import com.genuitec.eclipse.meexplorer.monitor.BreadCrumbUsageMetricsProvider;
import com.genuitec.eclipse.meexplorer.navigator.ElementHandlerManager;
import com.genuitec.eclipse.meexplorer.navigator.IElementHandler;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class BreadCrumbItem
extends Item {
    private CLabel nodelabel1;
    private Label pathSeparatorIconLabel1;
    private IContentProvider itemContentProvider;
    private ILabelProvider itemLabelProvider;
    private Composite itemParent;
    private Composite parentComposite;
    private MEBreadCrumbViewer breadCrumbViewer;
    private BreadCrumbItemDropDownViewer dropDownViewer;

    public BreadCrumbItem(Composite parent, MEBreadCrumbViewer viewer) {
        super((Widget)parent, 0);
        this.parentComposite = parent;
        this.breadCrumbViewer = viewer;
        this.itemParent = new Composite(parent, 0);
        this.itemParent.setLayoutData((Object)new GridData(16384, 128, false, false));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 1;
        gridLayout.horizontalSpacing = 2;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.itemParent.setLayout((Layout)gridLayout);
        this.createControls();
    }

    private void createControls() {
        this.nodelabel1 = new CLabel(this.itemParent, 0);
        GridData data = new GridData(1, 128, false, false);
        this.nodelabel1.setLayoutData((Object)data);
        this.nodelabel1.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                BreadCrumbItem.this.updateItemSelection();
                if (event.button == 1) {
                    BreadCrumbItem.this.handleBreadCrumbItemSelection();
                }
            }
        });
        this.pathSeparatorIconLabel1 = new Label(this.itemParent, 0);
        this.pathSeparatorIconLabel1.setImage(MEExplorerPlugin.getDefault().getImage("icons/breadcrumb/arror_black.png"));
        data = new GridData(1, 0x1000000, false, false);
        this.pathSeparatorIconLabel1.setLayoutData((Object)data);
        this.itemParent.layout();
    }

    protected void updateItemSelection() {
        this.breadCrumbViewer.closeDropDownViewers();
        for (BreadCrumbItem item : this.breadCrumbViewer.getBreadCrumbItems()) {
            if (((Object)((Object)this)).equals((Object)item)) {
                this.nodelabel1.setBackground(Display.getDefault().getSystemColor(26));
                this.nodelabel1.setForeground(Display.getDefault().getSystemColor(27));
                continue;
            }
            Color color = null;
            item.getNodelabel1().setBackground(color);
            item.getNodelabel1().setForeground(color);
        }
    }

    protected void handleDoubleClickEvent(IFile fileToOpen) {
        try {
            IDE.openEditor((IWorkbenchPage)PlatformUIUtil.getActivePage(), (IFile)fileToOpen);
            BreadCrumbUsageMetricsProvider.fileOpenedfromBC();
        }
        catch (PartInitException e) {
            MEExplorerPlugin.getDefault().log(e);
        }
    }

    protected boolean handleBreadCrumbItemSelection() {
        if (this.getData() instanceof IFile) {
            this.handleDoubleClickEvent((IFile)this.getData());
            return false;
        }
        for (IElementHandler elementHandler : ElementHandlerManager.getInstance().getElementHandlerList()) {
            if (!elementHandler.handleDoubleClick(this.getData())) continue;
            BreadCrumbUsageMetricsProvider.fileOpenedfromBC();
            return false;
        }
        final int index = this.breadCrumbViewer.getBreadCrumbItems().indexOf((Object)this);
        this.dropDownViewer = null;
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                ArrayList<BreadCrumbItem> items = BreadCrumbItem.this.breadCrumbViewer.getBreadCrumbItems();
                int ind = Math.min(index, items.size() - 1);
                BreadCrumbItem.this.dropDownViewer = new BreadCrumbItemDropDownViewer((BreadCrumbItem)((Object)items.get(ind)));
                BreadCrumbItem.this.dropDownViewer.openDropDownShell();
                BreadCrumbItem.this.breadCrumbViewer.shellOpened();
            }
        });
        return true;
    }

    public void refresh() {
        if (this.getData() != null) {
            this.nodelabel1.setRedraw(false);
            this.setLabelTextAndToolTip();
            this.nodelabel1.setImage(this.itemLabelProvider.getImage(this.getData()));
            this.nodelabel1.setRedraw(true);
            this.nodelabel1.pack();
        }
    }

    private void setLabelTextAndToolTip() {
        String labelText = this.itemLabelProvider.getText(this.getData());
        String tooltipText = null;
        if (labelText != null && labelText.indexOf(File.separator) != -1) {
            tooltipText = labelText;
            labelText = labelText.substring(labelText.lastIndexOf(File.separator) + 1, labelText.length());
        }
        if (labelText != null) {
            if (labelText.equals("WORKSPACE_ROOT_TEXT_TO_REMOVE")) {
                this.nodelabel1.setText("");
            } else {
                this.nodelabel1.setText(labelText);
            }
        }
        if (tooltipText != null) {
            this.nodelabel1.setToolTipText(tooltipText);
        }
    }

    public void setItemLabelProvider(ILabelProvider labelProvider) {
        this.itemLabelProvider = labelProvider;
    }

    public void setItemContentProvider(IContentProvider contentProvider) {
        this.itemContentProvider = contentProvider;
    }

    public void dispose() {
        this.itemParent.dispose();
        this.itemContentProvider.dispose();
        this.itemLabelProvider.dispose();
        super.dispose();
    }

    public Composite getParentComposite() {
        return this.parentComposite;
    }

    public CLabel getNodelabel1() {
        return this.nodelabel1;
    }

    public Label getPathSeparatorIconLabel1() {
        return this.pathSeparatorIconLabel1;
    }

    public IContentProvider getItemContentProvider() {
        return this.itemContentProvider;
    }

    public BreadCrumbItemDropDownViewer getDropDownViewer() {
        return this.dropDownViewer;
    }

    public MEBreadCrumbViewer getBreadCrumbViewer() {
        return this.breadCrumbViewer;
    }

    public ILabelProvider getItemLabelProvider() {
        return this.itemLabelProvider;
    }
}

