/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.meexplorer.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.ide.ResourceSelectionUtil;

public class RefactorActionGroup
extends ActionGroup {
    public static final String REFACTOR_MENU_ID = "com.genuitec.eclipse.meexplorer.refactoring.menu";
    private RenameResourceAction renameAction;
    private MoveResourceAction moveAction;
    private Shell shell;
    private Tree tree;

    public RefactorActionGroup(Shell aShell, Tree aTree) {
        this.shell = aShell;
        this.tree = aTree;
        this.makeActions();
    }

    public void fillContextMenu(IMenuManager menu) {
        boolean anyResourceSelected;
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean bl = anyResourceSelected = !selection.isEmpty() && ResourceSelectionUtil.allResourcesAreOfType((IStructuredSelection)selection, (int)7);
        if (anyResourceSelected) {
            MenuManager refactorSubmenu = new MenuManager("Refac&tor", REFACTOR_MENU_ID);
            menu.appendToGroup("group.reorganize", (IContributionItem)refactorSubmenu);
            menu.insertBefore(REFACTOR_MENU_ID, (IContributionItem)new Separator());
            this.renameAction.selectionChanged(selection);
            refactorSubmenu.add((IAction)this.renameAction);
            this.moveAction.selectionChanged(selection);
            refactorSubmenu.add((IAction)this.moveAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        this.updateActionBars();
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.move", (IAction)this.moveAction);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.rename", (IAction)this.renameAction);
    }

    protected void makeActions() {
        IShellProvider sp = new IShellProvider(){

            public Shell getShell() {
                return RefactorActionGroup.this.shell;
            }
        };
        this.moveAction = new MoveResourceAction(sp);
        this.moveAction.setActionDefinitionId(ActionFactory.MOVE.getCommandId());
        this.renameAction = new RenameResourceAction(sp, this.tree);
        this.renameAction.setActionDefinitionId(ActionFactory.RENAME.getCommandId());
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.moveAction.selectionChanged(selection);
        this.renameAction.selectionChanged(selection);
    }
}

