/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.profiler;

import com.genuitec.eclipse.core.CommonUI;
import com.genuitec.eclipse.core.Messages;
import com.genuitec.eclipse.core.ui.util.PlatformSWTUtil;
import com.genuitec.eclipse.core.util.ValueHolder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jface.dialogs.MessageDialog;

public class ProfilerLaunchRegistry
implements ILaunchesListener2 {
    public static final String PROFILING_MODE = "myeclipse.profiling.mode";
    private HashMap<String, String> serverProfileMap = new HashMap();
    private HashSet<ILaunch> profileLaunchSet = new HashSet();
    private static ProfilerLaunchRegistry instance;

    private ProfilerLaunchRegistry() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    public static ProfilerLaunchRegistry getInstance() {
        if (instance == null) {
            instance = new ProfilerLaunchRegistry();
        }
        return instance;
    }

    public static void enableProfiler(String id, String settingsFile) {
        ProfilerLaunchRegistry.getInstance().serverProfileMap.put(id, settingsFile);
    }

    public static void disableProfiler(String id) {
        ProfilerLaunchRegistry.getInstance().serverProfileMap.remove(id);
    }

    public static String getProfilerId(String serverId) {
        return ProfilerLaunchRegistry.getInstance().serverProfileMap.get(serverId);
    }

    public void launchesAdded(ILaunch[] launches) {
        int i = 0;
        while (i < launches.length) {
            ILaunch curLaunch = launches[i];
            boolean shutdownLaunch = false;
            try {
                shutdownLaunch = Boolean.valueOf(curLaunch.getLaunchConfiguration().getAttribute("LAUNCH_IS_SHUTDOWN", "false"));
            }
            catch (CoreException coreException) {}
            if (shutdownLaunch) {
                return;
            }
            String mode = curLaunch.getLaunchMode();
            if ("profile".equals(mode)) {
                this.profileLaunchSet.add(curLaunch);
            }
            ++i;
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
        int i = 0;
        while (i < launches.length) {
            this.profileLaunchSet.remove(launches[i]);
            ++i;
        }
    }

    public static boolean terminateLaunch(ILaunch launch) {
        try {
            launch.terminate();
        }
        catch (DebugException ex) {
            CommonUI.getDefault().log(ex);
            return false;
        }
        return true;
    }

    public static boolean profilerAvailable() {
        HashSet<ILaunch> set = ProfilerLaunchRegistry.getInstance().profileLaunchSet;
        boolean available = set.isEmpty();
        if (!available) {
            Iterator<ILaunch> iter;
            ILaunch tLaunch;
            final ValueHolder valueHolder = new ValueHolder();
            PlatformSWTUtil.invokeOnDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    boolean start = MessageDialog.openQuestion(null, (String)Messages.ProfilerLaunchRegistry_dialog_profiling_active_title, (String)Messages.ProfilerLaunchRegistry_dialog_profling_session_message);
                    valueHolder.setValue((Object)start);
                }
            });
            if (((Boolean)valueHolder.getValue()).booleanValue() && ProfilerLaunchRegistry.terminateLaunch(tLaunch = (iter = set.iterator()).next())) {
                available = true;
            }
        }
        return available;
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        this.launchesTerminated(launches);
    }
}

