/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.util;

import com.genuitec.eclipse.core.CommonUI;
import com.genuitec.eclipse.core.Messages;
import com.genuitec.eclipse.core.util.EditorUtil;
import com.genuitec.eclipse.core.util.Util;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.internal.editors.text.WorkspaceOperationRunner;
import org.eclipse.ui.part.FileEditorInput;

public class FileCreateUtil {
    private IFile newFile;
    private IWorkbench workbench;
    String path;
    String fileName;
    InputStream content;

    public FileCreateUtil(String theContainerPath, String fileName, InputStream content, IWorkbench workbench) {
        this.path = theContainerPath;
        this.fileName = fileName;
        this.content = content;
        this.workbench = workbench;
    }

    public FileCreateUtil(String theContainerPath, String fileName, String content, IWorkbench workbench) {
        this.path = theContainerPath;
        this.fileName = fileName;
        this.content = content != null ? new ByteArrayInputStream(content.getBytes()) : new ByteArrayInputStream(new byte[0]);
        this.workbench = workbench;
    }

    public IFile createNewFile() {
        return this.createNewFile(null);
    }

    public IFile createNewFile(Shell theShell) {
        WorkspaceOperationRunner runner = new WorkspaceOperationRunner();
        return this.createNewFile((IRunnableContext)runner, theShell);
    }

    public IFile createNewFile(IRunnableContext theRunnableContext, Shell theShell) {
        if (this.newFile != null) {
            return this.newFile;
        }
        if (theRunnableContext == null) {
            this.createNewFile(theShell);
        }
        Path containerPath = new Path(this.path);
        IPath newFilePath = containerPath.append(this.fileName);
        IFile newFileHandle = this.createFileHandle(newFilePath);
        InputStream initialContents = this.getInitialContents();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation((IPath)containerPath, newFileHandle, initialContents){
            private final /* synthetic */ IPath val$containerPath;
            private final /* synthetic */ IFile val$newFileHandle;
            private final /* synthetic */ InputStream val$initialContents;
            {
                this.val$containerPath = iPath;
                this.val$newFileHandle = iFile;
                this.val$initialContents = inputStream;
            }

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                try {
                    monitor.beginTask(MessageFormat.format(Messages.FileCreateUtil_taskname_creating_file, FileCreateUtil.this.path, FileCreateUtil.this.fileName), 2000);
                    ContainerGenerator generator = new ContainerGenerator(this.val$containerPath);
                    generator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                    FileCreateUtil.this.createFile(this.val$newFileHandle, this.val$initialContents, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            theRunnableContext.run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)theShell, (String)Messages.FileCreateUtil_dialog_core_exception_title, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                CommonUI.getDefault().log(MessageFormat.format(Messages.FileCreateUtil_dialog_get_newfile_error_message, this.getClass().getName(), e.getTargetException()));
                MessageDialog.openError((Shell)theShell, (String)Messages.FileCreateUtil_dialog_get_newfile_error_title, (String)e.getTargetException().getMessage());
            }
            return null;
        }
        this.newFile = newFileHandle;
        return this.newFile;
    }

    public IFile createNewFile(boolean openInEditor) {
        return this.createNewFile(null, null, openInEditor);
    }

    public IFile createNewFile(IRunnableContext theRunnableContext, Shell theShell, boolean openInEditor) {
        IFile file = this.createNewFile(theRunnableContext, theShell);
        if (file == null) {
            return null;
        }
        if (openInEditor) {
            IWorkbenchWindow dw = this.workbench.getActiveWorkbenchWindow();
            try {
                IWorkbenchPage page = dw.getActivePage();
                if (page != null) {
                    page.openEditor((IEditorInput)new FileEditorInput(file), EditorUtil.getEditorId((IFile)file));
                }
            }
            catch (PartInitException e) {
                MessageDialog.openError((Shell)dw.getShell(), (String)Messages.FileCreateUtil_dialog_open_in_editor_title, (String)e.getMessage());
            }
        }
        return file;
    }

    protected IFile createFileHandle(IPath filePath) {
        return Util.getWorkspace().getRoot().getFile(filePath);
    }

    protected InputStream getInitialContents() {
        return this.content;
    }

    protected void createFile(IFile fileHandle, InputStream contents, IProgressMonitor monitor) throws CoreException {
        try {
            if (!fileHandle.exists()) {
                fileHandle.create(contents, false, monitor);
            } else {
                fileHandle.setContents(contents, false, true, monitor);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                fileHandle.refreshLocal(0, null);
            }
            throw e;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

