/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.preference;

import com.genuitec.eclipse.core.CommonUI;
import com.genuitec.eclipse.core.Messages;
import com.genuitec.eclipse.core.portability.wizard.SelectionButtonDialogField;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public class NotificationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String KEY = "com.genuitec.pulse.delivery.notifications.tags.exclude";
    private static final String CRITICAL = "critical";
    private static final String MAJOR = "majorRelease";
    private static final String MINOR = "minorRelease";
    private static final String SURVEY = "survey";
    private static final String NORMAL = "normal";
    private IEclipsePreferences scope;
    private SelectionButtonDialogField criticalDF;
    private SelectionButtonDialogField surveyDF;
    private SelectionButtonDialogField majorDF;
    private SelectionButtonDialogField minorDF;
    private SelectionButtonDialogField normalDF;

    public void init(IWorkbench workbench) {
        this.criticalDF = new SelectionButtonDialogField(32);
        this.criticalDF.setLabelText(Messages.NotificationPreferencePage_checkbox_critical);
        this.majorDF = new SelectionButtonDialogField(32);
        this.majorDF.setLabelText(Messages.NotificationPreferencePage_checkbox_major);
        this.minorDF = new SelectionButtonDialogField(32);
        this.minorDF.setLabelText(Messages.NotificationPreferencePage_checkbox_minor);
        this.normalDF = new SelectionButtonDialogField(32);
        this.normalDF.setLabelText(Messages.NotificationPreferencePage_checkbox_normal);
        this.surveyDF = new SelectionButtonDialogField(32);
        this.surveyDF.setLabelText(Messages.NotificationPreferencePage_checkbox_survey);
        this.enableAll();
        this.scope = ConfigurationScope.INSTANCE.getNode("com.genuitec.pulse.client.delivery.package.runtime");
        String excluded = this.scope.get(KEY, "");
        StringTokenizer tokenizer = new StringTokenizer(excluded, " ,");
        while (tokenizer.hasMoreTokens()) {
            String exclude = tokenizer.nextToken();
            if (CRITICAL.equalsIgnoreCase(exclude)) {
                this.criticalDF.setSelection(false);
                continue;
            }
            if (MAJOR.equalsIgnoreCase(exclude)) {
                this.majorDF.setSelection(false);
                continue;
            }
            if (MINOR.equalsIgnoreCase(exclude)) {
                this.minorDF.setSelection(false);
                continue;
            }
            if (NORMAL.equalsIgnoreCase(exclude)) {
                this.normalDF.setSelection(false);
                continue;
            }
            if (!SURVEY.equalsIgnoreCase(exclude)) continue;
            this.surveyDF.setSelection(false);
        }
    }

    private void enableAll() {
        this.criticalDF.setSelection(true);
        this.majorDF.setSelection(true);
        this.minorDF.setSelection(true);
        this.normalDF.setSelection(true);
        this.surveyDF.setSelection(true);
    }

    public boolean performOk() {
        StringBuilder builder = new StringBuilder();
        if (!this.criticalDF.isSelected()) {
            builder.append(",");
            builder.append(CRITICAL);
        }
        if (!this.majorDF.isSelected()) {
            builder.append(",");
            builder.append(MAJOR);
        }
        if (!this.minorDF.isSelected()) {
            builder.append(",");
            builder.append(MINOR);
        }
        if (!this.surveyDF.isSelected()) {
            builder.append(",");
            builder.append(SURVEY);
        }
        if (!this.normalDF.isSelected()) {
            builder.append(",");
            builder.append(NORMAL);
        }
        if (builder.length() > 0) {
            this.scope.put(KEY, builder.substring(1));
        } else {
            this.scope.remove(KEY);
        }
        try {
            this.scope.flush();
        }
        catch (BackingStoreException e) {
            CommonUI.getDefault().log("Could not save notification settings", e);
        }
        return super.performOk();
    }

    protected void performDefaults() {
        this.enableAll();
        super.performDefaults();
    }

    protected Control createContents(Composite parent) {
        Composite pageContent = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        pageContent.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        pageContent.setLayoutData((Object)gd);
        Label label = new Label(pageContent, 0);
        label.setText(Messages.NotificationPreferencePage_lable_enable_notifications);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.criticalDF.doFillIntoGrid(pageContent, 2);
        this.majorDF.doFillIntoGrid(pageContent, 2);
        this.minorDF.doFillIntoGrid(pageContent, 2);
        this.normalDF.doFillIntoGrid(pageContent, 2);
        this.surveyDF.doFillIntoGrid(pageContent, 2);
        this.criticalDF.setEnabled(false);
        this.majorDF.setEnabled(false);
        return pageContent;
    }
}

