/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.preference;

import com.genuitec.eclipse.core.Messages;
import com.genuitec.eclipse.core.ui.preference.ListButtonDetails;
import com.genuitec.eclipse.core.ui.preference.ListFieldEditor;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;

public class LibraryFieldEditor
extends ListFieldEditor {
    public static final int JAR_MODE = 1;
    public static final int TLD_MODE = 2;
    public static final String DEFAULT_ADDJARZIP_LABEL = Messages.LibraryFieldEditor_label_default_addjarzip;
    public static final String DEFAULT_ADDTLD_LABEL = Messages.LibraryFieldEditor_label_default_addtld;
    private int mode = 1;
    private String lastPath;
    private Composite parentComposite;

    protected LibraryFieldEditor() {
    }

    public LibraryFieldEditor(String name, String labelText, Composite parent, int mode) {
        this(name, labelText, new ListButtonDetails(mode == 1 ? DEFAULT_ADDJARZIP_LABEL : DEFAULT_ADDTLD_LABEL, null, ListButtonDetails.DEFAULT_REMOVE_LABEL, null, null), parent);
        this.setMode(mode);
    }

    public LibraryFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, parent, 1);
    }

    public LibraryFieldEditor(String name, String labelText, ListButtonDetails theButtonDetails, Composite parent) {
        super(name, labelText, theButtonDetails, parent);
        this.parentComposite = parent;
    }

    public void store() {
        super.store();
    }

    protected String[] getNewJarZip() {
        String file;
        FileDialog dialog = new FileDialog(this.addButton1.getShell(), 2);
        dialog.setFilterNames(this.getFileFilterNames(this.getMode()));
        dialog.setFilterExtensions(this.getFileExtensionFilter(this.getMode()));
        if (this.lastPath != null && new File(this.lastPath).exists()) {
            dialog.setFilterPath(this.lastPath);
        }
        if ((file = dialog.open()) == null) {
            return new String[0];
        }
        String[] files = dialog.getFileNames();
        ArrayList<String> fileList = new ArrayList<String>(files.length);
        IPath dirPath = new Path(file).removeLastSegments(1);
        int i = 0;
        while (i < files.length) {
            file = files[i].trim();
            if (file.length() != 0) {
                if (i == 0) {
                    this.lastPath = new File(file).getAbsolutePath();
                }
                fileList.add(dirPath.append(file).toOSString());
            }
            ++i;
        }
        return fileList.toArray(new String[fileList.size()]);
    }

    @Override
    protected void createButtons(Composite buttonBox) {
        super.createButtons(buttonBox);
    }

    @Override
    protected void add1Pressed() {
        this.setPresentsDefaultValue(false);
        String[] input = this.getNewJarZip();
        if (input != null) {
            int index = this.list.getSelectionIndex();
            index = index > 0 ? index : 0;
            int i = 0;
            while (i < input.length) {
                this.list.add(input[i], index++);
                ++i;
            }
            this.selectionChanged();
        }
    }

    public Composite getParentComposite() {
        return this.parentComposite;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    protected String[] getFileFilterNames(int theMode) {
        String[] result = null;
        result = theMode == 2 ? new String[]{Messages.LibraryFieldEditor_filternames_tld, Messages.LibraryFieldEditor_filternames_allfiles} : new String[]{Messages.LibraryFieldEditor_filternames_alljar_allzip, Messages.LibraryFieldEditor_filternames_allfiles};
        return result;
    }

    protected String[] getFileExtensionFilter(int theMode) {
        String[] result = null;
        result = theMode == 2 ? new String[]{"*.tld", "*.*"} : new String[]{"*.jar;*.zip", "*.*"};
        return result;
    }
}

