/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.console;

import com.genuitec.eclipse.core.ui.console.CustomConsoleException;
import com.genuitec.eclipse.core.ui.console.CustomConsoleProcess;
import com.genuitec.eclipse.core.ui.console.CustomProcessConsole;
import com.genuitec.eclipse.core.ui.console.IConsoleColorProviderFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;

public class CustomConsoleLaunch
extends Launch {
    private IConsoleColorProviderFactory clProviderFactory;

    public CustomConsoleLaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator, IConsoleColorProviderFactory consoleColorProviderFactory) throws CoreException, CustomConsoleException {
        super(launchConfiguration, mode, locator);
        if (consoleColorProviderFactory == null) {
            throw new CustomConsoleException("ConsoleColorProviderFactory cannot be null!");
        }
        if (launchConfiguration instanceof ILaunchConfigurationWorkingCopy) {
            ((ILaunchConfigurationWorkingCopy)launchConfiguration).setAttribute("process_factory_id", "com.genuitec.eclipse.core.ui.console.CustomConsoleProcessFactory");
        }
        if (!launchConfiguration.getAttribute("process_factory_id", "").equals("com.genuitec.eclipse.core.ui.console.CustomConsoleProcessFactory")) {
            throw new CustomConsoleException("Invalid process factory id specified!");
        }
        this.clProviderFactory = consoleColorProviderFactory;
    }

    public void addProcess(IProcess process) {
        if (process != null && !this.getProcesses0().contains(process)) {
            super.addProcess(process);
            if (process instanceof CustomConsoleProcess) {
                this.createConsole(process);
            }
        }
    }

    public void removeProcess(IProcess process) {
        if (process != null && this.getProcesses0().contains(process)) {
            if (process instanceof CustomConsoleProcess) {
                this.removeConsole(process);
            }
            super.removeProcess(process);
        }
    }

    private IConsole getConsole(IProcess process) {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = manager.getConsoles();
        int i = 0;
        while (i < consoles.length) {
            ProcessConsole pc;
            IConsole console = consoles[i];
            if (console instanceof ProcessConsole && (pc = (ProcessConsole)console).getProcess().equals(process)) {
                return pc;
            }
            ++i;
        }
        return null;
    }

    private void createConsole(IProcess process) {
        String encoding = this.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING");
        CustomProcessConsole pc = new CustomProcessConsole(process, this.clProviderFactory.createCustomConsoleColorProvider(), encoding);
        pc.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_PROCESS", process);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{pc});
    }

    private void removeConsole(IProcess process) {
        IConsole console = this.getConsole(process);
        if (console != null) {
            IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
            manager.removeConsoles(new IConsole[]{console});
        }
    }
}

