/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.datatransfer;

import com.genuitec.eclipse.core.datatransfer.Base64Encoder;
import com.genuitec.eclipse.core.util.Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class ZipFileExporter {
    private ZipOutputStream outputStream;
    private StringBuffer manifestContents;
    private boolean generateManifestFile = false;
    private boolean generateDirectories = false;
    private boolean useCompression = true;
    private static final String newline = "\r\n";
    private static final String manifestMagic = "Manifest-Version: 1.0\r\n\r\n";
    private static final String nameLabel = "Name: ";
    private static final String digestsLabel = "Digest-Algorithms: SHA MD5\r\n";
    private static final String shaLabel = "SHA-Digest: ";
    private static final String md5Label = "MD5-Digest: ";
    private static final String manifestPath = "META-INF/MANIFEST.MF";

    public ZipFileExporter(String filename, boolean compress, boolean includeManifestFile) throws IOException {
        this(filename, compress, includeManifestFile, false);
    }

    public ZipFileExporter(String filename, boolean compress, boolean includeManifestFile, boolean generateDirectories) throws IOException {
        File file = new File(filename);
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        this.outputStream = new ZipOutputStream(new FileOutputStream(file));
        this.useCompression = compress;
        this.generateManifestFile = includeManifestFile;
        this.generateDirectories = generateDirectories;
        if (this.generateManifestFile) {
            this.manifestContents = new StringBuffer(manifestMagic);
        }
    }

    protected void appendToManifest(String pathname, IFile file) throws IOException, CoreException {
        StringBuffer manifestEntry = new StringBuffer();
        manifestEntry.append(nameLabel);
        manifestEntry.append(pathname);
        manifestEntry.append(newline);
        manifestEntry.append(digestsLabel);
        manifestEntry.append(shaLabel);
        byte[] fileContents = null;
        InputStream contentStream = file.getContents(false);
        InputStreamReader in = new InputStreamReader(contentStream);
        int chunkSize = contentStream.available();
        StringBuffer buffer = new StringBuffer(chunkSize);
        char[] readBuffer = new char[chunkSize];
        int n = in.read(readBuffer);
        while (n > 0) {
            buffer.append(readBuffer);
            n = in.read(readBuffer);
        }
        contentStream.close();
        fileContents = buffer.toString().getBytes();
        try {
            byte[] hashValue = MessageDigest.getInstance("SHA").digest(fileContents);
            manifestEntry.append(Base64Encoder.encode(hashValue));
            manifestEntry.append(newline);
            manifestEntry.append(md5Label);
            hashValue = MessageDigest.getInstance("MD5").digest(fileContents);
            manifestEntry.append(Base64Encoder.encode(hashValue));
            manifestEntry.append("\r\n\r\n");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return;
        }
        this.manifestContents.append(manifestEntry.toString());
    }

    public void finished() throws IOException {
        try {
            if (this.generateManifestFile) {
                this.writeManifestFile();
            }
        }
        catch (IOException e) {
            this.outputStream.close();
            throw e;
        }
        this.outputStream.close();
    }

    private void write(String pathName, Object input) throws IOException, CoreException {
        InputStream contentStream;
        byte[] readBuffer = new byte[4096];
        ZipEntry newEntry = new ZipEntry(pathName);
        this.outputStream.putNextEntry(newEntry);
        if (!this.useCompression) {
            newEntry.setMethod(0);
            contentStream = this.getContentStream(input);
            int length = 0;
            CRC32 checksumCalculator = new CRC32();
            try {
                int n;
                while ((n = contentStream.read(readBuffer)) > 0) {
                    checksumCalculator.update(readBuffer, 0, n);
                    length += n;
                }
            }
            finally {
                if (contentStream != null) {
                    contentStream.close();
                }
            }
            newEntry.setSize(length);
            newEntry.setCrc(checksumCalculator.getValue());
        }
        if (input != null) {
            contentStream = this.getContentStream(input);
            try {
                int n;
                while ((n = contentStream.read(readBuffer)) > 0) {
                    this.outputStream.write(readBuffer, 0, n);
                }
            }
            finally {
                if (contentStream != null) {
                    contentStream.close();
                }
            }
        }
        this.outputStream.closeEntry();
    }

    private InputStream getContentStream(Object input) throws CoreException {
        if (input instanceof IFile) {
            return ((IFile)input).getContents(false);
        }
        if (input instanceof StringBuffer) {
            return new ByteArrayInputStream(((StringBuffer)input).toString().getBytes());
        }
        return null;
    }

    protected void write_old(String pathname, byte[] contents) throws IOException {
        ZipEntry newEntry = new ZipEntry(pathname);
        if (!this.useCompression) {
            newEntry.setMethod(0);
            if (contents != null) {
                newEntry.setSize(contents.length);
                CRC32 checksumCalculator = new CRC32();
                checksumCalculator.update(contents);
                newEntry.setCrc(checksumCalculator.getValue());
            }
        }
        this.outputStream.putNextEntry(newEntry);
        if (contents != null) {
            this.outputStream.write(contents);
        }
        this.outputStream.closeEntry();
    }

    public void write(IResource resource, String destinationPath) throws IOException, CoreException {
        if (Util.isNullOrEmpty((String)destinationPath)) {
            return;
        }
        String destPath = destinationPath;
        if (resource.getType() == 1) {
            this.write(destPath, resource);
        } else if (this.generateDirectories && resource.getType() == 2) {
            if (!destPath.endsWith("/") && !destPath.endsWith("\\")) {
                destPath = String.valueOf(Util.trimString((String)destPath)) + "/";
                this.write(destPath, null);
            }
        } else {
            return;
        }
        if (this.generateManifestFile && resource.getType() == 1) {
            this.appendToManifest(destPath, (IFile)resource);
        }
    }

    protected void writeManifestFile() throws IOException {
        try {
            this.write(manifestPath, this.manifestContents);
        }
        catch (CoreException coreException) {}
    }
}

