/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.datatransfer;

import com.genuitec.eclipse.core.CommonUI;
import com.genuitec.eclipse.core.datatransfer.DataTransferMessages;
import com.genuitec.eclipse.core.datatransfer.ZipFileExporter;
import com.genuitec.eclipse.core.datatransfer.ZipFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;

public class ZipFileExportOperation
implements IRunnableWithProgress {
    private ZipFileExporter exporter;
    private String destinationFilename;
    private IProgressMonitor monitor;
    private List resourcesToExport;
    private IResource resource;
    private List errorTable = new ArrayList(1);
    private boolean useCompression = true;
    private boolean createLeadupStructure = true;
    private boolean generateManifestFile = false;
    private boolean generateDirectories = false;
    private final ZipFilter filter;

    public ZipFileExportOperation(List resources, String filename, ZipFilter zipFilter) {
        this.filter = zipFilter;
        Iterator elementsEnum = resources.iterator();
        while (elementsEnum.hasNext()) {
            IResource currentResource = (IResource)elementsEnum.next();
            if (!this.isDescendent(resources, currentResource)) continue;
            elementsEnum.remove();
        }
        this.resourcesToExport = resources;
        this.destinationFilename = filename;
    }

    public ZipFileExportOperation(IResource res, String filename, ZipFilter zipFilter) {
        this.filter = zipFilter;
        this.resource = res;
        this.destinationFilename = filename;
    }

    public ZipFileExportOperation(IResource res, List resources, String filename, ZipFilter zipFilter) {
        this(res, filename, zipFilter);
        this.resourcesToExport = resources;
    }

    protected void addError(String message, Throwable e) {
        this.errorTable.add(new Status(4, "org.eclipse.ui", 0, message, e));
    }

    protected int countChildrenOf(IResource resource) throws CoreException {
        if (resource.getType() == 1) {
            return 1;
        }
        int count = 0;
        if (resource.isAccessible()) {
            IResource[] children = ((IContainer)resource).members();
            int i = 0;
            while (i < children.length) {
                count += this.countChildrenOf(children[i]);
                ++i;
            }
        }
        return count;
    }

    protected int countSelectedResources() throws CoreException {
        int result = 0;
        Iterator resources = this.resourcesToExport.iterator();
        while (resources.hasNext()) {
            result += this.countChildrenOf((IResource)resources.next());
        }
        return result;
    }

    protected void exportResource(IResource resource) throws InterruptedException {
        this.exportResource(resource, 1);
    }

    public void exportResource(IResource resource, int leadupDepth) throws InterruptedException {
        if (!resource.isAccessible()) {
            return;
        }
        if (resource.getType() == 1 || resource.getType() == 2 || resource.getType() == 4) {
            IPath fullPath = resource.getFullPath();
            String destinationName = this.createLeadupStructure || resource.getType() == 4 ? this.fixName(fullPath.makeRelative()) : this.fixName(fullPath.removeFirstSegments(fullPath.segmentCount() - leadupDepth));
            this.monitor.subTask(destinationName);
            try {
                if (this.filter.packFile(resource, destinationName)) {
                    this.exporter.write(resource, destinationName);
                }
            }
            catch (IOException e) {
                this.addError(DataTransferMessages.format("DataTransfer.errorExporting", new Object[]{resource.getFullPath().makeRelative(), e.getMessage()}), e);
            }
            catch (CoreException e) {
                this.addError(DataTransferMessages.format("DataTransfer.errorExporting", new Object[]{resource.getFullPath().makeRelative(), e.getMessage()}), e);
            }
            this.monitor.worked(1);
            ModalContext.checkCanceled((IProgressMonitor)this.monitor);
        }
        if (resource.getType() == 2 || resource.getType() == 4) {
            IResource[] children = null;
            try {
                children = ((IContainer)resource).members();
            }
            catch (CoreException e) {
                this.addError(DataTransferMessages.format("DataTransfer.errorExporting", new Object[]{resource.getFullPath()}), e);
            }
            int i = 0;
            while (i < children.length) {
                this.exportResource(children[i], leadupDepth + 1);
                ++i;
            }
        }
    }

    protected String fixName(IPath path) {
        return path.toString();
    }

    protected void exportSpecifiedResources() throws InterruptedException {
        for (IResource currentResource : this.resourcesToExport) {
            this.exportResource(currentResource);
        }
    }

    public List getResult() {
        return this.errorTable;
    }

    public IStatus getStatus() {
        IStatus[] errors = new IStatus[this.errorTable.size()];
        this.errorTable.toArray(errors);
        return new MultiStatus("org.eclipse.ui", 0, errors, DataTransferMessages.getString("FileSystemExportOperation.problemsExporting"), null);
    }

    protected void initialize() throws IOException {
        this.exporter = new ZipFileExporter(this.destinationFilename, this.useCompression, this.generateManifestFile, this.generateDirectories);
    }

    protected boolean isDescendent(List resources, IResource child) {
        if (child.getType() == 4) {
            return false;
        }
        IContainer parent = child.getParent();
        if (resources.contains(parent)) {
            return true;
        }
        return this.isDescendent(resources, (IResource)parent);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        block10: {
            this.monitor = monitor;
            try {
                try {
                    try {
                        this.initialize();
                    }
                    catch (IOException e) {
                        this.finished();
                        throw new InvocationTargetException(e, DataTransferMessages.format("ZipExport.cannotOpen", new Object[]{e.getMessage()}));
                    }
                    int totalWork = -1;
                    try {
                        totalWork = this.resourcesToExport == null ? this.countChildrenOf(this.resource) : this.countSelectedResources();
                    }
                    catch (CoreException coreException) {}
                    monitor.beginTask(DataTransferMessages.getString("DataTransfer.exportingTitle"), totalWork);
                    if (this.resourcesToExport == null) {
                        this.exportResource(this.resource, 0);
                        break block10;
                    }
                    this.exportSpecifiedResources();
                }
                catch (Throwable e) {
                    CommonUI.getDefault().getLog().log((IStatus)new Status(4, "com.genuitec.eclipse.ui.common", "Exception while exporting zip file", e));
                    this.finished();
                    monitor.done();
                }
            }
            finally {
                this.finished();
                monitor.done();
            }
        }
    }

    private void finished() throws InvocationTargetException {
        try {
            if (this.exporter != null) {
                this.exporter.finished();
            }
        }
        catch (IOException e) {
            throw new InvocationTargetException(e, DataTransferMessages.format("ZipExport.cannotClose", new Object[]{e.getMessage()}));
        }
    }

    public void setCreateLeadupStructure(boolean value) {
        this.createLeadupStructure = value;
    }

    public void setGenerateDirectories(boolean value) {
        this.generateDirectories = value;
    }

    public void setGenerateManifestFile(boolean value) {
        this.generateManifestFile = value;
    }

    public void setUseCompression(boolean value) {
        this.useCompression = value;
    }
}

