/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.appserver;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.console.IConsole;

public class TailLogThread
extends Thread {
    private static final int SLEEP = 50;
    private File logFile;
    private BufferedWriter outputWriter;
    private boolean shouldContinue = true;
    private IProcess process;
    private static final int WRITE_COUNT = 50;
    private boolean isProcessBased = true;
    private IConsole console;

    public TailLogThread(File theFile, OutputStream theOutputStream, IConsole console) {
        this(theFile, theOutputStream, console.getProcess());
        this.console = console;
    }

    public TailLogThread(File theFile, OutputStream theOutputStream, IProcess theProcess) {
        this.setName("TailLogThread");
        this.logFile = theFile;
        this.outputWriter = new BufferedWriter(new OutputStreamWriter(theOutputStream));
        this.process = theProcess;
    }

    @Override
    public void run() {
        if (!this.logFile.exists()) {
            return;
        }
        long fileLength = this.logFile.length();
        RandomAccessFile raFile = this.openFileAtTail(this.logFile);
        while (!(!this.shouldContinue || this.isProcessBased() && this.process.isTerminated())) {
            try {
                long currentLength = this.logFile.length();
                if (currentLength < fileLength) {
                    this.closeFile(raFile);
                    raFile = this.openFileAtStart(this.logFile);
                }
                fileLength = currentLength;
                int count = this.readFileAndWrite(raFile, this.outputWriter);
                if (count > 0 && this.console instanceof IDebugEventSetListener) {
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this.console);
                }
            }
            catch (IOException iOException) {}
            try {
                TailLogThread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.console instanceof IDebugEventSetListener) {
            ((IDebugEventSetListener)this.console).handleDebugEvents(new DebugEvent[]{new DebugEvent((Object)this.console.getProcess(), 8)});
        }
    }

    private void closeFile(RandomAccessFile raFile) {
        try {
            raFile.close();
        }
        catch (IOException iOException) {}
    }

    private int readFileAndWrite(RandomAccessFile raFile, BufferedWriter theWriter) throws IOException {
        int writes = 0;
        byte[] read = this.readFromFile(raFile);
        while (read != null && writes < 50) {
            theWriter.write(new String(read));
            theWriter.flush();
            ++writes;
            read = this.readFromFile(raFile);
        }
        return writes;
    }

    private byte[] readFromFile(RandomAccessFile raFile) {
        long remaining;
        block3: {
            try {
                long currentPos = raFile.getFilePointer();
                remaining = raFile.length() - currentPos;
                if (remaining >= 0L) break block3;
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        long readAmount = Math.min(remaining, 16384L);
        byte[] buffer = new byte[(int)readAmount];
        raFile.read(buffer);
        return buffer;
    }

    private RandomAccessFile openFileAtTail(File logFile) {
        try {
            RandomAccessFile raFile = new RandomAccessFile(logFile, "r");
            raFile.seek(raFile.length());
            return raFile;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    private RandomAccessFile openFileAtStart(File logFile) {
        try {
            RandomAccessFile raFile = new RandomAccessFile(logFile, "r");
            return raFile;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public void setShouldContinue(boolean theContinue) {
        this.shouldContinue = theContinue;
    }

    public boolean isProcessBased() {
        return this.isProcessBased;
    }

    public void setProcessBased(boolean isProcessBased) {
        this.isProcessBased = isProcessBased;
    }
}

