/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.ui.dialog;

import com.genuitec.eclipse.j2eedt.core.IJEEProject;
import com.genuitec.eclipse.j2eedt.core.IJEEProjectModule;
import com.genuitec.eclipse.j2eedt.core.IWebProject;
import com.genuitec.eclipse.j2eedt.core.J2EEProjectUIUtil;
import com.genuitec.eclipse.j2eedt.core.version.JEEProjectType;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ProjectLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private Image errorImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IJEEProjectModule) {
            element = ((IJEEProjectModule)element).getModuleProject();
        }
        if (element instanceof IJEEProject || element instanceof IJEEProjectModule) {
            IJEEProject project = element instanceof IJEEProjectModule ? ((IJEEProjectModule)element).getModuleProject() : (IJEEProject)element;
            switch (columnIndex) {
                case 0: {
                    return project.getName();
                }
                case 1: {
                    return project.getType().toString();
                }
                case 2: {
                    if (project.getType() == JEEProjectType.WEB) {
                        return ((IWebProject)project).getContextRoot();
                    }
                    return "";
                }
                case 3: {
                    return project.getArchiveName();
                }
            }
        }
        return element.toString();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        if (element == null) {
            return null;
        }
        if (element instanceof IJEEProject) {
            return J2EEProjectUIUtil.getProjectTypeImage(((IJEEProject)element).getType());
        }
        if (element instanceof IJEEProjectModule) {
            return J2EEProjectUIUtil.getProjectTypeImage(((IJEEProjectModule)element).getModuleProject().getType());
        }
        return this.errorImage;
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }

    public Image getErrorImage() {
        return this.errorImage;
    }
}

